/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: pk.h,v 1.8 1994/03/25 03:00:33 kakiuchi Exp $
 */

#ifndef _PK_
#define _PK_

/* This is a header file for pk font file. */
#include "font.h"

/*
 * pk file constants
 */

#define	NPKCHARS	256
#define	min(x,y)	((x)<=(y) ? (x) : (y))

/* The following macros describe pk file format */

#define PK_ID		89
#define PK_FLAG		239
#define PK_XXX1		240
#define PK_XXX2		241
#define PK_XXX3		242
#define PK_XXX4		243
#define PK_YYY		244
#define PK_POST		245
#define PK_NO_OP	246
#define PK_PRE		247

/*
 * Data Structures
 * ===============
 */

/*
 * Font infomation.
 */

typedef struct font_entry {
  /* common fields (defined in font.h) */
  CommonEntry common;
  /* pk file specific fields */
  struct pk_entry *pk;
} FontEntry;

#include "common.h"

typedef struct pk_entry {
  int	n;
  CharEntry ch[NPKCHARS];
} PkEntry;

#endif /* _PK_ */
