/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: pxl.c,v 1.12 1994/03/25 03:22:27 kakiuchi Exp $
 */

static char rcsid[] = "$Id: pxl.c,v 1.12 1994/03/25 03:22:27 kakiuchi Exp $";

/*
 * pxl font file functions.
 * ========================
 */

#include "pxl.h"

static int pxl_init(), pxl_open(), pxl_free();
static CharEntry *pxl_get_glyph();

FontOps pxlops = {
  {"pxl", "pxl", 5.0, pxl_init, pxl_open, pxl_get_glyph, pxl_free},
  NULL
};


static int
pxl_init()
{
  return(True);
}

static int
pxl_open(fe)
register FontEntry *fe;
{
  register u32 t;

  if (search_font_file(fe)) {
    register FILE *pxlfp;

    if (!(pxlfp = open_file(fe)))
      return(False);
    fseek(pxlfp, 0L, 0);
    if ((t = get_unsigned4(pxlfp)) != PXLID) goto bad_version;
    fseek(pxlfp, -4L, 2);
    if ((t = get_unsigned4(pxlfp)) != PXLID) goto bad_version;
    return(True);
  }
  return(False);
 bad_version:
  close_file(fe);
  prerror("Bad PXL file version %d\n", t);
  return(False);
}

static int
read_pxl_header(fe)
register FontEntry *fe;
{
  register int i, nchars;
  register u32 t;
  register FILE *pxlfp;
  register PxlEntry *pxl;
  long direndptr, dirptr;
  u32 mag, des;

  if (!(pxlfp = open_file(fe)))
    return(False);
  fseek(pxlfp, -20L, 2);
  t = get_unsigned4(pxlfp);
  if ((fe->common.c != 0) && (t != 0) && (fe->common.c != t)) {
    prerror("Bad PXL checksum %s\n", fe->common.name);
    return(False);
  }
  mag = get_unsigned4(pxlfp);
  des = get_unsigned4(pxlfp);

  direndptr = ftell(pxlfp) - 12;
  fseek(pxlfp, (dirptr = (long) (get_unsigned4(pxlfp) * 4)), 0);
  nchars = (direndptr - dirptr) / 16;

  if (nchars > NPXLCHARS) {
    prerror("PXL font directory size is too large [%d]\n", nchars);
    return(False);
  } else if (nchars != NPXLCHARS && nchars != NHALFPXLCHARS)
    prerror("PXL font directory does not match %d and %d\n",
	    NPXLCHARS, NHALFPXLCHARS);

  /* allocate memory for PxlEntry */
  fe->pxl = pxl = (PxlEntry *) AllocMemory(sizeof(PxlEntry));
  pxl->ch = (CharEntry *) AllocMemory((size_t)(sizeof(CharEntry)*nchars));
  pxl->magnification = mag;
  pxl->designsize = des;

  /* allocate memory for CharEntry */
  for (i = 0; i < nchars; ++i) {
    pxl->ch[i].width = (u16) get_unsigned2(pxlfp);
    pxl->ch[i].height = (u16) get_unsigned2(pxlfp);
    pxl->ch[i].xOffset= (i16) get_signed2(pxlfp);
    pxl->ch[i].yOffset = (i16) get_signed2(pxlfp);
    pxl->ch[i].where.isloaded = False;
    pxl->ch[i].where.address.fileOffset = (long) (get_unsigned4(pxlfp) * 4);
    pxl->ch[i].tfmw =
      ((float)get_unsigned4(pxlfp) * (float) fe->common.s) / (float) (1<<20);
  }
  return(True);
}

static CharEntry *
pxl_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  register CharEntry *ptr;
  register FILE *pxlfp;
  register int uwidth, i, col, restbytes;
  register UTYPE *dp0, *dp, *sp;
  u8 buf[4];

  if (c > NPXLCHARS) {
    prerror("pxl font bad charcter data\n");
    return(NULL);
  }
  /* If pxl header is not loaded, then load header */
  if (!fe->pxl && !read_pxl_header(fe)) return(NULL);

  ptr = &fe->pxl->ch[c];
  /* If bad character is specified, then return NULL */
  if (ptr->where.address.fileOffset <= 0) {
    ptr->where.address.bitmap = (char *) NULL;
    return(NULL);
  }
  /* If the bitmap is already loaded on memory, then simply return. */
  if (ptr->where.isloaded) return(ptr);

  if (!(pxlfp = open_file(fe))) return(NULL);
  fseek(pxlfp, ptr->where.address.fileOffset, 0);

  uwidth = UWIDTH((int) ptr->width);
  dp = dp0 = (UTYPE *) AllocMemory((size_t)(uwidth * ptr->height * UBYTES));
  ptr->where.address.bitmap = (char *) dp;
  for (col = ptr->height; col-- > 0; ) {
    restbytes = 0;
    for(i = uwidth; i-- > 0; ) {
      if (restbytes == 0) {
	fread((char *) buf, sizeof(u8), 4, pxlfp);
	sp = (UTYPE *) buf;
	restbytes = 4;
      }
      *dp++ = *sp++;
      restbytes -= UBYTES;
    }
    dp = dp0 += uwidth;
  }
  ptr->where.isloaded = True;
  ptr->glyph_attribute = 0;
  fe->common.access_count++;

  return(ptr);
}

static int
pxl_free(fe)
FontEntry *fe;
{
  return(True);
}
