/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: pxl.h,v 1.7 1994/03/25 03:22:27 kakiuchi Exp $
 */

#ifndef _PXL_
#define _PXL_

/* This is a header file for pxl font file. */
#include "font.h"

/*
 * pxl file constants
 */
#define  NPXLCHARS	256
#define  NHALFPXLCHARS	128
#define  PXLID         1001

/*
 * Data Structures
 * ===============
 */

/*
 * Font information.
 */

typedef struct font_entry
{
  /* common fields (defined in font.h) */
  CommonEntry common;
  /* pxl file specific fields */
  struct pxl_entry *pxl;
} FontEntry;

#include "common.h"

typedef struct pxl_entry {
  u32 magnification;	/* magnification read from PXL file */
  u32 designsize;	/* design size read from PXL file */
  CharEntry *ch;	/* character information */
} PxlEntry;

#endif /* _PXL_ */
