/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: tfm.c,v 1.8 1994/03/29 03:46:49 kakiuchi Exp $
 */

static char rcsid[] = "$Id: tfm.c,v 1.8 1994/03/29 03:46:49 kakiuchi Exp $";

/*
 * tfm font file functions.
 * ========================
 */

#include "font.h"
#include "tfm.h"


static TFMTable *search_hash_table();
static TFMTable *read_tfm_file(), *read_jfm_file();
static CharInfo *read_char_info();
static i32 *read_four_bytes();


TFMTable *
read_tfm(fn, tfmname)
char *fn, **tfmname;
{
  register TFMTable *ttp = search_hash_table(fn, tfmname);
  register u16 id;
  register FILE *tfmfp;

  if (!ttp) return(NULL);
  else if (ttp->data.tfm) return(ttp);

  if (!(tfmfp = fopen(*tfmname, "r"))) {
    prerror("can't open %s\n", *tfmname);
    return(NULL);
  }

  id = get_unsigned2(tfmfp);

  /* test jfm id field. */
#ifdef PTEX
  if (id == JFM_ID || id == PTEX_JFM_ID) return(read_jfm_file(ttp, tfmfp, id));
#else
  if (id == JFM_ID) return(read_jfm_file(ttp, tfmfp, id));
#endif /* PTEX */
  else return(read_tfm_file(ttp, tfmfp, id));
}

static TFMTable *
read_tfm_file(ttp, tfmfp, lf)
register TFMTable *ttp;
register FILE *tfmfp;
register u16 lf;
{
  register u16 lh, bc, ec, nw, nh, nd, ni, nl, nk, ne, np, nc;
  register TFM *tfm;

  ttp->data.tfm = tfm = (TFM *) AllocMemory(sizeof(TFM));
  ttp->is_jfm = 0;

  lh = get_unsigned2(tfmfp);
  bc = tfm->bc = get_unsigned2(tfmfp);
  ec = tfm->ec = get_unsigned2(tfmfp);
  nw = get_unsigned2(tfmfp);
  nh = get_unsigned2(tfmfp);
  nd = get_unsigned2(tfmfp);
  ni = get_unsigned2(tfmfp);
  nl = get_unsigned2(tfmfp);
  nk = get_unsigned2(tfmfp);
  ne = get_unsigned2(tfmfp);
  np = get_unsigned2(tfmfp);

  /* read jfm header */
  tfm->check_sum = get_unsigned4(tfmfp);
  tfm->design_size = get_unsigned4(tfmfp);
  (void) fseek(tfmfp, (long) (4 * (lh - 2)), 1);

  nc = ec - bc + 1;

  /* read tfm charinfo, width, height, depth tables */
  if (!(tfm->info = read_char_info(tfmfp, (int) nc)) ||
      !(tfm->width = read_four_bytes(tfmfp, (int) nw)) ||
      !(tfm->height = read_four_bytes(tfmfp, (int) nh)) ||
      !(tfm->depth = read_four_bytes(tfmfp, (int) nd))) {
    fclose(tfmfp);
    return(NULL);
  }

  fclose(tfmfp);
  return(ttp);
}

static TFMTable *
read_jfm_file(ttp, tfmfp, id)
register TFMTable *ttp;
register FILE *tfmfp;
register u16 id;
{
  register int i;
  register u16 nt, lf, lh, bc, ec, nw, nh, nd, ni, nl, nk, ng, np;
  register JFM *jfm;

  ttp->data.jfm = jfm = (JFM *) AllocMemory(sizeof(JFM));
  ttp->is_jfm = 1;

  /* read jfm table field. */
  nt = jfm->nt = get_unsigned2(tfmfp);
  lf = get_unsigned2(tfmfp);
  lh = get_unsigned2(tfmfp);
  bc = get_unsigned2(tfmfp);
  ec = get_unsigned2(tfmfp);
  nw = get_unsigned2(tfmfp);
  nh = get_unsigned2(tfmfp);
  nd = get_unsigned2(tfmfp);
  ni = get_unsigned2(tfmfp);
  nl = get_unsigned2(tfmfp);
  nk = get_unsigned2(tfmfp);
  ng = get_unsigned2(tfmfp);
  np = get_unsigned2(tfmfp);

  /* read jfm header */
  jfm->check_sum = get_unsigned4(tfmfp);
  jfm->design_size = get_unsigned4(tfmfp);
  (void) fseek(tfmfp, (long) (4 * (lh - 2)), 1);

  /* read jfm char_type */
  jfm->type = (JFMCharType *) AllocMemory((size_t) (sizeof(JFMCharType) * nt));
  for (i = 0; i < (int) nt; i++) {
    jfm->type[i].code = get_unsigned2(tfmfp);
    jfm->type[i].index = get_unsigned2(tfmfp);
  }

  /* read jfm charinfo, width, height, depth tables */
  if (!(jfm->info = read_char_info(tfmfp, (int) (ec + 1))) ||
      !(jfm->width = read_four_bytes(tfmfp, (int) nw)) ||
      !(jfm->height = read_four_bytes(tfmfp, (int) nh)) ||
      !(jfm->depth = read_four_bytes(tfmfp, (int) nd))) {
    fclose(tfmfp);
    return(NULL);
  }

  fclose(tfmfp);
  return(ttp);
}

static CharInfo *
read_char_info(tfmfp, nc)
register FILE *tfmfp;
register int nc;
{
  register CharInfo *ci, *ret;

  ret = ci = (CharInfo *) AllocMemory((size_t)(sizeof(CharInfo) * nc));

  while (--nc >= 0) {
    ci->width_ix = get_unsigned1(tfmfp);
    ci->height_depth_ix = get_unsigned1(tfmfp);
    ci->italic_ix_tag = get_unsigned1(tfmfp);
    ci->remainder_ix = get_unsigned1(tfmfp);
    ci++;
  }
  if (feof(tfmfp))
    return(NULL);
  else return(ret);
}

static i32 *
read_four_bytes(tfmfp, nc)
register FILE *tfmfp;
register int nc;
{
  register i32 *tab, *ret;

  ret = tab = (i32 *) AllocMemory((size_t)(sizeof(i32) * nc));
  while (--nc >= 0)
    *tab++ = get_signed4(tfmfp);
  if (feof(tfmfp))
    return(NULL);
  else return(ret);
}

static int
HASH(name)
char name[];
{
  register int i, h = 0, l = strlen(name);

  for (i = 0; i < l; ++i)
    h += name[i] << i;
  return(h % TFMTABLESIZE);
}

/* This flag represents whether the hash table is initialized */
static int initialized = True;
static TFMTable *tfm_table[TFMTABLESIZE];

static TFMTable *
search_hash_table(fn, tfmname)
register char *fn, **tfmname;
{
  register TFMTable **ttp = &tfm_table[HASH(fn)];

  /* Search in the hash tree */
  while (*ttp) {
    if (!strcmp(fn, (*ttp)->name)) {
      /* If found */
      *tfmname = (*ttp)->filename;
      return(*ttp);
    } else ttp = &(*ttp)->next;
  }

  /* If not found */
  if (!search_tfm_file(fn, tfmname)) {
    prerror("%s.tfm [not found]\n", fn);
    return(NULL);
  }

  /* allocate memory for PxlEntry */
  *ttp = (TFMTable *) AllocMemory(sizeof(TFMTable));
  (*ttp)->name = fn;
  (*ttp)->filename = *tfmname;
  (*ttp)->next = (TFMTable *) NULL;
  (*ttp)->data.tfm = (TFM *) NULL;
  initialized = False;

  return(*ttp);
}

void
free_tfm()
{
  register int i;

  if (initialized) return;
  for (i = 0; i < TFMTABLESIZE; ++i)
    tfm_table[i] = (TFMTable *) NULL;
  initialized = True;
}

u16
find_type(jfm, c)
register JFM *jfm;
register u32 c;
{
  register u16 nt = jfm->nt;
  register u16 min = jfm->type[1].code, max = jfm->type[nt - 1].code;
  register u16 i;

  if (c >= min && c <= max) {
    for (i = 1; i < nt; ++i)
      if (jfm->type[i].code == c) {
	goto found;
      }
  }
  return((u16) 0);

found:
  return(jfm->type[i].index);
}

