/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: tfm.h,v 1.7 1994/03/29 08:56:10 kakiuchi Exp $
 */

#ifndef _TFM_
#define _TFM_

/* This is a header file for tfm font file. */

/*
 * TFM file information.
 */

/*
 * The remainder of the TFM file comprises the following information,
 * all of which are 32 bit quantities:
 *
 * header:	array [0..lh-1] of stuff
 * char_info:	array [bc..ec] of char_info_word
 * width:	array [0..nw-1] of fix_word
 * height:	array [0..nh-1] of fix_word
 * depth:	array [0..nd-1] of fix_word
 * italic:	array [0..ni-1] of fix_word
 * lig_kern:	array [0..nl-1] of lig_kern_command
 * kern:	array [0..ne-1] of extensible_recipie
 * param:	array [0..np-1] of fix_word
 */

/*
 * A char_info_word is built of four unsigned eight-bit quantities.  The first
 * is an index into the width table (this saves 24 bits for every
 * character that has the same width as another character).  The
 * second is a composite height and depth index.  The third is a
 * composite italic index and tag, and the fourth is a remainder.
 *
 */
typedef struct {
  u8 width_ix;		/* index to width */
  u8 height_depth_ix;	/* index to height & depth */
  u8 italic_ix_tag;	/* index to italic & tag */
  u8 remainder_ix;	/* index to remainder */
} CharInfo;

typedef struct tfm {
  u32 check_sum, design_size;
  u16 bc, ec;
  CharInfo *info;
  i32 *width, *height, *depth;
} TFM;

/* .jfm file format */
#define JFM_ID		11
#ifdef PTEX
#define PTEX_JFM_ID	9
#endif /* PTEX */

/*
 * jfm file information
 */

typedef struct {
  u16 code;	/* JIS code */
  u16 index;	/* index to char_info */
} JFMCharType;

typedef struct jfm {
  u32 check_sum, design_size;
  u16 nt;
  JFMCharType *type;
  CharInfo *info;
  i32 *width, *height, *depth;
} JFM;

typedef struct tfm_table {
  char *name, *filename;
  struct tfm_table *next;
  u8 is_jfm;
  union {
    TFM *tfm;
    JFM *jfm;
  } data;
} TFMTable;


/*
 * These macros split up h_and_d and i_and_t values.
 */
#define INFO_HEIGHT(h_d) ( ((h_d)>>4)&0x0f )
#define INFO_DEPTH(h_d)  ( (h_d)&0x0f )
#define INFO_ITALIC(h_d) ( ((h_d)>>2)&0x3f )

#define TFMTABLESIZE 97

extern TFMTable *read_tfm(
#if NeedFunctionPrototypes
    char*	/* fn */,
    char**	/* tfmname */
#endif
);
extern void free_tfm(
#if NeedFunctionPrototypes
#endif
);
extern u16 find_type(
#if NeedFunctionPrototypes
    JFM*	/* jfm */,
    u32		/* c */
#endif
);

#endif /* _TFM_ */
