/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: tfmfont.c,v 1.10 1994/03/24 13:19:22 kakiuchi Exp $
 */

static char rcsid[] = "$Id: tfmfont.c,v 1.10 1994/03/24 13:19:22 kakiuchi Exp $";

/*
 * tfm font file functions.
 * ========================
 */

#include "tfmfont.h"


static int tfm_init(), tfm_open(), tfm_free();
static CharEntry *box_get_glyph(), *blank_get_glyph();

/* magnifications are unused in tfm fonts */
FontOps tfmboxops = {
  {"tfmbox", "tfm", 0.0, tfm_init, tfm_open, box_get_glyph, tfm_free},
  NULL};
FontOps tfmblankops = {
  {"tfmblank", "tfm", 0.0, tfm_init, tfm_open, blank_get_glyph, tfm_free},
  NULL};


static int
tfm_init()
{
  return(True);
}

static int
tfm_open(fe)
register FontEntry *fe;
{
  register TfmEntry *tfmfont;
  register TFMTable *tp;
  register int cnum;

  /* allocate memory for TfmEntry */
  fe->tfmfont = tfmfont = (TfmEntry *) AllocMemory(sizeof(TfmEntry));

  if (!(tp = read_tfm(fe->common.n, &fe->common.name)))
    return(False);

  if (tp->is_jfm) return(False);

  tfmfont->tfm = tp->data.tfm;
  cnum = tfmfont->tfm->ec - tfmfont->tfm->bc + 1;
  tfmfont->ch = (CharEntry *) AllocMemory((size_t) (sizeof(CharEntry) * cnum));
  for (; --cnum >= 0; ) {
    tfmfont->ch[cnum].where.isloaded = False;
    tfmfont->ch[cnum].glyph_attribute = 0;
  }
  prerror("Font %s [%d] not found: Using dummy [box/blank] font.\n",
	  fe->common.n, fix(fe->common.font_mag));
  return(True);
}

/*
 * Read a Blank font.
 */
static CharEntry *
blank_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  register u32 index = c - fe->tfmfont->tfm->bc;
  register CharEntry *ptr = &fe->tfmfont->ch[index];
  register TFM *tfm = fe->tfmfont->tfm;

  /* If the bitmap is already loaded on memory, then simply return. */
  if (ptr->where.isloaded) return(ptr);

  if (tfm->info[index].width_ix == 0)
      return(NULL);

  ptr->xOffset = (i16) 0;
  ptr->yOffset = (i16) 0;
  ptr->tfmw = (int) ((double) fe->common.s *
		     (double) tfm->width[tfm->info[index].width_ix] /
		     (double) (0x1 << 20));
  ptr->width = (u16) 0;
  ptr->height = (u16) 0;
  ptr->where.isloaded = True;
  ptr->where.address.bitmap = (char *) NULL;

  return(ptr);
}

/*
 * Read a Box font.
 */
static CharEntry *
box_get_glyph(fe, c)
register FontEntry *fe;
register u32 c;
{
  register u32 index = c - fe->tfmfont->tfm->bc;
  register size_t size;
  register CharEntry *ptr = &fe->tfmfont->ch[index];
  register TFM *tfm = fe->tfmfont->tfm;

  /* If the bitmap is already loaded on memory, then simply return. */
  if (ptr->where.isloaded) return(ptr);

  if (tfm->info[index].width_ix == 0)
      return(NULL);

  ptr->xOffset = (i16) 0;
  ptr->yOffset = (i16)
    VConv((int) ((double) fe->common.s *
		 (double) tfm->height[INFO_HEIGHT(tfm->info[index].height_depth_ix)] /
		 (double) (0x1 << 20)));
  ptr->tfmw = (int) ((double) fe->common.s *
		     (double) tfm->width[tfm->info[index].width_ix] /
		     (double) (0x1 << 20));
  ptr->width = (u16) HConv((int) ptr->tfmw);
  ptr->height = (u16)
    (ptr->yOffset +
     VConv((int) ((double) fe->common.s *
		  (double) tfm->depth[INFO_DEPTH(tfm->info[index].height_depth_ix)] /
		  (double) (0x1 << 20))));

  ptr->where.isloaded = True;
  fe->common.access_count++;

  size = UWIDTH((int) ptr->width) * UBYTES * ptr->height;
  ptr->where.address.bitmap = AllocMemory(size);
  bzero(ptr->where.address.bitmap, (int) size);

  DrawRectangle(ptr->where.address.bitmap, (int) ptr->width, (int) ptr->height,
		(int) (UWIDTH((int) ptr->width) * UBYTES), 0, 0,
		(int) ptr->width, (int) ptr->height, 2);

  return(ptr);
}

static int
tfm_free(fe)
register FontEntry *fe;
{
  free_tfm();
  return(True);
}

#if NeedFunctionPrototypes
char *
GetTfmHandle(
    register FontEntry *fe
)
#else
char *
GetTfmHandle(fe)
register FontEntry *fe;
#endif
{
  return((char *) fe->tfmfont->tfm);
}

#if NeedFunctionPrototypes
double
GetTfmDotSize(
    register FontEntry *fe,
    register TFM *tfm
)
#else
double
GetTfmDotSize(fe, tfm)
register FontEntry *fe;
register TFM *tfm;
#endif
{
  register double dot;

  dot = ((fe->common.font_mag / 72.27) *		/* scale [dot/pt] */
	 (double)tfm->design_size / (double)(0x1<<20));	/* design_size[pt] */
  return(dot);
}
