/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: types.h,v 1.6 1994/03/29 09:16:37 kakiuchi Exp $
 */

#ifndef _LOCALTYPES_
#define _LOCALTYPES_

/*
 * Some type definitions for general purpose.
 */
#ifdef	__STDC__
#include <stddef.h>
#else
#ifdef BE
#include <sys/types.h>
#else
#undef	size_t
#define	size_t		unsigned int
#endif /* BE */
#endif /* __STDC__ */

#ifndef	NULL
#define	NULL	0
#endif

typedef long		i32;
typedef unsigned long	u32;
typedef short		i16;
typedef unsigned short	u16;
#ifdef	__STDC__
typedef signed char	i8;
#else
typedef char		i8;
#endif /* __STDC__ */
typedef unsigned char 	u8;
typedef double		f64;
typedef float		f32;

#ifndef bool
#define bool   int
#endif
#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif

#ifndef MAXINT
#define MAXINT                  2147483647
#endif
#ifndef NEGMAXINT
#define NEGMAXINT               (-2147483648)
#endif

/*
 * OS dependent part.
 */
#if !defined(SYSV) && !defined(SVR4)
#include <strings.h>
#else
#include <string.h>
#undef bcopy
#define bcopy(b1,b2,len)	memcpy(b2,b1,(size_t)(len))
#undef bzero
#define bzero(b,len)		memset(b,0,(size_t)(len))
#undef bcmp
#define	bcmp(b1,b2,len)		memcmp(b1,b2,(size_t)(len))
#undef index
#define index(s,c)		strchr(s,c)
#undef rindex
#define rindex(s,c)		strrchr(s,c)
#undef getwd
#define getwd(p)		getcwd(p,MAXPATHLEN)
#endif

/*
 * Compiler dependent part.
 */
#ifndef NeedFunctionPrototypes
#ifdef __STDC__
#define	NeedFunctionPrototypes	1
#else
#define	NeedFunctionPrototypes	0
#endif /* __STDC__ */
#endif /* NeedFunctionPrototypes */

#ifndef NeedVarargsPrototypes
#ifdef __STDC__
#define	NeedVarargsPrototypes	1
#else
#define	NeedVarargsPrototypes	0
#endif /* __STDC__ */
#endif /* NeedVarargsPrototypes */

#if NeedFunctionPrototypes
#ifndef NeedNestedPrototypes
#ifdef __STDC__
#define	NeedNestedPrototypes	1
#else
#define	NeedNestedPrototypes	0
#endif /* __STDC__ */
#endif /* NeedNestedPrototypes */
#endif /* NeedFunctionPrototypes */

/*
 * Varargs parameter list.
 */
#if __STDC__
#include <stdarg.h>
#define	VA_START(pvar, parmN)	va_start(pvar, parmN)
#else
#include <varargs.h>
#define	VA_START(pvar, parmN)	va_start(pvar)
#endif

/*
 * malloc and etc.
 */
#if __STDC__
#include <stdlib.h>
#else
#include <malloc.h>
#endif

#endif /* _LOCALTYPES_ */
