/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: utils.c,v 1.10 1994/03/30 09:51:05 kakiuchi Exp $
 */

static char rcsid[] = "$Id: utils.c,v 1.10 1994/03/30 09:51:05 kakiuchi Exp $";

/*
 * some utilities
 * ==============
 */

#include "font_public.h"
#include "common.h"

/*
 * utilities for raster operations
 */

#if NeedFunctionPrototypes
void
FillRectangle(
    register u8 *dp,
    register int dwidth,
    register int dheight,
    register int bytes_per_line,
    register int x,
    register int y,
    register int width,
    register int height
)
#else
void
FillRectangle(dp, dwidth, dheight, bytes_per_line, x, y, width, height)
register u8 *dp;
register int dwidth, dheight, bytes_per_line, x, y, width, height;
#endif
{
  if (x >= dwidth || y >= dheight) return;
  if (x < 0) {
    width += x;
    if (width < 0) return;
    x = 0;
  }
  if (y < 0) {
    height += y;
    if(height < 0) return;
    y = 0;
  }
  if (x + width > dwidth) width = dwidth - x;
  if (y + height > dheight) height = dheight - y;

  {
    register int i, j;
    register int endx = x + width - 1,
                 start_bytes = x >> 3,
                 end_bytes = endx >> 3,
                 bwidth = end_bytes - start_bytes - 1;
    register u8 start_pattern = 0xff >> (x & 0x7),
		end_pattern = 0xff << ((endx & 0x7) ^ 0x7),
		*d0 = (u8 *) dp + (y * bytes_per_line + start_bytes),
		*d = d0;

    if (bwidth < 0)
      start_pattern &= end_pattern;
    for (j = 0; j++ < height; ) {
      *(d++) |= start_pattern;
      for (i = 0; i++ < bwidth; ) *(d++) |= 0xff;
      if (start_bytes != end_bytes) *d |= end_pattern;
      d = d0 += bytes_per_line;
    }
  }
}

#if NeedFunctionPrototypes
void
DrawRectangle(
    register u8 *dp,
    register int dwidth,
    register int dheight,
    register int bytes_per_line,
    register int x,
    register int y,
    register int width,
    register int height,
    register int border
)
#else
void
DrawRectangle(dp, dwidth, dheight, bytes_per_line, x, y, width, height, border)
register u8 *dp;
register int dwidth, dheight, bytes_per_line, x, y, width, height, border;
#endif
{
  FillRectangle(dp, dwidth, dheight, bytes_per_line, x, y,
		width, border);
  FillRectangle(dp, dwidth, dheight, bytes_per_line, x, y + height - border,
		width, border);
  FillRectangle(dp, dwidth, dheight, bytes_per_line, x, y,
	        border, height);
  FillRectangle(dp, dwidth, dheight, bytes_per_line, x + width - border, y,
		border, height);
}

/*
 * get_unsigned:
 *
 */

#if NeedFunctionPrototypes
u32
get_unsigned(	/* return n byte quantity from file fd */
    register FILE *fp,	/* file pointer	*/
    register int n	/* number of bytes */
)
#else
u32
get_unsigned(fp, n)	/* return n byte quantity from file fd */
register FILE *fp;	/* file pointer	*/
register int n;		/* number of bytes */
#endif
{
  register u32 x;	/* number being constructed */

  for (x = 0; n-- > 0; ) x = (x << 8) | getc(fp);
  return(x);
}

/*
 * get_signed:
 *
 */

#if NeedFunctionPrototypes
i32
get_signed(	/* return n byte quantity from file fd */
    register FILE *fp,  /* file pointer	*/
    register int n	/* number of bytes */
)
#else
i32
get_signed(fp, n)   /* return n byte quantity from file fd */
register FILE *fp;  /* file pointer	*/
register int n;	 /* number of bytes */
#endif
{
  register i32 x;

  if ((x = getc(fp)) >= 128) x -= 256;
  while (--n > 0) x = (x << 8) | getc(fp);
  return(x);
}

#if NeedVarargsPrototypes
void
prerror(char *fmt, ...)
#else
void
prerror(fmt, va_alist)
char *fmt;
va_dcl
#endif
{
  va_list argptr;

  VA_START(argptr, fmt);
  vfprintf(stderr, fmt, argptr);
  va_end(argptr);
}

/*
 * Utilities for file operartion.
 */
static FILE *
try_open(dir, path, suff, name, fullname, mode, path_return)
register char *dir, *path, *suff, *name, *fullname, *mode;
char **path_return;
{
  register char *p = fullname;
  register FILE *f = (FILE *) NULL;

  if (dir) {
    while (*dir != NULL) *p++ = *dir++;
    *p++ = '/';
  }
  while (*path != NULL) {
    if (*path == ':' || *path == ';') {
      path++;
      break;
    } else *p++ = *path++;
  }
  if (path_return) *path_return = path;
  *p++ = '/';
  while (*name != NULL) *p++ = *name++;
  while (*suff != NULL) {
    while (*suff != NULL) {
      if (*suff == ':' || *suff == ';') {
	suff++;
	break;
      } else *p++ = *suff++;
    }
    *p = NULL;
    if ((f = fopen(fullname, mode)) != (FILE *) NULL)
      return(f);
  }
  return(NULL);
}

#if NeedFunctionPrototypes
FILE *
fopenp(
    register char *dir,
    char *path,
    register char *suff,
    register char *name,
    register char *fullname,
    register char *mode
)
#else
FILE *
fopenp(dir, path, suff, name, fullname, mode)
register char *dir, *suff, *name, *fullname, *mode;
char *path;
#endif
{
  register FILE *f;

  if (*name == '/') {
    strcpy(fullname, name);
    return fopen(fullname, mode);
  }

  while (*path) {
    if (*path != '/') {
      if ((f = try_open(dir, path, suff, name, fullname, mode, NULL)) !=
	  (FILE *)NULL)
	return f;
    }
    if((f = try_open(NULL, path, suff, name, fullname, mode, &path)) !=
       (FILE *)NULL)
      return f;
  }

  return (FILE *)NULL;
}
