/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: jdvi2.h,v 1.11 1994/03/30 09:50:41 kakiuchi Exp $
 */

#include <sys/param.h>
#include <ctype.h>
#include "dvi_public.h"
#include "font_public.h"

#define NumArray(x) ((long) (sizeof(x)/sizeof(x[0])))

typedef enum _DescType {
  NoArg, StickyArg, SepArg,
} DescType;

typedef enum _OptionType {
  INTEGER, FLOAT, DIMENSION, MAGSTEP, STRING, BOOLEAN,
} OptionType;

typedef struct _Pages {
  int page;
} Pages;

typedef char *Pointer;

typedef struct _OptionDesc {
  char *option;
  DescType type;
  OptionType value_type;
  Pointer initial_value, default_value, value;
} OptionDesc;

typedef struct {
  char *name;
  float width, height;   /* page size (inch) */
} PaperType;

typedef struct _OptionCore {
  char	*prog_name;
  char	*dvi_filename;
  char	*output_filename;
  FILE	*out_fp;
  char	*language;
  char	*tex_pages_string, *pages_string;
  int	page_from, page_to;
  Pages	*pages;
  bool	reverse;
  bool	landscape;
  char	*paper;
  PaperType *paper_type;
  bool	manual_feed;
  bool	silent;
  bool	show_version;
  bool	show_help;
  int	copies;
  u32	magstep;
  float	top_margin, left_margin;
  int	resolution;
  bool	even_page, odd_page;
} OptionCore;

extern OptionCore core_option;
#if NeedVarargsPrototypes
extern void FatalExit(char *fmt, ...);
#else
extern void FatalExit();
#endif
extern void RotateImage();

#define CoreProgName	(core_option.prog_name)
#define CoreDVIFilename	(core_option.dvi_filename)
#define CoreOutputFilename	(core_option.output_filename)
#define CoreOutFp	(core_option.out_fp)
#define outfp		CoreOutFp
#define CoreLanguage	(core_option.language)
#define CoreTeXPagesString	(core_option.tex_pages_string)
#define CorePagesString	(core_option.pages_string)
#define CorePageFrom	(core_option.page_from)
#define CorePageTo	(core_option.page_to)
#define CorePages	(core_option.pages)
#define CoreReverse	(core_option.reverse)
#define CoreLandscape	(core_option.landscape)
#define CorePaper	(core_option.paper)
#define CorePaperType	(core_option.paper_type)
#define CoreManualFeed	(core_option.manual_feed)
#define CoreSilent	(core_option.silent)
#define CoreShowVersion	(core_option.show_version)
#define CoreShowHelp	(core_option.show_help)
#define CoreCopies	(core_option.copies)
#define CoreMagStep	(core_option.magstep)
#define CoreTopMargin	(core_option.top_margin)
#define CoreLeftMargin	(core_option.left_margin)
#define CoreResolution	(core_option.resolution)
#define CoreEvenPage	(core_option.even_page)
#define CoreOddPage	(core_option.odd_page)

typedef struct _PDLInfo {
  char *prog_name, *version, *usage;
  char *language;
  int default_resolution;
  struct _OptionDesc *option_desc;
  long option_desc_num;
  void (*option_check_func)(), (*initialize)(), (*postprocess)();
  AppInfo *app_info;
} PDLInfo;
