/*
 * Copyright (c) Matsushita Electric Industrial Co.,Ltd. 1994
 *
 * $Id: postscript.c,v 1.30 1994/03/25 02:16:47 kakiuchi Exp $
 */

static char rcsid[] = "$Id: postscript.c,v 1.30 1994/03/25 02:16:47 kakiuchi Exp $";

/*
 * Private DVI file functions.
 */

#include "jdvi2.h"
#include "postscript.h"

#define	DEFAULTRESOLUTION 300	/* can be changed with [-d integer] */
				/* usually the same, but you can get */
				/* interesting effects if they are not */
#ifndef PS_PATH
#define	PS_PATH		"."
#endif

#ifndef PS_SUFF
#define	PS_SUFF		":.ps:.eps:.epsf"
#endif

#ifndef	HDRFILE
#define HDRFILE		"/usr/lib/tex/jdvi2.ps"
#endif

/*
 * External functions and variables.
 */

/*
 * Private functions
 */
static void set_fnt_num(), set_char(), set_rule(), do_special();
static bool init_dvi(), bop(), eop();
static void initialize(), AllDone(), AppCheckOption();
static void font_status();

/*
 * Private variables
 */
#define STRINGBUFSIZE 256

typedef struct font_table {
	long	n_dload;
	long	n_tpxl;
	long	n_cset;
} FontTable;

typedef struct{
  u16	code;              /* jis code */
  float	Xadj, Yadj;      /* coefficient for adjustment */
} AdjustRatioRecord;

typedef struct {
        char *tex_name;		/* name in TeX */
        char *ps_name;		/* real font name */
	AdjustRatioRecord *adj_table;
	int size_of_adj_table;
        int len;		/* length of the name in TeX */
} JFontName;

#include "psmtradj.h"

static int Snbpxl	= 0;	/* # of bytes of pixel data */
static int Sonbpx	= 0;	/* "optimal" number of bytes of pixel data */
static int Sndc		= 0;	/* count set bitmap character */
static int Stnc		= 0;	/* total # of chars typeset */
static int Snbpx0, Sndc0, Stnc0;/* used for printing incremental changes per */
				/*  dvi page */
static FontTable	*psfe;		/* PostScript Font Entry Pointer */
static int StringPtr;
static char StringBuf[STRINGBUFSIZE];

static char	*digit		= "0123456789ABCDEF";
static int	ordinal_page = 0;	/* Culculate total number of page */
static int	n_Ifile = 0;		/* count include file */
static char	*ps_path = (char *) NULL;	/* PostScript file directory */
static char	*ps_suff = (char *) NULL;	/* PostScript file suffixes */

static i32 hold_h, hold_v;
#ifdef PTEX
static u8 hold_dir;
#endif /* PTEX */

static char prog_name[] = "jdvi2kps";
static char version[] = "4.0";
static char usage[] = "\
	[-mirror]	Generate mirrored image.\n\
	[-h]		Do not include default header file.\n\
	[-stat]		Show statistics.\n\
	[-i file]	Include a header file.\n\
	[-w]		Do not show warning.\n\
	[-j]		Do not handle Japanese fonts.\n\
	[+3]		Handle additional 3 Japanese fonts.\n";

static AppInfo app_info = {
  /* fontdesc		*/	"pk gf pxl jfmblank tfmblank",
  /* error_handlder	*/	FatalExit,
  /* init_dvi		*/	init_dvi,
  /* check_sheet	*/	NULL,
  /* bop		*/	bop,
  /* eop		*/	eop,
  /* set_fnt_num	*/	set_fnt_num,
  /* set_char		*/	set_char,
  /* set_rule		*/	set_rule,
  /* do_special		*/	do_special
};

static OptionApp app_option;
#define Option app_option

static OptionDesc app_desc[] = {
  {"-mirror", NoArg, BOOLEAN, "False", "True", (Pointer) &app_option.Mirror},
  {"-h", NoArg, BOOLEAN, "True", "False", (Pointer) &app_option.G_header},
  {"-stat", NoArg, BOOLEAN, "False", "True", (Pointer) &app_option.Stats},
  {"-i", SepArg, STRING, NULL, NULL, (Pointer) &app_option.Ifile[0]},
  {"-w", NoArg, BOOLEAN, "False", "True", (Pointer) &app_option.G_nowarn},
  {"-j", NoArg, BOOLEAN, "True", "False", (Pointer) &app_option.handle_jfonts},
  {"+3", NoArg, BOOLEAN, "False", "True", (Pointer) &app_option.isFive},
};

/*
 * Global variables
 */

PDLInfo postscript_info = {
  prog_name, version, usage, "postscript", DEFAULTRESOLUTION,
  app_desc, NumArray(app_desc), AppCheckOption,
  initialize, AllDone, &app_info,
};

static void
AppCheckOption(option)
register OptionDesc *option;
{
  if (option->value == (Pointer) &Option.Ifile[n_Ifile] && Option.Ifile[n_Ifile])
    option->value = (Pointer) &Option.Ifile[++n_Ifile];
}

static void
initialize()
{
  char *getenv();

  /* Set PostScript file path */
  ps_path = getenv("DVIPSPATH");
  if (!ps_path) ps_path = PS_PATH;
  ps_suff = getenv("DVIPSSUFF");
  if (!ps_suff) ps_suff = PS_SUFF;
}

static void
AllDone()
{
  EMITS("%%Trailer\n");
  EMITS("@end\n");
  EMIT(outfp, "%%%%Pages: %d\n", ordinal_page);

  if( !CoreSilent ) prerror("\n");

#ifdef GLOBAL_FONT
  if (Option.Stats) {
    font_status();
  }
#endif
}

/*-->PutInt*/
/**********************************************************************/
/*****************************  PutInt  *******************************/
/**********************************************************************/

static void
PutInt(n)               /* output an integer followed by a space */
register i32 n;
{
  char buf[10];
  register char *b;

  if( n == 0 ) {
    EMITC('0'); 
  } else {
    if( n < 0 ) {
      EMITC('-');
      n = -n;
    }

    for(b=buf;  n>0;  ) {
      *b++ = digit[n%10];
      n /= 10;
    }
    
    for( ; b>buf; ) {
      EMITC(*--b);
    }
  }

  EMITC(' ');
}

/*-->PutOct*/
/**********************************************************************/
/*****************************  PutOct  *******************************/
/**********************************************************************/

static void
PutOct(n)               /* output an 3 digit octal number preceded by a "\" */
register int n;
{                  
  EMITC( '\\' ); 
  EMITC( digit[(n&0300)>>6] );
  EMITC( digit[(n&0070)>>3] ); 
  EMITC( digit[n&0007] );
}

/*-->SetPosn*/
/**********************************************************************/
/*****************************  SetPosn  ******************************/
/**********************************************************************/

static void
SetPosn(x, y)           /* output a positioning command */
register i32 x, y;
{
  EMITN(x);
  EMITN(y);
  EMITS("p ");
}

#define ItemNum(x) (sizeof(x)/sizeof(x[0]))

static JFontName JFontNameTable[] = {
  { "min",	"min",	min_adj,	ItemNum(min_adj) },
  { "goth",	"goth",	goth_adj,	ItemNum(goth_adj) },
  { "fmin",	"min",	min_adj,	ItemNum(min_adj) },
  { "fgoth",	"goth",	goth_adj,	ItemNum(goth_adj) },
  { "mgoth",	"goth",	goth_adj,	ItemNum(goth_adj) },
#ifdef PTEX
  { "tmin",	"tmin",	tmin_adj,	ItemNum(tmin_adj) },
  { "tgoth",	"tgoth",tgoth_adj,	ItemNum(tgoth_adj) },
  { "tfmin",	"tmin",	tmin_adj,	ItemNum(tmin_adj) },
  { "tfgoth",	"tgoth",tgoth_adj,	ItemNum(tgoth_adj) },
  { "tmgoth",	"tgoth",tgoth_adj,	ItemNum(tgoth_adj) },
#endif /* PTEX */
  { NULL, NULL },
};

/*-->JFontInit		(improvement proc) oka 27-Aug-1989 */
/**********************************************************************/
/****************************  JFontInit  *****************************/
/**********************************************************************/

static void
JFontInit()
{
  register JFontName *fn = JFontNameTable;

  while (fn->tex_name) {
    fn->len = strlen(fn->tex_name);
    ++fn;
  }
}

/*-->JapaneseFont	(improvement proc) oka 27-Aug-1989 */
/**********************************************************************/
/***************************  JapaneseFont  ***************************/
/**********************************************************************/

static JFontName *
JapaneseFont(fe)
register FontEntry *fe;
{
  register JFontName *fn = JFontNameTable;

  while (fn->tex_name) {
    if (!strncmp(fe->common.n, fn->tex_name, fn->len)) return(fn);
    else ++fn;
  }
  return (NULL);
}

/*-->CopyFile*/   /* copy a file straight through to output */
/*********************************************************************/
/***************************** CopyFile ******************************/
/*********************************************************************/

static void
copy_file(fp, name, filename)
register FILE *fp;
register char *name, *filename;
{
  register int t;

  if( !CoreSilent ) prerror(" [%s", filename);
  EMIT(outfp, "%%%%BeginDocument: %s\n", filename);
  while( (t = getc(fp)) != EOF ) {
    EMITC((char) t);
  }              
  EMIT(outfp, "\n%%%%EndDocument\n");
  if( !CoreSilent ) prerror("]");
}

static void
CopyFile( str )
register char *str;
{
  register FILE *spfp;
  static char fullname[MAXPATHLEN];

  if( (spfp = fopenp(dvi_info.directory, ps_path, ps_suff, str, fullname, "r")) == NULL) {
    prerror("Unable to open file %s\n", str );
    return;
  }
  copy_file(spfp, str, fullname);
  (void) fclose(spfp);
}

/*-->OutHeader		(improvement proc) oka 27-Feb-1989 */
/**********************************************************************/
/****************************  OutHeader  *****************************/
/**********************************************************************/

static void
OutHeader(name)
register char *name;
{
  EMIT(outfp, "%%!PS-Adobe-2.0\n");
  EMIT(outfp, "%%%%Title: %s\n", name);
  EMIT(outfp, "%%%%Creator: %s\n", CoreProgName);
  /* EMIT(outfp, "%%%%CreationDate:\n"); */
  /* EMIT(outfp, "%%%%For:\n"); */
  /* EMIT(outfp, "%%%%Routing:\n"); */
  /* EMIT(outfp, "%%%%BoundingBox: \n"); */
  EMIT(outfp, "%%%%Pages: (atend)\n");
  EMIT(outfp, "%%%%PageOrder: %s\n", (CoreReverse ? "Descend" : "Ascend"));
  /* EMIT(outfp, "%%%%DocumentFonts: (atend)\n"); */
  /* EMIT(outfp, "%%%%DocumentNeededFonts: \n"); */
  /* EMIT(outfp, "%%%%DocumentSuppliedFonts: \n"); */
  /* EMIT(outfp, "%%%%DocumentPaperSizes: \n"); */
  EMIT(outfp, "%%%%EndComments\n");

  if (Option.G_header) {
    char *getenv(), *filename = getenv("KPSHEADER");

    CopyFile( filename ? filename : HDRFILE );	/* output header file */
  }
}

static bool
init_dvi(fullname, name)
register char *fullname, *name;
{
  register int i;

  JFontInit();		/* Japanese font name Initialize */

  OutHeader(name);	/* output header file preamble */

  for (i = 0; i < n_Ifile; i++)
    CopyFile( Option.Ifile[i] );/* output all included files */

  EMITS("%%EndProlog\n");
  EMITS("%%BeginSetup\n");
  EMITS("TeXDict begin\n");
  EMIT(outfp, "/Resolution %d def\n", CoreResolution);
  /* EMITS("%%IncludeFont: Ryumin-Light-H\n"); */
  /* EMITS("%%IncludeFont: GothicBBB-Medium-H\n"); */
  if (Option.handle_jfonts) {
    EMITS("JFontSetup ");
    if (Option.isFive) EMITS("JFontSetup3 ");
  }
  EMIT(outfp, "/@tm %.3f def /@lm %.3f def ", CoreTopMargin, CoreLeftMargin);
  EMIT(outfp, "%s ", (Option.Mirror ? "true" : "false"));
  EMIT(outfp, "%s ", (CoreLandscape ? "true" : "false"));
  EMIT(outfp, "/%s @sp", CorePaper);
  if (CoreManualFeed) EMITS(" @manualfeed");
  EMITS("\n");

  EMIT(outfp, "/#copies %d def\n", CoreCopies);
  EMITS("%%EndSetup\n");

  return(True);
}

/*-->PSFontInit		(improvement proc) oka 27-Aug-1989 */
/**********************************************************************/
/***************************  PSFontInit  *****************************/
/**********************************************************************/

static FontTable *
PSFontInit(fe)
register FontEntry *fe;
{
  register FontTable *ft = (FontTable *) GetFontAttribute(fe);

  if (ft) return(ft);

  ft = (FontTable *) AllocMemory(sizeof(FontTable));
  ft->n_dload = 0;
  ft->n_tpxl = 0;
  ft->n_cset = 0;
  PutFontAttribute(fe, (long) ft);

  return(ft);
}

/*-->PSFontClearAll		(improvement proc) oka 27-Aug-1989 */
/**********************************************************************/
/**************************  PSFontClearAll  **************************/
/**********************************************************************/

static void
PSFontClearAll(fe)
register FontEntry *fe;
{
  register FontTable *ft = (FontTable *) GetFontAttribute(fe);

  if (ft) {
    ft->n_dload = 0;
    ft->n_tpxl = 0;
    ft->n_cset = 0;
  }
}

static bool
bop()
{
  StringPtr = 0;
  hold_h = -9999, hold_v = -9999;
#ifdef PTEX
  hold_dir = 0;
#endif /* PTEX */

  /* once pass begin of page */
  EMIT(outfp, "%%%%Page: %d %d\n", dvi_info.curPage->sheet_page, ++ordinal_page);
  /* EMIT(outfp, "%%%%PageFonts: (atend)\n"); */
  /* EMIT(outfp, "%%%%PageBoundingBox:\n"); */
  EMIT(outfp, "%%%%BeginPageSetup\n");
  EMIT(outfp, "%%%%EndPageSetup\n");
  EMIT(outfp,"@bop\n", dvi_info.curPage->sheet_page);
#ifndef GLOBAL_FONT
  FontsForAll(PSFontClearAll);
  Stnc = 0;
  Sndc = 0;
  Snbpxl = 0;
#else
  if (Option.Stats) {
    Stnc0 = Stnc;
    Sndc0 = Sndc;
    Snbpx0 = Snbpxl;
  }
#endif
  return(True);
}

/*-->show_status*/
/**********************************************************************/
/***************************  show_status  ****************************/
/**********************************************************************/

static void
show_status(fe)
register FontEntry *fe;
{
  register FontTable *ft = (FontTable *) GetFontAttribute(fe);

  if (ft && (ft->n_cset > 0 || ft->n_tpxl > 0)) {
    prerror( "  %10d%4d", ft->n_cset, (100*ft->n_cset + Stnc/2)/Stnc);
    prerror( "  %10d%4d", ft->n_tpxl, (100*ft->n_tpxl + Snbpxl/2)/Snbpxl);
    prerror( "  %10s[%4d]\n", fe->common.n, fix(fe->common.font_mag));
  }
}

/*-->font_status*/
/**********************************************************************/
/***************************  font_status  ****************************/
/**********************************************************************/

static void
font_status()
{
  prerror("     Total chars       pxl bytes\n" );
  prerror("           #   %%           #   %%\n" );
  prerror("     ------- ---     ------- ---\n" );
  FontsForAll(show_status);
  prerror("     ------- ---       ----- ---    -----------------\n" );
  prerror("     %7d%4d[%%]   %6d%4d[%%]\n\n" ,Stnc, 100, Snbpxl, 100);
  prerror("Total number of bitmap characters registration:    %8d\n", Sndc);
  prerror("Total number of characters typeset:                %8d\n", Stnc);
  prerror("Number of bytes of pxl data downloaded:            %8d\n", Snbpxl);
  prerror("Optimal # of bytes of pxl data:                    %8d\n", Sonbpx);
}

static void
EmitString()
{
  if (StringPtr == 0) return;
  else {
    register int i, c;

    EMITC('(');
    for (i = 0; i < StringPtr; ++i) {
      c = StringBuf[i];
      if (c < ' ' || c >= 0177) EMITO(c);
      else if (c == '(' || c == ')' || c == '\\') {
	EMITC('\\'); 
	EMITC(c); 
      } else EMITC(c);
    }
    EMITS(") s\n");
  }
  StringPtr = 0;
}

static void
HoldChar(c, hh, vv)
register u32 c;
register i32 hh, vv;
{
  if (StringPtr == 0) SetPosn(hh, vv);
  if (StringPtr < STRINGBUFSIZE) StringBuf[StringPtr++] = (char) c;
  else {
    EmitString();
    HoldChar(c, hh, vv);
  }
}

static void
show_fontname(fe)
register FontEntry *fe;
{
  EMIT(outfp, "%%%%+ %s.%d\n", fe->common.n, fix(fe->common.font_mag));
}

static bool
eop()
{
  EmitString();
  /* end of second pass, and of page processing */
  EMITS("@eop\n");
  EMIT(outfp, "%%%%PageTrailer\n");
  /* EMITS("%%PageFonts: \n");
  FontsForAll(show_fontname); */
  if (Option.Stats) {
#ifndef GLOBAL_FONT
    font_status();
#else
    prerror( " - %d total character on this page\n", Stnc-Stnc0);
#endif
  }
  return(True);
}

/*-->SetFntNum		(improvement proc) oka 27-Feb-1989 */
/**********************************************************************/
/****************************  SetFntNum  *****************************/
/**********************************************************************/

static void
set_fnt_num(fe)
register FontEntry *fe;
/*  this routine is used to specify the font to be used in printing future
 *  characters
 */
{
  JFontName	*fn;

  EmitString();
  psfe = PSFontInit(fe);
  if ((fn = JapaneseFont(fe)) != NULL) {
    if (Option.isFive)
      EMIT(outfp,"%s %.3f @jsf\n", fn->tex_name,
	   (double) GetJfmDotSize(fe, (JFM *) GetJfmHandle(fe)) /
	   (double) CoreResolution * 72.27);
    else
      EMIT(outfp,"%s %.3f @jsf\n", fn->ps_name,
	   (double) GetJfmDotSize(fe, (JFM *) GetJfmHandle(fe)) /
	   (double) CoreResolution * 72.27);
  } else {
    if (strcmp(fe->common.font_ops->extension, "tfm")) {
      if (psfe->n_dload == 0) {
	EMIT(outfp, "/%s.%d @nf\n",
	     fe->common.n, fix(fe->common.font_mag));
      }
      EMIT(outfp,"/%s.%d @sf\n", fe->common.n, fix(fe->common.font_mag));
    } else {
      /* only when tfm blank font is used */
      EMIT(outfp, "/%s %.3f @psf\n", fe->common.n,
	   GetTfmDotSize(fe, (TFM *) GetTfmHandle(fe)));
    }
  }
}

static void
EmitChar(c, ce)              /* output a character bitmap */
register u32 c;
register CharEntry *ce;
{
  register int i, j;
  register unsigned char *sl;
  register int cc;
  register int nbpl, nspl;

  if (ce->where.address.bitmap) {

    /* Output in PostScript coord system (y +ive up, x +ive right)
       (0,0) of char bitmap at lower left.  Output scan lines
       from bottom to top */

    EMITS("[<");
    cc = 2;
    nbpl = ((int) ce->width + 7) >> 3;

    nspl = UWIDTH((int) ce->width);
    for(i = ce->height-1;  i >= 0;  i--) {
      sl = (unsigned char *)(ce->where.address.bitmap + i*nspl);
      for(j = 0;  j < nbpl;  j++, sl++) {
	if( cc > 100 ) {
	  EMITS("\n  ");
	  cc = 2;
	}
	EMITH(*sl);
	cc += 2;
      }
    }

#if 0
    /* print font bitmap */
    {
      int	i,j,k;
      prerror( "<%c>[%d,%d]offset[%d,%d]nb[%d]nw[%d]\n",
	       c, ce->width,ce->height,
	       ce->xOffset,ce->yOffset,nbpl,nspl);
      for (i = 0 ; i < ce->height ; i++) {
	for (j = 0 ; j < nspl ; j++) {
	  for (k = 0 ; k < 8 ; k++) {
	    prerror("%c",
		    (*(((char *)(ce->where.address.bitmap) + i*nspl+j)))
		    & (0x80 >> k) ? '0' : '_');
	  }
	}
	prerror( "\n");
      }
    }
#endif

    EMIT(outfp,"> %d %d %d %d %d] %d @dc\n", 
	 nbpl<<3, ce->height, ce->xOffset,
	 (((int)ce->height)-ce->yOffset)-1, HConv(ce->tfmw), c);
    PutGlyphAttribute2(ce, (long) dvi_info.curPage);
  }

  Snbpxl += nbpl*ce->height;
  Sonbpx += ((int) ce->width * (int) ce->height + 7) >> 3;
  Sndc++;
  psfe->n_tpxl += nbpl*ce->height;
  psfe->n_dload++;
}

/*
 * set_char:
 */

static AdjustRatioRecord *
findAdjustTbl(fn, c)
JFontName *fn;
register u32 c;
{
  register int lower, upper, key;
  register AdjustRatioRecord *ar;

  ar = fn->adj_table;
  lower = 0;
  upper = fn->size_of_adj_table;
  while (lower <= upper) {
    key = ( lower + upper ) / 2;
    if ( c == ar[key].code ) {
#ifdef DEBUG
      prerror("Adjustment for %x(%g,%g) is executed!\n",
	      ar[key].code, ar[key].Xadj, ar[key].Yadj );
#endif
      return(&ar[key]);
    } else if ( c < ar[key].code ) upper = --key;
    else lower = ++key;
  }
  return(NULL);
}

#ifdef PTEX
static void
set_char(ptr, c, h, v, hh, vv, dir)
register CharEntry *ptr;
register u32 c;
register i32 h, v, hh, vv;
register u8 dir;
{
  JFontName *fn;

  if (c > 127 && (fn = JapaneseFont(dvi_info.curFont)) != NULL) {
    register JFM *jfm = (JFM *) GetJfmHandle(dvi_info.curFont);
    if (find_type(jfm, c) != 0) {
      AdjustRatioRecord *ar = findAdjustTbl(fn, c);
      if (ar) {
	int size = GetJfmDotSize(dvi_info.curFont, jfm);

	hh += size * ar->Xadj;
	vv += size * ar->Yadj;
      }
    }
    EmitString();
    SetPosn(hh, vv);
    /* EMITN(c & 0xff); EMITN(c >> 8); EMITS("jc\n"); */
    EMIT(outfp, "<%02x%02x> jc\n", c >> 8, c & 0xff);
  } else {
    if (GetGlyphAttribute2(ptr) != (long) dvi_info.curPage)
      EmitChar(c, ptr);
    if (h != hold_h || v != hold_v || dir != hold_dir)
      EmitString();
    if (hold_dir != dir)
      EMIT(outfp, "/dir %d def\n", (int) dir);
    /* emit the instructions */
    HoldChar(c, hh, vv);
    if (dir) {
      hold_h = h;
      hold_v = v + ptr->tfmw;
    } else {
      hold_h = h + ptr->tfmw;
      hold_v = v;
    }
    hold_dir = dir;
  }
  /*- status -*/
  ++Stnc;
  ++psfe->n_cset;
  /*- status -*/
}
#else
static void
set_char(ptr, c, h, v, hh, vv)
register CharEntry *ptr;
register u32 c;
register i32 h, v, hh, vv;
{
  JFontName *fn;

  if (c > 127 && (fn = JapaneseFont(dvi_info.curFont)) != NULL) {
    register JFM *jfm = (JFM *) GetJfmHandle(dvi_info.curFont);
    if (find_type(jfm, c) != 0) {
      AdjustRatioRecord *ar = findAdjustTbl(fn, c);
      if (ar) {
	int size = GetJfmDotSize(dvi_info.curFont, jfm);

	hh += size * ar->Xadj;
	vv += size * ar->Yadj;
      }
    }
    EmitString();
    SetPosn(hh, vv);
    /* EMITN(c & 0xff); EMITN((unsigned int)c >> 8); EMITS("jc\n"); */
    EMIT(outfp, "<%02x%02x> jc\n", (unsigned int)c >> 8, c & 0xff);
  } else {
    if (GetGlyphAttribute2(ptr) != (long) dvi_info.curPage)
      EmitChar(c, ptr);
    if (h != hold_h || v != hold_v)
      EmitString();
    /* emit the instructions */
    HoldChar(c, hh, vv);
    hold_h = h + ptr->tfmw;
    hold_v = v;
  }
  /*- status -*/
  ++Stnc;
  ++psfe->n_cset;
  /*- status -*/
}
#endif /* PTEX */

/*
 * set_rule:
 *	This routine will draw a rule on the screen
 */

static void
set_rule(a, b, hh, vv, ehh, evv)
register u32 a, b;
register i32 hh, vv, ehh, evv;
{
  EmitString();
  SetPosn(hh,evv);	/* lower left corner */
  EMITN(ehh - hh);	/* width */
  EMITN(evv - vv);	/* height */
  EMITS("ru\n");
}

/*-->do_special*/
/*********************************************************************/
/****************************  do_special  ***************************/
/*********************************************************************/

typedef enum {None, String, Integer, Number, Dimension} ValTyp;

typedef struct {
  char    *Key;           /* the keyword string */
  char    *Val;           /* the value string */
  ValTyp  vt;             /* the value type */
  union {                 /* the decoded value */
    int  i;
    float n;
  } v;
} KeyWord;

typedef struct {
  char    *Entry;
  ValTyp  Type;
} KeyDesc;

#define PSFILE 0
KeyDesc KeyTab[] = {{"psfile", String},
                    {"hsize", Dimension},
                    {"vsize", Dimension},
                    {"hoffset", Dimension},
                    {"voffset", Dimension},
                    {"hscale", Number},
                    {"vscale", Number}};

/*-->IsSame*/
/**********************************************************************/
/*******************************  IsSame  *****************************/
/**********************************************************************/

static int
IsSame(a, b)        /* compare strings, ignore case */
char *a, *b;
{
  for( ; *a != '\0'; ) {
    if( tolower(*a++) != tolower(*b++) ) {
      return( False );
    }
  }
  return( *a == *b ? True : False );
}

/*-->GetKeyVal*/
/**********************************************************************/
/*****************************  GetKeyVal  ****************************/
/**********************************************************************/

/* get next keyword-value pair
 * decode value according to table entry
 */

static int
GetKeyVal( kw, tab, nt, tno)
KeyWord *kw; 
KeyDesc tab[];
int     nt;
int     *tno;
{
  int i;
  char c = '\0';

  *tno = -1;

  for(i=0; i<nt; i++) {
    if( IsSame(kw->Key, tab[i].Entry) ) {
      *tno = i;
      switch( tab[i].Type ) {
      case None: 
	if( kw->vt != None ) return( False );
	break;
      case String:
	if( kw->vt != String ) return( False );
	break;
      case Integer:
	if( kw->vt != String ) return( False );
	if( sscanf(kw->Val,"%d%c", &(kw->v.i), &c) != 1
	   || c != '\0' ) return( False );
	break;
      case Number:
      case Dimension:
	if( kw->vt != String ) return( False );
	if( sscanf(kw->Val,"%f%c", &(kw->v.n), &c) != 1
	   || c != '\0' ) return( False );
	break;
      }
      kw->vt = tab[i].Type;
      return( True );
    }
  }
  return( True );
}

/*-->GetKeyStr*/
/**********************************************************************/
/*****************************  GetKeyStr  ****************************/
/**********************************************************************/

/* extract first keyword-value pair from string (value part may be null)
 * return pointer to remainder of string
 * return NULL if none found
 */

char    KeyStr[STRSIZE];
char    ValStr[STRSIZE];

static char
*GetKeyStr( str, kw )
char    *str;
KeyWord *kw;
{
  char *s, *k, *v, t;

  if( !str ) return( NULL );

  for( s=str; *s == ' '; s++ ) ;	/* skip over blanks */
  if( *s == '\0' ) return( NULL );

  for( k=KeyStr;			/* extract keyword portion */
      *s != ' ' && *s != '\0' && *s != '='; 
      *k++ = *s++ ) ;
  *k = '\0';
  kw->Key = KeyStr;
  kw->Val = v = NULL;
  kw->vt = None;

  for( ; *s == ' '; s++ ) ;	/* skip over blanks */
  if( *s != '=' )			/* look for "=" */
    return( s );

  for( s++ ; *s == ' '; s++ ) ;	/* skip over blanks */
  if( *s == '\'' || *s == '\"' )	/* get string delimiter */
    t = *s++;
  else
    t = ' ';
  for( v=ValStr;			/* copy value portion up to delim */
      *s != t && *s != '\0';
      *v++ = *s++ ) ;
  if( t != ' ' && *s == t ) s++;
  *v = '\0';
  kw->Val = ValStr;
  kw->vt = String;

  return( s );
}

/*-->DoPostScriptBox*/
/**********************************************************************/
/*************************  DoPostScriptBox  **************************/
/**********************************************************************/

#define		Min(a, b)	((a) > (b) ? (b) : (a))
#define		Abs(n)		(((n) >= 0) ? (n) : -(n))

int	framemode	= False;	/* Framemarker compatibility mode.  */
int	skip_postscript	= False;	/* input PostScript data flad */

/*
 * DoPostScriptBox:
 *  This is where the postscriptbox is handled.
 *  Note that the width and height here are in real points (1/72.27 inch)
 *  as generated from TeX, as opposed to the silly 1/72 inch PS points.
 */

void
DoPostScriptBox(str)
char *str;
{
  register FILE *spfp;
  float width;
  float height;
  float x1, y1, x2, y2;
  float bbx, bby, bbw, bbh;
  float ho, vo, hsc, vsc;
  int foundsize;
  char name[STRSIZE];
  char dummy[10];
  char line[STRSIZE];
  char fullname[STRSIZE];

  /*
   * Read args and open file.
   */
  if (sscanf(str, "postscriptbox { %fpt }{ %fpt }{ %[^ {}] }",
	     &width, &height, name) != 3) {
    prerror("badly formed postscriptbox command `%s'.", str);
    return;
  }

  /*
   * Open the PS file.
   */
  if ((spfp = fopenp(dvi_info.directory, ps_path, ps_suff, name, fullname, "r")) == NULL) {
      prerror("unable to open %s for postscriptbox cmd.", name);
      return;
  }

  /*
   * Search for BoundingBox or Frame, and rewind.
   */
  foundsize = False;
  while(fgets(line, STRSIZE, spfp)) {
    if(sscanf(line, " %%%% BoundingBox : %f %f %f %f ",
	      &x1, &y1, &x2, &y2) == 4) {
      bbx = Min(x1, x2);
      bby = Min(y1, y2);
      bbw = Abs(x2 - x1);
      bbh = Abs(y2 - y1);
      foundsize = True;
      break;
    }
    if(framemode &&
       sscanf(line, " %f %f %f %f %[C] ",
	      &x1, &y1, &x2, &y2, &dummy[0]) == 5) {
      bbx = Min(x1, x2);
      bby = Min(y1, y2);
      bbw = Abs(x2 - x1);
      bbh = Abs(y2 - y1);
      foundsize = True;
      break;
    }
  }
  (void) fseek(spfp, 0L, 0);
  if(! foundsize) {
    prerror("no BoundingBox found: assuming unit square.");
    bbx = 0.0;
    bby = 0.0;
    bbw = 1.0;
    bbh = 1.0;
  }

  /*
   * Emit preamble.
   *  The PS box thinks it will print in bbw PSpoints, or bbw/72 inches.
   *  TeX wants it to fit into width real points, or width/72.27 inches.
   *  The current scale has been reset to 72 dots per inch.
   * Scale = (width/72.27) / (bbw/72).
   */
  hsc = (width/72.27) * (72.0/bbw);
  vsc = (height/72.27) * (72.0/bbh);
  ho = -bbx * hsc;
  vo = -bby * vsc;
  if(! skip_postscript) {
    EMIT(outfp, "%% \\postscriptbox{%f}{%f}{%s}\n", width, height, name);
    EMIT(outfp, "%f @hoffset %f @voffset\n", ho, vo);
    EMIT(outfp, "%f @hscale %f @vscale\n", hsc, vsc);

    /*
     * Copy file.
     */
    EMITS("@setspecial\n");
    copy_file(spfp, name, fullname);
  } else
    prerror(" (%s skipped)", name);

  (void) fclose(spfp);
}

#define NKEYS (sizeof(KeyTab)/sizeof(KeyTab[0]))

static void
do_special( str, n, hh, vv )          /* interpret a \special command, made up of keyword=value pairs */
char    *str;
u32 n;
i32 hh, vv;
{ 
  int access();
  char spbuf[STRSIZE]; 
  char *sf = NULL;
  KeyWord k;
  int i;
  double actual_factor();

  EmitString();
  str[n] = '\0';
  spbuf[0] = '\0';

  /* Handling psfig macros */
  /* skip blank */
  for (i = 0; str[i] == ' ' && i < n; ++i) ;
/*
  if (strncmp(&str[i], "pstext=", 7) == 0) {
    i += 7;
    if (strncmp(&str[i], "endTexFig", 9) == 0) {
      EMITS("endTexFig\n");
      EMITS("@endspecial\n");
    } else {
      int j;

      SetPosn(hh, vv);
      EMITS("@beginspecial\n");
      EMITS("@setspecial\n");
      if (str[i] == '\"') {
	for (j = ++i; str[j] != '\"' && j < n; ++j) ;
	str[j] = '\0';
      }
      EMITS(&str[i]);
      EMITS("\n");
    }
    return;
  } else if (strncmp(&str[i], "psfile=", 7) == 0) {
    int j;

    i += 7;
    for (j = i; str[j] != ' ' && j < n; ++j) ;
    str[j] = '\0';
    CopyFile(&str[i]);
    return;
  }
*/

  SetPosn(hh, vv);
  if (strncmp(str, "ps:", 3) == 0) {
    EMITS("\n");
    EMITS(&str[3]);
    EMITS("\n");
    return;
  }
  EMIT(outfp, "%.4f @beginspecial\n", (double) actual_factor(dvi_info.mag));

  if (strncmp(str,"postscriptbox",13) == 0) {
    DoPostScriptBox(str);
  } else if (strncmp(str, "\" ", 2) == 0) {
    EMITS("@setspecial\n");
    EMITS(&str[2]);
  } else {
    /* get all keyword-value pairs */
    while( (str=GetKeyStr(str,&k)) != NULL ) {
      /* for compatibility, single words are taken as file names */
      if( k.vt == None && access(k.Key,0) == 0) {
	if( sf ) {
	  prerror("More than one \\special file name given. %s ignored", sf );
	}
	(void) strcpy(spbuf, k.Key);
	sf = spbuf;
      } else if( GetKeyVal( &k, KeyTab, NKEYS, &i ) && i != -1 ) {
	if( i == PSFILE ) {
	  if( sf )
	    prerror("More than one \\special file name given. %s ignored", sf );
	  (void) strcpy(spbuf, k.Val);
	  sf = spbuf;
	} else {
	  /* the keywords are simply output as PS procedure calls */
	  EMIT(outfp, "%f @%s\n", k.v.n, KeyTab[i].Entry);
	}
      } else
	prerror("  Invalid keyword or value in \\special - \"%s\" ignored", k.Key );
    }

    EMITS("@setspecial\n");
    if( sf ) {
      CopyFile( sf );
    } else
      prerror("  No special file name provided.");
  }
  EMITS("\n@endspecial\n");
}
