/*
 * Page mark ring for xdvi
 *
 * Copyright (c) 1993
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#include <stdio.h>
#include "markpage.h"

static  MARKRING        *PageMarkRing;

void
  CreateNewPageMarkRing()
{
  PageMarkRing = CreateNewRing();
}

void
  MakePageMarkRingNull()
{
  MakeRingNull(PageMarkRing);
}

BOOL
  ThisPageIsMarked(page)
PAGE page;
{
  return(MemberOfRing(page,PageMarkRing));
}

void
  MarkPage(page)
PAGE page;
{
  if (ThisPageIsMarked(page)) {
    PurgeTheValueAllFromRing(page,PageMarkRing);
  }
  AddElementToRing(page,PageMarkRing);
  /* Like LRU-stack */
}

void
  UnmarkPage(page)
PAGE page;
{
  if (ThisPageIsMarked(page)) {
    PurgeTheValueAllFromRing(page,PageMarkRing);
  }
}

void
  ReverseTheMarkOfPage(page)
PAGE page;
{
  if (ThisPageIsMarked(page)) {
    UnmarkPage(page);
  }
  else {
    MarkPage(page);
  }
}

BOOL
  EmptyPageMarkRing()
{
  return(EmptyRing(PageMarkRing));
}

PAGE
  LastMarkPage()
{
  return(RingLastElement(PageMarkRing));
}

void
  SetPageMarkAtLast(page)
PAGE page;
{
  if (! ThisPageIsMarked(page)) {
    PurgeLastElementFromRing(PageMarkRing);
  }
  MarkPage(page);
}

void
  RotatePageMarkRing()
{
  RotateRing(PageMarkRing);
}

LIST_LOCATION
  MakeMarkedPageList(PageList)
PAGE PageList[LISTSIZE];
{
  return(MakeListFromRing(PageMarkRing,PageList));
}

LIST_LOCATION
  MakeSortedMarkedPageList(PageList)
PAGE PageList[LISTSIZE];
{
  return(MakeListFromRing(MakeRingSort(PageMarkRing),PageList));
}

void
  GetMarkedPageListAsString(ResultString,prevchar,postchar,delimiter)
char ResultString[STRLENGTH], prevchar, postchar, delimiter;
{
  PAGE          PageList[LISTSIZE];
  LIST_LOCATION EndLocation, loc;
  char          buff[STRLENGTH];
  
  ResultString[0] = NULL;
  EndLocation = MakeMarkedPageList(PageList);
  if (EndLocation >= INITIAL_LIST) {
    if(prevchar!=NULL) {
      sprintf(buff, "%c", prevchar);
      strcat(ResultString, buff);
    }
    /* Put a character on the previous position of the first page number */
    sprintf(buff, "%d", PageList[INITIAL_LIST] + 1);
    strcat(ResultString, buff);
    /* Put the first page number */
    if(postchar!=NULL) {
      sprintf(buff, "%c", postchar);
      strcat(ResultString, buff);
    }
    /* Put a character on the post position of the first page number */
    for(loc = INITIAL_LIST + 1; loc<=EndLocation; loc++) {
      sprintf(buff, "%c", delimiter);
      strcat(ResultString, buff);
      /* Put the delimiter character */
      if(prevchar!=NULL) {
	sprintf(buff, "%c", prevchar);
	strcat(ResultString, buff);
      }
      /* Put a character on the previous position of the first page number */
      sprintf(buff, "%d", PageList[loc] + 1);
      strcat(ResultString, buff);
      /* Put the page number */
      if(postchar!=NULL) {
	sprintf(buff, "%c", postchar);
	strcat(ResultString, buff);
      }
      /* Put a character on the post position of the first page number */
    }
  }
}

void
  GetSortedMarkedPageListAsString(ResultString,prevchar,postchar,delimiter)
char ResultString[STRLENGTH], prevchar, postchar, delimiter;
{
  PAGE          PageList[LISTSIZE];
  LIST_LOCATION EndLocation, loc;
  char          buff[STRLENGTH];
  
  ResultString[0] = NULL;
  EndLocation = MakeSortedMarkedPageList(PageList);
  if (EndLocation >= INITIAL_LIST) {
    if(prevchar!=NULL) {
      sprintf(buff, "%c", prevchar);
      strcat(ResultString, buff);
    }
    /* Put a character on the previous position of the first page number */
    sprintf(buff, "%d", PageList[INITIAL_LIST] + 1);
    strcat(ResultString, buff);
    /* Put the first page number */
    if(postchar!=NULL) {
      sprintf(buff, "%c", postchar);
      strcat(ResultString, buff);
    }
    /* Put a character on the post position of the first page number */
    for(loc = INITIAL_LIST + 1; loc<=EndLocation; loc++) {
      sprintf(buff, "%c", delimiter);
      strcat(ResultString, buff);
      /* Put the delimiter character */
      if(prevchar!=NULL) {
	sprintf(buff, "%c", prevchar);
	strcat(ResultString, buff);
      }
      /* Put a character on the previous position of the first page number */
      sprintf(buff, "%d", PageList[loc] + 1);
      strcat(ResultString, buff);
      /* Put the page number */
      if(postchar!=NULL) {
	sprintf(buff, "%c", postchar);
	strcat(ResultString, buff);
      }
      /* Put a character on the post position of the first page number */
    }
  }
}
