/*
 * Mark ring package
 *
 * Copyright (c) 1993
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

typedef int             BOOL;
#ifndef TRUE
#define TRUE            (1)
#define FALSE           (0)
#endif

typedef unsigned short int      NUMBER;

typedef int             RING_ELEMENT;   /* contents of Ring */
#ifndef RINGSIZE
#define RINGSIZE        16
#endif /* RINGSIZE */
typedef short int       RING_LOCATION;  /* index of Ring */
#define ILLEGAL_LOCAT   -1              /* when location is illegal */
#define INITIAL_FRONT   0               /* front index */
#define INITIAL_REAR    RINGSIZE-1      /* rear index */

struct MarkRing {
  RING_ELEMENT    element[RINGSIZE]  ;    /* Ring body */
  RING_LOCATION   front,rear;
  /* front     : index of first-in element */
  /* rear      : index of last-in element */
};

typedef struct MarkRing MARKRING;

typedef RING_ELEMENT    LIST_ELEMENT;   /* contents of List */
#define LISTSIZE        RINGSIZE
typedef short int       LIST_LOCATION;  /* index of List */
#define INITIAL_LIST   0                /* initial position of List */

typedef LIST_ELEMENT    MARKLIST[LISTSIZE];

extern  void             MakeRingNull();
extern  MARKRING         *CreateNewRing();
extern  BOOL             EmptyRing();
extern  BOOL             ElementExistsHereInRing();
extern  BOOL             BetweenOnRing();
extern  BOOL             MemberOfRing();
extern  RING_LOCATION    LocationOfMemberInRing();
extern  RING_ELEMENT     RingTopElement();
extern  RING_ELEMENT     RingLastElement();
extern  NUMBER           NumberOfElementsInRing();
extern  void             PurgeOldElementFromRing();
extern  void             PurgeLastElementFromRing();
extern  void             PurgeElementHereFromRing();
extern  void             PurgeTheValueAllFromRing();
extern  void             AddElementToRing();
extern  void             InsertElementToRing();
extern  void             RotateRing();
extern  void             ReverseRotateRing();
extern  MARKRING         *CopyRing();
extern  MARKRING         *MakeRingUnique();
extern  BOOL             RingElemCompare();
extern  MARKRING         *MakeRingSort();
extern  LIST_LOCATION    MakeListFromRing();

#define Ring_Next_Location(i)   ( ((i)+1) % RINGSIZE )
#define Ring_Prev_Location(i)   ( (i)==INITIAL_FRONT ? INITIAL_REAR : ((i)-1) )
#define Is_Next_In_Ring(i,j)            ( Ring_Next_Location(j)==(i) )
#define Is_Prev_In_Ring(i,j)            ( Ring_Prev_Location(j)==(i) )
#define Is_Empty_Location(front,rear)   ( Is_Next_In_Ring(front,rear) )
