/*
 * print-out DVI
 *
 * Copyright (c) 1993
 *      MATSUURA Syun           syun@fuka.info.waseda.ac.jp
 *      HIRAHARA Atsushi        hirahara@fuka.info.waseda.ac.jp
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

/*
 * Internal variables for print-out command string
 *
 * %f : filename of DVI file (full pathname)
 * %F : filename of DVI file (basename of pathname)
 * %d : directory where DVI file is placed (directory of pathname)
 * %p : printer name (if the environment variable PRINTER is defined, use it)
 * %r : proces id
 *
 * The following variables denote absolute page number.
 * %c : current page number
#ifdef MARKPAGE
 * %m : lastly marked page number
 * %s : start page number of region; minimum of %c and %m
 * %e : end page number of region; maximum of %c and %m
 * %l : marked page list; marked order; separated by ","
 * %L : marked page list; marked order; separated by " "
 * %t : marked page list; sorted; separated by ","
 * %T : marked page list; sorted; separated by " "
 * %k : like %l; '=' is put on each page number (assumed dviselect)
 * %K : like %L; '=' is put on each page number (assumed dviselect)
 * %a : like %t; '=' is put on each page number (assumed dviselect)
 * %A : like %T; '=' is put on each page number (assumed dviselect)
#endif
 */

#define DEFAULTPRINTER  "lp"
#define ENVVARPRINTER   "PRINTER"
#define PRINTERNAMELEN  32

#define VARMARK    '%'
/* Print-out command templates */
#ifndef PRCMDALL
#define	PRCMDALL   "cd %d; dvi2ps %F > /tmp/%F:All@%r.ps; lpr -s -r -P%p -J'%F' /tmp/%F:All@%r.ps"
/* all pages of DVI file */
#endif /* PRCMDALL */
#ifndef PRCMDCUR
#define	PRCMDCUR   "cd %d; dviselect -i %F -o /tmp/%F:%c@%r.dvi =%c; dvi2ps /tmp/%F:%c@%r.dvi > /tmp/%F:%c@%r.ps; /bin/rm /tmp/%F:%c@%r.dvi; lpr -s -r -P%p -J'%F (Page %c)' /tmp/%F:%c@%r.ps"
/* the current page */
#endif /* PRCMDCUR */
#ifdef MARKPAGE
#ifndef PRCMDMRK
#define	PRCMDMRK   "cd %d; dviselect -i %F -o /tmp/%F:%m@%r.dvi =%m; dvi2ps /tmp/%F:%m@%r.dvi > /tmp/%F:%m@%r.ps; /bin/rm /tmp/%F:%m@%r.dvi; lpr -s -r -P%p -J'%F (Page %m)' /tmp/%F:%m@%r.ps"
/* the lastly marked page */
#endif /* PRCMDMRK */
#ifndef PRCMDRGN
#define	PRCMDRGN   "cd %d; dviselect -i %F -o /tmp/%F:%s-%e@%r.dvi =%s:%e; dvi2ps /tmp/%F:%s-%e@%r.dvi > /tmp/%F:%s-%e@%r.ps; /bin/rm /tmp/%F:%s-%e@%r.dvi; lpr -s -r -P%p -J'%F (Page %s-%e)' /tmp/%F:%s-%e@%r.ps"
/* pages in the region, between the current page and the lastly marked page */
#endif /* PRCMDRGN */
#ifndef PRCMDLST
#define	PRCMDLST   "cd %d; dviselect -i %F -o /tmp/%F:%t@%r.dvi %A; dvi2ps /tmp/%F:%t@%r.dvi > /tmp/%F:%t@%r.ps; /bin/rm /tmp/%F:%t@%r.dvi; lpr -P%p -J'%F (Page %t)' /tmp/%F:%t@%r.ps"
/* all marked pages */
#endif /* PRCMDLST */
#endif /* MARKPAGE */

#define LBLPRINTSH             "Print-out"

#define LBLPRINTER             "Printer name"

#define LBLPRINTOUT            "Print"
#define LBLCANCEL              "Cancel"

#define LBLPRINTMENU           "Print menu"

#define LBLPRINTALL            "All pages"
#define LBLPRINTCUR            "Current page"
#ifdef MARKPAGE
#define LBLPRINTMRK            "Lastly marked page"
#define LBLPRINTRGN            "Region"
#define LBLPRINTAMK            "All marked pages"
#endif /* MARKPAGE */

#ifdef MARKPAGE
#define MIN(i,j)        ( (i) < (j) ? (i) : (j) )
#define MAX(i,j)        ( (i) > (j) ? (i) : (j) )
#endif /* MARKPAGE */

#define PATH_DELIMITER  '/'

typedef struct {
  int           print_style;
  Widget        widget;
} PrintOrder;

#define TEMPFILE        "/tmp/XDVI:%r"

extern void     InitPrintMenu();
extern void     print_DVI_file();
