/*
 * Table of Contents / Page list for xdvi
 *
 * Copyright (c) 1993
 *      MATSUURA Syun           syun@fuka.info.waseda.ac.jp
 *      HIRAHARA Atsushi        hirahara@fuka.info.waseda.ac.jp
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>


#include "xdvi.h"
#include "toc.h"
#ifdef MARKPAGE
#include "markpage.h"
#endif /* MARKPAGE */

extern	int	pageno_correct;

static Widget	list_widget, viewport=NULL;
static char	*toc[MAX_PAGE];
static int	press_page_2 = -1;
static int	press_page_3 = -1;

extern	void	keystroke();

static  int
  get_Page_size()
{
  int  offset;
  int  start_page = pageno_correct - 1;
  int  end_page   = start_page + total_pages;
  int  start_pageno_len;
  int  end_pageno_len;
  
  if (start_page >= 0) {
    offset = 0; /* plus symbol is hidden */
  }
  else {
    offset = 1; /* offset for minus symbol */
    start_page = - start_page;
  }
  for (start_pageno_len = offset; start_page > 0;
       start_page /= 10, start_pageno_len++);
  
  if (end_page >= 0) {
    offset = 0; /* plus symbol is hidden */
  }
  else {
    offset = 1; /* offset for minus symbol */
    end_page = - end_page;
  }
  for (end_pageno_len   = offset; end_page > 0;
       end_page /= 10,   end_pageno_len++);
  
  return(MAX(start_pageno_len, end_pageno_len));
  /* Plus 1 for minus symbol */
}


static int
  /* get TOC's width size */
  get_TOC_size()
{
  /* Print format is "  NN<"    get_Page_size() is number of N */
#ifdef	MARKPAGE
  return(get_Page_size()+3)*8+20;
#else
  return(get_Page_size()+1)*8+20;
#endif	/* MARKPAGE */
}


static char *
  StrDup(str)
char *str;
{
  char *ptr = xmalloc(strlen(str) + 1, "strdup");
  return(strcpy(ptr, str));
}

static void
  /* set TOC's string */
  set_TOC()
{
  int   i;
  char  s[PAGENUMLEN];
  
  for( i=0; i<total_pages; i++){
    if( toc[i] )   free(toc[i]);
#ifdef MARKPAGE
    if (ThisPageIsMarked(i)) {
      sprintf(s, "%c %*d%c",
	      i==LastMarkPage() ? LASTMRKPAGESYM : MRKPAGESYM,
	      get_Page_size(), i+pageno_correct,
	      i==current_page   ? CURPAGESYM     : NORMALPAGESYM);
    }
    else {
      sprintf(s, "%c %*d%c",
	      NORMALPAGESYM,
	      get_Page_size(), i+pageno_correct,
	      i==current_page   ? CURPAGESYM     : NORMALPAGESYM);
    }
#else
    sprintf(s, "%*d%c",
	    get_Page_size(), i+pageno_correct,
	    i==current_page   ? CURPAGESYM     : NORMALPAGESYM);
#endif /* MARKPAGE */
    toc[i] = (char *)StrDup(s);
  }
  toc[total_pages] = NULL;
}

void
  Redraw_TOC()
{
  set_TOC();
  XawListChange(list_widget, toc, total_pages, LONGESTPAGENUM, False);
}


/* ARGSUSED */
static void
  /* Called when Button-1 Pressed */
  SelectThisPage(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  XawListReturnStruct *item = (XawListReturnStruct *)call_data;
  
  keystroke('g', item->list_index+pageno_correct, 1, (XEvent *)NULL);
  
  Redraw_TOC();
}


#ifdef MARKPAGE
static void
  /* Called when Button-2 | 3 pressed */
  Press_Mark_Page(w, event, button)
Widget  w;
XEvent  *event;
int     button;
{
  int   x;
  
  switch( button ) {
    /* Get item number */
  case  2 :  press_page_2 = x = (event->xbutton.y-1)/15;    break;
  case  3 :  press_page_3 = x = (event->xbutton.y-1)/15;    break;
  }
  ReverseTheMarkOfPage(x);
  
  Redraw_TOC();
}



static  void
  /* Set or Reset TOC mark */
  set_Drag_TOC(button, x)
int  button, x;
{
  int  i;
  
  i = (button==2) ? press_page_2: press_page_3;
  
  if( i < x ) {
    for( ; i<=x; i++) {
      if (button==2) {
	MarkPage(i);
      }
      else {
	UnmarkPage(i);
      }
    }
  }
  else {
    for( ; i>=x; i--) {
      if (button==2) {
	MarkPage(i);
      }
      else {
	UnmarkPage(i);
      }
    }
  }
}


static void
  /* Called when Button-2 | 3 released */
  Release_Mark_Page(w, event, button)
Widget  w;
XEvent  *event;
int      button;
{
  int   x;
  
  x = (event->xbutton.y-1)/15;	/* Get item number */
  switch( button ) {
  case  2 :  if( (press_page_2 != x) && (press_page_2 != -1) )
    set_Drag_TOC(button, x);
    press_page_2 = 0;
    break;
  case  3 :  if( (press_page_3 != x) && (press_page_3 != -1) )
    set_Drag_TOC(button, x);
    press_page_3 = 0;
    break;
  }
  Redraw_TOC();
}


static void
  /* Called when mouse leaved the LIST-widget */
  Leave_Mark_Page(w, event, button)
Widget  w;
XEvent  *event;
int      button;
{
  press_page_2 = press_page_3 = -1;
}
#endif /* MARKPAGE */


static void
  /* TOC's event handler */
  TOCs_Event_Handler(w, n, event)
Widget          w;
int             n;
XEvent   *event;
{
  switch( event->type ) {
  case  ButtonPress :
    /* when TOC pressed */
    switch( event->xbutton.button ) {
    case  2 : Press_Mark_Page(w, event, 2);  break;
    case  3 : Press_Mark_Page(w, event, 3);  break;
    }
    break;
    
  case  ButtonRelease :
    /* when TOC released */
    switch( event->xbutton.button ) {
    case  2 : Release_Mark_Page(w, event, 2);  break;
    case  3 : Release_Mark_Page(w, event, 3);  break;
    }
    break;
    
  case  LeaveNotify :
    /* when TOC leaved */
    Leave_Mark_Page(w, event);
    break;
  }
}


void
  Create_TOC(parent, h)
Widget    parent;
XtArgVal  h;
{
  int   i;
  char  s[PAGENUMLEN];
  int   height = h - 50;
  
  if( total_pages > MAX_PAGE )  total_pages = MAX_PAGE;
  
  set_TOC();
  
  viewport = XtVaCreateManagedWidget("viewport", viewportWidgetClass, parent,
				     XtNallowVert,	True,
				     XtNforceBars,	True,
				     XtNx,		78,
				     XtNy,		20,
				     XtNheight,		height,
				     XtNwidth,		get_TOC_size(),
				     NULL);
  
  list_widget = XtVaCreateManagedWidget( "list", listWidgetClass, viewport,
					XtNlist,		toc,
					XtNdefaultColumns,	1,
					XtNforceColumns,	True,
					XtNx,			100,
					XtNy,			20,
					XtNheight,		height,
					XtNwidth,		get_TOC_size(),
					XtNlongest,		LONGESTPAGENUM,
					XtNverticalList,	True,
					NULL);
  XtAddCallback(list_widget, XtNcallback, SelectThisPage, (XtPointer)NULL);
#ifdef MARKPAGE
  XtAddEventHandler(list_widget,
		    ButtonPressMask | ButtonReleaseMask | LeaveWindowMask,
		    False, TOCs_Event_Handler, NULL);
#endif /* MARKPAGE */
}
