#!/bin/sh
#
#  Do not run this script, or dvips, as setuid programs!  This will
#  result in a major security hole!
#
#   This script file makes a new TeX PK font, because one wasn't
#   found.  Parameters are:
#
#   name dpi bdpi magnification [mode [subdir]]
#
#   `name' is the name of the font, such as `cmr10'.  `dpi' is
#   the resolution the font is needed at.  `bdpi' is the base
#   resolution, useful for figuring out the mode to make the font
#   in.  `magnification' is a string to pass to MF as the
#   magnification.  `mode', if supplied, is the mode to use.
#
#   Note that this file must execute Metafont, and then gftopk,
#   and place the result in the correct location for the PostScript
#   driver to find it subsequently.  If this doesn't work, it will
#   be evident because MF will be invoked over and over again.
#
#   Of course, it needs to be set up for your site.
#
DESTDIR=%%MAKEPK_DESTDIR%%
DEFAULT_PKPATH=%%DEFAULT_FONT_PATH%%
#
echo -n "Are you sure? [y/n] "
#echo "Are you sure? [y/n] \c"
read yn
case "$yn" in
   y*|Y*) exit
esac
#
# TEMPDIR needs to be unique for each process because of the possibility
# of simultaneous processes running this script.
#
if test X"$TMPDIR" = X""
then
   TEMPDIR=/tmp/mtpk.$$
else
   TEMPDIR=$TMPDIR/mtpk.$$
fi
NAME=$1
DPI=$2
BDPI=$3
MAG=$4
MODE=$5
#
#   Prevent X-windows from displaying.  Except it doesn't always work;
#   some sh'ells don't seem to understand unset.  There are also some
#   versions of METAFONT that don't work if the DISPLAY isn't set and
#   the term type is set to xterm.
#
DISPLAY=""
umask 0

if test X"$MODE" = X""
then
   case $BDPI in
      72)   MODE=seventwo;;
      100)  MODE=nextscreen;;
      200)  MODE=FAX;;
      300)  MODE=imagen;;
      360)  MODE=nextII;;
      400)  MODE=nexthi;;
      635)  MODE=linolo;;
      1270) MODE=linohi;;
      2540) MODE=linosuper;;
      *)    echo "I don't know the mode for $BDPI"
            echo "Have your system admin update MakeTeXPK"
            exit 1;;
   esac
fi

GFNAME=$NAME.$DPI'gf'
PKNAME=$NAME.$DPI'pk'

#  Something like the following is useful at some sites.
# DESTDIR=$DESTDIR/pk.$MODE
# DESTDIR=$DESTDIR/pk$BDPI

if test X"$XDVIFONTS" != X""
then
   PKPATH=$XDVIFONTS
else
   if test X"$TEXPKS" != X""
   then
      PKPATH=$TEXPKS
   else
      if test X"$TEXPACKED" != X""
      then
         PKPATH=$TEXPACKED
      else
         if test X"$PKFONTS" != X""
         then
            PKPATH=$PKFONTS
         else
            if test X"$TEXFONTS" != X""
            then
               PKPATH=$$TEXFONTS
            else
               PKPATH=$DEFAULT_PKPATH
            fi
         fi
      fi
   fi
fi

OIFS="$IFS"
IFS=:

for dir in $PKPATH
do
   if test X"$dir" = X""
   then
      dir="."
   fi
   if test -r $dir/$PKNAME
   then
      echo "$dir/$PKNAME already exists!"
      exit 0
   fi
done

IFS="$OIFS"

# Clean up on normal or abnormal exit
trap "cd /; /bin/rm -rf $TEMPDIR $DESTDIR/pktmp.$$" 0 1 2 15

if test ! -d $DESTDIR
then
   %%MKDIR%% $DESTDIR
   chmod 777 $DESTDIR
fi

if test X"$6" != X""
then
   DESTDIR=$DESTDIR/"$6"
   if test ! -d $DESTDIR
   then
      %%MKDIR%% $DESTDIR
      chmod 777 $DESTDIR
   fi
fi

# added by gwb, to allow searching in current dir before cd'ing
if test X"$MFINPUTS" != X""
then
   MFINPUTS="$MFINPUTS":`pwd`; export MFINPUTS
fi
%%MKDIR%% $TEMPDIR
cd $TEMPDIR

echo "mf \"\\mode:=$MODE; mag:=$MAG; scrollmode; input $NAME\" < /dev/null"
mf "\mode:=$MODE; mag:=$MAG; scrollmode; input $NAME" < /dev/null
if test ! -r $GFNAME
then
   echo "Metafont failed for some reason on $GFNAME"
   exit 1
fi

gftopk -v ./$GFNAME ./$PKNAME

# Install the PK file carefully, since others may be doing the same
# as us simultaneously.

mv $PKNAME $DESTDIR/pktmp.$$
cd $DESTDIR
mv pktmp.$$ $PKNAME
chmod a+r $PKNAME

exit 0

