/*
 *	ps.c
 *
 *		Revision 1.5  1992/09/16  04:43:56  hiro@jaist-east.ac.jp
 *		Revision 1.5a 1993/09/02  23:34:56  miyu@ftp.tohoku.ac.jp
 */

#include <stdio.h>

#include "xdvi.h"
#include "gs-view.h"

#include <string.h>
#include <sys/stat.h>

extern	char	*strDup();

#ifdef	PS_HEADER
#ifndef	VMS
#define	PATH_SEP	':'
#else
#define	PATH_SEP	'/'
#endif
#endif	/* PS_HEADER */

#ifdef	PS_HEADER
int
add_ps_header(fname)
	char	*fname;
{
	char	buf[BUFSIZ];
	char	*path = NULL;
	FILE	*fp;
	static	char	*dirname();

#ifndef	VMS
	if (*fname == '/' ||
	    *fname == '.' && *(fname + 1) == '/' ||
	    *fname == '.' && *(fname + 1) == '.' && *(fname + 2) == '/') {
		Strcpy(buf, fname);
		if (fp = fopen(buf, "r")) {
		    Fclose(fp);
		    path = strDup(buf);
		} else {
		    (void) strcat(buf, ".ps");
		    if (fp = fopen(buf, "r")) {
			Fclose(fp);
			path = strDup(buf);
		    }
		}
	} else
#endif	/* !VMS */
	{
	    char *cp = ps_path;

	    while (*cp) {
		char *cp2 = buf;

		while (*cp && *cp != PATH_SEP)
		    *cp2++ = *cp++;
		if (*cp == PATH_SEP)
		    cp++;
#ifdef	VMS
		*cp2++ = ':';
#else	/* VMS */
		*cp2++ = '/';
#endif	/* VMS */
		Strcpy(cp2, fname);

		if (fp = fopen(buf, "r")) {
		    Fclose(fp);
		    path = strDup(buf);
		    break;
		}
		(void) strcat(buf, ".ps");
		if (fp = fopen(buf, "r")) {
		    Fclose(fp);
		    path = strDup(buf);
		    break;
		}
	    }
	}

	if (!path) {
	    Fprintf(stderr, "%s: PS header file %s not found\n", prog, fname);
	    return -1;
	}

	{
	    struct ps_hdr *new, *p;

	    new = (struct ps_hdr *)
			xmalloc(sizeof(struct ps_hdr), "add_ps_header");
	    if (new == NULL)
		return -1;

	    new->next = (struct ps_hdr *) NULL;
	    new->psheader = path;

	    if (p = ps_headers) {
		while (p->next)
		    p = p->next;
		p->next = new;
	    } else
		ps_headers = new;
	}

	return 0;
}
#endif	/* PS_HEADER */

#ifdef	PS_LITERAL
void
open_temp_ps_file()
{
	extern	FILE	*TmpFile();

	if ((temp_ps_file = TmpFile()) == (FILE *) NULL)
	    exit(1);
}

void
temp_ps_out(s)
	char *s;
{
	Fputs(s, temp_ps_file);
}

void
temp_ps_flush()
{
	Fclose(temp_ps_file);
	open_temp_ps_file();
}
#endif	/* PS_LITERAL */

static	char *
dirname(f1, f2)
	char	*f1;
	char	*f2;
{
	char	*p1, *p2, *q1;
	static char	buf[BUFSIZ];

#ifndef	VMS
	if (*f2 == '/')
		return f2;
#endif	/* !VMS */

	for (p1 = p2 = f1, q1 = buf; *p1; p1++, q1++) {
#ifndef	VMS
	    if (*p1 == '/')
#else
	    if (*p1 == ':')
#endif	/* !VMS */
		p2 = p1 + 1;
	    *q1 = *p1;
	}
	Strcpy(buf + (p2 - f1), f2);

	return buf;
}

static	int
strrncmp(s1, s2, n)
	char	*s1;
	char	*s2;
	int	n;
{
	int	val;

	while (*s1)
	    s1++;
	while (*s2)
	    s2++;

	while (n-- > 0)
	    if (val = *s1-- - *s2--)
		return val;

	return 0;
}

int
get_bounding_box(psfile, llx, lly, urx, ury)
	char	*psfile;
	float	*llx;
	float	*lly;
	float	*urx;
	float	*ury;
{
	FILE	*fptr;
	char	buf[BUFSIZ];

	if ((fptr = xfopen(psfile)) == NULL) {
	    perror(psfile);
	    return -1;
	}

	for (;;) {
	    if (fgets(buf, BUFSIZ, fptr) == NULL) {
		Fprintf(stderr, "%s:unexpected EOF.\n", psfile);
		Fclose(fptr);
		return -1;
	    }
	    if (strncmp(buf, "%%BoundingBox:", 14) == 0) {
		if (sscanf(buf + 14, "%f %f %f %f", llx, lly, urx, ury) < 4) {
		    Fprintf(stderr, "\\special: ERROR.\n");
		    Fclose(fptr);
		    return -1;
		}
		break;
	    }
	}

	Fclose(fptr);

	return 0;
}

int
psSpecial(cp)
	char	*cp;
{
	struct psfig_info	psfile;
	char	*ptr;
	float 	hsize = 0.0, vsize = 0.0;
	float	hscale = 0.0, vscale = 0.0;
	extern	double	atof();
	extern	void	draw_ps();

	psfile.filename = NULL;
#ifdef	PS_LITERAL
	if (strncmp(cp, "ps:",3) == 0) {
	    temp_ps_out("\n");
	    temp_ps_out(&cp[3]);
	    temp_ps_out("\n");
	} else if (*cp == '"') {
	    temp_ps_out("@beginspecial\n@setspecial\n");
	    temp_ps_out(cp + 1);
	    temp_ps_out("\n@endspecial\n");
	} else
#endif	/* PS_LITERAL */
#ifdef	EPSBOX
	if (strncmp(cp, "postscriptbox",13) == 0) {
	    ptr = strtok(cp, "{}");
	    if ((ptr = strtok(NULL, "{}")) == NULL) {
		Fprintf(stderr, "\\special: ERROR.\n");
		return -1;
	    }
	    hsize = atof(ptr);
	    if ((ptr = strtok(NULL, "{}")) == NULL) {
		Fprintf(stderr, "\\special: ERROR.\n");
		return -1;
	    }
	    vsize = atof(ptr);
	    if ((ptr = strtok(NULL, "{}")) == NULL) {
		Fprintf(stderr, "\\special: ERROR.\n");
		return -1;
	    }
	    psfile.filename = dirname(dvi_name, ptr);
	    if (get_bounding_box(psfile.filename,
				 &psfile.llx, &psfile.lly,
				 &psfile.urx, &psfile.ury))
		return -1;

	    if (hsize != 0.0)
		hscale = hsize / (psfile.urx - psfile.llx);
	    if (vsize != 0.0)
		vscale = vsize / (psfile.ury - psfile.lly);

	    if (hscale == 0.0 && vscale == 0.0)
		hscale = vscale = 1.0;
	    else if (hscale == 0.0)
		hscale = vscale;
	    else if (vscale == 0.0)
		vscale = hscale;

	    psfile.hscale = hscale;
	    psfile.vscale = vscale;

	    draw_ps(&psfile, PXL_H, PXL_V, vsize);
	}
	else
#endif	/* EPSBOX */
#ifdef	DVIPS
	if (strncmp(cp, "psfile=", 7) == 0 || strncmp(cp, "PSfile=", 7) == 0) {
	    float	llx = 0.0, lly = 0.0;
	    float	urx = 0.0, ury = 0.0;
	    float	rwi = 0.0, rhi = 0.0;
	    static char	buf[BUFSIZ];

	    if (sscanf(cp + 7, "%s llx=%f lly=%f urx=%f ury=%f rwi=%f rhi=%f",
		       buf, &llx, &lly, &urx, &ury, &rwi, &rhi) < 6) {
		Fprintf(stderr, "\\special: ERROR.\n");
		return -1;
	    }
	    psfile.filename = dirname(dvi_name, buf);
	    if (get_bounding_box(psfile.filename,
				 &psfile.llx, &psfile.lly,
				 &psfile.urx, &psfile.ury))
		return -1;
	    if (urx == llx || ury == lly) {
		Fprintf(stderr, "\\special:ERROR.\n");
		return -1;
	    }
	    psfile.hscale = rwi / (10.0*(urx-llx));
	    psfile.urx = (psfile.urx - psfile.llx) + llx;
	    psfile.llx = llx;
	    if (rhi != 0.0)
		psfile.vscale = rhi / (10.0 * (ury - lly));
	    else
		psfile.vscale = psfile.hscale;
	    vsize = psfile.vscale * (psfile.ury-psfile.lly);
	    psfile.ury = (psfile.ury - psfile.lly ) + lly;
	    psfile.lly = lly;

	    if (psfile.hscale == 0.0 && psfile.vscale == 0.0)
		psfile.hscale = psfile.vscale = 1.0;
  
	    draw_ps(&psfile, PXL_H, PXL_V, vsize);
	} else
#endif	/* DVIPS */
	{
	    for (ptr = strtok(cp, " ="); ptr != NULL; ptr = strtok(NULL, " ="))
		if (strrncmp(ptr, "file", 4) == 0) {
		    if ((ptr = strtok(NULL, " ")) == NULL) {
			Fprintf(stderr, "\\special: ERROR.\n");
			return -1;
		    }
		    psfile.filename = dirname(dvi_name, ptr);
		    if (get_bounding_box(psfile.filename,
					 &psfile.llx, &psfile.lly,
					 &psfile.urx, &psfile.ury))
			return -1;
		}
		else if (strcmp(ptr, "hsize") == 0)
		    hsize = atof(strtok(NULL, " "));
		else if (strcmp(ptr, "vsize") == 0)
		    vsize = atof(strtok(NULL, " "));
		else if (strcmp(ptr, "hscale") == 0) {
		    hscale = atof(strtok(NULL, " "));
		    if (vscale == 0.0)
			vscale = hscale;
		}
		else if (strcmp(ptr, "vscale") == 0) {
		    vscale = atof(strtok(NULL, " "));
		    if (hscale == 0.0)
			hscale = vscale;
		}

	    if (psfile.filename == NULL) {
		Fprintf(stderr, "\\special: ERROR.\n");
		return -1;
	    }

	    if (hsize != 0.0)
		hscale = hsize / (psfile.urx - psfile.llx);
	    if (vsize != 0.0)
		vscale = vsize / (psfile.ury - psfile.lly);

	    if (hscale == 0.0 && vscale == 0.0)
		hscale = vscale = 1.0;
	    else if (hscale == 0.0)
		hscale = vscale;
	    else if (vscale == 0.0)
		vscale = hscale;

	    psfile.hscale = hscale;
	    psfile.vscale = vscale;

	    draw_ps(& psfile, PXL_H, PXL_V, 0.0);
	}

	return 0;
}

#ifdef	DEBUG
int
main()
{
	applicationDoSpecial("psfile=fig1.ps hscale=0.5 vsize=100");
	return 0;
}
#endif

