/*
 * Test program for Vector Font Library VFlib
 *
 *  Programmed by Hirotsugu KAKUGAWA, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 * Edition History
 *  14 Mar. 1993
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include "VF.h"


/* Pixel Size */
#define BUF_XDOTS 200    
#define BUF_YDOTS 200    
#define XDOTS      40
#define YDOTS      40

#define	etoj(c1, c2)	{c1 &= 0x7f; c2 &= 0x7f;}
#define	iseuc1st(c)	((c) >= 0xa1 && (c) <= 0xfe)


main(argc, argv)
  int  argc;
  char **argv;
{
  int  fd;
  int  code1, code2;
  char buff[BUF_YDOTS*(BUF_XDOTS+7)/8];
  char *path;  
  

  code1 = jis2ccode(euc2jis(""));

  VF_init("FontConf");

  if ((path = FontPath((argc>1) ? argv[1]:"goth")) == NULL){
    fprintf(stderr, "path not found\n");
    exit(-1);
  }
  
  if ((fd = VF_open_font(path)) == -1){
    fprintf(stderr, "open error\n");
    exit( -1 );
  }

  bzero(buff, (XDOTS/8)*YDOTS);
  VF_get_bitmap(code1, fd, XDOTS, YDOTS, (BUF_XDOTS+7)/8, 0, buff, 0, 0, 0);
  Dump(buff, XDOTS, YDOTS, (BUF_XDOTS+7)/8);

  VF_close_font(fd);
}

euc2jis(s)
  char  *s;
{
  int j1, j2;

  j1 = s[0];
  j2 = s[1];
  etoj(j1, j2);

  return (j1*0x100 + j2);
}

jis2ccode(jis)
  int  jis;
{
  return (jis/0x100 - 0x21)*94 + (jis%0x100 - 0x21);
}


Dump(s, x, y, yyy)
  char  *s;
  int   x, y, yyy;
{
  register int          i, j;
  unsigned char         d;
  static unsigned char  
    mask[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

  for (j = 0; j < y; j++){
    for (i = 0; i < x; i++){
      d = s[yyy*j + i/8];
      if (d & mask[i%8])
	printf("*");
      else
	printf(" ");
    }
    printf("\n");
  }
}


