/*
 * Test program for Zeit Vector Font Library ZFlib
 *
 *  Programmed by Hirotsugu KAKUGAWA, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 * Edition History
 *  14 Mar. 1993
 */

#include <stdio.h>
#include <sys/types.h>
#include "VF.h"

#define WINSIZE 400


/* Pixel Size */
#define BUF_XDOTS 200    
#define BUF_YDOTS 200    
#define XDOTS      60
#define YDOTS      30

#define	etoj(c1, c2)	{c1 &= 0x7f; c2 &= 0x7f;}
#define	iseuc1st(c)	((c) >= 0xa1 && (c) <= 0xfe)


#define ZF_FONT_DIR  "/usr/local/font/syotai_club/"
/*
#define ZF_FONT_DIR  "/usr/local/font/watanabe_font/"
*/

main(argc, argv)
  int  argc;
  char **argv;
{
  int  fd;
  int  code1, code2;
  char buff[BUF_YDOTS*(BUF_XDOTS+7)/8];
  char f[100];
  char *font = "aska";
  /*char *font = "mg1r";*/
  
  code1 = jis2ccode(euc2jis(""));

  init();

  sprintf(f, "%s%s", ZF_FONT_DIR, font);
  if ((fd = ZF_open_font(f)) == -1){
    fprintf(stderr, "open error\n");
    exit( -1 );
  }

  bzero(buff, (XDOTS/8)*YDOTS);
  ZF_get_bitmap(code1, fd, 
		XDOTS, YDOTS,
		(BUF_XDOTS+7)/8, 2, buff, 0, 0, 0);
  Dump(buff, XDOTS, YDOTS, (BUF_XDOTS+7)/8);

  ZF_close_font(fd);

  deinit();
}

euc2jis(s)
  char  *s;
{
  int j1, j2;

  j1 = s[0];
  j2 = s[1];
  etoj(j1, j2);

  return (j1*0x100 + j2);
}

jis2ccode(jis)
  int  jis;
{
  return (jis/0x100 - 0x21)*94 + (jis%0x100 - 0x21);
}




/*------------------------*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>

Display               *Disp;
Window                Win;
GC                    Gc, GcLine;
XGCValues             GcVal;
XSetWindowAttributes  Att;
unsigned int          WinX, WinY, WinSizeX, WinSizeY, WinBorder, WinDepth;
char                  *DisplayName; 
char                  *WindowName;

int                   CurX, CurY;

init()
{
  WindowName = "Zeit Vector Font";
  DisplayName = NULL;
  WinSizeX = WINSIZE;
  WinSizeY = WINSIZE;

  Disp = XOpenDisplay(DisplayName);
  Win = XCreateSimpleWindow(Disp, RootWindow(Disp, 0), 
			    0, 0, WinSizeX, WinSizeY, 2,
			    WhitePixel(Disp, 0), BlackPixel(Disp, 0));
  XStoreName(Disp, Win, WindowName);
  XMapWindow(Disp, Win);
  Att.override_redirect = True;
  Att.backing_store = Always;
  XChangeWindowAttributes(Disp, Win, CWOverrideRedirect, &Att);
  XChangeWindowAttributes(Disp, Win, CWBackingStore, &Att);
  Gc     = XCreateGC(Disp, Win, 0, 0);
  GcVal.line_width = 1;
  GcLine = XCreateGC(Disp, Win, GCLineWidth, &GcVal);
  XSetForeground(Disp, Gc, BlackPixel(Disp, 0));
  XFillRectangle(Disp, Win, Gc, 0, 0, WinSizeX, WinSizeY);
}

deinit()
{
  XFlush(Disp);
  pause();
}

moveto(x,y)
  int x, y;
{
  printf("MOVETO    (%10d,%10d)\n", x, y);
  CurX = x;
  CurY = y;
}

lineto(x,y)
  int  x, y;
{
  printf("LINETO    (%10d,%10d)\n", x, y);
  XDrawLine(Disp, Win, GcLine, ConvX(CurX), ConvY(CurY), ConvX(x), ConvY(y));
  CurX = x;
  CurY = y;
}

ConvX(x)
  int x;
{
  int  xxx;

  xxx = (int)(((float)WinSizeX)*((float)x/1000.0));
  return xxx;
}

ConvY(y)
  int y;
{
  int  yyy;

  yyy = (int) (((float)WinSizeY)*((float)y/1000.0));
  return yyy;
}


Dump(s, x, y, yyy)
  char  *s;
  int   x, y, yyy;
{
  register int          i, j;
  unsigned char         d;
  static unsigned char  
    mask[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

  for (j = 0; j < y; j++){
    printf("|");
    for (i = 0; i < x; i++){
      d = s[yyy*j + i/8];
      if (d & mask[i%8])
	printf("*");
      else
	printf(" ");
    }
    printf("|");
    printf("\n");
  }
}


