/*
 * VF.h  -  Header file for Vector font library VFlib
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 *  Edition History
 *  13 Mar. 1993
 *  20 Mar. 1993
 *  22 Mar. 1993
 *  10 June 1993  Added JG Font feature
 */


/* This is a part of VFlib
 *
 * Copyright (C) 1993 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * VFlib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any
 * particular purpose or works at all, unless he says so in writing.  Refer
 * to the GNU General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * VFlib, but only under the conditions described in the GNU
 * General Public License.  A copy of this license is supposed to have been
 * given to you along with VFlib so you can know your rights and
 * responsibilities.  It should be in a file named COPYING.  Among other
 * things, the copyright notice and this notice must be preserved on all
 * copies. 
 */


/* Maximun number of fonts */
#define  FONT_TABLE_SIZE   32

/* Font Class ID */
#define  VF_NOT_USED     -1
#define  VF_FONT_SONY     1
#define  VF_FONT_ZEIT     2
#define  VF_FONT_JG       3

#define  VF_FONT_DEFAULT  1  /* sony */


/* access method */
struct _font_method {
  int  (*open_font)();
  int  (*close_font)();
  int  (*get_outline)();
  int  (*scan_conv)();
  int  (*get_bitmap)();
  void (*set_f_xform)();
  void (*fast_xform)();
  void (*set_m_xform)();
  void (*mat_xform)();
};
typedef struct _font_method   Method;

/* Font Class */
struct _font_info {
  int    font_class;
  int    fd;
  char   *font_name;
  Method *method;
};
typedef struct _font_info  FontInfo;



int     VF_init();
int     VF_open_font();
int     VF_close_font();
void    VF_close_font_all();
int     VF_get_outline();
int     VF_scan_conv();
int     VF_get_bitmap();
void    VF_set_fast_xform();
void    VF_fast_xform();
void    VF_set_mat_xform();
void    VF_mat_xform();

int     InternFontAlias();
char*   FontPath();
int     FontTypeByPath();
int     FontType();
int     FontOpened();
int     FontOpenedByAlias();







