/***************************************************
 * NTT JTeX support routine for xdvi-zeit
 * Written by Y. Hayashi (hayashi@me.aoyama.ac.jp)
 **************************************************/

struct _dnplist {
    char *name;
    int index;
} dnplist[] = {
   { "sy",	 1 },	    { "roma",	 2 },
   { "hira",	 3 },	    { "kata",	 4 },
   { "greek",	 5 },	    { "russian", 6 },
   { "keisen",	 7 },	    { "ka",	 8 },
   { "kb",	 9 },	    { "kc",	10 },
   { "kd",	11 },	    { "ke",	12 },
   { "kf",	13 },	    { "kg",	14 },
   { "kh",	15 },	    { "ki",	16 },
   { "kj",	17 },	    { "kk",	18 },
   { "kl",	19 },	    { "km",	20 },
   { "kn",	21 },	    { "ko",	22 },
   { "kp",	23 },	    { "kq",	24 },
   { "kr",	25 },	    { "ks",	26 },
   { "kt",	27 },	    { "ku",	28 },
   { "kv",	29 },	    { "kw",	30 },
   { "kx",	31 },	    { "ky",	32 },
   { "kz",	33 },	    { NULL,	0  }
};

struct _tfminfo {
    char *point;	/* point number	*/
    double width;
    double height;
    double depth;
} tfminfo[] = {
    {  "5", 0.9154200, 0.7708800, 0.1445400 },
    {  "6", 0.9234495, 0.7628500, 0.1606000 },
    {  "7", 0.9291850, 0.7915280, 0.1376560 },
    {  "8", 0.9033750, 0.7226990, 0.1806750 },
    {  "9", 0.9100670, 0.7494660, 0.1606000 },
    { "10", 0.9154200, 0.7708800, 0.1445400 },
    { "12", 0.9234495, 0.7628500, 0.1606000 },
    { "17", 0.9352580, 0.7793820, 0.1558760 },
    { "20", 0.9154200, 0.7588350, 0.1565850 },
    { NULL,            0.0,       0.0       }
};

isdnpfont(font)
char *font;
{
    if(0 == strncmp(font, "dmj", 3))
	return(1);
    if(0 == strncmp(font, "dgj", 3))
	return(2);
    return(0);
}

static void
read_NTT_char(fontp, ch)
struct font *fontp;
int ch;
{
#ifndef MSBITFIRST
    int n;
    unsigned char *p;
#endif
    struct glyph *g;

    g = &fontp->glyph[ch];
    g->bitmap.w = fontp->glyph[0].bitmap.w;
    g->bitmap.h = fontp->glyph[0].bitmap.h;
    g->dvi_adv = fontp->glyph[0].dvi_adv;
    g->x = fontp->glyph[0].x;
    g->y = fontp->glyph[0].y;
    
    alloc_bitmap(&g->bitmap);
    get_NTT_font(fontp, ch);
#ifndef MSBITFIRST
    n = g->bitmap.bytes_wide * g->bitmap.h;
    p = (unsigned char *)g->bitmap.bits;
    while(n--){
	*p = _reverse_byte[*p];
	++p;
    }
#endif
}

read_NTT_index(fontp)
register struct font *fontp;
{
    struct _dnplist *dp;
    struct _tfminfo *tp;
    double dimconv, pow();
    char *p;

    fontp->read_char = read_NTT_char;
    fontp->glyph = (struct glyph *) xmalloc(256 * sizeof(struct glyph),
					    "glyph array");
    bzero((char *)fontp->glyph, 256 * sizeof(struct glyph));
    dimconv = fontp->dimconv;
    if(-1 == open_ZEIT_font(fontp, isdnpfont(fontp->fontname)))
	return(-1);

    dp = dnplist;
    p = fontp->fontname + 3;
    while(dp->name){
	if(0 == strncmp(p, dp->name, strlen(dp->name)))
	    break;
	++dp;
    }
    if(NULL == dp->name){
	fprintf(stderr, "Cannot recognize font: %s\n", fontp->fontname);
	exit(-1);
    }
    fontp->index = dp->index;

    p += strlen(dp->name);
    tp = tfminfo;
    while(tp->point){
	if(0 == strncmp(p, tp->point, strlen(tp->point)))
	    break;
	++tp;
    }
    if(NULL == tp->point)
	tp = &tfminfo[5];	/* default is 10pt. */

    fontp->glyph[0].bitmap.w = (int)(dimconv * tp->width * 16);
    fontp->glyph[0].bitmap.h = (int)(dimconv * (tp->height + tp->depth) * 16);
    fontp->glyph[0].dvi_adv = dimconv * tp->width * pow(2.0, 20.0);
    fontp->glyph[0].x = 0;
    fontp->glyph[0].y = (int)(dimconv * tp->height * 16);
}

get_NTT_font(fontp, code)
struct font *fontp;
int code;
{
    struct bitmap *bitmap;
    int bwidth, jis;

    bitmap = &fontp->glyph[code].bitmap;
    bwidth = (bitmap->w + 7) / 8;
    bzero(bitmap->bits, bwidth*bitmap->h);
    jis = ku_ten_compute(fontp->index, code);
    
    VF_get_bitmap(jis2ccode(jis), fontp->vf, bitmap->w, bitmap->h,
		  bwidth, 0, bitmap->bits, 0, 0, 0);
}

/* ku_ten to jis code conversion */
/* original is in dvi2tty        */

ku_ten_compute(f,c)
int f,c;
{
  int ku, ten, n;
  if (f<=7) 
    switch(f) {
    case 1: 
      if (c>=100) {
	ku=2; ten=c-100;
      }else {
	ku=1; ten=c;
      }
      break;
    case 2: 
      ku=3; ten=c-32;
      break;
    default: 
      ku=f+1; ten=c;
    }
  else if (f<=19) { /* then {Daiichi Suijun} */
    n=(f-8)*256+c; ku=(n / 94)+16; ten=(n % 94)+1;
  }else { /* {Daini Suijun} */
    n=(f-20)*256+c; ku=(n / 94)+48; ten=(n % 94)+1;
  }
  ku += 32;
  ten+= 32;
  return((ku<<8) + ten);
}
