/*******************************************************
 *  Zeit Shotai Kurabu interface routine for xdvi pl.17
 *  Written by Y. Hayashi   (hayashi@me.aoyama.ac.jp)
 ******************************************************/
#include "jtfm.h"

#ifndef	MSBITFIRST
static unsigned char _reverse_byte[0x100] = {
	0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
	0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
	0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
	0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
	0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
	0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
	0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
	0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
	0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
	0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
	0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
	0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
	0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
	0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
	0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
	0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
	0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
	0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
	0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
	0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
	0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
	0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
	0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
	0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
	0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
	0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
	0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
	0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
	0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
	0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
	0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
	0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
};
#endif	/* MSBITFIRST */

static	void
read_ZEIT_char(fontp, ch)
struct font *fontp;
int ch;
{
#ifndef MSBITFIRST
    int n;
    unsigned char *p;
#endif
    struct bitmap *bitmap;
    struct glyph  *g;
    int ch2;

#ifdef DEBUG
    if(list_fonts)
	printf("zeit raster: %x in %s\n", ch, fontp->fontname);
#endif
    ch2 = jisindex(ch);

    if(NULL == fontp->kglyph[ch2]){
	if(NULL == (fontp->kglyph[ch2]=
		    (struct glyph *)malloc(sizeof(struct glyph)))){
	    fprintf(stderr, "Cannot memory allocation\n");
	    return;
	}
	g = fontp->kglyph[ch2];
	g->bitmap2.bits = NULL;
#ifdef GREY
	g->pixmap2 = NULL;
#endif
	g->bitmap.w = fontp->kglyph[0]->bitmap.w;
	g->bitmap.h = fontp->kglyph[0]->bitmap.h;
	g->x = fontp->kglyph[0]->x;
	g->y = fontp->kglyph[0]->y;
	g->dvi_adv = fontp->kglyph[0]->dvi_adv;
    }	    
    bitmap = &fontp->kglyph[ch2]->bitmap;
    alloc_bitmap(bitmap);
    get_ZEIT_font(fontp, ch);
#ifdef  DEBUG
    dispfont(bitmap->bits, bitmap->w, bitmap->h);
#endif
#ifndef MSBITFIRST
    n = bitmap->bytes_wide * bitmap->h;
    p = (unsigned char *)bitmap->bits;
    while(n--){
	*p = _reverse_byte[*p];
	++p;
    }
#endif
}

get_ZEIT_font(fontp, code)
struct font *fontp;
int code;
{
    struct bitmap *bitmap;
    int bwidth;

    bitmap = &fontp->kglyph[jisindex(code)]->bitmap;
    bwidth = (bitmap->w + 7) / 8;
    bzero(bitmap->bits, bwidth*bitmap->h);

    VF_get_bitmap(jis2ccode(code), fontp->vf, bitmap->w, bitmap->h,
		  bwidth, 0, bitmap->bits, 0, 0, 0);
}

jis2ccode(jis)
  int  jis;
{
  return (jis/0x100 - 0x21)*94 + (jis%0x100 - 0x21);
}


read_ZEIT_index(fontp)
register struct font *fontp;
{
    struct jfm *j;
    struct bitmap *bm;
    double dimconv;
    int n, index, code, width, height, depth;

    fontp->read_char = read_ZEIT_char;
    fontp->kglyph = (struct glyph **)
	calloc(sizeof(struct glyph *), KTABLESIZE);
    dimconv = fontp->dimconv;

    if(NULL == (j=read_jfm(fontp->file, fontp->fontname)))
	return(-1);
    if(-1 == open_ZEIT_font(fontp, iskanjifont(fontp->fontname)))
	return(-1);

    for(n=0; n<j->table[J_NT]; ++n){
	code = jisindex(j->type[n].code);
	if(NULL == (fontp->kglyph[code]=
		    (struct glyph *)malloc(sizeof(struct glyph)))){
	    fprintf(stderr, "Cannot memory allocation\n");
	    return(-1);
	}
	index = j->type[n].index;
	width = j->width[j->info[index].width_ix];
	height= j->height[(j->info[index].height_depth_ix)>>4];
	depth = j->depth[(j->info[index].height_depth_ix)&0xf];

	bm = &(fontp->kglyph[code]->bitmap);
	bm->w = (int)(dimconv * width) >> 16;
	bm->h = (int)(dimconv * (height+depth)) >> 16;
	bm->bits = NULL;
	fontp->kglyph[code]->bitmap2.bits = NULL;
#ifdef GREY
	fontp->kglyph[code]->pixmap2 = NULL;
#endif
	fontp->kglyph[code]->x = 0;
	fontp->kglyph[code]->y = (int)(dimconv * height) >> 16;
	fontp->kglyph[code]->dvi_adv = dimconv * width;
    }
    bm = &(fontp->kglyph[0]->bitmap);
    alloc_bitmap(bm);
    bbox(bm->bits, bm->bytes_wide*bm->h);
}

open_ZEIT_font(fontp, shotai)
struct font *fontp;
int shotai;
{
    static int min = -1, goth = -1;
    char buf[1024], *path;
    int *fd;

    if(NULL == (path=(char *)FontPath(shotai==1 ? "min" : "goth")))
	exit(-1);
    fd = (shotai==1 ? &min : &goth);
    if(*fd == -1)
	if(-1 == (*fd=VF_open_font(path)))
	    exit(-1);
    fontp->vf = *fd;
    return(0);
}

#ifdef KANJI
struct jfm *read_jfm(fp, fn)
FILE *fp;
char *fn;
{
    struct jfmchain {
	struct jfmchain *next;
	struct jfm *jfm;
    };
    static struct jfmchain *jfmtop = NULL;
    struct jfmchain *jcp;

    jcp = jfmtop;
    while(jcp){
	if(0 == strcmp(fn, jcp->jfm->fn))
	    break;
	jcp = jcp->next;
    }
    if(jcp)
	return(jcp->jfm);

    if(jcp = (struct jfmchain *)malloc(sizeof(struct jfmchain))){
	jcp->next = NULL;
	if(jcp->jfm = (struct jfm *)malloc(sizeof(struct jfm))){
	    strcpy(jcp->jfm->fn, fn);
	    if(0 == read_jfm0(fp, jcp->jfm))
		return(jcp->jfm);
	    else{
		fprintf(stderr, "Cannot open metric file: %s\n", fn);
		return((struct jfm *)NULL);
	    }
	}
    }
    fprintf(stderr, "Cannot memory allocation\n");
    return((struct jfm *)NULL);
}

/**** read_jfm0:  borrowed from jxdvi-NEWS ***/

read_jfm0(fp, j)
FILE *fp;
struct jfm *j;
{
    int i;

    fseek(fp, 0, SEEK_SET);

    /* read jfm table field. */
    for (i=0; i<=J_NP; i++)
	j->table[i]= (short) two(fp);

    /* read jfm header */
    j->check_sum = four(fp);
    j->design_size = four(fp);
    fseek(fp,(long)(sizeof(long)*(j->table[J_LH]-2)),1);
    
    /* read jfm char_type */
    j->type = (struct jfm_char_type *)
	malloc( (sizeof(struct jfm_char_type)*j->table[J_NT]) );
    for (i=0; i<j->table[J_NT]; i++) {
	j->type[i].code = (short) two(fp);
	j->type[i].index = (short) two(fp);
    }
    
    /* read jfm char_info */
    j->info = (struct jfm_char_info *)
	malloc( (sizeof(struct jfm_char_info)*(j->table[J_EC]+1)) );
    for (i=0; i<=j->table[J_EC]; i++) {
	j->info[i].width_ix = (unsigned char) one(fp);
	j->info[i].height_depth_ix = (unsigned char) one(fp);
	j->info[i].italic_ix_tag = (unsigned char) one(fp);
	j->info[i].remainder_ix = (unsigned char) one(fp);
    }
    
    /* read jfm width */
    j->width = (unsigned long *)
	malloc((sizeof(unsigned long)*(j->table[J_NW])));
    for (i=0; i<j->table[J_NW]; i++)
	j->width[i] = four(fp);

    /* read jfm height */
    j->height = (unsigned long *)
	malloc((sizeof(unsigned long)*(j->table[J_NH])));
    for (i=0; i<j->table[J_NH]; i++)
	j->height[i] = four(fp);

    /* read jfm depth */
    j->depth = (unsigned long *)
	malloc((sizeof(unsigned long)*(j->table[J_ND])));
    for (i=0; i<j->table[J_ND]; i++)
	j->depth[i] = four(fp);

    /* read jfm italic */
    j->italic = (unsigned long *)
	malloc((sizeof(unsigned long)*(j->table[J_NI])));
    for (i=0; i<j->table[J_NI]; i++)
	j->italic[i] = four(fp);
    return(0);
}

iskanjifont(font)
char *font;
{
    if(0==strncmp(font, "min", 3) || 0==strncmp(font, "nmin", 4))
	return(1);
    if(0==strncmp(font, "goth", 4) || 0==strncmp(font, "ngoth", 5))
	return(2);
    return(0);
}
#endif

bbox(buf, size)
char *buf;
int size;
{
    int n;

    for(n=0; n<size; ++n)
	buf[n] = 0xff;
}

#ifdef DEBUG
dispfont(buf, width, hight)
char *buf;
int width, hight;
{
    char *p;
    int n, w, h, mask;

    p = buf;
    for(h=0; h<hight; ++h){
	for(w=0; w<width; w+=8){
	    mask = 0x80;
	    for(n=0; n<8; ++n){
		if(*p & mask)
		    putchar('*');
		else
		    putchar('.');
		mask >>= 1;
	    }
	    ++p;
	}
	putchar('\n');
    }
}
#endif
