/* config.h: master configuration file, included first by all compilable
   source files (not headers).  */

#ifndef CONFIG_H
#define CONFIG_H

/* The stuff from the path searching library.  */
#include <kpathsea/config.h>

#include <setjmp.h>

#ifndef HAVE_VPRINTF
#ifdef HAVE_DOPRNT
#define	vfprintf(stream, message, args)	_doprnt(message, args, stream)
/* If we have neither, should fall back to fprintf with fixed args.  */
#endif
#endif

/* Some xdvi options we want by default.  */
#define USE_PK
#define USE_GF
#ifndef NOSELFILE
#define SELFILE
#endif
#ifndef NOBUTTONS
#define BUTTONS
#endif
#ifndef NOGREY
#define GREY
#endif
#ifndef NOTEXXET
#define TEXXET
#endif
#ifdef NOMAKEPK
#define MAKEPK_BY_DEFAULT_STRING "false"
#define MAKEPK_BY_DEFAULT_BOOL False
#else
#define MAKEPK_BY_DEFAULT_STRING "true"
#define MAKEPK_BY_DEFAULT_BOOL True
#endif

#define KANJI
#ifdef  NOZEIT
#define ASCIIDNP
#else
#define USE_ZEIT
#define DEFAULT_FONTCONF ""
#ifndef NONTTZEIT
#define NTTZEIT
#endif
#endif

#ifndef NOTOC
#define TOC
#define MAX_PAGE 1024
#endif
#ifndef NOMARKPAGE
#define MARKPAGE
#define RINGSIZE 1024
#endif
#ifndef NOPRINTDVI
#define PRINTDVI
/* Print-out command templates */
/* all pages of DVI file */
#define PRCMDALL "(cd %d; dvi2ps %F) | lpr -P%p -J'%F'"
/* the current page */
#define PRCMDCUR "(cd %d; dviselect -i %F -o /tmp/%F:%c@%r.dvi =%c; dvi2ps /tmp/%F:%c@%r.dvi) | lpr -P%p -J'%F (Page %c)'; /bin/rm /tmp/%F:%c@%r.dvi"
/* the lastly marked page */
#define PRCMDMRK "(cd %d; dviselect -i %F -o /tmp/%F:%m@%r.dvi =%m; dvi2ps /tmp/%F:%m@%r.dvi) | lpr -P%p -J'%F (Page %m)'; /bin/rm /tmp/%F:%m@%r.dvi"
/* pages in the region, between the current page and the lastly marked page */
#define PRCMDRGN "(cd %d; dviselect -i %F -o /tmp/%F:%s-%e@%r.dvi =%s:%e; dvi2ps /tmp/%F:%s-%e@%r.dvi) | lpr -P%p -J'%F (Page %s-%e)'; /bin/rm /tmp/%F:%s-%e@%r.dvi"
/* all marked pages */
#define PRCMDLST "(cd %d; dviselect -i %F -o /tmp/%F:%t@%r.dvi %A; dvi2ps /tmp/%F:%t@%r.dvi) | lpr -P%p -J'%F (Page %t)'; /bin/rm /tmp/%F:%t@%r.dvi"
/* the default printer to print-out DVI file */
#define DVIPRINTER "lp"
#endif

/* xdvi's definitions.  */
#include "xdvi.h"

#endif /* not CONFIG_H */
