#!/bin/sh

usage="usage: `basename $0` DPI [half]"

if [ $# -lt 1 -o $# -gt 2 ]; then
	echo 1>&2 $usage
	exit 1
fi

if [ X"$1" = X"-help" ]; then
	echo $usage
	exit 0
fi

dpi=$1

case "$2" in
  half|Half|HALF)
	half="half";;
  *)
	half="";;
esac

make DPI=$dpi HALF=$half MAGLIST="magstep[0-5]" Everything
make DPI=$dpi HALF=$half MAGLIST="magstep[6-8]" slitex
make DPI=$dpi HALF=$half MAGLIST=1.3 texinfo
make DPI=$dpi HALF=$half cmcsc_scaled

