/* -*-C-*-
********************************************************************************
*
* File:         w_funtab.h
* RCS:          $Header: w_funtab.h,v 1.10 91/03/25 04:20:42 mayer Exp $
* Description:  Indexes (pointers) into functiontable.... these are needed
*               in C inteface to adding methods to clases (xladdmsg()).
* Author:       Niels Mayer, HPLabs
* Created:      Fri Nov 24 00:00:00 1989
* Modified:     Thu Oct  3 20:48:19 1991 (Niels Mayer) mayer@hplnpm
* Language:     C
* Package:      N/A
* Status:       X11r5 contrib tape release
*
* WINTERP Copyright 1989, 1990, 1991 Hewlett-Packard Company (by Niels Mayer).
* XLISP version 2.1, Copyright (c) 1989, by David Betz.
*
* Permission to use, copy, modify, distribute, and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice appear in all copies and that both that
* copyright notice and this permission notice appear in supporting
* documentation, and that the name of Hewlett-Packard and David Betz not be
* used in advertising or publicity pertaining to distribution of the software
* without specific, written prior permission.  Hewlett-Packard and David Betz
* make no representations about the suitability of this software for any
* purpose. It is provided "as is" without express or implied warranty.
*
* HEWLETT-PACKARD AND DAVID BETZ DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
* SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
* IN NO EVENT SHALL HEWLETT-PACKARD NOR DAVID BETZ BE LIABLE FOR ANY SPECIAL,
* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
* LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
* OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* See ./winterp/COPYRIGHT for information on contacting the authors.
* 
* Please send modifications, improvements and bugfixes to mayer@hplabs.hp.com
* Post XLISP-specific questions/information to the newsgroup comp.lang.lisp.x
*
********************************************************************************
*/

/*
 * NOTE:
 * The following enumerations must be in the exact same order as the
 * entries in w_funtab.c:funtab[]. w_funtab.c:Wfu_Funtab_Sanity_Check()
 * checks to make sure that the number of entries in funtab[] correspond
 * to the number of indexes generated by the enum below. This is done by
 * setting LAST_FUNTAB_POINTER_USED_BY_libWinterp to the last enumeration.
 * A corresponding constant is set to the count of the funtab[] entry in
 * w_funtab.c -- INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp.
 */ 
enum {
  FTAB_rmhash = 0,
  FTAB_rmquote,
  FTAB_rmdquote,
  FTAB_rmbquote,
  FTAB_rmcomma,
  FTAB_rmlpar,
  FTAB_rmrpar,
  FTAB_rmsemi,
  FTAB_xnotimp1,
  FTAB_xnotimp2,
  FTAB_clnew,
  FTAB_clisnew,
  FTAB_clanswer,
  FTAB_obisnew,
  FTAB_obclass,
  FTAB_obshow,
  FTAB_xnotimp3,
  FTAB_xnotimp4,
  FTAB_xnotimp5,
  FTAB_xnotimp6,
  FTAB_xeval,
  FTAB_xapply,
  FTAB_xfuncall,
  FTAB_xquote,
  FTAB_xfunction,
  FTAB_xbquote,
  FTAB_xlambda,
  FTAB_xset,
  FTAB_xsetq,
  FTAB_xsetf,
  FTAB_xdefun,
  FTAB_xdefmacro,
  FTAB_xgensym,
  FTAB_xmakesymbol,
  FTAB_xintern,
  FTAB_xsymname,
  FTAB_xsymvalue,
  FTAB_xsymplist,
  FTAB_xget,
  FTAB_xputprop,
  FTAB_xremprop,
  FTAB_xhash,
  FTAB_xmkarray,
  FTAB_xaref,
  FTAB_xcar,
  FTAB_xcdr,
  FTAB_xcaar,
  FTAB_xcadr,
  FTAB_xcdar,
  FTAB_xcddr,
  FTAB_xcaaar,
  FTAB_xcaadr,
  FTAB_xcadar,
  FTAB_xcaddr,
  FTAB_xcdaar,
  FTAB_xcdadr,
  FTAB_xcddar,
  FTAB_xcdddr,
  FTAB_xcaaaar,
  FTAB_xcaaadr,
  FTAB_xcaadar,
  FTAB_xcaaddr,
  FTAB_xcadaar,
  FTAB_xcadadr,
  FTAB_xcaddar,
  FTAB_xcadddr,
  FTAB_xcdaaar,
  FTAB_xcdaadr,
  FTAB_xcdadar,
  FTAB_xcdaddr,
  FTAB_xcddaar,
  FTAB_xcddadr,
  FTAB_xcdddar,
  FTAB_xcddddr,
  FTAB_xcons,
  FTAB_xlist,
  FTAB_xappend,
  FTAB_xreverse,
  FTAB_xlast,
  FTAB_xnth,
  FTAB_xnthcdr,
  FTAB_xmember,
  FTAB_xassoc,
  FTAB_xsubst,
  FTAB_xsublis,
  FTAB_xremove,
  FTAB_xlength,
  FTAB_xmapc,
  FTAB_xmapcar,
  FTAB_xmapl,
  FTAB_xmaplist,
  FTAB_xrplca,
  FTAB_xrplcd,
  FTAB_xnconc,
  FTAB_xdelete,
  FTAB_xatom,
  FTAB_xsymbolp,
  FTAB_xnumberp,
  FTAB_xboundp,
  FTAB_xnull,
  FTAB_xlistp,
  FTAB_xconsp,
  FTAB_xminusp,
  FTAB_xzerop,
  FTAB_xplusp,
  FTAB_xevenp,
  FTAB_xoddp,
  FTAB_xeq,
  FTAB_xeql,
  FTAB_xequal,
  FTAB_xcond,
  FTAB_xcase,
  FTAB_xand,
  FTAB_xor,
  FTAB_xlet,
  FTAB_xletstar,
  FTAB_xif,
  FTAB_xprog,
  FTAB_xprogstar,
  FTAB_xprog1,
  FTAB_xprog2,
  FTAB_xprogn,
  FTAB_xgo,
  FTAB_xreturn,
  FTAB_xdo,
  FTAB_xdostar,
  FTAB_xdolist,
  FTAB_xdotimes,
  FTAB_xcatch,
  FTAB_xthrow,
  FTAB_xerror,
  FTAB_xcerror,
  FTAB_xbreak,
  FTAB_xcleanup,
  FTAB_xtoplevel,
  FTAB_xcontinue,
  FTAB_xerrset,
  FTAB_xbaktrace,
  FTAB_xevalhook,
  FTAB_xfix,
  FTAB_xfloat,
  FTAB_xadd,
  FTAB_xsub,
  FTAB_xmul,
  FTAB_xdiv,
  FTAB_xadd1,
  FTAB_xsub1,
  FTAB_xrem,
  FTAB_xmin,
  FTAB_xmax,
  FTAB_xabs,
  FTAB_xsin,
  FTAB_xcos,
  FTAB_xtan,
  FTAB_xexpt,
  FTAB_xexp,
  FTAB_xsqrt,
  FTAB_xrand,
  FTAB_xlogand,
  FTAB_xlogior,
  FTAB_xlogxor,
  FTAB_xlognot,
  FTAB_xlss,
  FTAB_xleq,
  FTAB_xequ,
  FTAB_xneq,
  FTAB_xgeq,
  FTAB_xgtr,
  FTAB_xstrcat,
  FTAB_xsubseq,
  FTAB_xstring,
  FTAB_xchar,
  FTAB_xread,
  FTAB_xprint,
  FTAB_xprin1,
  FTAB_xprinc,
  FTAB_xterpri,
  FTAB_xflatsize,
  FTAB_xflatc,
  FTAB_xopen,
  FTAB_xformat,
  FTAB_xclose,
  FTAB_xrdchar,
  FTAB_xpkchar,
  FTAB_xwrchar,
  FTAB_xreadline,
#ifdef WINTERP
  FTAB_Wut_Prim_LOAD,		/* WINTERP uses it's own version of xload() */
#else
  FTAB_xload,
#endif				/* WINTERP */
  FTAB_xtranscript,
  FTAB_xgc,
  FTAB_xexpand,
  FTAB_xalloc,
  FTAB_xmem,
  FTAB_xsave,
  FTAB_xrestore,
  FTAB_xtype,
  FTAB_xexit,
  FTAB_xpeek,
  FTAB_xpoke,
  FTAB_xaddrs,
  FTAB_xvector,
  FTAB_xblock,
  FTAB_xrtnfrom,
  FTAB_xtagbody,
  FTAB_xpsetq,
  FTAB_xflet,
  FTAB_xlabels,
  FTAB_xmacrolet,
  FTAB_xunwindprotect,
  FTAB_xpp,
  FTAB_xstrlss,
  FTAB_xstrleq,
  FTAB_xstreql,
  FTAB_xstrneq,
  FTAB_xstrgeq,
  FTAB_xstrgtr,
  FTAB_xstrilss,
  FTAB_xstrileq,
  FTAB_xstrieql,
  FTAB_xstrineq,
  FTAB_xstrigeq,
  FTAB_xstrigtr,
  FTAB_xintegerp,
  FTAB_xfloatp,
  FTAB_xstringp,
  FTAB_xarrayp,
  FTAB_xstreamp,
  FTAB_xobjectp,
  FTAB_xupcase,
  FTAB_xdowncase,
  FTAB_xnupcase,
  FTAB_xndowncase,
  FTAB_xtrim,
  FTAB_xlefttrim,
  FTAB_xrighttrim,
  FTAB_xwhen,
  FTAB_xunless,
  FTAB_xloop,
  FTAB_xsymfunction,
  FTAB_xfboundp,
  FTAB_xsend,
  FTAB_xsendsuper,
  FTAB_xprogv,
  FTAB_xcharp,
  FTAB_xcharint,
  FTAB_xintchar,
  FTAB_xrdbyte,
  FTAB_xwrbyte,
  FTAB_xmkstrinput,
  FTAB_xmkstroutput,
  FTAB_xgetstroutput,
  FTAB_xgetlstoutput,
  FTAB_xgcd,
  FTAB_xgetlambda,
  FTAB_xmacroexpand,
  FTAB_x1macroexpand,
  FTAB_xchrlss,
  FTAB_xchrleq,
  FTAB_xchreql,
  FTAB_xchrneq,
  FTAB_xchrgeq,
  FTAB_xchrgtr,
  FTAB_xchrilss,
  FTAB_xchrileq,
  FTAB_xchrieql,
  FTAB_xchrineq,
  FTAB_xchrigeq,
  FTAB_xchrigtr,
  FTAB_xuppercasep,
  FTAB_xlowercasep,
  FTAB_xbothcasep,
  FTAB_xdigitp,
  FTAB_xalphanumericp,
  FTAB_xchupcase,
  FTAB_xchdowncase,
  FTAB_xdigitchar,
  FTAB_xcharcode,
  FTAB_xcodechar,
  FTAB_xendp,
  FTAB_xremif,
  FTAB_xremifnot,
  FTAB_xdelif,
  FTAB_xdelifnot,
  FTAB_xtrace,
  FTAB_xuntrace,
  FTAB_xsort,
  FTAB_Prim_SYSTEM,
  FTAB_Prim_POPEN,
  FTAB_Prim_PCLOSE,
  FTAB_Widget_Class_Method_ISNEW,
  FTAB_Shell_Widget_Class_Method_ISNEW,
  FTAB_Popup_Shell_Widget_Class_Method_ISNEW,
  FTAB_Shell_Widget_Class_Method_REALIZE,
  FTAB_Shell_Widget_Class_Method_UNREALIZE,
  FTAB_Popup_Shell_Widget_Class_Method_POPUP,
  FTAB_Popup_Shell_Widget_Class_Method_POPDOWN,
  FTAB_Widget_Class_Method_MANAGE,
  FTAB_Widget_Class_Method_UNMANAGE,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_ISNEW,
  FTAB_Xm_Form_Widget_Class_Method_ISNEW,
  FTAB_Xm_List_Widget_Class_Method_ISNEW,
  FTAB_Xm_Text_Widget_Class_Method_ISNEW,
  FTAB_Xm_Message_Box_Widget_Class_Method_ISNEW,
  FTAB_Xm_Row_Column_Widget_Class_Method_ISNEW,
  FTAB_Xm_Selection_Box_Widget_Class_Method_ISNEW,
  FTAB_Widget_Class_Method_SET_VALUES,
  FTAB_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Text_Widget_Class_Method_GET_STRING,
  FTAB_Wto_Prim_XtAddTimeOut,
  FTAB_Wto_Prim_XtRemoveTimeout,
  FTAB_Wcb_Prim_XtRemoveCallback,
  FTAB_Widget_Class_Method_SET_CALLBACK,
  FTAB_Widget_Class_Method_REMOVE_ALL_CALLBACKS,
  FTAB_Wut_Prim_XAllocColor,
  FTAB_Wpm_Prim_XmGetPixmap,
  FTAB_Wpm_Prim_XmInstallImage,
  FTAB_Wpm_Prim_XmUninstallImage,
  FTAB_Wpm_Prim_XmGetImageFromFile,
  FTAB_Widget_Class_Method_UPDATE_DISPLAY,
  FTAB_Wut_UserClick_To_WidgetObj,
  FTAB_Widget_Class_Method_DESTROY,
  FTAB_Widget_Class_Method_PARENT,
  FTAB_Xm_Text_Widget_Class_Method_GET_LAST_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SET_STRING,
  FTAB_Xm_Text_Widget_Class_Method_REPLACE,
  FTAB_Xm_Text_Widget_Class_Method_GET_EDITABLE,
  FTAB_Xm_Text_Widget_Class_Method_SET_EDITABLE,
  FTAB_Xm_Text_Widget_Class_Method_GET_MAX_LENGTH,
  FTAB_Xm_Text_Widget_Class_Method_SET_MAX_LENGTH,
  FTAB_Xm_Text_Widget_Class_Method_GET_SELECTION,
  FTAB_Xm_Text_Widget_Class_Method_SET_SELECTION,
  FTAB_Xm_Text_Widget_Class_Method_CLEAR_SELECTION,
  FTAB_Xm_Text_Widget_Class_Method_GET_TOP_CHARACTER,
  FTAB_Xm_Text_Widget_Class_Method_SET_TOP_CHARACTER,
  FTAB_Xm_Text_Widget_Class_Method_GET_INSERTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SET_INSERTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_GET_SELECTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_XY_TO_POS,
  FTAB_Xm_Text_Widget_Class_Method_POS_TO_XY,
  FTAB_Xm_Text_Widget_Class_Method_SHOW_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SCROLL,
  FTAB_Xm_Text_Widget_Class_Method_DISABLE_REDISPLAY,
  FTAB_Xm_Text_Widget_Class_Method_ENABLE_REDISPLAY,
  FTAB_Xm_List_Widget_Class_Method_ADD_ITEM,
  FTAB_Xm_List_Widget_Class_Method_ADD_ITEM_UNSELECTED,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ITEM,
  FTAB_Xm_List_Widget_Class_Method_DELETE_POS,
  FTAB_Xm_List_Widget_Class_Method_SELECT_ITEM,
  FTAB_Xm_List_Widget_Class_Method_SELECT_POS,
  FTAB_Xm_List_Widget_Class_Method_DESELECT_ITEM,
  FTAB_Xm_List_Widget_Class_Method_DESELECT_POS,
  FTAB_Xm_List_Widget_Class_Method_DESELECT_ALL_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_SET_POS,
  FTAB_Xm_List_Widget_Class_Method_SET_BOTTOM_POS,
  FTAB_Xm_List_Widget_Class_Method_SET_ITEM,
  FTAB_Xm_List_Widget_Class_Method_SET_BOTTOM_ITEM,
  FTAB_Xm_List_Widget_Class_Method_ITEM_EXISTS,
  FTAB_Xm_List_Widget_Class_Method_SET_HORIZ_POS,
  FTAB_Xm_List_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_List_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Drawing_Area_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Drawing_Area_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Drawn_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Drawn_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Row_Column_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Row_Column_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Selection_Box_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Selection_Box_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Command_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Command_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Scale_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Scale_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Text_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Text_Widget_Class_Method_SET_CALLBACK,
  FTAB_Widget_Class_Method_GET_VALUES,
  FTAB_Xm_Cascade_Button_Widget_Class_Method_HIGHLIGHT,
  FTAB_Xm_Command_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_Command_Widget_Class_Method_SET_VALUE,
  FTAB_Xm_Command_Widget_Class_Method_APPEND_VALUE,
  FTAB_Xm_Command_Widget_Class_Method_ERROR,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_DO_SEARCH,
  FTAB_Xm_Main_Window_Widget_Class_SET_AREAS,
  FTAB_Xm_Main_Window_Widget_Class_SEP1,
  FTAB_Xm_Main_Window_Widget_Class_SEP2,
  FTAB_Xm_Message_Box_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_Row_Column_Widget_Class_Method_MENU_POSITION,
  FTAB_Xm_Row_Column_Widget_Class_Method_OPTION_LABEL_GADGET,
  FTAB_Xm_Row_Column_Widget_Class_Method_OPTION_BUTTON_GADGET,
  FTAB_xdefstruct,
  FTAB_xstrtypep,
  FTAB_xmkstruct,
  FTAB_xcpystruct,
  FTAB_xstrref,
  FTAB_xstrset,
  FTAB_xasin,
  FTAB_xacos,
  FTAB_xatan,
  FTAB_Prim_FSCANF_FIXNUM,
  FTAB_Prim_FSCANF_STRING,
  FTAB_Prim_FSCANF_FLONUM,
  FTAB_Prim_COPY_ARRAY,
  FTAB_Prim_ARRAY_INSERT_POS,
  FTAB_Prim_ARRAY_DELETE_POS,
  FTAB_Shell_Widget_Class_Method_IS_MOTIF_WM_RUNNING,
  FTAB_Xm_Scale_Widget_Class_Method_SET_VALUE,
  FTAB_Xm_Scale_Widget_Class_Method_GET_VALUE,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_SET_VALUE,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_GET_VALUE,
  FTAB_Xm_Scrolled_Window_Widget_Class_Method_SET_AREAS,
  FTAB_Xm_Selection_Box_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_GET_STATE,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_SET_STATE,
  FTAB_Xm_Toggle_Button_Gadget_Class_Method_GET_STATE,
  FTAB_Xm_Toggle_Button_Gadget_Class_Method_SET_STATE,
  FTAB_Wtx_Prim_XT_PARSE_TRANSLATION_TABLE,
  FTAB_Wtx_Prim_XT_PARSE_ACCELERATOR_TABLE,
  FTAB_Widget_Class_Method_OVERRIDE_TRANSLATIONS,
  FTAB_Widget_Class_Method_AUGMENT_TRANSLATIONS,
  FTAB_Widget_Class_Method_UNINSTALL_TRANSLATIONS,
  FTAB_Widget_Class_Method_INSTALL_ACCELERATORS,
  FTAB_Widget_Class_Method_INSTALL_ALL_ACCELERATORS,
  FTAB_Widget_Class_Method_ADD_EVENT_HANDLER,
  FTAB_Widget_Class_Method_SET_EVENT_HANDLER,
  FTAB_Widget_Class_Method_BUILD_EVENT_MASK,
  FTAB_Weh_Prim_REMOVE_EVENT_HANDLER,
  FTAB_Wxt_Prim_XT_MANAGE_CHILDREN,
  FTAB_Wxt_Prim_XT_UNMANAGE_CHILDREN,
  FTAB_Widget_Class_Method_ADD_TAB_GROUP,
  FTAB_Widget_Class_Method_REMOVE_TAB_GROUP,
  FTAB_Widget_Class_Method_ADD_GRAB,
  FTAB_Widget_Class_Method_REMOVE_GRAB,
  FTAB_Widget_Class_Method_IS_COMPOSITE,
  FTAB_Widget_Class_Method_IS_CONSTRAINT,
  FTAB_Widget_Class_Method_IS_SHELL,
  FTAB_Widget_Class_Method_IS_PRIMITIVE,
  FTAB_Widget_Class_Method_IS_GADGET,
  FTAB_Widget_Class_Method_IS_MANAGER,
  FTAB_Widget_Class_Method_SET_SENSITIVE,
  FTAB_Widget_Class_Method_SET_MAPPED_WHEN_MANAGED,
  FTAB_Widget_Class_Method_IS_MANAGED,
  FTAB_Widget_Class_Method_IS_REALIZED,
  FTAB_Widget_Class_Method_IS_SENSITIVE,
  FTAB_Widget_Class_Method_WINDOW,
  FTAB_Widget_Class_Method_MAP,
  FTAB_Widget_Class_Method_UNMAP,
  FTAB_Xm_Bulletin_Board_Widget_Class_Method_ISNEW,
  FTAB_Wxms_Prim_XM_STRING_CREATE,
  FTAB_Wxms_Prim_XM_STRING_DIRECTION_CREATE,
  FTAB_Wxms_Prim_XM_STRING_SEPARATOR_CREATE,
  FTAB_Wxms_Prim_XM_STRING_SEGMENT_CREATE,
  FTAB_Wxms_Prim_XM_STRING_CREATE_L_TO_R,
  FTAB_Wxms_Prim_XM_STRING_GET_L_TO_R,
  FTAB_Wxms_Prim_XM_STRING_CONCAT,
  FTAB_Wxms_Prim_XM_STRING_COPY,
  FTAB_Wxms_Prim_XM_STRING_BYTE_COMPARE,
  FTAB_Wxms_Prim_XM_STRING_COMPARE,
  FTAB_Wxms_Prim_XM_STRING_LENGTH,
  FTAB_Wxms_Prim_XM_STRING_EMPTY,
  FTAB_Wxms_Prim_XM_STRING_LINE_COUNT,
  FTAB_Wcls_Prim_WIDGETOBJP,
  FTAB_Wut_Prim_X_STORE_COLOR,
  FTAB_Wut_Prim_X_ALLOC_N_COLOR_CELLS_NO_PLANES,
  FTAB_Xm_Command_Widget_Class_Method_ISNEW,
  FTAB_Application_Shell_Widget_Class_Method_GET_ARGV,
  FTAB_Application_Shell_Widget_Class_Method_SET_ARGV,
  FTAB_Xm_Command_Widget_Class_Method_GET_HISTORY_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_GET_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_GET_SELECTED_ITEMS,
  FTAB_Xm_Selection_Box_Widget_Class_Method_GET_LIST_ITEMS,
  FTAB_Widget_Class_Method_HAS_CALLBACKS,
  FTAB_Widget_Class_Method_EXISTS_P,
  FTAB_Application_Shell_Widget_Class_Method_ISNEW,
  FTAB_Wxm_Prim_XM_SET_MENU_CURSOR,
  FTAB_Wut_Prim_GET_MOUSE_LOCATION, /* uunet!cimshop!rhess */
  FTAB_Wto_Prim_TIMEOUT_ACTIVE_P,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Wto_Prim_TIMEOUT_ACTIVE_P

#ifdef WINTERP_MOTIF_11
  FTAB_Wxm_Prim_XM_GET_COLORS,
  FTAB_Xm_Arrow_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Arrow_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Push_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Push_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Cascade_Button_Gadget_Class_Method_HIGHLIGHT,
  FTAB_Xm_List_Widget_Class_Method_ADD_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ITEMS_POS,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ALL_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_REPLACE_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_REPLACE_ITEMS_POS,
  FTAB_Xm_List_Widget_Class_Method_SET_ADD_MODE,
  FTAB_Xm_List_Widget_Class_Method_ITEM_POS,
  FTAB_Xm_List_Widget_Class_Method_GET_MATCH_POS,
  FTAB_Xm_List_Widget_Class_Method_GET_SELECTED_POS,
  FTAB_Xm_Main_Window_Widget_Class_SEP3,
  FTAB_Xm_Row_Column_Widget_Class_Method_GET_POSTED_FROM_WIDGET,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_STRING,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_LAST_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_STRING,
  FTAB_Xm_Text_Field_Widget_Class_Method_REPLACE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_EDITABLE,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_EDITABLE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_MAX_LENGTH,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_MAX_LENGTH,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_SELECTION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_SELECTION,
  FTAB_Xm_Text_Field_Widget_Class_Method_CLEAR_SELECTION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_INSERTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_GET_CURSOR_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_CURSOR_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_INSERTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SET_CURSOR_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_CURSOR_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_SELECTION_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_XY_TO_POS,
  FTAB_Xm_Text_Field_Widget_Class_Method_POS_TO_XY,
  FTAB_Xm_Text_Field_Widget_Class_Method_SHOW_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SET_HIGHLIGHT,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_HIGHLIGHT,
  FTAB_Xm_Text_Widget_Class_Method_INSERT,
  FTAB_Xm_Text_Field_Widget_Class_Method_INSERT,
  FTAB_Xm_Text_Widget_Class_Method_SET_ADD_MODE,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_ADD_MODE,
  FTAB_Xm_Text_Widget_Class_Method_GET_ADD_MODE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_ADD_MODE,
  FTAB_Xm_Text_Widget_Class_Method_REMOVE,
  FTAB_Xm_Text_Field_Widget_Class_Method_REMOVE,
  FTAB_Xm_Text_Widget_Class_Method_COPY,
  FTAB_Xm_Text_Field_Widget_Class_Method_COPY,
  FTAB_Xm_Text_Widget_Class_Method_CUT,
  FTAB_Xm_Text_Field_Widget_Class_Method_CUT,
  FTAB_Xm_Text_Widget_Class_Method_PASTE,
  FTAB_Xm_Text_Field_Widget_Class_Method_PASTE,
  FTAB_Xm_Text_Widget_Class_Method_GET_BASELINE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_BASELINE,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_GET_DIR_LIST_ITEMS,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_GET_FILE_LIST_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_PARENT,
  FTAB_Xm_Text_Widget_Class_Method_PARENT,
  FTAB_Widget_Class_Method_NAME,
  FTAB_Xm_Row_Column_Widget_Class_Method_GET_SUB_MENU_WIDGET,
  FTAB_Widget_Class_Method_GET_CHILDREN,
  FTAB_Widget_Class_Method_CALL_ACTION_PROC,
  FTAB_Wxt_Prim_XT_RESOLVE_PATHNAME,
  FTAB_Wxm_Prim_XM_SET_FONT_UNITS,
  FTAB_Wxms_Prim_XM_STRING_HAS_SUBSTRING,
  FTAB_Wxm_Prim_XM_TRACKING_LOCATE,
  FTAB_Wxm_Prim_XM_CONVERT_UNITS,
  FTAB_Wxms_Prim_XM_CVT_CT_TO_XM_STRING,
  FTAB_Wxms_Prim_XM_CVT_XM_STRING_TO_CT,
  FTAB_Widget_Class_Method_PROCESS_TRAVERSAL,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Widget_Class_Method_PROCESS_TRAVERSAL
#endif				/* WINTERP_MOTIF_11 */

#ifndef WINTERP_MOTIF_11	/* HP_GRAPH_WIDGET doesn't work with 1.1 */
#ifdef HP_GRAPH_WIDGET		/* if HP_GRAPH_WIDGET defined */
  FTAB_Xm_Graph_Widget_Class_Method_ISNEW,
  FTAB_Xm_Arc_Widget_Class_Method_ISNEW,
  FTAB_Xm_Graph_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Graph_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Graph_Widget_Class_Method_CENTER_AROUND_WIDGET,
  FTAB_Xm_Graph_Widget_Class_Method_DESTROY_ALL_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_DESTROY_ALL_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_DESTROY_SELECTED_ARCS_OR_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ARCS_BETWEEN_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_NODE_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_SELECTED_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_SELECTED_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_INPUT_OVER_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_INSERT_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_IS_POINT_IN_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_IS_SELECTED_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_IS_SELECTED_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_MOVE_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_MOVE_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_NODE_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_SELECTED_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_SELECTED_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_MOVE_ALL,
  FTAB_Xm_Graph_Widget_Class_Method_LAYOUT,
  FTAB_Xm_Graph_Widget_Class_Method_RELAY_SUBGRAPH,
  FTAB_Xm_Graph_Widget_Class_Method_REMOVE_ARC_BETWEEN_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_REMOVE_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_NODES,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_NODES
#endif				/* HP_GRAPH_WIDGET */
#endif				/* notdef(WINTERP_MOTIF_11) */

#ifdef hpux			/* I'm too lazy to make this portable */
  FTAB_Wut_Prim_X_REFRESH_DISPLAY,
#endif

  /*
   * applications adding new functions to winterp in app_fundecl.h
   * must add corresponding FTAB_* entries in app_funidx.h.
   */
#include "app_funidx.h"

  /*
   * This allows all entries above to terminate with  ',' without regards
   * to the special case for the last element.
   */
  FTAB_BOGUS_LAST_ELEMENT	
  };
