.\" $Id: editres.man,v 1.1 1992/03/19 09:12:35 proj Exp $
.TH EDITRES 1 "Release 5" "X Version 11"
.SH NAME
editres - a dynamic resource editor for X Toolkit applications
(Internationalized version)
.SH SYNTAX
\fBeditres\fP [ \fI-toolkitoption\fP ...]
.SH OPTIONS
.I Editres
accepts all of the standard X Toolkit command line
options (see \fIX(1)\fP).  The order of the command line options is
not important.
.SH DESCRIPTION
Editres is a tool that allows users and application developers to view
the full widget hierarchy of any X Toolkit client that speaks the
Editres protocol.  In addition editres will help the user construct
resource specifications, allow the user to apply the resource to
the application and view the results dynamically.  Once the user is
happy with a resource specification editres will append the resource
string to the user's X Resources file.
.PP
This internationalized version editres uses the internationalized Athena
Widget Set. And so it is possible to handle NON-ASCII strings,
if the language is specified by \fBxnllanguage\fP resource or
\fBLANG\fP environment. It uses the input manager \fBxwnmo\fP for
inputting NON-ASCII strings. Please see \fBpreeditType\fP and
\fBinputMethod\fP resources in RESOURCES section.
.SH USING EDITRES
.I Editres
provides a window consisting of the following four areas:
.IP "Menu Bar" 25
A set of popup menus that allow you full access to editres's features.
.IP "Panner" 
The panner allows a more intuitive way to scroll the application tree display.
.IP "Message Area"
Displays information to the user about the action that editres expects 
of her.
.IP "Application Widget Tree" 25
This area will be used to display the selected client's widget tree.
.LP
To begin an editres session select the \fBGet Widget Tree\fP menu item from
the command menu.  This will change the pointer cursor to cross hair.
You should now select the application you wish look at by clicking on
any of its windows.  If this application understands the editres
protocol then editres will display the client's widget tree in its
tree window.  If
the application does not understand the editres protocol editres will
inform you of this fact in the message area after a few seconds delay.
.LP
Once you have a widget tree you may now select any of the other menu
options. The effect of each of these is described below.  
.SH COMMANDS
.IP "Get Widget Tree" 8
Allows the user to click on any client that speaks the editres
protocol and receive its widget tree.
.IP "Refresh Current Widget Tree" 
Editres only knows about the widgets that exist at the present time.
Many applications create and destroy widgets "on-the-fly".  Selecting
this menu item will cause editres to ask the application to resend its
widget tree, thus updating its information to the new state of the application.
.IP "Example"
Xman only creates the widgets for its \fItopbox\fP when it
starts up.  None of the widgets for the manual page window are created
until the user actually clicks on the \fIManual Page\fP button.  If
you retrieved 
xman's widget tree before the the manual page is active, you may
wish to refresh the widget tree after the manual page has been
displayed.  This will allow you to also edit the manual page's resources.
.IP "Dump Widget Tree to a File"
For documenting applications it is often useful to be able to
dump the entire application widget tree to an ascii file.  This file
can then be included in the manual page.  When this menu item is selected
a popup dialog is activated.  Type the name of the file in this
dialog, and either select \fIokay\fP, or type a carriage-return.  Editres
will now dump the widget tree to this file.  To cancel the file dialog
just select the \fIcancel\fP button.
.IP "Show Resource Box"
This command will popup a resource box for the current client.  This
resource box (described in detail below) will allow the user to see
exactly which resources can be set for the widget that is currently
selected in the widget tree display.  Only one widget may be currently
selected, if greater or fewer are selected editres will refuse to
pop up the resource box, and put an error message in the \fBMessage Area\fP.
.IP "Set Resource"
This command will popup a simple dialog box for setting an arbitrary
resource on all selected widgets.  You must type in the resource name,
as well as the value.  You can use the Tab key to switch between the
resource name field the resource value field.
.IP "Quit"
Exits editres.
.SH TREE COMMANDS
The \fBTree\fP menu contains several commands that allow operations to
be performed on the widget tree.
.IP "Select Widget in Client"
This menu item allows you to select any widget in the application, editres
will then highlight the corrosponding element the widget tree display.
Once
this menu item is selected the pointer cursor will again turn to a
crosshair, and you must click any pointer button in the widget you
wish to have displayed.  Since some widgets are fully obscured by
their children, it is not possible to get to every widget this way,
but this mechanism does give very useful feedback between the elements
in the widget tree and those in the actual client.
.IP "Select All" 
.br
.ns 
.IP "Unselect All"
.br
.ns 
.IP "Invert All" 
These functions allow the user to select, unselect, or invert all
widgets in the widget tree.
.IP "Select Children"
.br
.ns 
.IP "Select Parents"
These functions select the immediate parent or children of each of the
currently selected widgets.
.IP "Select Descendants"
.br
.ns 
.IP "Select Ancestors"
These functions select all parents or children of each of the
currently selected widgets.  This is a recursive search.
.IP "Show Widget Names"
.br
.ns 
.IP "Show Class Names"
.br
.ns .IP "Show Widget IDs"
.br
.ns 
.IP "Show Widget Windows"
When the tree widget is initially displayed the labels of each widget
in the tree correspond to the widget names.  These functions will
cause the label of \fBall\fP widgets in the tree to be changed to show the
class name, IDs, or window associated with each widget in the application.
The widget IDs, and windows are shown as hex numbers.
.LP
In addition there are keyboard accelerators for each of the 
Tree operations.  If the input focus is over an individual widget in
the tree, then that operation will only effect that widget.  If the
input focus is in the Tree background it will have 
exactly the same effect as the corresponding menu item.  
.LP
The translation
entries shown may be applied to any widget in the application.  If
that widget is a child of the Tree widget, then it will only affect that
widget, otherwise it will have the same effect as the commands in the
tree menu.
.IP "Flash Active Widgets"
This command is the inverse of the \fBSelect Widget in Client\fP
command, it will show the user each widget that is currently selected in
the widget tree, by flashing the corresponding widget in the
application \fInumFlashes\fP (three by default) times in the
\fIflashColor\fP.
.sp
.nf
.TA .5i 1.5i 4.0i
.ta .5i 1.5i 4.0i
	\fBKey	Option	Translation Entry\fP

	space	Unselect	Select(nothing)
	w	Select	Select(widget)
	s	Select	Select(all)
	i	Invert	Select(invert)
	c	Select Children	Select(children)
	d	Select Descendants	Select(descendants)
	p	Select Parent	Select(parent)
	a	Select Ancestors	Select(ancestors)
	N	Show Widget Names	Relabel(name)
	C	Show Class Names	Relabel(class)
	I	Show Widget IDs	Relabel(id)
	W	Show Widget Windows	Relabel(window)
	T	Toggle Widget/Class Name	Relabel(toggle)
.fi
.sp
Clicking button 1 on a widget adds it to the set of selected widgets.
Clicking button 2 on a widget deselects all other widgets and then
selects just that widget.
Clicking button 3 on a widget toggles its label between the widget's
instance name the widget's class name.
.sp
.SH USING THE RESOURCE BOX
The resource box contains five different areas.  Each of the areas,
as they appear on the screen, from top to bottom will be discussed.
.IP "The Resource Line"
This area at the top of the resource box shows the current resource
name exactly as it would appear if you were to save it to a file or
apply it.
.IP "The Widget Names and Classes"
This area allows you to select exactly which widgets this resource will
apply to.  The area contains four lines, the first contains the 
name of the selected widget and all its ancestors, and the more restrictive
dot (\fB.\fP) separator.  The second line contains less specific the
Class names 
of each widget, and well as the less restrictive star (\fB*\fP) separator.
The third line contains a set of special buttons called \fBAny Widget\fP
which will generalize this level to match any widget.
The last line contains a set of special buttons called \fBAny
Widget Chain\fP which will turn the single level into something that
matches zero or more levels.
.IP ""
The initial state of this area is the most restrictive, using the
resource names and the dot separator.  By selecting the other buttons
in this are you can ease the restrictions to allow more and more widgets
to match the specification.  The extreme case is to select all the 
\fBAny Widget Chain\fP buttons, which will match every widget in the
application.   As you select different buttons the tree display will update
to show you exactly which widgets will be effected by the current
resource specification.
.IP "Normal and Constraint Resources"
The next area allows you to select the name of the normal or
constraint resources you wish to set.  Some widgets may not have constraint
resources, so that area will not appear.
.IP "Resource Value"
This next area allows you to enter the resource value.  This value
should be entered exactly as you would type a line into your resource file.
Thus it should contain no unescaped new-lines.  There are a few
special character sequences for this file:
.IP ""
\\n - This will be replaced with a newline.
.br
.sp
\\### - Where # is any octal digit.  This will be replaced with a
single byte that contains this sequence interpreted as an octal number.
For example, a value containing a NULL byte can be stored by
specifying \\000.
.br
.sp
\\<new-line> - This will compress to nothing.
.br
.sp
\\\\ - This will compress to a single backslash.
.IP "Command Area"
This area contains several command buttons that I will describe in
this section.
.IP "Set Save File"
This button allows the user to modify file that the resources
will be saved to.  This button will bring up a dialog box that will
ask you for a filename, once the filename has been entered, either hit
carriage-return or click on the \fIokay\fP button.  To popdown the
dialog box without changing the save file, click the \fIcancel\fP button.
.IP "Save"
This button will append the \fBresource line\fP described above to the
end of the current save file.  If no save file has been set the \fBSet
Save File\fP dialog box will be popped up to prompt the user for a filename.
.IP "Apply"
This button attempts to perform a XtSetValues call on all widgets
that match the \fBresource line\fP described above.  The value specified
is applied directly to all matching widgets.  This behavior is an attempt
to give a dynamic feel to the resource editor.  Since this feature allows
users to put an application in states it may not be willing to handle,
a hook has been provided to allow specific clients block these SetValues
requests (see \fBBlocking Editres Requests\fP below).
.IP ""
Unfortunately due to design constraints imposed on the widgets by the X
Toolkit and the Resource Manager, trying to coerce an inherently
static system into dynamic behavior can cause strange results.  There
is no guarantee that the results of an apply will be the same as what
will happen when you save the value, and restart the application.
This functionality is provided to try to give you a rough feel for what
your changes will accomplish, and the results obtained should be considered
suspect at best.  Having said that, this is one of the neatest
features of editres, and I strongly suggest that you play with it, and
see what it can do.
.IP "Save and Apply"
This button combines the Save and Apply actions described above into
one button.
.IP "Popdown Resource Box"
This button will remove the resource box from the display.
.SH BLOCKING EDITRES REQUESTS
The editres protocol has been built into the Athena Widget set.  This allows
all application that are linked against Xaw to be able to speak to the
resource editor.  While this provides great flexability, and is a
useful tool, it can quite easily be abused.  It is therefore possible
for any Xaw client to specify a value for the \fBeditresBlock\fP
resource described below, to keep editres from divulging information
about its internals, or to disable the \fBSetValues\fP part of the protocol.
.TP 8
.B editresBlock (\fPClass\fB EditresBlock)
Specifies which type of blocking this client wishes to impose on the
editres protocol.  
.LP
The accepted values are:
.IP all 15
Block all requests.
.IP setValues 
Block all setvalues request, this is the only editres request that
actually modifies the application, this is in effect stating that the
applicaion is read-only.
.IP none
Allow all editres requests.
.LP
Remember that these resources are set on any Xaw client, \fBnot
editres\fP.  They allow individual clients to keep all or some
of the requests editres makes from ever succeeding.  Of course,
editres is also an Xaw client, so it may also be viewed and modified
by editres (rather recursive, I know), these commands can be blocked
by setting the \fBeditresBlock\fP resource on editres itself.
.SH RESOURCES
For \fIeditres\fP the available application resources are:
.TP 8
.B numFlashes (\fPClass\fB NumFlashes)
Specifies the number of times the widgets in the client application
will be flashed when the \fBShow Active Widgets\fP command in invoked.
.TP 8
.B flashTime (\fPClass\fB FlashTime)
Amount of time between the flashes described above.
.TP 8
.B flashColor (\fPClass\fB flashColor)
Specifies the color used to flash client widgets.  A bright color
should be used that will immediately draw your attention to the area being
flashed, such as red or yellow.
.TP 8
.B saveResourcesFile (\fPClass\fB SaveResourcesFile)
This is the file the resource line will be append to when the \fBSave\fP
button activated in the resource box.
.TP 8
.B preeditType (\fPClass\fB PreeditType)
Specifies the name of the input method style.
You can select { OverTheSpot | OffTheSpot | Root }.
The default is not specified.
.TP 8
.B "inputMethod (\fPclass\fB InputMethod)"
Specifies the name of the input method. The default is not specified.
If you want to use xwnmo, set this as _XWNMO.
.SH WIDGETS
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIeditres\fP.  In the notation below,
indentation indicates hierarchical structure.  The widget class name
is given first, followed by the widget instance name.
.sp
.nf
.TA .5i 1.0i 1.5i 2.0i
.ta .5i 1.0i 1.5i 2.0i
Editres  editres
	Paned  paned
		Box  box
			MenuButton  commands
				SimpleMenu  menu
					SmeBSB  sendTree
					SmeBSB  refreshTree
					SmeBSB  dumpTreeToFile
					SmeLine  line
					SmeBSB  getResourceList
					SmeLine  line
					SmeBSB  quit
			MenuButton  treeCommands
				SimpleMenu  menu
					SmeBSB  showClientWidget
					SmeBSB  selectAll
					SmeBSB  unselectAll
					SmeBSB  invertAll
					SmeLine  line
					SmeBSB  selectChildren
					SmeBSB  selectParent
					SmeBSB  selectDescendants
					SmeBSB  selectAncestors
					SmeLine  line
					SmeBSB  showWidgetNames
					SmeBSB  showClassNames
					SmeBSB  showWidgetIDs
					SmeBSB  showWidgetWindows
					SmeLine  line
					SmeBSB  flashActiveWidgets
		Paned  hPane
			Panner  panner
			Label  userMessage
			Grip  grip
		Porthole  porthole
			Tree  tree
				Toggle  <name of widget in client>
					.
					.
					.
					TransientShell  resourceBox
						Paned  pane
							Label  resourceLabel
							Form  namesAndClasses
								Toggle  dot
								Toggle  star
								Toggle  any
								Toggle  name
								Toggle  class
								     .
								     .
								     .
							Label  namesLabel
							List  namesList
							Label  constraintLabel
							List  constraintList
							Form  valueForm
								Label  valueLabel
								Text  valueText
							Box  commandBox
								Command  setFile
								Command  save
								Command  apply
								Command  saveAndApply
								Command  cancel
							Grip  grip
		Grip  grip
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
/usr/lib/X11/app-defaults/Editres - specifies required resources
.SH SEE ALSO
X(1), xrdb(1), Athena Widget Set
.SH RESTRICTIONS
This is a prototype, there are lots of nifty features I would love to add,
but I hope this will give you some ideas about what a resource editor
can do.
.SH COPYRIGHT
Copyright 1992, OMRON Corporation.
.br
Copyright 1990, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Chris D. Peterson, formerly MIT X Consortium

