/*
 * $Id: jtermio.c,v 1.4 1992/04/15 10:56:53 proj Exp $
 */
/*
 * Copyright 1991 by OMRON Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of OMRON not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  OMRON makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * OMRON DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL OMRON BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE. 
 *
 */				
#ifdef	XLOCALE
#if defined(luna) && defined(CTRL_JTERMIO)
#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#ifdef	uniosb
#include <sys/jtermio.h>
#endif	/* uniosb */
#include <sys/tty.h>
#ifdef	uniosu
#include <sys/termio.h>
#include <sys/pty.h>
#endif	/* uniosu */

#include "ptyx.h"
#include "data.h"

#define LOCALE_UJIS	"ja_JP.ujis"
#define LOCALE_SJIS	"ja_JP.mscode"
#define LOCALE_JIS7	"ja_JP.jis7"
#define LOCALE_JIS8	"ja_JP.jis8"
#define LOCALE_PJIS	"ja_JP.pjis"
#define LOCALE_UGB	"zh_CN.ugb"

static char	jis_ki_str[6] = {0x1b,0x24,0x42,0x1b,0x24,0x40};
static char	jis_ko_str[6] = {0x1b,0x28,0x4a,0x1b,0x28,0x4a};
/* jtermio mode change */
void
set_jterm(locale, fd)
char *locale;
int fd;
{
	struct jtermio	jbuf1;
#ifndef	uniosu
	unsigned int lmode;
#endif	/* !uniosu */

#ifndef	uniosu
	(void)ioctl(fd, TIOCLGET, (char *)&lmode);
#endif	/* !uniosu */
	(void)ioctl(fd, JTERMGET, (char *)&jbuf1);

	if (!strcmp(locale, LOCALE_UJIS) || !strcmp(locale, LOCALE_UGB)) {
		jbuf1.j_level = 2;
		jbuf1.j_flg |= (CONVTOEXT | KANJIINPUT);
		jbuf1.j_ecode = UJIS;
		jbuf1.j_jst[0] = NULL;
		jbuf1.j_jstl = 0;
		jbuf1.j_jend[0] = NULL;
		jbuf1.j_jendl = 0;
#ifndef	uniosu
		lmode |= LCTLECH;
#endif	/* !uniosu */
	} else if (!strcmp(locale, LOCALE_SJIS)) {
		jbuf1.j_level = 2;
		jbuf1.j_flg &= ~CONVTOEXT;
		jbuf1.j_flg |= KANJIINPUT;
		jbuf1.j_ecode = SJIS;
		jbuf1.j_jst[0] = NULL;
		jbuf1.j_jstl = 0;
		jbuf1.j_jend[0] = NULL;
		jbuf1.j_jendl = 0;
#ifndef	uniosu
		lmode |= LCTLECH;
#endif	/* !uniosu */
	} else if (!strcmp(locale, LOCALE_JIS7) ||
		   !strcmp(locale, LOCALE_JIS8) ||
		   !strcmp(locale, LOCALE_PJIS)) {
		jbuf1.j_level = 2;
		jbuf1.j_flg &= ~CONVTOEXT;
		jbuf1.j_flg |= KANJIINPUT;
		jbuf1.j_ecode = JIS;
		strncpy(jbuf1.j_jst, jis_ki_str, 6);
		jbuf1.j_jstl = 3;
		strncpy(jbuf1.j_jend, jis_ko_str, 6);
		jbuf1.j_jendl = 3;
#ifndef	uniosu
		lmode &= ~LCTLECH;
#endif	/* !uniosu */
	} else {
		jbuf1.j_level = 0;
		jbuf1.j_flg &= ~CONVTOEXT;
		jbuf1.j_flg |= KANJIINPUT;
		jbuf1.j_ecode = JIS;
		jbuf1.j_jst[0] = NULL;
		jbuf1.j_jstl = 0;
		jbuf1.j_jend[0] = NULL;
		jbuf1.j_jendl = 0;
#ifndef	uniosu
		lmode |= LCTLECH;
#endif	/* !uniosu */
	}
#ifndef	uniosu
	(void)ioctl(fd, TIOCLSET, (char *)&lmode);
#endif	/* !uniosu */
	(void)ioctl(fd, JTERMSET, (char *)&jbuf1);
}

#ifdef XLOCALE_XIM
set_init_jterm(locale, fd)
char *locale;
int fd;
{
    struct jtermio  jbuf1;

    (void)ioctl(fd, JTERMGET, (char *)&jbuf1);
    jbuf1.j_flg |= KANJIINPUT;
    (void)ioctl(fd, JTERMSET, (char *)&jbuf1);
}

void
kanjiinput()
{
    struct jtermio jbuf1;
    int fd = term->screen.respond;

    (void)ioctl(fd, JTERMGET, (char *)&jbuf1);
    if (term->screen.ximon == True) {
	jbuf1.j_flg |= KANJIINPUT;
    } else {
	jbuf1.j_flg &= ~KANJIINPUT;
    }
    (void)ioctl(fd, JTERMSET, (char *)&jbuf1);
}
#endif /* XLOCALE_XIM */

#ifdef	PIOCPKT
#ifdef XLOCALE_XIM
static void
call_do_im()
{
    extern void do_root(), do_off(), do_over();

    switch(last_im_mode) {
     case ROOT:
	do_root((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
	break;
     case OFFSPOT:
	do_off((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
	break;
     case OVERSPOT:
	do_over((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
	break;
    }
}
#endif /* XLOCALE_XIM */

void
arrange_ioctl()
{
    struct jtermio jbuf1;
    struct termio buf;
    int fd = term->screen.respond;

    (void)ioctl(fd, JTERMGET, &jbuf1);
    (void)ioctl(fd, TCGETA, &buf);

#ifdef XLOCALE_XIM
#ifdef	RAW_KINPUT_OFF
    if ((buf.c_lflag & (ISIG | ICANON)) == 0) {	/* RAW mode */
	if (term->screem.ximon == True) {
	    call_do_im();
	}
    }
#endif	/* RAW_KINPUT_OFF */

    if (jbuf1.j_flg & KANJIINPUT) {
	if (term->screen.ximon == False) {	/* try to open IM */
	    call_do_im();
	}
    } else {
	if (term->screen.ximon == True) {	/* try to close IM */
	    call_do_im();
	}
    }
#endif /* XLOCALE_XIM */
    
}
#endif	/* PIOCPKT */
#endif	/* defined(luna) && defined(CTRL_JTERMIO) */
#endif	/* XLOCALE */
