/*
 * $Id: ximset.c,v 1.15 1992/05/15 02:56:10 proj Exp $
 */
/*
 * Copyright 1990, 1991 by OMRON Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of OMRON not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  OMRON makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * OMRON DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL OMRON BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE. 
 *
 *	Author:	LU Qunyun	OMRON Corporation
 */				

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <setjmp.h>
#include "ptyx.h"
#include "data.h"
#include "Xi18nint.h"

#include <X11/Xlocale.h>
#ifdef	uniosu
#ifdef	CTRL_JTERMIO
#include <sys/tty.h>
#include <sys/pty.h>
#endif	/* CTRL_JTERMIO */
#endif	/* uniosu */

#ifdef XLOCALE_XIM

static int s_x = 0;
static int s_y = 0;

extern char *getenv();
#ifdef XML
extern XIM XmlOpenIM();
#define IC	(xic)
#define IM	(xim)
#define IC_FOCUS	(ic_focus)
#define OpenInputMethod	XmlOpenIM
#else /* XML */
#define IC	(CurXlcInfo->ic)
#define IM	(CurXlcInfo->im)
#define IC_FOCUS	(CurXlcInfo->ic_focus)
#define OpenInputMethod	XOpenIM
#endif /* XML */

#define MARGIN	 10

Status OpenIM()
{
        XrmDatabase rdb;
        char *pp;
        char filename[256];
	TScreen *screen = &term->screen;
	char *p, modifiers[32];
	extern int imioerror();

	if (!strcmp(setlocale(LC_ALL, NULL), "C")) {
   		fprintf(stderr,
		"BadIMOpen , could not create input method on C locale.\n");
		return(False);
	}
	if (IM)
	    return(True);
	if ((p = XSetLocaleModifiers(NULL)) == NULL || *p == '\0') {
		if (term->misc.input_method == NULL) {
			fprintf(stderr,
	"BadIMOpen , please set XMODIFIERS or a resource inputMethod.\n");
			return(False);
		}
		strcpy(modifiers, "@im=");
		strcat(modifiers, term->misc.input_method);
		XSetLocaleModifiers(modifiers);
	}
    	pp = getenv("HOME");
    	sprintf(filename, "%s/.Xdefaults", pp);
    	rdb = XrmGetFileDatabase(filename);

    	if((IM = OpenInputMethod(screen->display,rdb, "xim", "Xim")) == NULL) {
   		fprintf(stderr, "BadIMOpen , input method is not created\n");
		return(False);
	}
	_XipSetIOErrorHandler(imioerror);
	return(True);

}

#ifdef XML
static Status
ch_curlang(lc_name, getlang, only_LandT)
register char *lc_name, *getlang;
Status only_LandT;
{
    int check_len;
    char *p;

    if (!lc_name || !*lc_name || !getlang || !*getlang) return(False);
    if (only_LandT == True && (p = index(getlang, '.'))) {
	check_len = p - getlang;
    } else {
	check_len = strlen(getlang);
    }
    if (!strncmp(lc_name, getlang, check_len))
	return(True);
    return(False);
}
#endif /* XML */

Status CreateIC()
{
        XVaNestedList preedit_nestedlist = NULL, status_nestedlist = NULL;
        XRectangle pre_area, sta_area, *area_needed = NULL;
        XPoint point;
	TScreen *screen = &term->screen;
#ifdef XML
	char	*lanp, *lcp, curlang[16], *getlang;
#endif /* XML */
	XIMStyle  p;
	Pixel fg = screen->foreground, bg = term->core.background_pixel;
	extern void ICFocus();


	if (!strcmp(setlocale(LC_ALL, NULL), "C")) return(False);
#ifdef XML
	lcp = CurXlcInfo->lcname;
	for(lanp = curlang; *lcp != '@' && *lcp != '\0'; lanp++, lcp++){
		*lanp = *lcp;
	}
	*lanp = '\0';
#endif /* XML */

	switch(term->flags & ALLIMMODE){
	case	OVERSPOT:	
		p = (XIMPreeditPosition|XIMStatusArea);
                s_x = point.x = CursorX(screen, screen->cur_col);
		s_y = point.y = CursorY(screen, screen->cur_row)
			      + GetAscent(screen->fset_norm);
		pre_area.x = screen->border + screen->scrollbar;
		pre_area.y = screen->border;
		pre_area.width = FullWidth(screen) - screen->border * 2
				- screen->scrollbar;
		pre_area.height = FullHeight(screen) - screen->border * 2;
	    	preedit_nestedlist = XVaCreateNestedList(0,
					XNLineSpace, 0,
					XNFontSet, screen->fset_norm,
					XNSpotLocation, &point,
					XNArea, &pre_area,
					XNForeground, fg,
					XNBackground, bg,
					NULL);
    		status_nestedlist = XVaCreateNestedList(0,
					XNLineSpace, 0,
					XNFontSet, screen->fset_norm,
					XNForeground, fg,
					XNBackground, bg,
					NULL);
		IC = XCreateIC(IM, XNInputStyle, p,
#ifdef XML
			    XNCurrentLanguage, curlang,
#endif /* XML */
			    XNClientWindow, term->core.window,
			    XNFocusWindow, term->core.window,
			    XNPreeditAttributes, preedit_nestedlist,
			    XNStatusAttributes, status_nestedlist,
			    NULL);
		if (preedit_nestedlist) XFree(preedit_nestedlist);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
#ifdef XML
		XGetICValues(IC, XNCurrentLanguage, &getlang, NULL);
		if (ch_curlang(curlang, getlang, False) == False) {
		    XDestroyIC(IC);
		    IC = NULL;
		    return(False);
		}
#endif /* XML */

		status_nestedlist = XVaCreateNestedList(0,
					XNAreaNeeded, &area_needed,
					NULL);
		XGetICValues(IC, XNStatusAttributes, status_nestedlist, NULL);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
		if (area_needed == NULL) {
		    XDestroyIC(IC);
		    IC = NULL;
		    return(False);
		}

		sta_area.x = screen->border + screen->scrollbar;
		sta_area.y = FullHeight(screen) - area_needed->height
				- screen->border;
		sta_area.width =  area_needed->width;
		sta_area.height = area_needed->height;
		XFree(area_needed);
		status_nestedlist = XVaCreateNestedList(0, XNArea, &sta_area, 
					NULL);
		XSetICValues(IC, XNStatusAttributes, status_nestedlist, NULL);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);

		break;

	case	OFFSPOT:
		p = (XIMPreeditArea|XIMStatusArea);
	    	preedit_nestedlist = XVaCreateNestedList(0,
					XNLineSpace, 0,
					XNFontSet, screen->fset_norm,
					XNForeground, fg,
					XNBackground, bg,
					NULL);
		status_nestedlist = XVaCreateNestedList(0,
                                        XNLineSpace, 0,
                                        XNFontSet, screen->fset_norm,
					XNForeground, fg,
					XNBackground, bg,
                                        NULL);
                IC = XCreateIC(IM, XNInputStyle, p,
#ifdef XML
                            XNCurrentLanguage, curlang,
#endif /* XML */
                            XNClientWindow, term->core.window,
                            XNFocusWindow, term->core.window,
                            XNPreeditAttributes, preedit_nestedlist,
                            XNStatusAttributes, status_nestedlist,
                            NULL);

		if (preedit_nestedlist) XFree(preedit_nestedlist);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
#ifdef XML
		XGetICValues(IC, XNCurrentLanguage, &getlang, NULL);
		if (ch_curlang(curlang, getlang, False) == False) {
		    XDestroyIC(IC);
		    IC = NULL;
		    return(False);
		}
#endif /* XML */

		status_nestedlist = XVaCreateNestedList(0,
					XNAreaNeeded, &area_needed,
					NULL);
		XGetICValues(IC, XNStatusAttributes, status_nestedlist, NULL);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
		if (area_needed == NULL) {
		    XDestroyIC(IC);
		    IC = NULL;
		    return(False);
		}

		pre_area.x = screen->border + area_needed->width 
				+ screen->scrollbar + MARGIN;
		pre_area.y = FullHeight(screen) - area_needed->height
				- screen->border;
		pre_area.width = FullWidth(screen) - pre_area.x;
		pre_area.height = area_needed->height;
		preedit_nestedlist = XVaCreateNestedList(0,
					XNArea, &pre_area,
					NULL);
	
		sta_area.x = screen->border + screen->scrollbar;
		sta_area.y = pre_area.y;
		sta_area.width =  area_needed->width;
		sta_area.height = area_needed->height;
		XFree(area_needed);
		status_nestedlist = XVaCreateNestedList(0, XNArea, &sta_area, 
					NULL);
	
		XSetICValues(IC, XNPreeditAttributes, preedit_nestedlist,
				XNStatusAttributes, status_nestedlist,
				NULL);
		
		if (preedit_nestedlist) XFree(preedit_nestedlist);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);

		break;

	case	ROOT:
		p = (XIMPreeditNothing|XIMStatusNothing);
		IC = XCreateIC(IM, XNInputStyle, p,
			    XNClientWindow, term->core.window,
			    XNFocusWindow, term->core.window,
			    NULL);
		if (IC == NULL) return(False);
#ifdef XML
		XGetICValues(IC, XNCurrentLanguage, &getlang, NULL);
		if (ch_curlang(curlang, getlang, True) == False) {
		    XDestroyIC(IC);
		    IC = NULL;
		    return(False);
		}
#endif /* XML */
		break;
	}

	IC_FOCUS = False;
	if (screen->select) {
	    ICFocus(True);
	} else {
	    ICFocus(False);
	}
	if (IC == NULL) return(False);
	last_im_mode = term->flags & ALLIMMODE;
#ifndef XML
	CurXlcInfo->cur_im_mode = last_im_mode;
#endif /* !XML */
	return(True);
}


Status ModifyICValue()
{
        XVaNestedList preedit_nestedlist = NULL, status_nestedlist = NULL;
        XRectangle pre_area, sta_area, *area_needed = NULL;
        XPoint point;
        register TScreen *screen = &term->screen;
#ifdef XML
	char	*lanp, *lcp, curlang[16], *getlang;
#endif /* XML */
	Pixel fg = screen->foreground, bg = term->core.background_pixel;
	int save_immode = term->flags & ALLIMMODE;
	extern void set_im_menu();
	extern void ICFocus();

	XUnsetICFocus(IC); /* dummy : checking for socket to IM */
	IC_FOCUS = False;
	if (!IC) {
	    if (OpenIM() == True) {
		term->flags |= save_immode;
		screen->ximon = True;
	    	if (CreateIC() == True) {
		    set_im_menu();
		    return(True);
		}
	    }
	    return(False);
	}
#ifdef XML
	if (last_im_mode != (term->flags & ALLIMMODE)) {
#else /* XML */
	if (CurXlcInfo->cur_im_mode != (term->flags & ALLIMMODE)) {
#endif /* XML */
	    XDestroyIC(IC);
	    return(CreateIC());
	}
        if(!strcmp(CurXlcInfo->lcname , "C")) return(False);
#ifdef XML
	lcp = CurXlcInfo->lcname;
	for(lanp = curlang; *lcp != '@' && *lcp != '\0'; lanp++, lcp++){
		*lanp = *lcp;
	}
	*lanp = '\0';
#endif /* XML */

	switch(term->flags & ALLIMMODE){
	case	OVERSPOT:
                s_x = point.x = CursorX(screen, screen->cur_col);
		s_y = point.y = CursorY(screen, screen->cur_row)
			      + GetAscent(screen->fset_norm);
		pre_area.x = screen->border + screen->scrollbar;
		pre_area.y = screen->border;
		pre_area.width = FullWidth(screen) - screen->border * 2
				- screen->scrollbar;
		pre_area.height = FullHeight(screen) - screen->border * 2;
		preedit_nestedlist = XVaCreateNestedList(0,
                                        XNSpotLocation, &point,
					XNArea, &pre_area,
					XNForeground, fg,
					XNBackground, bg,
                                        NULL);

                status_nestedlist = XVaCreateNestedList(0,
                                        XNAreaNeeded, &area_needed,
                                        NULL);
                XGetICValues(IC, XNStatusAttributes, status_nestedlist, NULL);
                if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
		if (area_needed == NULL) {
		    XDestroyIC(IC);
		    return(False);
		}

		sta_area.x = screen->border + screen->scrollbar;
                sta_area.y = FullHeight(screen) - screen->border
                                - area_needed->height;
                sta_area.width =  area_needed->width;
                sta_area.height = area_needed->height;
		XFree(area_needed);
                status_nestedlist = XVaCreateNestedList(0, XNArea, &sta_area,
					XNForeground, fg,
					XNBackground, bg,
                                        NULL);
                XSetICValues(IC,
#ifdef XML
			     XNCurrentLanguage, curlang,
#endif /* XML */
			     XNPreeditAttributes, preedit_nestedlist,
			     XNStatusAttributes, status_nestedlist,
			     NULL);
		if (preedit_nestedlist) XFree(preedit_nestedlist);
                if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
#ifdef XML
		XGetICValues(IC, XNCurrentLanguage, &getlang, NULL);
		if (ch_curlang(curlang, getlang, False) == False) {
		    return(False);
		}
#endif /* XML */
		break;

	case	OFFSPOT:
		status_nestedlist = XVaCreateNestedList(0,
					XNAreaNeeded, &area_needed,
					NULL);
		XGetICValues(IC, XNStatusAttributes, status_nestedlist, NULL);
		if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
		if (area_needed == NULL) {
		    XDestroyIC(IC);
		    return(False);
		}

		pre_area.x = screen->border + area_needed->width 
				+ screen->scrollbar + MARGIN;
		pre_area.y = FullHeight(screen) - area_needed->height
				- screen->border;
		pre_area.width = FullWidth(screen) - pre_area.x;
		pre_area.height = area_needed->height;
		preedit_nestedlist = XVaCreateNestedList(0,
					XNArea, &pre_area,
					XNForeground, fg,
					XNBackground, bg,
					NULL);
	
		sta_area.x = screen->border + screen->scrollbar;
		sta_area.y = pre_area.y;
		sta_area.width =  area_needed->width;
		sta_area.height = area_needed->height;
		XFree(area_needed);
		status_nestedlist = XVaCreateNestedList(0, XNArea, &sta_area, 
					XNForeground, fg,
					XNBackground, bg,
					NULL);
	
		XSetICValues(IC,
#ifdef XML
			     XNCurrentLanguage, curlang,
#endif /* XML */
			     XNPreeditAttributes, preedit_nestedlist,
			     XNStatusAttributes, status_nestedlist,
			     NULL);

		if (preedit_nestedlist) XFree(preedit_nestedlist);
                if (status_nestedlist) XFree(status_nestedlist);
		if (IC == NULL) return(False);
#ifdef XML
		XGetICValues(IC, XNCurrentLanguage, &getlang, NULL);
		if (ch_curlang(curlang, getlang, False) == False) {
		    return(False);
		}
#endif /* XML */
		break;
#ifdef XML
	case ROOT:
		XSetICValues(IC, XNCurrentLanguage, curlang, NULL);
		if (IC == NULL) return(False);
		XGetICValues(IC, XNCurrentLanguage, &getlang, NULL);
		if (ch_curlang(curlang, getlang, True) == False) {
		    return(False);
		}
		break;
#endif /* XML */
	}

	if (screen->select) ICFocus(True);
	if (IC == NULL) return(False);
	return(True);
}

void
IMCursorMove(screen)
register TScreen *screen;
{
	short x, y;
#ifndef	SPOT
        static XVaNestedList preedit_nestedlist = NULL;
        static XPoint point;
#endif	/* SPOT */

	if (!(term->flags & OVERSPOT)) return;
	x = CursorX(screen, screen->cur_col);
	y = CursorY(screen, screen->cur_row) + GetAscent(screen->fset_norm);
	if (s_x == x && s_y == y) return;
	s_x = x;
	s_y = y;
#ifdef	SPOT
	_XipChangeSpot(IC, x, y);
#else	/* SPOT */
	point.x = x;
	point.y = y;
	if (preedit_nestedlist == NULL) {
	    preedit_nestedlist = XVaCreateNestedList(0, XNSpotLocation, &point,
						     NULL);
	}
	XSetICValues(IC, XNPreeditAttributes, preedit_nestedlist, NULL);
#endif	/* SPOT */
}

void ICFocus(focus)
Boolean focus;
{
    if (!IC) return;
    if (IC_FOCUS != focus) {
	if (focus) {
	    XSetICFocus(IC);
	    IC_FOCUS = True;
	} else {
	    XUnsetICFocus(IC);
	    IC_FOCUS = False;
	}
    }
}
#endif /* XLOCALE_XIM */
