/*
 * This table of multibyte font is based on Chinese/Japanese/Korean.
 * If there is another styles of fonts at your platfrom, please replace
 * it, for example:
 *
 *		-*--14*   ----> *gothic-medium-r-normal--14*
 * At our platform, there is only kanji/hanzi in the size:
 *		-*--14*
 *		-*--16*
 *		-*--18*
 *		-*--26*
 */
static char	* fontNameStr[] =
{
/* 75 dpi fonts */
  "*times-medium-r-normal--8*",
  "*times-medium-r-normal--10*",
  "*times-medium-r-normal--12*",
  "*times-medium-r-normal--14*",
  "*times-medium-r-normal--18*",
  "*times-medium-r-normal--24*",
  "*times-bold-r-normal--8*",
  "*times-bold-r-normal--10*",
  "*times-bold-r-normal--12*",
  "*times-bold-r-normal--14*",
  "*times-bold-r-normal--18*",
  "*times-bold-r-normal--24*",
  "*times-medium-i-normal--8*",
  "*times-medium-i-normal--10*",
  "*times-medium-i-normal--12*",
  "*times-medium-i-normal--14*",
  "*times-medium-i-normal--18*",
  "*times-medium-i-normal--24*",
  "*times-bold-i-normal--8*",
  "*times-bold-i-normal--10*",
  "*times-bold-i-normal--12*",
  "*times-bold-i-normal--14*",
  "*times-bold-i-normal--18*",
  "*times-bold-i-normal--24*",

  "*courier-medium-r-normal--8*",
  "*courier-medium-r-normal--10*",
  "*courier-medium-r-normal--12*",
  "*courier-medium-r-normal--14*",
  "*courier-medium-r-normal--18*",
  "*courier-medium-r-normal--24*",
  "*courier-bold-r-normal--8*",
  "*courier-bold-r-normal--10*",
  "*courier-bold-r-normal--12*",
  "*courier-bold-r-normal--14*",
  "*courier-bold-r-normal--18*",
  "*courier-bold-r-normal--24*",
  "*courier-medium-o-normal--8*",
  "*courier-medium-o-normal--10*",
  "*courier-medium-o-normal--12*",
  "*courier-medium-o-normal--14*",
  "*courier-medium-o-normal--18*",
  "*courier-medium-o-normal--24*",
  "*courier-bold-o-normal--8*",
  "*courier-bold-o-normal--10*",
  "*courier-bold-o-normal--12*",
  "*courier-bold-o-normal--14*",
  "*courier-bold-o-normal--18*",
  "*courier-bold-o-normal--24*",

  "*helvetica-medium-r-normal--8*",
  "*helvetica-medium-r-normal--10*",
  "*helvetica-medium-r-normal--12*",
  "*helvetica-medium-r-normal--14*",
  "*helvetica-medium-r-normal--18*",
  "*helvetica-medium-r-normal--24*",
  "*helvetica-bold-r-normal--8*",
  "*helvetica-bold-r-normal--10*",
  "*helvetica-bold-r-normal--12*",
  "*helvetica-bold-r-normal--14*",
  "*helvetica-bold-r-normal--18*",
  "*helvetica-bold-r-normal--24*",
  "*helvetica-medium-o-normal--8*",
  "*helvetica-medium-o-normal--10*",
  "*helvetica-medium-o-normal--12*",
  "*helvetica-medium-o-normal--14*",
  "*helvetica-medium-o-normal--18*",
  "*helvetica-medium-o-normal--24*",
  "*helvetica-bold-o-normal--8*",
  "*helvetica-bold-o-normal--10*",
  "*helvetica-bold-o-normal--12*",
  "*helvetica-bold-o-normal--14*",
  "*helvetica-bold-o-normal--18*",
  "*helvetica-bold-o-normal--24*",

  "*new century schoolbook-medium-r-normal--8*",
  "*new century schoolbook-medium-r-normal--10*",
  "*new century schoolbook-medium-r-normal--12*",
  "*new century schoolbook-medium-r-normal--14*",
  "*new century schoolbook-medium-r-normal--18*",
  "*new century schoolbook-medium-r-normal--24*",
  "*new century schoolbook-bold-r-normal--8*",
  "*new century schoolbook-bold-r-normal--10*",
  "*new century schoolbook-bold-r-normal--12*",
  "*new century schoolbook-bold-r-normal--14*",
  "*new century schoolbook-bold-r-normal--18*",
  "*new century schoolbook-bold-r-normal--24*",
  "*new century schoolbook-medium-i-normal--8*",
  "*new century schoolbook-medium-i-normal--10*",
  "*new century schoolbook-medium-i-normal--12*",
  "*new century schoolbook-medium-i-normal--14*",
  "*new century schoolbook-medium-i-normal--18*",
  "*new century schoolbook-medium-i-normal--24*",
  "*new century schoolbook-bold-i-normal--8*",
  "*new century schoolbook-bold-i-normal--10*",
  "*new century schoolbook-bold-i-normal--12*",
  "*new century schoolbook-bold-i-normal--14*",
  "*new century schoolbook-bold-i-normal--18*",
  "*new century schoolbook-bold-i-normal--24*",

  /* The second is default if the first doesn't exists.  */
  /*multibyte*/ "*fixed-*--8*,	-*--14*",	/* normal, ming typeface */
  /*multibyte*/"*fixed-*--10*,	-*--14*",
  /*multibyte*/"*fixed-*--12*,	-*--14*",
  /*multibyte*/"*fixed-*--14*,	-*--14*",
  /*multibyte*/"*fixed-*--18*,	-*--18*",
  /*multibyte*/"*fixed-*--24*,	-*--26*",
  /*multibyte*/"*gothic-*--8*,	-*--14*",	/* bold, gothic typeface */
  /*multibyte*/"*gothic-*--10*,	-*--14*",
  /*multibyte*/"*gothic-*--12*,	-*--14*",
  /*multibyte*/"*gothic-*--14*,	-*--14*",
  /*multibyte*/"*gothic-*--18*,	-*--18*",
  /*multibyte*/"*gothic-*--24*,	-*--26*",
  /*multibyte*/"*songti-*--8*,	-*--14",	/* square style */
  /*multibyte*/"*songti-*--10*,	-*--14*",
  /*multibyte*/"*songti-*--12*,	-*--14*",
  /*multibyte*/"*songti-*--14*,	-*--14*",
  /*multibyte*/"*songti-*--18*,	-*--18*",
  /*multibyte*/"*songti-*--24*,	-*--26*",
  /*multibyte*/"*keiti-*--8*,	-*--14",	/* cursive style*/
  /*multibyte*/"*keiti-*--10*,	-*--14*",
  /*multibyte*/"*keiti-*--12*,	-*--14*",
  /*multibyte*/"*keiti-*--14*,	-*--14*",
  /*multibyte*/"*keiti-*--18*,	-*--18*",
  /*multibyte*/"*keiti-*--24*,	-*--26*",

  "*symbol-medium-r-normal--8*",
  "*symbol-medium-r-normal--10*",
  "*symbol-medium-r-normal--12*",
  "*symbol-medium-r-normal--14*",
  "*symbol-medium-r-normal--18*",
  "*symbol-medium-r-normal--24*",

/* 100 dpi fonts */
  "*times-medium-r-normal--11*",
  "*times-medium-r-normal--14*",
  "*times-medium-r-normal--17*",
  "*times-medium-r-normal--20*",
  "*times-medium-r-normal--25*",
  "*times-medium-r-normal--34*",
  "*times-bold-r-normal--11*",
  "*times-bold-r-normal--14*",
  "*times-bold-r-normal--17*",
  "*times-bold-r-normal--20*",
  "*times-bold-r-normal--25*",
  "*times-bold-r-normal--34*",
  "*times-medium-i-normal--11*",
  "*times-medium-i-normal--14*",
  "*times-medium-i-normal--17*",
  "*times-medium-i-normal--20*",
  "*times-medium-i-normal--25*",
  "*times-medium-i-normal--34*",
  "*times-bold-i-normal--11*",
  "*times-bold-i-normal--14*",
  "*times-bold-i-normal--17*",
  "*times-bold-i-normal--20*",
  "*times-bold-i-normal--25*",
  "*times-bold-i-normal--34*",

  "*courier-medium-r-normal--11*",
  "*courier-medium-r-normal--14*",
  "*courier-medium-r-normal--17*",
  "*courier-medium-r-normal--20*",
  "*courier-medium-r-normal--25*",
  "*courier-medium-r-normal--34*",
  "*courier-bold-r-normal--11*",
  "*courier-bold-r-normal--14*",
  "*courier-bold-r-normal--17*",
  "*courier-bold-r-normal--20*",
  "*courier-bold-r-normal--25*",
  "*courier-bold-r-normal--34*",
  "*courier-medium-o-normal--11*",
  "*courier-medium-o-normal--14*",
  "*courier-medium-o-normal--17*",
  "*courier-medium-o-normal--20*",
  "*courier-medium-o-normal--25*",
  "*courier-medium-o-normal--34*",
  "*courier-bold-o-normal--11*",
  "*courier-bold-o-normal--14*",
  "*courier-bold-o-normal--17*",
  "*courier-bold-o-normal--20*",
  "*courier-bold-o-normal--25*",
  "*courier-bold-o-normal--34*",

  "*helvetica-medium-r-normal--11*",
  "*helvetica-medium-r-normal--14*",
  "*helvetica-medium-r-normal--17*",
  "*helvetica-medium-r-normal--20*",
  "*helvetica-medium-r-normal--25*",
  "*helvetica-medium-r-normal--34*",
  "*helvetica-bold-r-normal--11*",
  "*helvetica-bold-r-normal--14*",
  "*helvetica-bold-r-normal--17*",
  "*helvetica-bold-r-normal--20*",
  "*helvetica-bold-r-normal--25*",
  "*helvetica-bold-r-normal--34*",
  "*helvetica-medium-o-normal--11*",
  "*helvetica-medium-o-normal--14*",
  "*helvetica-medium-o-normal--17*",
  "*helvetica-medium-o-normal--20*",
  "*helvetica-medium-o-normal--25*",
  "*helvetica-medium-o-normal--34*",
  "*helvetica-bold-o-normal--11*",
  "*helvetica-bold-o-normal--14*",
  "*helvetica-bold-o-normal--17*",
  "*helvetica-bold-o-normal--20*",
  "*helvetica-bold-o-normal--25*",
  "*helvetica-bold-o-normal--34*",

  "*new century schoolbook-medium-r-normal--11*",
  "*new century schoolbook-medium-r-normal--14*",
  "*new century schoolbook-medium-r-normal--17*",
  "*new century schoolbook-medium-r-normal--20*",
  "*new century schoolbook-medium-r-normal--25*",
  "*new century schoolbook-medium-r-normal--34*",
  "*new century schoolbook-bold-r-normal--11*",
  "*new century schoolbook-bold-r-normal--14*",
  "*new century schoolbook-bold-r-normal--17*",
  "*new century schoolbook-bold-r-normal--20*",
  "*new century schoolbook-bold-r-normal--25*",
  "*new century schoolbook-bold-r-normal--34*",
  "*new century schoolbook-medium-i-normal--11*",
  "*new century schoolbook-medium-i-normal--14*",
  "*new century schoolbook-medium-i-normal--17*",
  "*new century schoolbook-medium-i-normal--20*",
  "*new century schoolbook-medium-i-normal--25*",
  "*new century schoolbook-medium-i-normal--34*",
  "*new century schoolbook-bold-i-normal--11*",
  "*new century schoolbook-bold-i-normal--14*",
  "*new century schoolbook-bold-i-normal--17*",
  "*new century schoolbook-bold-i-normal--20*",
  "*new century schoolbook-bold-i-normal--25*",
  "*new century schoolbook-bold-i-normal--34*",

  /* The second is default if the first doesn't exists.  */
  /*multibyte*/"*fixed-*--11*,	-*--14*",	/* normal, ming typeface */
  /*multibyte*/"*fixed-*--14*,	-*--14*",
  /*multibyte*/"*fixed-*--17*,	-*--16*",
  /*multibyte*/"*fixed-*--20*,	-*--18*",
  /*multibyte*/"*fixed-*--25*,	-*--26*",
  /*multibyte*/"*fixed-*--34*,	-*--26*",
  /*multibyte*/"*gothic-*--11*,	-*--14*",	/* bold, gothic typeface */
  /*multibyte*/"*gothic-*--14*,	-*--14*",
  /*multibyte*/"*gothic-*--17*,	-*--16*",
  /*multibyte*/"*gothic-*--20*,	-*--18*",
  /*multibyte*/"*gothic-*--25*,	-*--26*",
  /*multibyte*/"*gothic-*--34*,	-*--26*",
  /*multibyte*/"*songti-*--11*,	-*--14*",	/* square style */
  /*multibyte*/"*songti-*--14*,	-*--14*",
  /*multibyte*/"*songti-*--17*,	-*--16*",
  /*multibyte*/"*songti-*--20*,	-*--18*",
  /*multibyte*/"*songti-*--25*,	-*--26*",
  /*multibyte*/"*songti-*--34*,	-*--26*",
  /*multibyte*/"*keiti-*--11*,	-*--14*",	/* cursive style */
  /*multibyte*/"*keiti-*--14*,	-*--14*",
  /*multibyte*/"*keiti-*--17*,	-*--16*",
  /*multibyte*/"*keiti-*--20*,	-*--18*",
  /*multibyte*/"*keiti-*--25*,	-*--26*",
  /*multibyte*/"*keiti-*--34*,	-*--26*",

  "*symbol-medium-r-normal--11*",
  "*symbol-medium-r-normal--14*",
  "*symbol-medium-r-normal--17*",
  "*symbol-medium-r-normal--20*",
  "*symbol-medium-r-normal--25*",
  "*symbol-medium-r-normal--34*"
};
