/*
 * @(#)$Header: input.c,v 1.1 92/04/27 01:51:41 li Exp $
 */

/*
 * Functions:
 *    OpenTextIM()
 *    IMLookupString()
 */
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>

XIM	textIM;
XIC	textIC;

/*
 * Warning: The textIMOn will make chaos, be careful it.
 *          This is most ugly method, but it makes sense.
 * Li Yuhong
 * 11/22/91
 */
int	textIMOpen = 0;		/* flag if connected to xwnmo */
int	textIMOn = 0;		/* flag if input characters from xwnmo */


static void TextIMIOError(error_im)
XIM error_im;
{
    if (textIM == error_im) {
	/*
	 * The xwnmo has closed outside, so we should quit also.
	 */
	XDestroyIC(textIC);
	XCloseIM(textIM);
	textIMOpen = textIMOn = 0;
    }
}

/*
 * connect to input method.
 */
int OpenTextIM(d, w)
Display		*d;
Window		w;
{
    XrmDatabase rdb;
    char	filename[BUFSIZ];
    static void	TextIMIOError();

    if (textIMOpen) return(1);		/* already connected. */
    sprintf(filename, "%s/.Xdefaults", getenv("HOME")); 
    rdb = XrmGetFileDatabase(filename);
    if ((textIM = XOpenIM(d, rdb, "xim", "Xim")) == NULL) {
        return(0);
    }
    _XipSetIOErrorHandler(TextIMIOError);
    if ((textIC = XCreateIC(textIM, XNInputStyle, 
		   (XIMPreeditNothing | XIMStatusNothing),
		   XNClientWindow, w,
		   XNFocusWindow, w,
		   NULL)) == NULL) {
	return(0);
    }
    XSetICFocus(textIC);
    textIMOpen = 1;
    return(1);
}

/*
 * get characters or keysym under control of input method.
 */
int IMLookupString(key_ev, strbuf, lenbuf, keysym, cstat)
XKeyEvent *key_ev;
char	*strbuf;
int	lenbuf;
KeySym	*keysym;
XComposeStatus *cstat;
{
    Status	mbstat;
    int		len;

    if (textIMOpen) {
	/*
	 * input characters or keysym under input method sometimes. 
	 */
	len = XmbLookupString (textIC,
			key_ev, strbuf, lenbuf, keysym, &mbstat);
#ifdef nodef
	if (mbstat == XLookupBoth && len == 1 &&
		(*keysym & 0x7f) >= '\040' && (*keysym & 0x7f) <= '\177') {
	    /* characters not from xwnmo? */
	    textIMOn = 0;
	} else
#endif
	if (mbstat == XBufferOverflow) {
	    Msg("Error in input method, maybe buffer overflow or no more memory!");
	} else 
	    textIMOn = 1;
#ifdef DEBUG
	printf("key_ev->state = 0x%x keysym=0x%x ", key_ev->state, *keysym);
	printf("lenbuf=%d strbuf:%s: return=%d mbstat=%d\n",
                lenbuf, strbuf, len, mbstat);
#endif
	return(len);
   } else {
	/*
	 * in normal case, not involving with input method.
	 */
	len = XLookupString(key_ev, strbuf, lenbuf, keysym, cstat);
	return(len);
   }
}
