/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/menu.c,v 2.78 1992/03/31 07:54:10 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "patchlevel.h"
#include "types.h"

#include "align.e"
#include "box.e"
#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "edit.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "msg.e"
#include "names.e"
#include "obj.e"
#include "pattern.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "special.e"
#include "text.e"
#include "version.e"

int	iconWindowCreated = FALSE;
int	iconWindowShown = FALSE;

int	showVersion = TRUE;
int	activeMenu = INVALID;

char	* mainMenuStr[MAXMENUS] =
      {
         "Mode", "File", "Edit", "Layout", "MoveMode", "Arrange",
         "HoriAlign", "VertAlign",
         "Font", "TextStyle", "TextSize",
         "LineDash", "LineStyle", "LineType", "LineWidth",
         "Fill", "Pen", "Color", "Special"
      };

GC	textMenuGC;
GC	rvPixmapMenuGC;

extern char	* getenv ();

static int	savedZoomScale = 0, savedDrawOrigX = 0, savedDrawOrigY = 0;
static int	savedZoomedIn = FALSE;
static int	savedDrawWinW = 0, savedDrawWinH = 0, savedFileModified = FALSE;

static int	menuIsMainMenu = FALSE;

int TextMenuLoop (OrigX, OrigY, Strings, Entries, ForeColors, Valid, InitRV,
      MultiColor)
   int	OrigX, OrigY, Entries, MultiColor;
   int	* ForeColors, * Valid, * InitRV;
   char	* Strings[];
{
   Window	window, root_win, child_win;
   register int	i, max_len, menuing = TRUE;
   int		x, y, rc = INVALID, old_selected, new_selected;
   int		* len, dsp_w, dsp_h, menu_w, menu_h, pixel;
   unsigned int	status;
   int		root_x, root_y, pinned_x=0, pinned_y=0, menu_pinned = FALSE;
   XEvent	input;
   XSetWindowAttributes	win_attrs;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   len = (int *) calloc (Entries, sizeof(int));
   for(i = 0, max_len = 0; i < Entries; i++)
   {
      len[i] = strlen (Strings[i]);
      if (len[i] > max_len) max_len = len[i];
   }
   menu_w = defaultFontWidth * max_len + 1;
   menu_h = defaultFontHeight * Entries;

   if (OrigX+menu_w >= dsp_w-1-2*brdrW)
      OrigX = dsp_w - 1 - 2*brdrW - menu_w;
   if (OrigY+menu_h >= dsp_h-1-2*brdrW)
      OrigY = dsp_h - 1 - 2*brdrW - menu_h;

   if ((window = XCreateSimpleWindow (mainDisplay, rootWindow, OrigX, OrigY,
         menu_w, menu_h, 2*brdrW, myBorderPixel, myBgPixel)) == 0)
      Error ("TextMenuLoop()", "Can not XCreateSimpleWindow()");

   win_attrs.save_under = True;
   win_attrs.override_redirect = True;
   win_attrs.colormap = mainColormap;
   XChangeWindowAttributes (mainDisplay, window,
         CWSaveUnder | CWOverrideRedirect | CWColormap, &win_attrs);

   old_selected = INVALID;

   XSetTransientForHint (mainDisplay, window, mainWindow);

#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, window);
   XSelectInput (mainDisplay, window, ExposureMask);
#else
   XSelectInput (mainDisplay, window, ExposureMask);
   XMapWindow (mainDisplay, window);
#endif

   XWarpPointer (mainDisplay, None, rootWindow, 0, 0, 0, 0, OrigX-2, OrigY-2);

   XFlush (mainDisplay);
   XSync (mainDisplay, False);

   XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);
   if (!(menuing = ((status & BUTTONSMASK) != 0)))
      while (XCheckWindowEvent (mainDisplay, window, ExposureMask, &input)) ;
 
   y = defaultFontAsc;
   if (MultiColor)
   {
      for (i = 0; i < Entries; i++, y += defaultFontHeight)
      {
         if (InitRV[i])
         {
            XSetForeground (mainDisplay, textMenuGC, ForeColors[i]);
            XFillRectangle (mainDisplay, window, textMenuGC, 0,
                  i*defaultFontHeight, menu_w, defaultFontHeight);
            XSetForeground (mainDisplay, textMenuGC, myBgPixel);
#ifdef XI18N
            XmbDrawString (mainDisplay, window, defaultFontPtr, textMenuGC, 0,
                  defaultFontAsc+i*defaultFontHeight, Strings[i], len[i]);
#else
            XDrawString (mainDisplay, window, textMenuGC, 0,
                  defaultFontAsc+i*defaultFontHeight, Strings[i], len[i]);
#endif
         }
         else
         {
            XSetForeground (mainDisplay, textMenuGC, ForeColors[i]);
#ifdef XI18N
            XmbDrawString (mainDisplay, window, defaultFontPtr,
		  textMenuGC, 0, y, Strings[i], len[i]);
#else
            XDrawString (mainDisplay, window, textMenuGC, 0, y,
                  Strings[i], len[i]);
#endif
         }
      }
   }
   else
   {
      XSetForeground (mainDisplay, textMenuGC, ForeColors[0]);
      pixel = ForeColors[0];
      for (i = 0; i < Entries; i++, y += defaultFontHeight)
      {
         if (InitRV[i])
         {
            XSetForeground (mainDisplay, textMenuGC, ForeColors[i]);
            XFillRectangle (mainDisplay, window, textMenuGC, 0,
                  i*defaultFontHeight, menu_w, defaultFontHeight);
            XSetForeground (mainDisplay, textMenuGC, myBgPixel);
            pixel = myBgPixel;
#ifdef XI18N
            XmbDrawString (mainDisplay, window, defaultFontPtr, textMenuGC, 0,
                  defaultFontAsc+i*defaultFontHeight, Strings[i], len[i]);
#else
            XDrawString (mainDisplay, window, textMenuGC, 0,
                  defaultFontAsc+i*defaultFontHeight, Strings[i], len[i]);
#endif
         }
         else
         {
            if (pixel != ForeColors[i])
            {
               XSetForeground (mainDisplay, textMenuGC, ForeColors[i]);
               pixel = ForeColors[i];
            }
#ifdef XI18N
            XmbDrawString (mainDisplay, window, defaultFontPtr,
		  textMenuGC, 0, y, Strings[i], len[i]);
#else
            XDrawString (mainDisplay, window, textMenuGC, 0, y, Strings[i],
                  len[i]);
#endif
         }
      }
   }
   XGrabPointer (mainDisplay, window, FALSE, None,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);

   while (menuing)
   {
      XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
            &root_y, &x, &y, &status);
      if ((status & BUTTONSMASK) == 0)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         menuing = FALSE;
         if (menu_pinned)
         {
            XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
                  pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
            XSetSubwindowMode (mainDisplay, revDefaultGC, ClipByChildren);
            pinned_x = root_x;
            pinned_y = root_y;
            if (menuIsMainMenu)
            {
               XMoveWindow (mainDisplay, mainMenuWindow, pinned_x, pinned_y);
               XMapRaised (mainDisplay, mainMenuWindow);
               XSetWindowColormap (mainDisplay, mainMenuWindow, mainColormap);
               XDefineCursor (mainDisplay, mainMenuWindow, defaultCursor);
               pinnedMainMenu = TRUE;
               mainMenuX = pinned_x;
               mainMenuY = pinned_y;
            }
            else
               RealizeSubMenuWindow (pinned_x, pinned_y,
                     menu_w+2*brdrW, menu_h+2*brdrW);
            rc = INVALID;
         }
         else if (x >= 0 && x < menu_w && y >= 0 && y < menu_h)
         {
            rc = (int)(y / defaultFontHeight);
            if (!Valid[rc]) rc = INVALID;
         }
         else
            rc = INVALID;
         break;
      }
      else if (menu_pinned)
      {
         XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
               pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
         pinned_x = root_x;
         pinned_y = root_y;
         XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
               pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
      }
      else if (!menu_pinned && (activeMenu!=INVALID || menuIsMainMenu) &&
            (x < -(mainMenuPinDistance) || x > (menu_w+mainMenuPinDistance)))
      {
         pinned_x = root_x;
         pinned_y = root_y;
         XSetSubwindowMode (mainDisplay, revDefaultGC, IncludeInferiors);
         XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
               pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
         menu_pinned = TRUE;
      }
      else if (x >= 0 && x < menu_w && y >=0 && y < menu_h)
      {
         new_selected = (int)(y / defaultFontHeight);
         if (old_selected != new_selected )
         {
            if (old_selected != INVALID && Valid[old_selected])
            {
               XSetForeground (mainDisplay, textMenuGC, myBgPixel);
               XFillRectangle (mainDisplay, window, textMenuGC, 0,
                     old_selected*defaultFontHeight, menu_w, defaultFontHeight);
               XSetForeground (mainDisplay, textMenuGC,
                     ForeColors[old_selected]);
#ifdef XI18N
               XmbDrawString (mainDisplay, window,
		     defaultFontPtr, textMenuGC, 0,
                     defaultFontAsc+old_selected*defaultFontHeight,
                     Strings[old_selected], len[old_selected]);
#else
               XDrawString (mainDisplay, window, textMenuGC, 0,
                     defaultFontAsc+old_selected*defaultFontHeight,
                     Strings[old_selected], len[old_selected]);
#endif
            }
            if (Valid[new_selected])
            {
               XSetForeground (mainDisplay, textMenuGC,
                     ForeColors[new_selected]);
               XFillRectangle (mainDisplay, window, textMenuGC, 0,
                     new_selected*defaultFontHeight, menu_w, defaultFontHeight);
               XSetForeground (mainDisplay, textMenuGC, myBgPixel);
#ifdef XI18N
               XmbDrawString (mainDisplay, window,
		     defaultFontPtr, textMenuGC, 0,
                     defaultFontAsc+new_selected*defaultFontHeight,
                     Strings[new_selected], len[new_selected]);
#else
               XDrawString (mainDisplay, window, textMenuGC, 0,
                     defaultFontAsc+new_selected*defaultFontHeight,
                     Strings[new_selected], len[new_selected]);
#endif
            }
            old_selected = new_selected;
         }
      }
      else if (old_selected != INVALID)
      {
         if (Valid[old_selected])
         {
            XSetForeground (mainDisplay, textMenuGC, myBgPixel);
            XFillRectangle (mainDisplay, window, textMenuGC, 0,
                  old_selected*defaultFontHeight, menu_w, defaultFontHeight);
            XSetForeground (mainDisplay, textMenuGC, ForeColors[old_selected]);
#ifdef XI18N
            XmbDrawString (mainDisplay, window,
		  defaultFontPtr, textMenuGC, 0,
                  defaultFontAsc+old_selected*defaultFontHeight,
                  Strings[old_selected], len[old_selected]);
#else
            XDrawString (mainDisplay, window, textMenuGC, 0,
                  defaultFontAsc+old_selected*defaultFontHeight,
                  Strings[old_selected], len[old_selected]);
#endif
         }
         old_selected = INVALID;
      }
   }
   cfree (len);
   cfree (ForeColors);
   cfree (Valid);
   cfree (InitRV);
   XDestroyWindow (mainDisplay, window);

   XFlush (mainDisplay);
   XSync (mainDisplay, False);
   return (rc);
}

int PxMpMenuLoop (OrigX, OrigY, W, H, Rows, Cols, Entries, ForeColors, PxMp,
      InitRV, MultiColor)
   int		OrigX, OrigY, W, H, Rows, Cols, Entries;
   int		* ForeColors, * InitRV, MultiColor;
   Pixmap	PxMp[];
{
   register int	i, j, menuing = TRUE;
   Window	window, root_win, child_win;
   int		x, y, old_selected, new_selected, menu_w, menu_h;
   int		rc = INVALID, old_i = 0, old_j = 0, k, dsp_w, dsp_h;
   unsigned int	status;
   int		root_x, root_y, pinned_x=0, pinned_y=0, menu_pinned = FALSE;
   XGCValues	values;
   XEvent	input;
   unsigned long	toggle = xorOne;
   XSetWindowAttributes	win_attrs;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   menu_w = W * Cols;
   menu_h = H * Rows;

   if (OrigX+menu_w >= dsp_w-1-2*brdrW)
      OrigX = dsp_w - 1 - 2*brdrW - menu_w;
   if (OrigY+menu_h >= dsp_h-1-2*brdrW)
      OrigY = dsp_h - 1 - 2*brdrW - menu_h;

   if ((window = XCreateSimpleWindow (mainDisplay, rootWindow, OrigX, OrigY,
         menu_w, menu_h, 2*brdrW, myBorderPixel, myBgPixel)) == 0)
      Error ("PxMpMenuLoop()", "Can not XCreateSimpleWindow()");

   win_attrs.save_under = True;
   win_attrs.override_redirect = True;
   win_attrs.colormap = mainColormap;
   XChangeWindowAttributes (mainDisplay, window,
         CWSaveUnder | CWOverrideRedirect | CWColormap, &win_attrs);

   old_selected = INVALID;

   XSetTransientForHint (mainDisplay, window, mainWindow);

#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, window);
   XSelectInput (mainDisplay, window, ExposureMask);
#else
   XSelectInput (mainDisplay, window, ExposureMask);
   XMapWindow (mainDisplay, window);
#endif

   XWarpPointer (mainDisplay, None, rootWindow, 0, 0, 0, 0, OrigX-2, OrigY-2);

   XFlush (mainDisplay);
   XSync (mainDisplay, False);

   XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);
   if (!(menuing = ((status & BUTTONSMASK) != 0)))
      while (XCheckWindowEvent (mainDisplay, window, ExposureMask, &input)) ;

   for (i = 0; i < Rows; i++)
      for (j = 0; j < Cols; j++)
      {
         k = i + j * Rows;
         if (k >= Entries) break;
         if (MultiColor)
         {
            values.foreground = ForeColors[k];
            values.stipple = patPixmap[SOLIDPAT];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            XFillRectangle (mainDisplay, window, rasterGC, j*W, i*H, W, H);
         }
         else
         {
            if (InitRV[k])
            {
               XSetForeground (mainDisplay, textMenuGC, myFgPixel);
               XFillRectangle (mainDisplay, window, textMenuGC, j*W, i*H, W, H);
               XSetStipple (mainDisplay, rvPixmapMenuGC, PxMp[k]);
               XFillRectangle (mainDisplay, window, rvPixmapMenuGC, j*W, i*H,
                  W, H);
            }
            else
            {
               XSetStipple (mainDisplay, rasterGC, PxMp[k]);
               XFillRectangle (mainDisplay, window, rasterGC, j*W, i*H, W, H);
            }
         }
      }

   XGrabPointer (mainDisplay, window, FALSE, ButtonReleaseMask,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);

   while (menuing)
   {
      XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
            &root_y, &x, &y, &status);
      if ((status & BUTTONSMASK) == 0)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         menuing = FALSE;
         if (menu_pinned)
         {
            XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
                  pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
            XSetSubwindowMode (mainDisplay, revDefaultGC, ClipByChildren);
            pinned_x = root_x;
            pinned_y = root_y;
            RealizeSubMenuWindow (pinned_x, pinned_y,
                  menu_w+2*brdrW, menu_h+2*brdrW);
            rc = INVALID;
         }
         else if (x >= 0 && x < menu_w && y >= 0 && y < menu_h)
         {
            i = (int)(y / H);
            j = (int)(x / W);
            rc = i + j * Rows;
            if (rc >= Entries) rc = INVALID;
         }
         else
            rc = INVALID;
         break;
      }
      else if (menu_pinned)
      {
         XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
               pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
         pinned_x = root_x;
         pinned_y = root_y;
         XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
               pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
      }
      else if (!menu_pinned && activeMenu!=MENU_COLOR && activeMenu!=INVALID &&
            (x < -(mainMenuPinDistance) || x > (menu_w+mainMenuPinDistance)))
      {
         pinned_x = root_x;
         pinned_y = root_y;
         XSetSubwindowMode (mainDisplay, revDefaultGC, IncludeInferiors);
         XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
               pinned_x, pinned_y, menu_w+2*brdrW, menu_h+2*brdrW);
         menu_pinned = TRUE;
      }
      else if (x >= 0 && x < menu_w && y >=0 && y < menu_h)
      {
         i = (int)(y / H);
         j = (int)(x / W);
         new_selected = i + j * Rows;
         if (old_selected != new_selected )
         {
            if (old_selected != INVALID)
            {
               if (MultiColor)
               {
                  if (old_selected >= Entries)
                     values.foreground = myBgPixel;
                  else
                     values.foreground = ForeColors[old_selected];
                  values.stipple = patPixmap[SOLIDPAT];
                  XChangeGC (mainDisplay, rasterGC,
                        GCForeground | GCStipple, &values);
                  XFillRectangle (mainDisplay, window, rasterGC,
                        old_j*W, old_i*H, W, H);
               }
               else
               {
                  values.foreground = myFgPixel;
                  values.stipple = PxMp[old_selected];
                  XChangeGC (mainDisplay, rasterGC,
                        GCForeground | GCStipple, &values);
                  XFillRectangle (mainDisplay, window, rasterGC,
                        old_j*W, old_i*H, W, H);
               }
            }
            if (!MultiColor)
            {
               XSetForeground (mainDisplay, textMenuGC, myFgPixel);
               XFillRectangle (mainDisplay, window, textMenuGC, j*W, i*H, W, H);
               XSetStipple (mainDisplay, rvPixmapMenuGC, PxMp[new_selected]);
               XFillRectangle (mainDisplay, window, rvPixmapMenuGC, j*W, i*H,
                  W, H);
            }
            toggle = xorOne;
            old_selected = new_selected;
            old_i = i;
            old_j = j;
         }
         else if (MultiColor)
         {
            toggle = (toggle == xorOne) ? xorZero : xorOne;
            values.foreground = toggle;
            values.stipple = patPixmap[SOLIDPAT];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            MyBox (window, rasterGC, j*W, i*H, (j+1)*W-1, (i+1)*H-1);
         }
      }
      else if (old_selected != INVALID)
      {
         if (MultiColor)
         {
            if (old_selected >= Entries)
               values.foreground = myBgPixel;
            else
               values.foreground = ForeColors[old_selected];
            values.stipple = patPixmap[SOLIDPAT];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            XFillRectangle (mainDisplay, window, rasterGC,
                  old_j*W, old_i*H, W, H);
         }
         else
         {
            values.foreground = myFgPixel;
            values.stipple = PxMp[old_selected];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            XFillRectangle (mainDisplay, window, rasterGC,
                  old_j*W, old_i*H, W, H);
         }
         old_selected = INVALID;
      }
   }
   XSetForeground (mainDisplay, rasterGC, myFgPixel);

   cfree (ForeColors);
   cfree (InitRV);
   XDestroyWindow (mainDisplay, window);

   XFlush (mainDisplay);
   XSync (mainDisplay, False);
   return (rc);
}

/*
 * static char * opStr[] =
 * {
 *    "more", "update", "vi", "init", "quit", "mainmenu", "animate",
 *    "upd_attr_val", "green", "yellow"
 * };
 * #define MAXOP 10
 * 
 * void Prompt (PromptStr, OpName, FileName)
 *    char	* PromptStr, * OpName, * FileName;
 * {
 *    char	inbuf[80];
 *  
 *    printf (PromptStr);
 *    fgets (inbuf, 80, stdin);
 *    sscanf (inbuf, "%s%s", OpName, FileName);
 *    return;
 * }
 */

int MainMenu ()
{
   int		rc = INVALID, index, * fore_colors, * valid, * init_rv, x, y;
   Window	root_win, child_win;
   unsigned int	status;
   int		root_x, root_y;

   Msg ("");
   XQueryPointer (mainDisplay, rootWindow, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);

   menuIsMainMenu = TRUE;
   DefaultColorArrays (MAXMENUS, &fore_colors, &valid, &init_rv);
   index = TextMenuLoop (x, y, mainMenuStr, MAXMENUS, fore_colors, valid,
         init_rv, SINGLECOLOR);
   menuIsMainMenu = FALSE;

   if (index == INVALID) return (INVALID);

   if (index == MENU_COLOR && !colorDisplay)
   {
      Msg ("No color menu available for non-color displays.");
      return (INVALID);
   }

   CornerLoop (&x, &y);
   switch (index)
   {
      case MENU_MODE: ModeMenu (x, y); break;
      case MENU_FILE: rc = FileMenu (x, y); break;
      case MENU_EDIT: EditMenu (x, y); break;
      case MENU_LAYOUT: LayoutMenu (x, y); break;
      case MENU_MOVEMODE: MoveModeMenu (x, y); break;
      case MENU_ARRANGE: ArrangeMenu (x, y); break;
      case MENU_HORIALIGN: HoriAlignMenu (x, y); break;
      case MENU_VERTALIGN: VertAlignMenu (x, y); break;
      case MENU_FONT: FontMenu (x, y); break;
      case MENU_STYLE: StyleMenu (x, y); break;
      case MENU_SIZE: SizeMenu (x, y); break;
      case MENU_LINEDASH: LineDashMenu (x, y); break;
      case MENU_LINESTYLE: LineStyleMenu (x, y); break;
      case MENU_LINETYPE: LineTypeMenu (x, y); break;
      case MENU_LINEWIDTH: LineWidthMenu (x, y); break;
      case MENU_FILL: FillMenu (x, y); break;
      case MENU_PEN: PenMenu (x, y); break;
      case MENU_COLOR: ColorMenu (x, y); break;
      case MENU_SPECIAL: SpecialMenu (x, y); break;
   }
   return (rc);
}

int IsPrefix (Prefix, Str, Rest)
   char	* Prefix, * Str, * * Rest;
{
   register char	* c_ptr = Prefix;

   for (*Rest=Str; *c_ptr!='\0' && **Rest!='\0'; (*Rest)++, c_ptr++)
      if (**Rest != *c_ptr)
         return (FALSE);
   return (*c_ptr == '\0' && **Rest == '/');
}

void RedrawTitleWindow ()
{
   int	y, len, amount, left;
   char	s[MAXPATHLENGTH], name[MAXPATHLENGTH], * c_ptr, * rest;

   s[0] = '\0';
   if (curFileDefined)
   {
      if (*curSymDir == '\0')
         sprintf (name, "%s/%s", curDir, curFileName);
      else
         sprintf (name, "%s/%s", curSymDir, curFileName);

      if (IsPrefix (bootDir, name, &rest))
         c_ptr = ++rest;
      else
         c_ptr = name;

      sprintf (s, "%s:%s (%1d%%)", curDomainName, c_ptr, printMag);
   }
   else
      sprintf (s, "%s:[Unnamed] (%1d%%)", curDomainName, printMag);

   if (fileModified) strcat (s, " [Modified]");

   if (s[0] != '\0')
   {
      if (showVersion)
      {
         XClearArea (mainDisplay, titleWindow, 0, titleWindowH/2, titleWindowW,
               titleWindowH/2, FALSE);
#ifdef XI18N
         XmbDrawString (mainDisplay, titleWindow,
	       defaultFontPtr, defaultGC, 1,
               titleWindowH/2+defaultFontAsc+1, s, strlen(s));
#else
         XDrawString (mainDisplay, titleWindow, defaultGC, 1,
               titleWindowH/2+defaultFontAsc+1, s, strlen(s));
#endif
      }
      else
      {
         XClearArea (mainDisplay, titleWindow, 0, 0, titleWindowW, titleWindowH,
               FALSE);
#ifdef XI18N
         XmbDrawString (mainDisplay, titleWindow, defaultFontPtr, defaultGC,
	       1, defaultFontAsc+1, s, strlen(s));
#else
         XDrawString (mainDisplay, titleWindow, defaultGC, 1, defaultFontAsc+1,
               s, strlen(s));
#endif
      }
   }

   if (showVersion)
   {
      if (TGIF_PATCHLEVEL == 0)
         sprintf (s, "%s-%s", TOOL_NAME, version_string);
      else
         sprintf (s, "%s-%s-p%1d", TOOL_NAME, version_string, TGIF_PATCHLEVEL);

      len = strlen (s);
      amount = defaultFontWidth * len;
      left = (titleWindowW - amount) / 2;

#ifdef XI18N
      XmbDrawString (mainDisplay, titleWindow, defaultFontPtr, defaultGC,
	left, defaultFontAsc+2, s, len);
#else
      XDrawString (mainDisplay, titleWindow, defaultGC, left, defaultFontAsc+2,
         s, len);
#endif

      for (y = 4; y < titleWindowH/2-4; y += 2)
      {
         XDrawLine (mainDisplay, titleWindow, defaultGC, 2, y,
               left-defaultFontWidth, y);
         XDrawLine (mainDisplay, titleWindow, defaultGC,
               left+amount+defaultFontWidth, y, titleWindowW-3, y);
      }
   }
}

static struct ObjRec	* iconTopObj = NULL, * iconBotObj = NULL;

void RedrawIconWindow ()
{
   register struct ObjRec	* obj_ptr;

   numRedrawBBox = 0;
   for (obj_ptr = iconBotObj; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      DrawObj (iconWindow, obj_ptr);
}

static char iconFileName[] = "tgificon";

static
void InitIcon ()
{
   struct ObjRec	* obj_ptr;
   char			s[MAXPATHLENGTH], * c_ptr, msg[MAXSTRING];
   char			ext_str[MAXPATHLENGTH];
   FILE			* fp;
   int			ltx = 0, lty = 0, rbx = 0, rby = 0, seen_obj = FALSE;
   int			dx, dy, w, h, len, ext_len;
   int			x, y, bitmask = 0, read_status;
   unsigned int		icon_w, icon_h;
   XSizeHints		sizehints;
   int			tmp_linenum;
   char			tmp_filename[MAXPATHLENGTH];

   iconWindowCreated = FALSE;
   if (((c_ptr = XGetDefault(mainDisplay,TOOL_NAME,"NoTgifIcon")) != NULL)
         && (strcmp(c_ptr,"True") == 0 || strcmp(c_ptr,"true") == 0))
      return;

   strcpy (s, drawPath);
   strcat (s, "/");
   if ((c_ptr = getenv ("TGIFICON")) == NULL)
      strcat (s, iconFileName);
   else if (strlen (c_ptr) >= 200)
      /* too long, must be an error */
      strcat (s, iconFileName);
   else if (*c_ptr == '/')
      strcpy (s, c_ptr);
   else
      strcat (s, c_ptr);

   sprintf (ext_str, ".%s", OBJ_FILE_EXT);
   ext_len = strlen (ext_str);
   len = strlen(s);

   if (len<ext_len || strcmp(&s[len-ext_len],ext_str) != 0) strcat (s, ".obj");

   if ((fp = fopen (s, "r")) == NULL)
   {
      fprintf (stderr, "Warning:  Can not open the tgif icon file '%s'\n.", s);
      return;
   }

   strcpy (tmp_filename, scanFileName);
   tmp_linenum = scanLineNum;
   strcpy (scanFileName, s);
   scanLineNum = 0;

   importingFile = TRUE; /* ignore the 'state' predicate */
   while ((read_status = ReadObj (fp, &obj_ptr)) == TRUE)
      if (obj_ptr != NULL)
      {
         AddObj (NULL, topObj, obj_ptr);
         if (!seen_obj)
         {
            seen_obj = TRUE;
            ltx = obj_ptr->bbox.ltx; lty = obj_ptr->bbox.lty;
            rbx = obj_ptr->bbox.rbx; rby = obj_ptr->bbox.rby;
         }
         else
         {
            if (obj_ptr->bbox.ltx < ltx) ltx = obj_ptr->bbox.ltx;
            if (obj_ptr->bbox.lty < lty) lty = obj_ptr->bbox.lty;
            if (obj_ptr->bbox.rbx > rbx) rbx = obj_ptr->bbox.rbx;
            if (obj_ptr->bbox.rby > rby) rby = obj_ptr->bbox.rby;
         }
      }
   strcpy (scanFileName, tmp_filename);
   scanLineNum = tmp_linenum;

   importingFile = FALSE;

   fclose (fp);

   if (read_status == INVALID)
   {
      sprintf (msg, "Icon file error:  file version too large (=%1d).",
            fileVersion);
      Msg (s);
      return;
   }

   w = rbx - ltx;
   h = rby - lty;
   if (w > iconWindowW)
   {
      dx = -ltx;
      iconWindowW = w;
   }
   else
      dx = -ltx+(iconWindowW-w)/2;

   if (h > iconWindowH)
   {
      dy = -lty;
      iconWindowH = h;
   }
   else
      dy = -lty+(iconWindowH-h)/2;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      MoveObj (obj_ptr, dx, dy);

   iconTopObj = topObj;
   iconBotObj = botObj;
   topObj = botObj = NULL;

   sizehints.x = 0;
   sizehints.y = 0;

   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"IconGeometry")) != NULL)
   {
      bitmask = XParseGeometry (c_ptr, &x, &y, &icon_w, &icon_h);
      if ((bitmask & XValue) && (bitmask & YValue))
      {
         if (bitmask & XValue) sizehints.x = x;
         if (bitmask & YValue) sizehints.y = y;
         if (bitmask & XNegative) sizehints.x += DisplayWidth (mainDisplay,
               mainScreen) - iconWindowW - 2*brdrW - 1;
         if (bitmask & YNegative) sizehints.y += DisplayHeight (mainDisplay,
               mainScreen) - iconWindowH - 2*brdrW - 1;
     }
   }

   if ((iconBaseWindow = XCreateSimpleWindow (mainDisplay, rootWindow,
         sizehints.x, sizehints.y, iconWindowW+2*brdrW, iconWindowH+2*brdrW,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { fprintf (stderr, "Can not create icon base window!\n"); exit(1); }

   if ((iconWindow = XCreateSimpleWindow (mainDisplay, iconBaseWindow, 0, 0,
         iconWindowW, iconWindowH, brdrW, myBorderPixel, myBgPixel)) == 0)
   { fprintf (stderr, "Can not create icon window!\n"); exit(1); }

   XStoreName (mainDisplay, iconBaseWindow, TOOL_NAME);

   XSelectInput (mainDisplay, iconBaseWindow, StructureNotifyMask);
   if (((c_ptr = 
         XGetDefault(mainDisplay,TOOL_NAME,"DoubleClickUnIconify")) != NULL)
         && (strcmp(c_ptr,"True") == 0 || strcmp(c_ptr,"true") == 0))
      XSelectInput (mainDisplay, iconWindow, ButtonPressMask | ExposureMask);
   else
      XSelectInput (mainDisplay, iconWindow, ExposureMask);

   iconWindowCreated = TRUE;
}

void InitTitle ()
{
   InitIcon ();
}

void InitMenu ()
{
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillSolid;
#ifdef XI18N
   textMenuGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle, &values);
#else
   values.font = defaultFontPtr->fid;
   textMenuGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);
#endif

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   values.fill_style = FillStippled;
#ifdef XI18N
   rvPixmapMenuGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle, &values);
#else
   rvPixmapMenuGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);
#endif

   InitMainMenu ();
}

void CleanUpMenu ()
{
   XFreeGC (mainDisplay, textMenuGC);
   XFreeGC (mainDisplay, rvPixmapMenuGC);
   CleanUpMainMenu ();
   if (stackingWins != NULL) { cfree (stackingWins); stackingWins = NULL; }
}

void SaveDrawWinInfo ()
{
   savedZoomScale = zoomScale;
   savedZoomedIn = zoomedIn;
   savedDrawOrigX = drawOrigX;
   savedDrawOrigY = drawOrigY;
   savedDrawWinW = drawWinW;
   savedDrawWinH = drawWinH;
   savedFileModified = fileModified;
}

void UnIconify ()
{
   register int	j, i;

   if (!iconWindowShown) return;

#ifdef notdef
   XUnmapWindow (mainDisplay, iconWindow);
#endif
   if (iconWindowCreated) XUnmapWindow (mainDisplay, iconBaseWindow);
   XMapWindow (mainDisplay, mainWindow);

   for (i = 0; i < numStacking; i++)
   {
      for (j = 0; j < numExtraWins; j++)
         if (extraWinInfo[j].raise && extraWinInfo[j].window==stackingWins[i])
         {
            extraWinInfo[j].mapped = TRUE;
            break;
         }
      XMapRaised (mainDisplay, stackingWins[i]);
   }

   XFlush (mainDisplay);
   XSync (mainDisplay, False);

   zoomScale = savedZoomScale;
   zoomedIn = savedZoomedIn;
   drawOrigX = savedDrawOrigX;
   drawOrigY = savedDrawOrigY;
   drawWinW = savedDrawWinW;
   drawWinH = savedDrawWinH;
   fileModified = savedFileModified;
   UpdDrawWinBBox ();
   SetDefaultDrawWinClipRecs ();

   iconWindowShown = FALSE;
}

void Iconify ()
{
   register int	i;

   if (iconWindowShown) return;

#ifdef notdef
   XUnmapWindow (mainDisplay, mainWindow);
#endif

   SaveStackingOrder ();

   if (pinnedMainMenu) XUnmapWindow (mainDisplay, mainMenuWindow);
   for (i = 0; i < numExtraWins; i++)
   {
      if (extraWinInfo[i].raise && extraWinInfo[i].mapped &&
            extraWinInfo[i].window != None)
      {
         XUnmapWindow (mainDisplay, extraWinInfo[i].window);
         extraWinInfo[i].mapped = FALSE;
      }
   }
   if (iconWindowCreated)
   {
      XMapWindow (mainDisplay, iconBaseWindow);
      XMapWindow (mainDisplay, iconWindow);
   }

   SaveDrawWinInfo ();
   zoomScale = 0;
   zoomedIn = FALSE;
   drawOrigX = 0;
   drawOrigY = 0;
   drawWinW = iconWindowW;
   drawWinH = iconWindowH;
   UpdDrawWinBBox ();
   SetDefaultIconWinClipRecs ();

   iconWindowShown = TRUE;
}

static int	iconJustClicked = FALSE;
static Time	iconClickTime;

void IconEventHandler (input)
   XEvent	* input;
{
   XEvent	ev;
   Time		click_time;

   if (input->xany.window == iconWindow && input->type == ButtonPress)
   {
      click_time = input->xbutton.time;
      if (iconJustClicked && (click_time-iconClickTime) < doubleClickInterval)
      {
         iconJustClicked = FALSE;
         UnIconify ();
      }
      else
      {
         iconJustClicked = TRUE;
         iconClickTime = click_time;
      }
   }
   else if (input->xany.window == iconBaseWindow && input->type == UnmapNotify)
      UnIconify ();
   else if (input->xany.window == iconBaseWindow && input->type == MapNotify)
      Iconify ();
   else if (input->xany.window == iconWindow && input->type == Expose)
   {
      if (!iconWindowShown) return;

      while (XCheckWindowEvent (mainDisplay, iconWindow, ExposureMask, &ev)) ;
      while (XCheckWindowEvent (mainDisplay, iconBaseWindow,
            StructureNotifyMask, &ev)) ;
      RedrawIconWindow ();
   }
}

void TitleEventHandler (input)
   XEvent	* input;
{
   XEvent	ev;

   if (input->type == Expose)
   {
      XSync (mainDisplay, False);
      while (XCheckWindowEvent (mainDisplay, titleWindow, ExposureMask, &ev)) ;
      RedrawTitleWindow ();
   }
}
