/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/setup.c,v 2.100 1992/06/26 05:23:54 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "attr.e"
#include "auxtext.e"
#include "choice.e"
#include "cmd.e"
#include "color.e"
#include "cursor.e"
#include "drawing.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "mark.e"
#include "menu.e"
#include "msg.e"
#include "names.e"
#include "pattern.e"
#include "raster.e"
#include "ruler.e"
#include "scroll.e"
#include "select.e"
#include "shortcut.e"
#include "spline.e"
#include "stk.e"
#include "text.e"
#include "xbitmap.e"
#include "xpixmap.e"
#ifdef XI18N
#include "input.e"

int	warning = 0;		/* flag if printing out warning message */
int	oneByteEncoding = 0;	/* flag if the current codeset is 1-byte. */
#endif

extern	char	* getenv ();

#define MENU_IMAGE_W 64
#define MENU_IMAGE_H 20
#define CHOICE_IMAGE_W 32
#define CHOICE_IMAGE_H 20
#define SCROLLBAR_W 16
#define RULER_W 20
#define BRDR_W 1

#define DRAW_WINDOW_W (5*PIX_PER_INCH)
#define DRAW_WINDOW_H (5*PIX_PER_INCH)
#define CHOICE_WINDOW_W (11*CHOICE_IMAGE_W)
#define CHOICE_WINDOW_H (2*CHOICE_IMAGE_H)
#define VSBAR_H (DRAW_WINDOW_H+RULER_W+2*BRDR_W)
#define HSBAR_W (DRAW_WINDOW_W+RULER_W+2*BRDR_W)
#define TITLE_WINDOW_W (HSBAR_W+SCROLLBAR_W+2*BRDR_W)
#define TITLE_WINDOW_H (MENU_IMAGE_H*2)
#define TOOL_WINDOW_W (TITLE_WINDOW_W+2*BRDR_W)
#define TOOL_WINDOW_H (TITLE_WINDOW_H+CHOICE_WINDOW_H+VSBAR_H+SCROLLBAR_W+8*BRDR_W)
#define MSG_WINDOW_W (TITLE_WINDOW_W-CHOICE_WINDOW_W-2*BRDR_W)
#define MSG_WINDOW_H (CHOICE_WINDOW_H)
#define ICON_WINDOW_W 64
#define ICON_WINDOW_H 80

unsigned int	mainWinW = 0;
unsigned int	mainWinH = 0;
int	vSBarH = VSBAR_H;
int	hSBarW = HSBAR_W;
int	scrollBarW = SCROLLBAR_W;
int	rulerW = RULER_W;
int	brdrW = BRDR_W;
int	msgWindowW = MSG_WINDOW_W;
int	msgWindowH = MSG_WINDOW_H;
int	choiceImageW = CHOICE_IMAGE_W;
int	choiceImageH = CHOICE_IMAGE_H;
int	choiceWindowW = CHOICE_WINDOW_W;
int	choiceWindowH = CHOICE_WINDOW_H;
int	menuImageW = MENU_IMAGE_W;
int	menuImageH = MENU_IMAGE_H;
int	titleWindowW = TITLE_WINDOW_W;
int	titleWindowH = TITLE_WINDOW_H;
int	iconWindowW = ICON_WINDOW_W;
int	iconWindowH = ICON_WINDOW_H;

Display		* mainDisplay;
Colormap	mainColormap;
unsigned int	mainDepth;
int		mainScreen;
Visual		* mainVisual;

Window	rootWindow=None;
Window	mainWindow=None;
Window	drawWindow=None;
Window	choiceWindow=None;
Window	titleWindow=None;
Window	msgWindow=None;
Window	vSBarWindow=None;
Window	hSBarWindow=None;
Window	vRuleWindow=None;
Window	hRuleWindow=None;
Window	iconWindow=None;
Window	iconBaseWindow=None;

#ifndef A4PAPER
int	paperWidth = (85*PIX_PER_INCH)/10;
int	paperHeight = 11*PIX_PER_INCH;
#else /* A4PAPER */
int	paperWidth = (825*PIX_PER_INCH)/100;
int	paperHeight = (117*PIX_PER_INCH)/10;
#endif /* A4PAPER */
int	drawOrigX = 0;
int	drawOrigY = 0;
int	drawWinW = DRAW_WINDOW_W;
int	drawWinH = DRAW_WINDOW_H;

int	zoomScale = 0;
int	zoomedIn = FALSE;

struct BBRec	drawWinBBox;

int	colorDisplay = FALSE;
int	fileModified = FALSE;
int	objId = 0;

int	myBgPixel;
int	myFgPixel;
int	myBorderPixel;
int	reverseVideo = FALSE;

char	drawPath[MAXPATHLENGTH];
char	bootDir[MAXPATHLENGTH+2];
char	homeDir[MAXPATHLENGTH];

int	symPathNumEntries = INVALID;
char	* * symPath;

int	initDrawWinW, initDrawWinH;

short	handleSize=3;

static Window	dummyWindow1, dummyWindow2;

static Atom	protocolAtom;

static int	canvasWindowOnly;

void UpdDrawWinWH ()
{
   drawWinW = ABS_SIZE(initDrawWinW);
   drawWinH = ABS_SIZE(initDrawWinH);
}

void UpdDrawWinBBox ()
{
   drawWinBBox.ltx = drawOrigX;
   drawWinBBox.lty = drawOrigY;
   drawWinBBox.rbx = drawOrigX + drawWinW-1;
   drawWinBBox.rby = drawOrigY + drawWinH-1;
}

static
void InitWinSizes ()
{
   initDrawWinW = drawWinW;
   initDrawWinH = drawWinH;
   titleWindowH = (showVersion) ? MENU_IMAGE_H*2 : MENU_IMAGE_H;
   hSBarW = drawWinW+rulerW+2*brdrW;
   vSBarH = drawWinH+rulerW+2*brdrW;
   titleWindowW = hSBarW+scrollBarW+2*brdrW;
   msgWindowW = titleWindowW-choiceWindowW-2*brdrW;
   mainWinW = titleWindowW+2*brdrW;
   mainWinH = titleWindowH+choiceWindowH+vSBarH+scrollBarW+8*brdrW;
}

static
void InverseInitWinSizes ()
   /* derive other win sizes from mainWinW and mainWinH */
{
   titleWindowW = mainWinW-2*brdrW;
   msgWindowW = titleWindowW-choiceWindowW-2*brdrW;
   vSBarH = mainWinH-titleWindowH-choiceWindowH-scrollBarW-8*brdrW;
   hSBarW = titleWindowW-scrollBarW-2*brdrW;
   drawWinH = initDrawWinH = vSBarH-rulerW-2*brdrW;
   drawWinW = initDrawWinW = hSBarW-rulerW-2*brdrW;
}

static
void ComputeMainWinXY (MainWinX, MainWinY)
   int	* MainWinX, * MainWinY;
{
   int		win_x, win_y, done = FALSE;
   unsigned int	win_w, win_h, win_brdr_w, win_d, num_child;
   Window	win = mainWindow, root_win, parent_win, * child_wins;

   *MainWinX = *MainWinY = 0;
   while (!done)
   {
      XGetGeometry (mainDisplay, win, &root_win, &win_x, &win_y, &win_w,
            &win_h, &win_brdr_w, &win_d);
      *MainWinX += win_x;
      *MainWinY += win_y;
      if (XQueryTree (mainDisplay, win, &root_win, &parent_win, &child_wins,
            &num_child) == 0)
         return;
      if (child_wins != NULL) cfree (child_wins);
      if (parent_win == rootWindow)
         done = TRUE;
      else
         win = parent_win;
   }
}

int mainWinEventHandler (input)
   XEvent	* input;
{
   register int	i;
   Window	root_win;
   int		win_x, win_y, main_win_x, main_win_y, configure = FALSE;
   unsigned int	win_w, win_h, win_brdr_w, win_d;
   char		* c_ptr, msg[MAXSTRING];
   XEvent	ev;

   if (input->type == UnmapNotify)
      Iconify ();
   else if (input->type == MapNotify)
      UnIconify ();
   else if (input->type == ConfigureNotify)
   {
      if (iconWindowCreated && iconWindowShown) UnIconify ();
      configure = TRUE;
   }
   else if (input->type == VisibilityNotify &&
         input->xvisibility.state == VisibilityUnobscured && !iconWindowShown)
   {
      SaveStackingOrder ();
      for (i = 0; i < numStacking; i++)
         XMapRaised (mainDisplay, stackingWins[i]);
   }
   else if (input->type == ClientMessage)
   {
      c_ptr = XGetAtomName (mainDisplay, input->xclient.message_type);
      if (strcmp ("WM_MOVED", c_ptr) == 0)
         configure = TRUE;
      else if (strcmp ("WM_PROTOCOLS", c_ptr) == 0 &&
            input->xclient.data.l[0] == protocolAtom)
         return (QuitProc ());
      else
      {
         sprintf (msg, "mainWindow ClientMessage: '%s'.", c_ptr);
         Msg (msg);
      }
      XFree (c_ptr);
   }

   if (configure)
   {
      ComputeMainWinXY (&main_win_x, &main_win_y);
      XGetGeometry (mainDisplay, mainWindow, &root_win, &win_x, &win_y, &win_w,
            &win_h, &win_brdr_w, &win_d);
      if (win_w == mainWinW && win_h == mainWinH)
      {
         SaveStackingOrder ();
         if (pinnedMainMenu)
            MoveMainMenuWindow (main_win_x, main_win_y);
         else
            SaveMainWinPosition (main_win_x, main_win_y);
         for (i = 0; i < numExtraWins; i++)
            if (extraWinInfo[i].mapped && extraWinInfo[i].raise &&
                  extraWinInfo[i].window != None)
               MoveSubMenuWindow (extraWinInfo[i].window);
         for (i = 0; i < numStacking; i++)
            XMapRaised (mainDisplay, stackingWins[i]);

         while (XCheckWindowEvent (mainDisplay, mainWindow,
               VisibilityChangeMask | StructureNotifyMask, &ev)) ;

         XFlush (mainDisplay);
         return (INVALID);
      }
      if (!iconWindowShown)
      {
         SaveStackingOrder ();
         for (i = 0; i < numStacking; i++)
            XMapRaised (mainDisplay, stackingWins[i]);
      }

      mainWinW = win_w;
      mainWinH = win_h;
      if (canvasWindowOnly)
      {
         initDrawWinW = mainWinW-2*brdrW;
         initDrawWinH = mainWinH-2*brdrW;
      }
      else
      {
         initDrawWinW = mainWinW - rulerW - scrollBarW - 6*brdrW;
         initDrawWinH = mainWinH - titleWindowH - choiceWindowH - rulerW -
               scrollBarW - 10*brdrW;
      }
      drawWinW = initDrawWinW;
      drawWinH = initDrawWinH;
      hSBarW = initDrawWinW + rulerW + 2*brdrW;
      vSBarH = initDrawWinH + rulerW + 2*brdrW;
      titleWindowW = hSBarW + scrollBarW + 2*brdrW;
      msgWindowW = titleWindowW - choiceWindowW - 2*brdrW;
      if (canvasWindowOnly)
         XResizeWindow (mainDisplay, drawWindow, drawWinW, drawWinH);
      else
      {
         XResizeWindow (mainDisplay, titleWindow, titleWindowW, titleWindowH);
         XResizeWindow (mainDisplay, msgWindow, msgWindowW, msgWindowH);
         XMoveWindow (mainDisplay, choiceWindow, msgWindowW+2*brdrW,
               titleWindowH+2*brdrW);
         XResizeWindow (mainDisplay, hRuleWindow, drawWinW, rulerW);
         XResizeWindow (mainDisplay, vRuleWindow, rulerW, drawWinH);
         XResizeWindow (mainDisplay, drawWindow, drawWinW, drawWinH);
         XMoveResizeWindow (mainDisplay, vSBarWindow, drawWinW+rulerW+4*brdrW,
               titleWindowH+choiceWindowH+4*brdrW, scrollBarW, vSBarH);
         XMoveResizeWindow (mainDisplay, hSBarWindow, 0,
               titleWindowH+choiceWindowH+rulerW+drawWinH+8*brdrW, hSBarW,
               scrollBarW);
         XMoveWindow (mainDisplay, dummyWindow1, drawWinW+rulerW+4*brdrW,
            titleWindowH+choiceWindowH+rulerW+drawWinH+8*brdrW);
      }
      UpdDrawWinWH ();
      UpdDrawWinBBox ();
      UpdScrollWinWH ();
      SetDefaultDrawWinClipRecs ();
      SaveMainWinPosition (main_win_x, main_win_y);
   }
   return (INVALID);
}

static Window	savedMainWindow=None, savedDrawWindow=None;

void Setup ()
{
   int		bitmask = 0, x_neg_in_def = FALSE, y_neg_in_def = FALSE;
   int		x_in_cmdline = FALSE, y_in_cmdline = FALSE, grid_size=0;
   char		* c_ptr;
   int		def_x_neg = 0, def_y_neg = 0;
   XWMHints	wmhints;
   XSizeHints	sizehints;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Synchronize")) != NULL)
      if ((strcmp (c_ptr, "on") == 0) || (strcmp (c_ptr, "On") == 0))
         XSynchronize (mainDisplay, True);

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DontShowVersion"))!=NULL)
      if ((strcmp (c_ptr, "true") == 0) || (strcmp (c_ptr, "True") == 0))
         showVersion = FALSE;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "PrintCommand")) != NULL)
      strcpy (printCommand, c_ptr);
   else
#ifdef PRINT_CMD
      strcpy (printCommand, PRINT_CMD);
#else
#ifdef VMS
      strcpy (printCommand, "print");
#else
#ifdef SYSV
      strcpy (printCommand, "lp -dpostscript");
#else
      strcpy (printCommand, "lpr");
#endif /* SYSV */
#endif /* VMS */
#endif /* PRINT_CMD */

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "PrintDirectory")) != NULL)
      strcpy (outputDir, c_ptr);
   else
      *outputDir = '\0';

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "WhereToPrint")) != NULL)
   {
      if (strcmp (c_ptr, "Printer") == 0)
         whereToPrint = PRINTER;
      else if (strcmp (c_ptr, "EPS") == 0)
         whereToPrint = LATEX_FIG;
      else if (strcmp (c_ptr, "PS") == 0)
         whereToPrint = PS_FILE;
      else if (strcmp (c_ptr, "Bitmap") == 0)
         whereToPrint = XBM_FILE;
      else
         fprintf (stderr, "Unrecognized WhereToPrint:  %s\n", c_ptr);
   }

   useGray = FALSE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"UseGrayScale")) != NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         useGray = TRUE;
   }

   autoPan = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"AutoPanInEditText")) !=
         NULL)
   {
      if (strcmp ("false", c_ptr) == 0 || strcmp ("False", c_ptr) == 0)
         autoPan = FALSE;
   }

   printMag = 100;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"PercentPrintReduction")) !=
         NULL)
   {
      int	print_reduction = atoi (c_ptr);

      if (print_reduction <= 0)
      {
         fprintf (stderr, "Invalid %s*PercentPrintReduction: '%s', %s.\n",
               TOOL_NAME, c_ptr, "100 is used");
         print_reduction = 100;
      }
      printMag = print_reduction;
   }

   moveMode = UNCONST_MOVE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"ConstrainedMove")) != NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         moveMode = CONST_MOVE;
   }

   doubleQuoteDoubleQuote = FALSE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"DoubleQuoteDoubleQuote"))
         != NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         doubleQuoteDoubleQuote = TRUE;
   }

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "GridSystem")) != NULL)
   {
      if (strcmp ("English", c_ptr) == 0 || strcmp ("english", c_ptr) == 0)
         gridSystem = ENGLISH_GRID;
      else if (strcmp ("Metric", c_ptr) == 0 || strcmp ("metric", c_ptr) == 0)
         gridSystem = METRIC_GRID;
   }

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "InitialGrid")) != NULL)
   {
      grid_size = atoi (c_ptr);
      switch (gridSystem)
      {
         case ENGLISH_GRID:
            if (grid_size < -2 || grid_size > 2)
               fprintf (stderr, "Invalid %s*InitialGrid: '%s', 0 is used.\n",
                     TOOL_NAME, c_ptr);
            else
               xyEnglishGrid = HALF_INCH>>(2-grid_size);
            break;
         case METRIC_GRID:
            if (grid_size < -1 || grid_size > 2)
               fprintf (stderr, "Invalid %s*InitialGrid: '%s', 0 is used.\n",
                     TOOL_NAME, c_ptr);
            else
               switch (grid_size)
               {
                  case -1: xyMetricGrid = ONE_MM; break;
                  case 0: xyMetricGrid = TWO_MM; break;
                  case 1: xyMetricGrid = FIVE_MM; break;
                  case 2: xyMetricGrid = ONE_CM; break;
               }
            break;
      }
   }

   splineTol = 9;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"SplineTolerance")) != NULL)
   {
      splineTol = atoi (c_ptr);
      if (splineTol < 3 || splineTol > 13)
      {
         fprintf (stderr, "Invalid %s*SplineTolerance: '%s', 9 is used.\n",
               TOOL_NAME, c_ptr);
         splineTol = 9;
      }
   }

   splineRubberband = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"SplineRubberband")) != NULL)
      if ((strcmp (c_ptr, "false") == 0) || (strcmp (c_ptr, "False") == 0))
         splineRubberband = FALSE;

   saveTmpOnReturn = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"SaveTmpOnReturn")) != NULL)
      if ((strcmp (c_ptr, "false") == 0) || (strcmp (c_ptr, "False") == 0))
         saveTmpOnReturn = FALSE;

   dropObsIconAttrWhenUpdate = FALSE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME,
         "DropObsIconAttrWhenUpdate")) != NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         dropObsIconAttrWhenUpdate = TRUE;
   }

   useRecentDupDistance = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME,
         "UseRecentDupDistance")) != NULL)
   {
      if (strcmp ("false", c_ptr) == 0 || strcmp ("False", c_ptr) == 0)
         useRecentDupDistance = FALSE;
   }

   handleSize = 2;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "HandleSize")) != NULL)
   {
      handleSize = atoi (c_ptr);
      if (handleSize < 2 || handleSize > 6)
      {
         fprintf (stderr, "Invalid %s*HandleSize:  '%s', 2 is used.\n",
               TOOL_NAME, c_ptr);
         handleSize = 2;
      }
   }

   historyDepth = -1;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "HistoryDepth")) != NULL)
      historyDepth = atoi (c_ptr);

   canvasWindowOnly = FALSE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "CanvasWindowOnly")) !=
         NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         canvasWindowOnly = TRUE;
   }

   saveCommentsInSaveNew = TRUE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME,
         "SaveCommentsInSaveNew")) != NULL)
   {
      if (strcmp ("false", c_ptr) == 0 || strcmp ("False", c_ptr) == 0)
         saveCommentsInSaveNew = FALSE;
   }

   usePsAdobeString = FALSE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME,
         "UsePsAdobeString")) != NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         usePsAdobeString = TRUE;
   }

   groupedTextEditable = FALSE;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME,
         "GroupedTextEditable")) != NULL)
   {
      if (strcmp ("true", c_ptr) == 0 || strcmp ("True", c_ptr) == 0)
         groupedTextEditable = TRUE;
   }

   strcpy (scanFileName, "No File");
   scanLineNum = 0;

   colorDisplay = (cmdLineBW || DisplayPlanes(mainDisplay,mainScreen)==1 ||
         mainVisual->class==StaticGray) ? FALSE : TRUE;

   InitColor ();

   if ((c_ptr = getenv ("TGIFPATH")) == NULL)
      strcpy (drawPath, TGIF_PATH);
   else
      if (strlen (c_ptr) >= 255)
         strcpy (drawPath, TGIF_PATH);
      else
         strcpy (drawPath, c_ptr);

   if ((c_ptr = getenv ("HOME")) == NULL)
      strcpy (homeDir, "/");
   else
      if (strlen (c_ptr) >= MAXPATHLENGTH-1)
         strcpy (homeDir, "/");
      else
         strcpy (homeDir, c_ptr);

#ifdef VMS
   if (getcwd (bootDir, MAXPATHLENGTH+2, 0) == NULL) strcpy (bootDir, ".");
#else
#ifdef ibm
   if (getwd (bootDir, MAXPATHLENGTH+2) == NULL) strcpy (bootDir, ".");
#else
#ifdef NeXT
   if (getwd (bootDir, MAXPATHLENGTH+2) == NULL) strcpy (bootDir, ".");
#else
#ifdef SYSV
   if (getcwd (bootDir, MAXPATHLENGTH+2) == NULL) strcpy (bootDir, ".");
#else
   if (getwd (bootDir) == NULL) strcpy (bootDir, ".");
#endif
#endif
#endif
#endif

   sizehints.flags = PPosition | PSize | PMinSize;
   sizehints.x = 0;
   sizehints.y = 0;
   sizehints.width = mainWinW;
   sizehints.height = mainWinH;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Geometry")) != NULL)
   {
      bitmask = XParseGeometry (c_ptr, &(sizehints.x), &(sizehints.y),
            (unsigned int *)&(sizehints.width),
            (unsigned int *)&(sizehints.height));
      if (bitmask & (XValue | YValue)) sizehints.flags |= USPosition;
      if (bitmask & (WidthValue | HeightValue))
      {
         sizehints.flags |= USSize;
         drawWinW = sizehints.width;
         drawWinH = sizehints.height;
      }
      if (bitmask & XNegative)
      {
         x_neg_in_def = TRUE;
         def_x_neg = sizehints.x;
      }
      if (bitmask & YNegative)
      {
         y_neg_in_def = TRUE;
         def_y_neg = sizehints.y;
      }
   }

   if (geometrySpecified && *geometrySpec != '\0')
   {
      bitmask = XParseGeometry (geometrySpec, &(sizehints.x), &(sizehints.y),
            (unsigned int *)&(sizehints.width),
            (unsigned int *)&(sizehints.height));
      if (bitmask & (XValue | YValue)) sizehints.flags |= USPosition;
      if (bitmask & (WidthValue | HeightValue))
      {
         sizehints.flags |= USSize;
         drawWinW = sizehints.width;
         drawWinH = sizehints.height;
      }
      if (bitmask & XValue) x_in_cmdline = TRUE;
      if (bitmask & YValue) y_in_cmdline = TRUE;
   }

   InitWinSizes ();
   InitFonts ();

   if (canvasWindowOnly)
   {
      mainWinW = initDrawWinW;
      mainWinH = initDrawWinH;

      switch (gridSystem)
      {
         case ENGLISH_GRID:
            sizehints.min_width = HALF_INCH+3*brdrW;
            sizehints.min_height = HALF_INCH+3*brdrW;
            break;
         case METRIC_GRID:
            sizehints.min_width = ONE_CM+3*brdrW;
            sizehints.min_height = ONE_CM+3*brdrW;
            break;
      }
      if (mainWinW > sizehints.min_width)
         sizehints.width = mainWinW;
      else
         sizehints.width = sizehints.min_width = mainWinW;
      if (mainWinH > sizehints.min_height)
         sizehints.height = mainWinH;
      else
         sizehints.height = sizehints.min_height = mainWinH;

      drawWinW = initDrawWinW = mainWinW-2*brdrW;
      drawWinH = initDrawWinH = mainWinH-2*brdrW;
   }
   else
   {
      sizehints.min_width = choiceWindowW+4*brdrW+defaultFontWidth;
      sizehints.min_height =
            titleWindowH+choiceWindowH+PIX_PER_INCH+rulerW+scrollBarW+10*brdrW;
      if (mainWinW > sizehints.min_width)
         sizehints.width = mainWinW;
      else
         mainWinW = sizehints.width = sizehints.min_width;
      if (mainWinH > sizehints.min_height)
         sizehints.height = mainWinH;
      else
         mainWinH = sizehints.height = sizehints.min_height;

      InverseInitWinSizes ();
   }

   if (bitmask & XNegative)
      sizehints.x += DisplayWidth(mainDisplay,mainScreen)-mainWinW-1;
   else if (!x_in_cmdline && x_neg_in_def)
      sizehints.x = def_x_neg+DisplayWidth(mainDisplay,mainScreen)-mainWinW-1;

   if (bitmask & YNegative)
      sizehints.y += DisplayHeight(mainDisplay,mainScreen)-mainWinH-1;
   else if (!y_in_cmdline && y_neg_in_def)
      sizehints.y = def_y_neg+DisplayHeight(mainDisplay,mainScreen)-mainWinH-1;

   if ((mainWindow = XCreateSimpleWindow (mainDisplay, rootWindow,
         sizehints.x, sizehints.y, sizehints.width, sizehints.height,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { fprintf (stderr, "Could not create main window!\n"); exit(1); }

   if (newColormapUsed)
      XSetWindowColormap (mainDisplay, mainWindow, mainColormap);

   InitShortCut ();
   InitScroll ();
   InitPattern ();
   InitRuler ();
   InitMenu ();
   InitNames ();
   InitStk ();
   InitXBm ();
   InitXPm ();
   CreateCursor ();

   if ((titleWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0, 0,
         titleWindowW, titleWindowH, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { fprintf (stderr, "Could not create menu window!\n"); exit(1); }

   if ((msgWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+2*brdrW, msgWindowW, msgWindowH, brdrW, myBorderPixel,
         myBgPixel)) == 0)
   { fprintf (stderr, "Could not create message window!\n"); exit(1); }

   if ((choiceWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         msgWindowW+2*brdrW, titleWindowH+2*brdrW, choiceWindowW, choiceWindowH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { fprintf (stderr, "Could not create choice window!\n"); exit(1); }

   InitChoice ();

   if ((hRuleWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         rulerW+2*brdrW, titleWindowH+choiceWindowH+4*brdrW, drawWinW, rulerW,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { fprintf (stderr, "Could not create horizontal ruler window!\n"); exit(1); }

   if ((vRuleWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+rulerW+choiceWindowH+6*brdrW, rulerW, drawWinH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { fprintf (stderr, "Could not create vertical ruler window!\n"); exit(1); }

   if ((drawWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         rulerW+2*brdrW, titleWindowH+rulerW+choiceWindowH+6*brdrW,
         drawWinW, drawWinH, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { fprintf (stderr, "Could not create draw window!\n"); exit(1); }

   if ((vSBarWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         4*brdrW+rulerW+drawWinW, titleWindowH+choiceWindowH+4*brdrW,
         scrollBarW, vSBarH, brdrW, myBorderPixel, myBgPixel)) == 0) 
   {
      fprintf (stderr, "Could not create vertical scrollbar window!\n");
      exit(1);
   }

   if ((hSBarWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+rulerW+drawWinH+choiceWindowH+8*brdrW,
         hSBarW, scrollBarW, brdrW, myBorderPixel, myBgPixel)) == 0) 
   {
      fprintf (stderr, "Could not create horizontal scrollbar window!\n");
      exit(1);
   }

   if ((dummyWindow1 = XCreateSimpleWindow (mainDisplay, mainWindow,
         rulerW+drawWinW+4*brdrW,
         titleWindowH+choiceWindowH+rulerW+drawWinH+8*brdrW,
         scrollBarW, scrollBarW, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { fprintf (stderr, "Could not create dummy window!\n"); exit(1); }

   if ((dummyWindow2 = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+choiceWindowH+4*brdrW, rulerW, rulerW,
         brdrW, myBorderPixel, myBgPixel)) == 0) 
   { fprintf (stderr, "Could not create dummy window!\n"); exit(1); }

   if (canvasWindowOnly)
   {
      savedMainWindow = mainWindow;
      savedDrawWindow = drawWindow;

      if ((mainWindow = XCreateSimpleWindow (mainDisplay, rootWindow,
            sizehints.x, sizehints.y, mainWinW, mainWinH,
            brdrW, myBorderPixel, myBgPixel)) == 0)
      { fprintf (stderr, "Could not create main window!\n"); exit(1); }

      if (newColormapUsed)
         XSetWindowColormap (mainDisplay, mainWindow, mainColormap);

      if ((drawWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
            0, 0, drawWinW, drawWinH, brdrW, myBorderPixel, myBgPixel)) == 0) 
      { fprintf (stderr, "Could not create draw window!\n"); exit(1); }
   }

#ifdef NOTR4MODE
   XSetNormalHints (mainDisplay, mainWindow, &sizehints);
#else
   XSetWMNormalHints (mainDisplay, mainWindow, &sizehints);
#endif
   XStoreName (mainDisplay, mainWindow, TOOL_NAME);

   UpdDrawWinBBox ();
   InitTitle ();
#ifdef XI18N
   if (curFont == FONT_SYM)
        SetCanvasFontSym ();
   else
#endif
   SetCanvasFont ();

#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, mainWindow);
   XSelectInput (mainDisplay, mainWindow, KeyPressMask | StructureNotifyMask
         | VisibilityChangeMask);
#else
   XSelectInput (mainDisplay, mainWindow, KeyPressMask | StructureNotifyMask
         | VisibilityChangeMask);
   XMapWindow (mainDisplay, mainWindow);
#endif
   XDefineCursor (mainDisplay, mainWindow, defaultCursor);

   protocolAtom = XInternAtom (mainDisplay, "WM_DELETE_WINDOW", False);
#ifndef NOTR4MODE
   XSetWMProtocols (mainDisplay, mainWindow, &protocolAtom, 1);
#endif

#ifdef MAPBEFORESELECT
   if (canvasWindowOnly)
   {
      XMapWindow (mainDisplay, drawWindow); 
      XSelectInput (mainDisplay, drawWindow, ButtonReleaseMask |
            ButtonPressMask | PointerMotionMask | KeyPressMask |
            KeyReleaseMask | ExposureMask);
   }
   else
   {
      XMapWindow (mainDisplay, titleWindow);
      XSelectInput (mainDisplay, titleWindow, ExposureMask);

      XMapWindow (mainDisplay, msgWindow);
      XSelectInput (mainDisplay, msgWindow, ButtonPressMask |
            ButtonReleaseMask | PointerMotionMask | ExposureMask);

      XMapWindow (mainDisplay, choiceWindow);
      XSelectInput (mainDisplay, choiceWindow,
            ButtonReleaseMask | ButtonPressMask | ExposureMask);

      XMapWindow (mainDisplay, hRuleWindow);
      XSelectInput (mainDisplay, hRuleWindow, ExposureMask);
      XMapWindow (mainDisplay, vRuleWindow);
      XSelectInput (mainDisplay, vRuleWindow, ExposureMask);

      XMapWindow (mainDisplay, drawWindow); 
      XSelectInput (mainDisplay, drawWindow, ButtonReleaseMask |
            ButtonPressMask | PointerMotionMask | KeyPressMask |
            KeyReleaseMask | ExposureMask);

      XMapWindow (mainDisplay, vSBarWindow);
      XSelectInput (mainDisplay, vSBarWindow, ButtonPressMask | ExposureMask);
      XMapWindow (mainDisplay, hSBarWindow);
      XSelectInput (mainDisplay, hSBarWindow, ButtonPressMask | ExposureMask);
   }
#else
   if (canvasWindowOnly)
   {
      XSelectInput (mainDisplay, drawWindow, ButtonReleaseMask |
            ButtonPressMask | PointerMotionMask | KeyPressMask |
            KeyReleaseMask | ExposureMask);
      XMapWindow (mainDisplay, drawWindow); 
   }
   else
   {
      XSelectInput (mainDisplay, titleWindow, ExposureMask);
      XMapWindow (mainDisplay, titleWindow);

      XSelectInput (mainDisplay, msgWindow, ButtonPressMask |
            ButtonReleaseMask | PointerMotionMask | ExposureMask);
      XMapWindow (mainDisplay, msgWindow);

      XSelectInput (mainDisplay, choiceWindow,
            ButtonReleaseMask | ButtonPressMask | ExposureMask);
      XMapWindow (mainDisplay, choiceWindow);

      XSelectInput (mainDisplay, hRuleWindow, ExposureMask);
      XMapWindow (mainDisplay, hRuleWindow);
      XSelectInput (mainDisplay, vRuleWindow, ExposureMask);
      XMapWindow (mainDisplay, vRuleWindow);

      XSelectInput (mainDisplay, drawWindow, ButtonReleaseMask |
            ButtonPressMask | PointerMotionMask | KeyPressMask |
            KeyReleaseMask | ExposureMask);
      XMapWindow (mainDisplay, drawWindow); 

      XSelectInput (mainDisplay, vSBarWindow, ButtonPressMask | ExposureMask);
      XMapWindow (mainDisplay, vSBarWindow);
      XSelectInput (mainDisplay, hSBarWindow, ButtonPressMask | ExposureMask);
      XMapWindow (mainDisplay, hSBarWindow);
   }
#endif

   if (!canvasWindowOnly)
   {
      XMapWindow (mainDisplay, dummyWindow1);
      XMapWindow (mainDisplay, dummyWindow2);
   }

   wmhints.flags = InputHint;
   wmhints.input = True;

   if (iconWindowCreated)
   {
      unsigned int	dummy_icon_w, dummy_icon_h;

      sizehints.flags = PSize | PMinSize | PMaxSize;
      sizehints.width = sizehints.min_width = sizehints.max_width =
            iconWindowW+2*brdrW;
      sizehints.height = sizehints.min_height = sizehints.max_height =
            iconWindowH+2*brdrW;

      wmhints.flags |= IconWindowHint;
      wmhints.icon_window = iconBaseWindow;

      if ((c_ptr = XGetDefault (mainDisplay,TOOL_NAME,"IconGeometry")) != NULL)
      {
         bitmask = XParseGeometry (c_ptr, &(sizehints.x), &(sizehints.y),
               &dummy_icon_w, &dummy_icon_h);
         if ((bitmask & XValue) && (bitmask & YValue))
         {
            if (bitmask & XNegative) sizehints.x += DisplayWidth (mainDisplay,
                  mainScreen) - iconWindowW - 2*brdrW - 1;
            if (bitmask & YNegative) sizehints.y += DisplayHeight (mainDisplay,
                  mainScreen) - iconWindowH - 2*brdrW - 1;

            sizehints.flags |= USPosition;

            wmhints.flags |= IconPositionHint;
            wmhints.icon_x = sizehints.x;
            wmhints.icon_y = sizehints.y;
         }
         else
            fprintf (stderr, "%s %s*IconGeometry:  %s.  Ignored!\n",
                  "Invalid spec -- ", TOOL_NAME, c_ptr);
      }
#ifdef NOTR4MODE
      XSetNormalHints (mainDisplay, iconBaseWindow, &sizehints);
#else
      XSetWMNormalHints (mainDisplay, iconBaseWindow, &sizehints);
#endif
   }
   XSetWMHints (mainDisplay, mainWindow, &wmhints);

   wmhints.flags = InputHint;
   wmhints.input = True;
   XSetWMHints (mainDisplay, drawWindow, &wmhints);

   InitText ();
#ifdef XI18N
   if (!OpenTextIM(mainDisplay, drawWindow))
	WPRINTF("Warning: cann't connect to any input method.\n");
#endif
}

int TieLooseEnds ()
   /* returns TRUE if something got created */
   /* returns FALSE otherwise */
{
   if (curChoice == DRAWTEXT) return (CreateTextObj ());
   return (FALSE);
}

void MakeQuiescent ()
{
   TieLooseEnds ();
   SetCurChoice (NOTHING);
   if (topSel != NULL) { HighLightReverse (); RemoveAllSel (); }
}

void SetFileModified (modified)
   int	modified;
{
   if (modified != fileModified)
   {
      fileModified = modified;
      RedrawTitleWindow ();
   }
}
