/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/tgif.c,v 2.14 1992/03/31 07:58:16 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#ifdef XI18N
#include <X11/Xlocale.h>
#endif
#include "const.h"
#include "types.h"

#include "mainloop.e"
#include "msg.e"
#include "setup.e"

/*
 * extern int	malloc_debug ();
 */

int	lastFile;
short	* pDrawFontAsc;
short	* pDrawFontDes;

/*
 * static
 * void Prompt2 (PromptStr, OpName, FileName)
 *    char	* PromptStr, * OpName, * FileName;
 * {
 *    char	inbuf[80];
 * 
 *    printf (PromptStr);
 *    fgets (inbuf, 80, stdin);
 *    sscanf (inbuf, "%s%s", OpName, FileName);
 * }
 *
 * static
 * void Prompt3 (PromptStr, AttrName, ColorName, ValName)
 *    char	* PromptStr, * AttrName, * ColorName, * ValName;
 * {
 *    char	inbuf[80];
 * 
 *    printf (PromptStr);
 *    fgets (inbuf, 80, stdin);
 *    sscanf (inbuf, "%s%s%s", AttrName, ColorName, ValName);
 * }
 */

int main (argc, argv)
   int	argc;
   char	* argv[];
   /* All these strangeness with strings are related to */
   /*	Prolog's foreign function interface. */
{
   int	i;
   char	op_name[80], file_name[80], s[80];
   char	* sp[6], * func_strp;
/*
 * char	color_name[80], val_name[80];
 * char	attr_name[80], speed_name[80], id_name[80];
 */
   file_name[0] = '\0';
   for (i = 1; i < argc; i++)
   {
#ifdef XI18N
      if (strcmp (argv[i], "-warning") == 0)
      {
	warning = 1;
      } else
#endif
      if (strcmp (argv[i], "-display") == 0)
      {
         if (++i == argc)
         { fprintf (stderr, "Missing display name.\n"); Usage ("tgif"); }
         displayName = argv[i];
      }
      else if (strcmp (argv[i], "-bw") == 0)
         cmdLineBW = TRUE;
      else if (strcmp (argv[i], "-rv") == 0)
         cmdLineRV = TRUE;
      else if (strcmp (argv[i], "-nv") == 0)
         cmdLineRV = FALSE;
      else if (strcmp (argv[i], "-fg") == 0)
      {
         if (++i == argc)
         { fprintf (stderr, "Missing foreground color.\n"); Usage ("tgif"); }
         cmdLineForeground = (char *) calloc (80, sizeof(char));
         strcpy (cmdLineForeground, argv[i]);
      }
      else if (strcmp (argv[i], "-bg") == 0)
      {
         if (++i == argc)
         { fprintf (stderr, "Missing background color.\n"); Usage ("tgif"); }
         cmdLineBackground = (char *) calloc (80, sizeof(char));
         strcpy (cmdLineBackground, argv[i]);
      }
      else if (strcmp (argv[i], "-bd") == 0)
      {
         if (++i == argc)
         { fprintf (stderr, "Missing border color.\n"); Usage ("tgif"); }
         cmdLineBorder = (char *) calloc (80, sizeof(char));
         strcpy (cmdLineBorder, argv[i]);
      }
      else if (strcmp (argv[i], "-geometry") == 0)
      {
         if (++i == argc)
         { fprintf (stderr, "Missing geometry spec.\n"); Usage ("tgif"); }
         strcat (geometrySpec, argv[i]);
         geometrySpecified = TRUE;
      }
      else if (*argv[i] == '=')
      {
         strcpy (geometrySpec, argv[i]);
         geometrySpecified = TRUE;
      }
      else if (*argv[i] != '-')
         strcpy (file_name, argv[i]);
      else
         Usage ("tgif");
   }
#ifdef XI18N
  /*
   * for configuration of internationalization.
   */
  if ((func_strp = setlocale(LC_ALL, "")) == NULL) {
        fprintf(stderr, "Error: can't configure locale, stop!\n");
        exit(1);
  }
  if (XSetLocaleModifiers("") == NULL) {
        fprintf(stderr, "Error: invalid modifiers, stop!\n");
        exit(2);
  }
  if (!strncmp(func_strp, "lt", 2) || !strcmp(func_strp, "C"))
	oneByteEncoding = 1; 	/* allow ESC-key to input 8-bit codepoint */
#endif
/*
 * malloc_debug (1);
 */
   if (file_name[0] == '\0')
      MainLoop ("init", "", &func_strp,
            &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
   else
      MainLoop ("init", file_name, &func_strp,
            &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
/*
 * for (i = 0; i < 6; i++)
 *    if (strcmp (sp[i], "") != 0)
 *       printf ("%s ", sp[i]);
 *    else
 *       break;
 * printf ("\n");
 */

   while (TRUE)
   {
      strcpy (s, func_strp);
      s[4] = '\0';

      DeallocStrings (&func_strp,&sp[0],&sp[1],&sp[2],&sp[3],&sp[4],&sp[5]);

      if (strcmp (s, "Quit") == 0)
      {
         *file_name = '\0';
         MainLoop ("quit", file_name, &func_strp,
               &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
         break;
      }

      Msg ("Returned from basic driver.");
/*
 *    Prompt2 ("Input an operation and a sub command.\n",op_name,file_name);
 *
 *    if (strcmp (op_name, "animate") == 0)
 *    {
 *       Prompt3 ("Input poly_id, speed, color.\n", id_name, speed_name,
 *             color_name);
 *       Animate (file_name, id_name, speed_name, color_name, &func_strp);
 *       printf ("Animate RETURNs --> %s %s %s\n", func_strp, sp[0], sp[1]);
 *    }
 *    if (strcmp (op_name, "upd_attr_val") == 0)
 *    {
 *       Prompt3 ("Input attrname, color and value.\n", attr_name, color_name,
 *             val_name);
 *       UpdAttrVal (file_name, attr_name, color_name, val_name, &func_strp);
 *       printf ("UpdAttrVal RETURNs --> %s %s %s\n", func_strp, sp[0], sp[1]);
 *    }
 */
      *op_name = *file_name = '\0';
      MainLoop (op_name, file_name, &func_strp,
            &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
/*
 *    printf ("RETURN --> %s ", func_strp);
 *    for (i = 0; i < 6; i++)
 *       if (strcmp (sp[i], "") != 0)
 *          printf ("%s ", sp[i]);
 *       else
 *          break;
 *    printf ("\n");
 */
   }
   return (0);
}
