.\" $Id: viewres.man,v 1.1 1992/03/19 09:13:34 proj Exp $
.TH VIEWRES 1 "Release 5" "X Version 11"
.SH NAME
viewres - graphical class browser for Xt (Internationalized version)
.SH SYNOPSIS
.B "viewres"
[-option ...]
.SH DESCRIPTION
.PP
The \fIviewres\fP program displays a tree showing the widget class hierarchy of
the Athena Widget Set.  Each node in the tree can be expanded to show the
resources that the corresponding class adds (i.e. does not inherit from its
parent) when a widget is created.  This application allows the user to visually
examine the structure and inherited resources for the Athena Widget Set.
.PP
This internationalized version viewres uses the internationalized Athena
Widget Set.
.SH OPTIONS
\fIViewres\fP accepts all of the standard toolkit command line options as
well as the following:
.TP 8
.B \-top \fIname\fP
This option specifies the name of the highest widget in the hierarchy to 
display.  This is typically used to limit the display to a subset of the
tree.  The default is \fIObject\fP.
.TP 8
.B \-variable
This option indicates that the widget variable names (as declared in 
header files) should be displayed in the nodes rather than the widget
class name.  This is sometimes useful to distinguish widget classes that
share the same name (such as \fIText\fP).
.TP 8
.B \-vertical
This option indicates that the tree should be displayed top to bottom
rather left to right.
.SH "VIEW MENU"
The way in which the tree is displayed may be changed through the 
entries in the \fBView\fP menu:
.TP 8
.B "Show Variable Names"
This entry causes the node labels to be set to the variable names used
to declare the corresponding widget class.  This operation may also be 
performed with the \fBSetLabelType(variable)\fP translation.
.TP 8
.B "Show Class Names"
This entry causes the node labels to be set to the class names used when
specifying resources.  This operation may also be performed with the
\fBSetLabelType(class)\fP translation.
.TP 8
.B "Layout Horizontal"
This entry causes the tree to be laid out from left to right.  This operation
may also be performed with the \fISetOrientation(West)\fP translation.
.TP 8
.B "Layout Vertical"
This entry causes the tree to be laid out from top to bottom.  This operation
may also be performed with the \fISetOrientation(North)\fP translation.
.TP 8
.B "Show Resource Boxes"
This entry expands the selected nodes (see next section) to show the 
new widget and constraint resources.  This operation
may also be performed with the \fIResources(on)\fP translation.
.TP 8
.B "Hide Resource Boxes"
This entry removes the resource displays from the selected nodes (usually to
conserve space).  This operation
may also be performed with the \fIResources(off)\fP translation.
.SH "SELECT MENU"
Resources for a single widget class can be displayed by clicking
\fBButton2\fP on the corresponding node, or by adding the node to the
selection list with \fBButton1\fP and using the \fBShow Resource Boxes\fP
entry in the \fBView\fP menu.  Since \fBButton1\fP actually toggles the
selection state of a node, clicking on a selected node will cause it to be
removed from the selected list.
.PP
Collections of nodes may also be selected through the various entries in
the \fBSelect\fP menu:
.TP 8
.B "Unselect All"
This entry removes all nodes from the selection list.  This operation
may also be performed with the \fISelect(nothing)\fP translation.
.TP 8
.B "Select All"
This entry adds all nodes to the selection list.  This operation
may also be performed with the \fISelect(all)\fP translation.
.TP 8
.B "Invert All"
This entry adds unselected nodes to, and removes selected nodes from, the
selection list.  This operation
may also be performed with the \fISelect(invert)\fP translation.
.TP 8
.B "Select Parent"
This entry selects the immediate parents of all selected nodes.  This operation
may also be performed with the \fISelect(parent)\fP translation.
.TP 8
.B "Select Ancestors"
This entry recursively selects all parents of all selected nodes.  This 
operation may also be performed with the \fISelect(ancestors)\fP translation.
.TP 8
.B "Select Children"
This entry selects the immediate children of all selected nodes.  This 
operation may also be performed with the \fISelect(children)\fP translation.
.TP 8
.B "Select Descendants"
This entry recursively selects all children of all selected nodes.  This 
operation may also be performed with the \fISelect(descendants)\fP translation.
.TP 8
.B "Select Has Resources"
This entry selects all nodes that add new resources (regular or constraint)
to their corresponding widget classes.  This operation
may also be performed with the \fISelect(resources)\fP translation.
.TP 8
.B "Select Shown Resource Boxes"
This entry selects all nodes whose resource boxes are currently expanded
(usually so that they can be closed with \fBHide Resource Boxes\fP).  This 
operation may also be performed with the \fISelect(shown)\fP translation.
.SH "ACTIONS"
The following application actions are provided:
.TP 8
.B "Quit()"
.br
This action causes \fIviewres\fP to exit.
.TP 8
.B "SetLabelType(\fItype\fP)"
This action sets the node labels to display the widget \fIvariable\fP or 
\fIclass\fP names, according to the argument \fItype\fP.
.TP 8
.B "SetOrientation(\fIdirection\fP)"
This action sets the root of the tree to be one of the following areas of
the window:  \fIWest\fP, \fINorth\fP, \fIEast\fP, or \fISouth\fP.
.TP 8
.B "Select(\fIwhat\fP)"
This action selects the indicated nodes, as described in the \fBVIEW MENU\fP
section: \fInothing\fP (unselects all nodes), \fIinvert\fP, \fIparent\fP,
\fIancestors\fP, \fIchildren\fP, \fIdescendants\fP, \fIresources\fP, 
\fIshown\fP.
.TP 8
.B "Resources(\fIop\fP)"
This action turns \fIon\fP, \fIoff\fP, or \fItoggles\fP the resource boxes
for the selected nodes.
If invoked from within one of the nodes (through the keyboard or pointer),
only that node is used.
.SH "WIDGET HIERARCHY"
Resources may be specified for the following widgets:
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i 6.5i 7.0i
Viewres viewres
	Paned pane
		Box buttonbox
			Command quit
			MenuButton view
				SimpleMenu viewMenu
					SmeBSB layoutHorizontal
					SmeBSB layoutVertical
					SmeLine line1
					SmeBSB namesVariable
					SmeBSB namesClass
					SmeLine line2
					SmeBSB viewResources
					SmeBSB viewNoResources
			MenuButton select
				SimpleMenu selectMenu
					SmeBSB unselect
					SmeBSB selectAll
					SmeBSB selectInvert
					SmeLine line1
					SmeBSB selectParent
					SmeBSB selectAncestors
					SmeBSB selectChildren
					SmeBSB selectDescendants
					SmeLine line2
					SmeBSB selectHasResources
					SmeBSB selectShownResources
		Form treeform
			Porthole porthole
				Tree tree
					Box \fIvariable-name\fP
						Toggle \fIvariable-name\fP
						List \fIvariable-name\fP
			Panner panner
.fi
.sp
where \fIvariable-name\fP is the widget variable name of each node.
.SH "SEE ALSO"
X(1), xrdb(1), listres(1), editres(1), appres(1), appropriate widget documents
.SH COPYRIGHT
Copyright 1992, OMRON Corporation.
Copyright 1990, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Jim Fulton, MIT X Consortium
