/*
	 Copyright (c) 1991 by Simon Marshall, University of Hull, UK

		   If you still end up late, don't blame me!
				       
  Permission to use, copy, modify, distribute, and sell this software and its
       documentation for any purpose and without fee is hereby granted,
    provided that the above copyright notice appear in all copies and that
	both that copyright notice and this permission notice appear in
			   supporting documentation.
				       
  This software is provided AS IS with no warranties of any kind.  The author
    shall have no liability with respect to the infringement of copyrights,
     trade secrets or any patents by this file or any part thereof.  In no
      event will the author be liable for any lost revenue or profits or
	      other special, indirect and consequential damages.
*/

/* 
 * The stuff needed for the alarm call widget to appear on the screen, 
 * and the stuff for snoozing it.
 */


#include "xalarm.h"
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>


/* 
 * A pain, you may have to alter this.  Basically USER() should return the
 * user name, HOSTNAME() the hostname in the first arg.
 */

#define		HOSTNAME(str,l)	gethostname ((str), (l))
#define		TITLEFORMAT	"%s: %s%s%s%s%s%s"



void		CreateAlarmWidget(), WakeUp(), ShowClickToZero(), ShowSnoozeValue();
static void	SnoozeAmount(), Snooze();
extern void	AddTimeOuts(), SetGeometry(), Quit();
extern String	getenv();


extern AlarmData        xalarm;



/* 
 * The snoozetime button displays its message when the ptr is in the 
 * window, and the snooze time when it's not.
 */

static char snoozetimetranslations [] =
    "<EnterWindow>:	highlight() ShowClickToZero() \n\
     <LeaveWindow>:	ShowSnoozeValue() unhighlight()";



void CreateAlarmWidget (alarmmessage)
  String   alarmmessage;
{
    Widget   alarm, alarmbox, message, buttonbox,
	     quit, snooze, snooze1, snooze5, snooze15, snoozetime;

    alarm = XtVaCreatePopupShell ("Alarm!", transientShellWidgetClass,
				  xalarm.toplevel, NULL);

    alarmbox = XtVaCreateManagedWidget ("alarm", formWidgetClass, alarm, NULL);

    buttonbox = XtVaCreateManagedWidget ("buttons", formWidgetClass, alarmbox, NULL);

    CreateManagedButton (quit, "quit", buttonbox, Quit, NULL);
    CreateManagedButton (snooze, "snooze", buttonbox, Snooze, NULL);
    CreateManagedButton (snooze1, "snooze1", buttonbox, SnoozeAmount, 1);
    CreateManagedButton (snooze5, "snooze5", buttonbox, SnoozeAmount, 5);
    CreateManagedButton (snooze15, "snooze15" ,buttonbox, SnoozeAmount, 15);
    CreateManagedButton (snoozetime, "snoozetime", buttonbox, SnoozeAmount, 0);

    if (alarmmessage != (String) NULL)
	message = XtVaCreateManagedWidget ("message", labelWidgetClass, alarmbox, XtNlabel,
					   (XtArgVal) (xalarm.messagestr = alarmmessage),
					   NULL);
    else {
	message = XtVaCreateManagedWidget ("message", labelWidgetClass, alarmbox, NULL);
	XtVaGetValues (message, XtNlabel, &xalarm.messagestr, NULL);
    }

    XtOverrideTranslations (snoozetime,
			    XtParseTranslationTable (snoozetimetranslations));

    xalarm.alarmwidget = alarm;
    xalarm.snoozetimewidget = snoozetime;
    xalarm.messagewidget = message;
}



/* 
 * This is for the snoozetime button which doubles as the label showing how 
 * much time the snooze is selected for.
 */

void ShowClickToZero ()
{
    XtVaSetValues (xalarm.snoozetimewidget, XtNlabel, (XtArgVal) "Zero time", NULL);
}
  


void ShowSnoozeValue ()
{  
    char   buf[TEXT];

    MAKETIMESTRING (buf, (int) (xalarm.timeout/(60*1000)));
    XtVaSetValues (xalarm.snoozetimewidget, XtNlabel, (XtArgVal) buf, NULL);
}



/* 
 * Add to the amount that is currently the amount to snooze by.
 */

static void SnoozeAmount (widget, clientdata, calldata)
  Widget      widget;
  XtPointer   clientdata, calldata;
{
    int   mins = (int) clientdata;

    if (mins == 0) {
	xalarm.timeout = 0;
	ShowClickToZero ();
    }
    else {
	xalarm.timeout += (mins*60*1000);
	ShowSnoozeValue ();
    }
}



/* 
 * Time to sleep.  Add the time outs & disappear.
 */

static void Snooze (widget, clientdata, calldata)
  Widget      widget;
  XtPointer   clientdata, calldata;
{
    AddTimeOuts ();
    XtPopdown (xalarm.alarmwidget);
}



/* 
 * Time to wake up.
 */

void WakeUp (clientdata, id)
  XtPointer 	 clientdata;
  XtIntervalId 	 id;
{
    Display 	   *display = XtDisplay (xalarm.toplevel);
    String 	    strs[1], name;
    XTextProperty   property;
#if not defined (NOGETHOSTNAME)
    char 	    hostname[TEXT];
#endif

    if (not XtIsRealized (xalarm.alarmwidget)) {
	XtRealizeWidget (xalarm.alarmwidget);
	/* 
	 * Set the name...
	 */
	name = getenv ("NAME");
#if not defined (NOGETHOSTNAME)
	HOSTNAME (hostname, TEXT-1);
#endif
	strs[0] = XtMalloc (TEXT);
	(void) sprintf (strs[0], TITLEFORMAT, xalarm.proggie,
			getenv ("USER"),
#if not defined (NOGETHOSTNAME)
			"@", hostname,
#else
			"", "",
#endif
			(name == (char *) NULL) ? "" : " (",
			(name == (char *) NULL) ? "" : name,
			(name == (char *) NULL) ? "" : ")");
	
	XStringListToTextProperty (strs, 1, &property);
	XSetWMName (display, XtWindow (xalarm.alarmwidget), &property);
    }

    SetGeometry (xalarm.alarmwidget);

    xalarm.timeout = 0;
    SnoozeAmount ((Widget) NULL, (XtPointer) xalarm.snooze, (XtPointer) NULL);

    if (xalarm.bell)
	XBell (display, 0);
    XtPopup (xalarm.alarmwidget, XtGrabNone);
}
