/****************************************************************************

	MultiListP.h

	This file is the private header file for the MultiList widget, an
	extension to the Athena List widget.

	This code is loosely based on the Athena List source which
	is why the MIT copyright notice appears below.

	July 1990, Brian Totty

 ****************************************************************************/

/*
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Original Athena Author:  Chris D. Peterson, MIT X Consortium
 */

#ifndef _MULTILISTP_H_
#define _MULTILISTP_H_

#include <X11/Xaw/SimpleP.h>
#include "MultiList.h"

/*---------------------------------------------------------------------------*

      L O C A L    D A T A    S T R U C T U R E    D E F I N I T I O N S

 *---------------------------------------------------------------------------*/

typedef	struct
{
	Boolean		sensitive;
	Boolean		highlighted;
	String		string;
} MultiListItem;

/*---------------------------------------------------------------------------*

     W I D G E T    D A T A    S T R U C T U R E    D E F I N I T I O N S

 *---------------------------------------------------------------------------*/

typedef struct
{
	int		foo;
} MultiListClassPart;

typedef struct _MultiListClassRec
{
	CoreClassPart	core_class;
	SimpleClassPart	simple_class;
	MultiListClassPart	multiList_class;
} MultiListClassRec;

extern MultiListClassRec multiListClassRec;

typedef struct
{
	Pixel		foreground;
	Pixel		highlight_fg;
	Pixel		highlight_bg;
	Dimension	column_space;
	Dimension	row_space;
	int		default_cols;
	Boolean		force_cols;
	Boolean		paste;
	Boolean		row_major;
	int		longest;
	int		nitems;
	XFontStruct	*font;
	String		*list;
	Boolean		*sensitive_array;
	XtCallbackList  callback;
	int		max_selectable;
	Boolean		notify_highlights;
	Boolean		notify_unhighlights;
	Boolean		notify_opens;
	Dimension	col_width;
	Dimension	row_height;

	int		right_padding;
	int		bottom_padding;
	int		nrows;
	int		ncols;
	int		most_recent_clicked_item;
	int		most_recent_action;
	GC		erase_gc;
	GC		draw_gc;
	GC		highlight_bg_gc;
	GC		highlight_fg_gc;
	GC		gray_gc;
	MultiListItem	*item_array;
	int		num_selected;
	int		*sel_array;
} MultiListPart;

typedef struct _MultiListRec
{
	CorePart	core;
	SimplePart	simple;
	MultiListPart	multiList;
} MultiListRec;

/*---------------------------------------------------------------------------*

          D A T A    S T R U C T U R E    A C C E S S    M A C R O S

 *---------------------------------------------------------------------------*/

#define	MultiListItemSensitive(i)	((i)->sensitive)
#define	MultiListItemHighlighted(i)	((i)->highlighted)
#define	MultiListItemString(i)		((i)->string)

#define	InstanceCore(w)			(&((w)->core))
#define	InstanceSimple(w)		(&((w)->simple))
#define	InstanceMultiList(w)		(&((w)->multiList))

#define	MultiListWidth(w)		(InstanceCore(w)->width)
#define	MultiListHeight(w)		(InstanceCore(w)->height)
#define	MultiListBG(w)			(InstanceCore(w)->background_pixel)
#define	MultiListSensitive(w)		(InstanceCore(w)->sensitive)
#define	MultiListAncesSensitive(w)	(InstanceCore(w)->ancestor_sensitive)
#define	MultiListDepth(w)		(InstanceCore(w)->depth)

#define	MultiListFG(w)			(InstanceMultiList(w)->foreground)
#define	MultiListHighlightFG(w)		(InstanceMultiList(w)->highlight_fg)
#define	MultiListHighlightBG(w)		(InstanceMultiList(w)->highlight_bg)
#define	MultiListColumnSpace(w)		(InstanceMultiList(w)->column_space)
#define	MultiListRowSpace(w)		(InstanceMultiList(w)->row_space)
#define	MultiListDefaultCols(w)		(InstanceMultiList(w)->default_cols)
#define	MultiListForceCols(w)		(InstanceMultiList(w)->default_cols)
#define	MultiListPaste(w)		(InstanceMultiList(w)->paste)
#define	MultiListRowMajor(w)		(InstanceMultiList(w)->row_major)
#define	MultiListLongest(w)		(InstanceMultiList(w)->longest)
#define	MultiListNumItems(w)		(InstanceMultiList(w)->nitems)
#define	MultiListFont(w)		(InstanceMultiList(w)->font)
#define	MultiListList(w)		(InstanceMultiList(w)->list)
#define	MultiListSensitiveArray(w)	(InstanceMultiList(w)->sensitive_array)
#define	MultiListCallback(w)		(InstanceMultiList(w)->callback)
#define	MultiListMaxSelectable(w)	(InstanceMultiList(w)->max_selectable)
#define	MultiListNotifySets(w)		(InstanceMultiList(w)->notify_highlights)
#define	MultiListNotifyUnsets(w)	(InstanceMultiList(w)->notify_unhighlights)
#define	MultiListNotifyOpens(w)		(InstanceMultiList(w)->notify_opens)

#define	MultiListColWidth(w)		(InstanceMultiList(w)->col_width)
#define	MultiListRowHeight(w)		(InstanceMultiList(w)->row_height)
#define	MultiListRightPadding(w)	(InstanceMultiList(w)->right_padding)
#define	MultiListBottomPadding(w)	(InstanceMultiList(w)->bottom_padding)
#define	MultiListNumRows(w)		(InstanceMultiList(w)->nrows)
#define	MultiListNumCols(w)		(InstanceMultiList(w)->ncols)
#define	MultiListMostRecentItem(w)	(InstanceMultiList(w)->most_recent_clicked_item)
#define	MultiListMostRecentAct(w)	(InstanceMultiList(w)->most_recent_action)
#define	MultiListEraseGC(w)		(InstanceMultiList(w)->erase_gc)
#define	MultiListDrawGC(w)		(InstanceMultiList(w)->draw_gc)
#define	MultiListHighlightForeGC(w)	(InstanceMultiList(w)->highlight_fg_gc)
#define	MultiListHighlightBackGC(w)	(InstanceMultiList(w)->highlight_bg_gc)
#define	MultiListGrayGC(w)		(InstanceMultiList(w)->gray_gc)
#define	MultiListItemArray(w)		(InstanceMultiList(w)->item_array)
#define	MultiListNthItem(w,n)		(&(MultiListItemArray(w)[n]))
#define	MultiListSelArray(w)		(InstanceMultiList(w)->sel_array)
#define	MultiListNumSelected(w)		(InstanceMultiList(w)->num_selected)

#endif
