/* Copyright 1991 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of NEC Corporation
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.  NEC 
 * Corporation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

#include "define.h"
#include <stdio.h>
#ifdef	BSD
#include <ttyent.h>
#endif	BSD
#include "extern.h"

extern	char	**environ;
char		*malloc();

#ifdef BSD

char *ttyname();
char *rindex();

int
ttyfdslot(fd)
     int fd;
{
  register char	*fullnamp;
  register int	slotnum;
  register char	*ttynamp;
  register struct ttyent	*te ;

  if ((fullnamp = ttyname(fd)) == NULL)
    return(NULL);
  if ((ttynamp = rindex(fullnamp, '/')) == NULL) {
    ttynamp = fullnamp;
  } else {
    ttynamp++;
  }
  for (slotnum = 1; (te = getttyent()) != NULL; slotnum++) {
    if ( strcmp(te->ty_name, ttynamp) == 0 ) {
      endttyent() ;
      return	slotnum ;
    }
  }
  endttyent() ;
  return NULL;
}

#endif	BSD

int
setenv(var, value)
     char *var;
     char *value;
{
  char	**newenv;
  int	i, j;
  int	l = strlen(var);
  
  for (i = 0;
       environ[i] != NULL && (environ[i][l] != '=' || strncmp(var, environ[i], l) != 0);
       i++)
    ;
  if (environ[i] == NULL) {
    if ((newenv = (char **)malloc((sizeof (char *))*(i + 2))) == NULL)
      return(ERROR);
    for (j = 0; j < i; j++) {
      newenv[j] = environ[j];
    }
    newenv[i + 1] = NULL;
    environ = newenv;
  }
  if ((environ[i] = malloc(l + strlen(value) + 2)) == NULL)
    return(ERROR);
  sprintf(environ[i], "%s=%s", var, value);
  return(0);
}

