/* 
 * HenkanP.h - Private definitions for Henkan widget
 * 
 */

#ifndef _XnwHenkanP_h
#define _XnwHenkanP_h

/***********************************************************************
 *
 * Henkan Widget Private Data
 *
 ***********************************************************************/

#include "Henkan.h"
#include <X11/kanji.h>
#include "SimpleP.h"

/* New fields for the Henkan widget class record */

typedef struct {int foo;} HenkanClassPart;

/* Full class record declaration */
typedef struct _HenkanClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    HenkanClassPart	henkan_class;
} HenkanClassRec;

extern HenkanClassRec henkanClassRec;

/* New fields for the Henkan widget record */
typedef struct {
    /* resources */
    Pixel	foreground;
    Pixel	background;
    XFontStruct	*font;
    XFontStruct *kanji_font;
    XFontStruct *kana_font;
    Boolean	resize;

    /* private state */
    GC		normal_GC;
    GC          kanji_normal_GC;
    GC          kana_normal_GC;
    GC          invert_GC;
    GC          kanji_invert_GC;
    GC          kana_invert_GC;
    int		max_ascent, max_descent;
    int		char_width;
    int		char_space;
    XKanjiStatus kanji_status;
} HenkanPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _HenkanRec {
    CorePart	core;
    SimplePart	simple;
    HenkanPart	henkan;
} HenkanRec;

#endif /* _XnwHenkanP_h */
