/* Copyright 1991 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of NEC Corporation
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.  NEC 
 * Corporation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

#include <stdio.h>
#include "/work/nk/iroha/RK.h"

main(argc, argv)
int argc;
char **argv;
{
  int cx;
  char buf[1024];

  char *userdic;

  if(argc < 2) {
    fprintf(stderr, "usage: %s dic \n", argv[0]);
    exit(1);
  }
  userdic = argv[1];
	    
  if ((cx =RkInitialize("/usr/lib/iroha/dic")) == -1) {
    printf("Init Error\n");
    exit(1);
  }

  RkSetDicPath(cx, "mako:iroha");

  printf("%s ޤ\n", userdic);

  if(RkCreateDic(cx, userdic, 0x80) == -1) {
    printf("%s cannot create\n", userdic);
    exit(1);
  }
    
  if(RkMountDic(cx, userdic, 0) == -1) {
    printf("%s cannot mount\n", userdic);
    exit(1);
  }
    
  if(RkDefineDic(cx, userdic, "ä #JN #å") != 0) {
    printf("cannot define\n");
    exit(1);
  }

  if(RkBgnBun(cx, "ä", 8, 0) == -1) {
    printf("cannot bgnbun\n");
    exit(1);
  }

  if(RkGetKanji(cx, buf, 1024) < 0) {
    printf("cannot getkanji\n");
    exit(1);
  }

  printf(" <%s>\n", buf);

  RkEndBun(cx, 0);

  RkFinalize();
  
  printf("OK!!\n");
}
