/* Copyright 1991 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of NEC Corporation
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.  NEC 
 * Corporation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

static char yomimap_id[] = "@(#) 102.1 $Header: /work/nk.R3.1/lib/iroha/RCS/yomimap.c,v 3.1 91/09/02 14:04:54 kon Exp $";

extern YomiNextJishu(), YomiPreviousJishu(), ConvertAsHex(), ConvertAsBushu();
extern YomiZenkaku(), YomiHankaku();
extern DoFuncSequence(),UseOtherKeymap();
extern YomiHiraganaJishu(), YomiKatakanaJishu(), YomiRomajiJishu();

static
yomiquotedfunc(d, mode, key, fnum)
uiContext d;
KanjiMode mode;
unsigned char key;
int fnum;
{
  return YomiInsertQuoted(d);
}

KanjiModeRec yomi_quoted_insert_mode = {
  yomiquotedfunc,
  0, 0, 0,
};

#define NONE IROHA_FN_Undefined

static int (*yomi_funcs[])() = {
/* ̤                           */    NONE,
/* ʬȤؿ           */    NONE,
/* ʤؿ         */    YomiInsert,
/* 			    */    YomiQuotedInsert,
/* ܸϥ⡼                 */    NONE,
/* ե٥åϥ⡼         */    NONE,
/* Ѵϥ⡼                   */    NONE,
/* ѤҤ餬ʳϥ⡼       */    YomiHiraganaMode,
/* ѥʳϥ⡼       */    YomiZenkakuKatakanaMode,
/* Ⱦѥʳϥ⡼       */    YomiHankakuKatakanaMode,
/* ѥե٥åȳϥ⡼ */    YomiZenkakuRomajiMode,
/* Ⱦѥե٥åȳϥ⡼ */    YomiHankakuRomajiMode,
/* ϥ⡼		    */    NONE,
/* ϥ⡼		    */    NONE,
/* ϥ⡼		    */    NONE,
/*                              */    YomiForward,
/*                              */    YomiBackward,
/* ι                           */    YomiNextJishu,
/* ι                           */    YomiPreviousJishu,
/* Ƭ                             */    YomiBeginningOfLine,
/*                              */    YomiEndOfLine,
/*                        */    YomiDeleteNext,
/* ˺                         */    YomiDeletePrevious,
/* ޤǺ                     */    YomiKillToEndOfLine,
#ifdef INTELLIGENTSPACE
/* Ѵ                             */    YomiHenkanOrSpace,
#else /* !INTELLIGENTSPACE */
/* Ѵ                             */    YomiHenkan,
#endif /* !INTELLIGENTSPACE */
/*                              */    YomiKakutei,
/* Ф                           */    YomiPrevMode,
/* ̤                             */    YomiNextMode,
/* ʸ῭̥⡼ɤ                 */    NONE, 		   
/*                          */    YomiQuit,
/* Ͽ                             */    NONE,
/* ʥɤȤѴ           */    ConvertAsHex,
/* ̾ȤѴ                 */    ConvertAsBushu,
/*                          */    ConvertAsBushu,
/* ʬ̵Ѵ                       */    NONE,
/* ѤؤѴ                     */    YomiZenkaku,
/* ȾѤؤѴ                     */    YomiHankaku,
/* ʸؤѴ                   */    NONE,
/* ԥ饤                   */    NONE,
/* ʸؤѴ                   */    NONE,
/* Ҥ餬Ѵ			    */	  YomiHiraganaJishu,
/* Ѵ			    */	  YomiKatakanaJishu,
/* ޻Ѵ			    */	  YomiRomajiJishu,
/* ʣΥγ             */    DoFuncSequence,
/* 󥹤ؤб           */    UseOtherKeymap,
};

KanjiModeRec yomi_mode = {
  simplefunc,
  default_kmap,
  IROHA_KANJIMODE_TABLE_SHARED,
  yomi_funcs,
};

