/* Copyright 1991 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of NEC Corporation
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.  NEC 
 * Corporation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

#include <stdio.h>
#include <signal.h>
#include <iroha/RK.h>
#include <iroha/jrkanji.h>

#define UI_CONNECTION

#define MAX_PROC 128

int proc_id[MAX_PROC];

main()
{
  int i, counter = 0;
  int pid, proc_error(), proc_cont();

  signal(SIGUSR1, proc_error);
  signal(SIGUSR2, proc_cont);

  for (i = 0 ; i < MAX_PROC ; i++) {
    proc_id[i] = 0;
  }

  for (i = 0 ; i < MAX_PROC ; i++) {
    pid = fork();
    if (pid == -1) { /*  */
      fprintf(stderr, "%dܤforkԤޤ\n", i);
      exit_con(1);
    }
    else if (pid == 0) { /* ҥץ */
      JrConnect(i);
      kill(getppid(), SIGUSR2);
      pause();
    }
    else { /* ƥץ */
      proc_id[i] = pid;
      pause();
    }
  }
}

exit_con(val)
int val;
{
  int i;

  for (i = 0 ; i < MAX_PROC && proc_id[i] ; i++) {
    fprintf(stderr, "%d ", proc_id[i]);
  }
  fprintf(stderr, "\n");
  fflush(stderr);

  exit(val);
}

proc_error(sig)
int sig;
/* ARGSUSED */
{
  exit_con(1);
}


RkConnect(n)
int n;
{
  int res, resc1, resc2, resc3;
  res = RkInitialize();
  RkMountDic(res, "iroha", 0);
  resc1 = RkDuplicateContext(res);
  resc2 = RkDuplicateContext(res);
  resc3 = RkDuplicateContext(res);
  fprintf(stderr, "%2d: RkInitialize returns %d, 1: %d, 2: %d, 3: %d\n",
	  n, res, resc1, resc2, resc3);
  fflush(stderr);
  if (res == -1 || resc1 == -1 || resc2 == -1 || resc3 == -1) {
    kill(getppid(), SIGUSR1);
    exit(0);
  }
}


JrConnect(n)
int n;
{
  char aho[200];
  int res, resc1, resc2, resc3;
  res = jrKanjiControl(0, KC_INITIALIZE, 0);
  jrKanjiControl(0, KC_QUERYMODE, aho);
  fprintf(stderr, "%2d: KC_INITIALIZE returns %d\n", n, res);
  fflush(stderr);
  if (res == -1) {
    kill(getppid(), SIGUSR1);
    exit(0);
  }
}

proc_cont(sig)
int sig;
/* ARGSUSED */
{
  signal(SIGUSR2, proc_cont);
  return 0;
}
