/*
 * Copyright 1991 Sony Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Sony not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Sony makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SONY
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Noriyuki Hosoe, Sony Corporation
 */

#include "sj_hinsi.h"

static	struct	hlist {
	int	code;
	char	*str;
} hinsi[] = {
	MEISI_1,	"\226\274\216\214",
	MEISI_1,	"\226\274\202\120",
	MEISI_2,	"\226\274\202\121",
	MEISI_3,	"\226\274\202\122",
	MEISI_4,	"\226\274\202\123",
	MEISI_5,	"\226\274\202\124",
	MEISI_6,	"\226\274\202\125",
	MEISI_7,	"\226\274\202\126",
	MEISI_8,	"\226\274\202\127",
	MEISI_9,	"\226\274\202\130",
	MEISI_10,	"\226\274\202\120\202\117",
	MEISI_11,	"\226\274\202\120\202\120",
	MEISI_20,	"\226\274\202\121\202\117",
	D_MEISI_1,	"\221\343\226\274\216\214",
	D_MEISI_1,	"\221\343\202\120",
	D_MEISI_2,	"\221\343\202\121",
	D_MEISI_3,	"\221\343\202\122",
	D_MEISI_4,	"\221\343\202\123",
	D_MEISI_5,	"\221\343\202\124",
	D_MEISI_6,	"\221\343\202\125",
	MYOUJI,		"\225\143\216\232",
	NAMAE,		"\226\274\221\117",
	KIGYOU,		"\212\351\213\306",
	TIMEI,		"\222\156\226\274",
	KEN_KU,		"\214\247\201\136\213\346\226\274",
	KEN_KU,		"\214\247\213\346",
	RENTAISI,	"\230\101\221\314\216\214",
	RENTAISI,	"\230\101\221\314",
	SETUZOKU,	"\220\332\221\261\216\214",
	SETUZOKU,	"\220\332\221\261",
	KANDOUSI,	"\212\264\223\256",
	JOSUUSI,	"\217\225\220\224\216\214",
	JOSUUSI,	"\217\225\220\224",
	SUUSI,		"\220\224\216\214",
	SETTOU_1,	"\220\332\223\252\214\352",
	SETTOU_1,	"\220\332\223\252\202\120",
	SETTOU_2,	"\220\332\223\252\202\121",
	SETTOU_3,	"\220\332\223\252\202\122",
	SETTOU_4,	"\220\332\223\252\202\123",
	SETTOU_5,	"\220\332\223\252\202\124",
	SETUBI_1,	"\220\332\224\366\214\352",
	SETUBI_1,	"\220\332\224\366\202\120",
	SETUBI_2,	"\220\332\224\366\202\121",
	SETUBI_3,	"\220\332\224\366\202\122",
	SETUBI_4,	"\220\332\224\366\202\123",
	SETUBI_5,	"\220\332\224\366\202\124",
	SETUBI_6,	"\220\332\224\366\202\125",
	SETUBI_7,	"\220\332\224\366\202\126",
	SETUBI_8,	"\220\332\224\366\202\127",
	SETUBI_9,	"\220\332\224\366\202\130",
	FUKUSI_1,	"\225\233\216\214",
	FUKUSI_1,	"\225\233\202\120",
	FUKUSI_2,	"\225\233\202\121",
	FUKUSI_3,	"\225\233\202\122",
	FUKUSI_4,	"\225\233\202\123",
	FUKUSI_5,	"\225\233\202\124",
	FUKUSI_6,	"\225\233\202\125",
	FUKUSI_7,	"\225\233\202\126",
	FUKUSI_8,	"\225\233\202\127",
	FUKUSI_9,	"\225\233\202\130",
	JOSUUSI2,	"\217\225\220\224\202\121",
	KEIYOUSI_1,	"\214\140\227\145\216\214",
	KEIYOUSI_1,	"\214\140\202\120",
	KEIYOUSI_2,	"\214\140\202\121",
	KEIYOUSI_3,	"\214\140\202\122",
	KEIYOUSI_4,	"\214\140\202\123",
	KEIYOUSI_5,	"\214\140\202\124",
	KEIYOUSI_6,	"\214\140\202\125",
	KEIYOUSI_7,	"\214\140\202\126",
	KEIYOUSI_8,	"\214\140\202\127",
	KEIYOUSI_9,	"\214\140\202\130",
	KEIYOUSI_10,	"\214\140\202\120\202\117",
	KEIYOUSI_11,	"\214\140\202\120\202\120",
	KE_DOUSI_1,	"\214\140\227\145\223\256\216\214",
	KE_DOUSI_1,	"\214\140\223\256\202\120",
	KE_DOUSI_2,	"\214\140\223\256\202\121",
	KE_DOUSI_3,	"\214\140\223\256\202\122",
	KE_DOUSI_4,	"\214\140\223\256\202\123",
	KE_DOUSI_5,	"\214\140\223\256\202\124",
	KE_DOUSI_6,	"\214\140\223\256\202\125",
	KE_DOUSI_7,	"\214\140\223\256\202\126",
	KE_DOUSI_8,	"\214\140\223\256\202\127",
	KE_DOUSI_9,	"\214\140\223\256\202\130",
	DO_SAHEN,	"\223\256\201\105\203\124\225\317",
	DO_SAHEN,	"\203\124\225\317",
	DO_ZAHEN,	"\223\256\201\105\203\125\225\317",
	DO_ZAHEN,	"\203\125\225\317",
	DO_1DAN_1,	"\223\256\201\105\210\352\222\151",
	DO_1DAN_1,	"\210\352\222\151\202\120",
	DO_KAGO_1,	"\223\256\201\105\203\112\214\334",
	DO_KAGO_1,	"\203\112\214\334\202\120",
	DO_GAGO_1,	"\223\256\201\105\203\113\214\334",
	DO_GAGO_1,	"\203\113\214\334\202\120",
	DO_SAGO_1,	"\223\256\201\105\203\124\214\334",
	DO_SAGO_1,	"\203\124\214\334\202\120",
	DO_TAGO_1,	"\223\256\201\105\203\136\214\334",
	DO_TAGO_1,	"\203\136\214\334\202\120",
	DO_NAGO_1,	"\223\256\201\105\203\151\214\334",
	DO_NAGO_1,	"\203\151\214\334",
	DO_BAGO_1,	"\223\256\201\105\203\157\214\334",
	DO_BAGO_1,	"\203\157\214\334\202\120",
	DO_MAGO_1,	"\223\256\201\105\203\175\214\334",
	DO_MAGO_1,	"\203\175\214\334\202\120",
	DO_RAGO_1,	"\223\256\201\105\203\211\214\334",
	DO_RAGO_1,	"\203\211\214\334\202\120",
	DO_WAGO_1,	"\223\256\201\105\203\217\214\334",
	DO_WAGO_1,	"\203\217\214\334\202\120",
	DO_1DAN_2,	"\210\352\222\151\202\121",
	DO_KAGO_2,	"\203\112\214\334\202\121",
	DO_GAGO_2,	"\203\113\214\334\202\121",
	DO_SAGO_2,	"\203\124\214\334\202\121",
	DO_TAGO_2,	"\203\136\214\334\202\121",
	DO_BAGO_2,	"\203\157\214\334\202\121",
	DO_MAGO_2,	"\203\175\214\334\202\121",
	DO_RAGO_2,	"\203\211\214\334\202\121",
	DO_WAGO_2,	"\203\217\214\334\202\121",
	DO_KAGO_5,	"\203\112\214\334\202\124",
	DO_GAGO_5,	"\203\113\214\334\202\124",
	DO_SAGO_5,	"\203\124\214\334\202\124",
	DO_TAGO_5,	"\203\136\214\334\202\124",
	DO_BAGO_5,	"\203\157\214\334\202\124",
	DO_MAGO_5,	"\203\175\214\334\202\124",
	DO_RAGO_5,	"\203\211\214\334\202\124",
	DO_WAGO_5,	"\203\217\214\334\202\124",
	DO_KAGO_6,	"\203\112\214\334\202\125",
	DO_GAGO_6,	"\203\113\214\334\202\125",
	DO_SAGO_6,	"\203\124\214\334\202\125",
	DO_TAGO_6,	"\203\136\214\334\202\125",
	DO_BAGO_6,	"\203\157\214\334\202\125",
	DO_MAGO_6,	"\203\175\214\334\202\125",
	DO_RAGO_6,	"\203\211\214\334\202\125",
	DO_WAGO_6,	"\203\217\214\334\202\125",
	DO_1DAN_3,	"\210\352\222\151\202\122",
	DO_KAGO_3,	"\203\112\214\334\202\122",
	DO_GAGO_3,	"\203\113\214\334\202\122",
	DO_SAGO_3,	"\203\124\214\334\202\122",
	DO_TAGO_3,	"\203\136\214\334\202\122",
	DO_BAGO_3,	"\203\157\214\334\202\122",
	DO_MAGO_3,	"\203\175\214\334\202\122",
	DO_RAGO_3,	"\203\211\214\334\202\122",
	DO_WAGO_3,	"\203\217\214\334\202\122",
	DO_1DAN_4,	"\210\352\222\151\202\123",
	DO_KAGO_4,	"\203\112\214\334\202\123",
	DO_GAGO_4,	"\203\113\214\334\202\123",
	DO_SAGO_4,	"\203\124\214\334\202\123",
	DO_TAGO_4,	"\203\136\214\334\202\123",
	DO_BAGO_4,	"\203\157\214\334\202\123",
	DO_MAGO_4,	"\203\175\214\334\202\123",
	DO_RAGO_4,	"\203\211\214\334\202\123",
	DO_WAGO_4,	"\203\217\214\334\202\123",
	DO_KAGO_7,	"\203\112\214\334\202\126",
	DO_GAGO_7,	"\203\113\214\334\202\126",
	DO_SAGO_7,	"\203\124\214\334\202\126",
	DO_TAGO_7,	"\203\136\214\334\202\126",
	DO_BAGO_7,	"\203\157\214\334\202\126",
	DO_MAGO_7,	"\203\175\214\334\202\126",
	DO_RAGO_7,	"\203\211\214\334\202\126",
	DO_WAGO_7,	"\203\217\214\334\202\126",
	DO_KAGO_8,	"\203\112\214\334\202\127",
	DO_GAGO_8,	"\203\113\214\334\202\127",
	DO_SAGO_8,	"\203\124\214\334\202\127",
	DO_TAGO_8,	"\203\136\214\334\202\127",
	DO_BAGO_8,	"\203\157\214\334\202\127",
	DO_MAGO_8,	"\203\175\214\334\202\127",
	DO_RAGO_8,	"\203\211\214\334\202\127",
	DO_WAGO_8,	"\203\217\214\334\202\127",
	SP_SA_MI1,	"\203\124\225\317\226\242\202\120",
	SP_SA_MI2,	"\203\124\225\317\226\242\202\121",
	SP_SA_YOU,	"\203\124\225\317\226\242\227\160",
	SP_SA_SYU,	"\203\124\225\317\217\111\221\314",
	SP_SA_KAT,	"\203\124\225\317\211\274",
	SP_SA_ME1,	"\203\124\225\317\226\275\202\120",
	SP_SA_ME2,	"\203\124\225\317\226\275\202\121",
	SP_KA_MIZ,	"\203\112\225\317\226\242",
	SP_KA_YOU,	"\203\112\225\317\227\160",
	SP_KA_SYU,	"\203\112\225\317\217\111\221\314",
	SP_KA_KAT,	"\203\112\225\317\211\274",
	SP_KA_MEI,	"\203\112\225\317\226\275",
	TEINEI1,	"\222\232\224\112\202\120",
	TEINEI2,	"\222\232\224\112\202\121",
	SP_KA_ONB,	"\203\112\214\334\211\271\225\326",
	SP_FUKUSI,	"\223\301\216\352\225\233",
	AISATU,		"\210\245\216\101",
	SP_KEIYOUSI,	"\223\301\216\352\214\140\227\145",
	TANKANJI,	"\222\120\212\277\216\232",
	TANKANJI,	"\222\120\212\277",
	IKKATU,		"\210\352\212\207",
	0,		0
};

char	*hns2str(code)
int	code;
{
	struct	hlist	*p;

	for (p = hinsi ; p -> code ; p++) {
		if (p -> code == code)
			return p -> str;
	}

	return "ERROR";
}

int	str2hns(str)
char	*str;
{
	struct	hlist	*p;

	for (p = hinsi ; p -> code ; p++) {
		if (strcmp(p -> str, str) == 0)
			return p -> code;
	}

	return 0;
}

