/*
 * Copyright 1991 Sony Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Sony not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Sony makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SONY
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Masaki Takeuchi, Sony Corporation
 */
/*
 *	sj_atbl.c
 *	hankaku/zenkaku - alphabet/katakana conversion table
 *	Copyright (c) 1987 1988 1989 Sony Corporation.
 *	Written by Masaki Takeuchi
 *	Sat May  9 01:44:52 JST 1987
 *
 *	This file is included Shift-JIS code.
 */
/*
 * $Header: sj_atbl.c,v 1.1 91/04/29 17:56:41 masaki Exp $ SONY;
 */

char *Atable[][4] = {
	" ",	"\201\100",	"\201\100",	" ",	/*	0	*/
	"!",	"\201\111",	"\201\111",	"!",	/*	1	*/
	"\"",	"\201\150",	"\201\150",	"\"",	/*	2	*/
	"#",	"\201\224",	"\201\224",	"#",	/*	3	*/
	"$",	"\201\220",	"\201\220",	"$",	/*	4	*/
	"%",	"\201\223",	"\201\223",	"%",	/*	5	*/
	"&",	"\201\225",	"\201\225",	"&",	/*	6	*/
	"'",	"\201\146",	"\201\146",	"'",	/*	7	*/
	"(",	"\201\151",	"\201\151",	"(",	/*	8	*/
	")",	"\201\152",	"\201\152",	")",	/*	9	*/
	"*",	"\201\226",	"\201\226",	"*",	/*	10	*/
	"+",	"\201\173",	"\201\173",	"+",	/*	11	*/
	",",	"\201\103",	"\201\101",	"\244",	/*	12 sp	*/
	"-",	"\201\174",	"\201\133",	"\260",	/*	13 sp	*/
	".",	"\201\104",	"\201\102",	"\241",	/*	14 sp	*/
	"/",	"\201\136",	"\201\136",	"/",	/*	15	*/
	"0",	"\202\117",	"\202\117",	"0",	/*	16	*/
	"1",	"\202\120",	"\202\120",	"1",	/*	17	*/
	"2",	"\202\121",	"\202\121",	"2",	/*	18	*/
	"3",	"\202\122",	"\202\122",	"3",	/*	19	*/
	"4",	"\202\123",	"\202\123",	"4",	/*	20	*/
	"5",	"\202\124",	"\202\124",	"5",	/*	21	*/
	"6",	"\202\125",	"\202\125",	"6",	/*	22	*/
	"7",	"\202\126",	"\202\126",	"7",	/*	23	*/
	"8",	"\202\127",	"\202\127",	"8",	/*	24	*/
	"9",	"\202\130",	"\202\130",	"9",	/*	25	*/
	":",	"\201\106",	"\201\106",	":",	/*	26	*/
	";",	"\201\107",	"\201\107",	";",	/*	27	*/
	"<",	"\201\203",	"\201\203",	"<",	/*	28	*/
	"=",	"\201\201",	"\201\201",	"=",	/*	29	*/
	">",	"\201\204",	"\201\204",	">",	/*	30	*/
	"?",	"\201\110",	"\201\110",	"?",	/*	31	*/
	"@",	"\201\227",	"\201\105",	"\245",	/*	32 sp	*/
	"A",	"\202\140",	"\202\140",	"A",	/*	33	*/
	"B",	"\202\141",	"\202\141",	"B",	/*	34	*/
	"C",	"\202\142",	"\202\142",	"C",	/*	35	*/
	"D",	"\202\143",	"\202\143",	"D",	/*	36	*/
	"E",	"\202\144",	"\202\144",	"E",	/*	37	*/
	"F",	"\202\145",	"\202\145",	"F",	/*	38	*/
	"G",	"\202\146",	"\202\146",	"G",	/*	39	*/
	"H",	"\202\147",	"\202\147",	"H",	/*	40	*/
	"I",	"\202\150",	"\202\150",	"I",	/*	41	*/
	"J",	"\202\151",	"\202\151",	"J",	/*	42	*/
	"K",	"\202\152",	"\202\152",	"K",	/*	43	*/
	"L",	"\202\153",	"\202\153",	"L",	/*	44	*/
	"M",	"\202\154",	"\202\154",	"M",	/*	45	*/
	"N",	"\202\155",	"\202\155",	"N",	/*	46	*/
	"O",	"\202\156",	"\202\156",	"O",	/*	47	*/
	"P",	"\202\157",	"\202\157",	"P",	/*	48	*/
	"Q",	"\202\160",	"\202\160",	"Q",	/*	49	*/
	"R",	"\202\161",	"\202\161",	"R",	/*	50	*/
	"S",	"\202\162",	"\202\162",	"S",	/*	51	*/
	"T",	"\202\163",	"\202\163",	"T",	/*	52	*/
	"U",	"\202\164",	"\202\164",	"U",	/*	53	*/
	"V",	"\202\165",	"\202\165",	"V",	/*	54	*/
	"W",	"\202\166",	"\202\166",	"W",	/*	55	*/
	"X",	"\202\167",	"\202\167",	"X",	/*	56	*/
	"Y",	"\202\170",	"\202\170",	"Y",	/*	57	*/
	"Z",	"\202\171",	"\202\171",	"Z",	/*	58	*/
	"[",	"\201\155",	"\201\165",	"\242",	/*	59 sp	*/
	"\\",	"\201\137",	"\201\217",	"\\",	/*	60 sp	*/
	"]",	"\201\156",	"\201\166",	"\243",	/*	61 sp	*/
	"^",	"\201\117",	"\201\117",	"^",	/*	62	*/
	"_",	"\201\121",	"\201\121",	"_",	/*	63	*/
	"`",	"\201\145",	"\201\145",	"`",	/*	64	*/
	"a",	"\202\201",	"\202\201",	"a",	/*	65	*/
	"b",	"\202\202",	"\202\202",	"b",	/*	66	*/
	"c",	"\202\203",	"\202\203",	"c",	/*	67	*/
	"d",	"\202\204",	"\202\204",	"d",	/*	68	*/
	"e",	"\202\205",	"\202\205",	"e",	/*	69	*/
	"f",	"\202\206",	"\202\206",	"f",	/*	70	*/
	"g",	"\202\207",	"\202\207",	"g",	/*	71	*/
	"h",	"\202\210",	"\202\210",	"h",	/*	72	*/
	"i",	"\202\211",	"\202\211",	"i",	/*	73	*/
	"j",	"\202\212",	"\202\212",	"j",	/*	74	*/
	"k",	"\202\213",	"\202\213",	"k",	/*	75	*/
	"l",	"\202\214",	"\202\214",	"l",	/*	76	*/
	"m",	"\202\215",	"\202\215",	"m",	/*	77	*/
	"n",	"\202\216",	"\202\216",	"n",	/*	78	*/
	"o",	"\202\217",	"\202\217",	"o",	/*	79	*/
	"p",	"\202\220",	"\202\220",	"p",	/*	80	*/
	"q",	"\202\221",	"\202\221",	"q",	/*	81	*/
	"r",	"\202\222",	"\202\222",	"r",	/*	82	*/
	"s",	"\202\223",	"\202\223",	"s",	/*	83	*/
	"t",	"\202\224",	"\202\224",	"t",	/*	84	*/
	"u",	"\202\225",	"\202\225",	"u",	/*	85	*/
	"v",	"\202\226",	"\202\226",	"v",	/*	86	*/
	"w",	"\202\227",	"\202\227",	"w",	/*	87	*/
	"x",	"\202\230",	"\202\230",	"x",	/*	88	*/
	"y",	"\202\231",	"\202\231",	"y",	/*	89	*/
	"z",	"\202\232",	"\202\232",	"z",	/*	90	*/
	"{",	"\201\157",	"\201\157",	"{",	/*	91	*/
	"|",	"\201\142",	"\201\142",	"|",	/*	92	*/
	"}",	"\201\160",	"\201\160",	"}",	/*	93	*/
	"~",	"\201\140",	"\201\140",	"~",	/*	94	*/
	"\336",	"\201\112",	"\201\112",	"\336",	/*	95	*/
	"\337",	"\201\113",	"\201\113",	"\337",	/*	96	*/
	",",	"\201\103",	"\201\101",	"\244",	/*	12 ref	*/
	"-",	"\201\174",	"\201\133",	"\260",	/*	13 ref	*/
	".",	"\201\104",	"\201\102",	"\241",	/*	14 ref	*/
	"@",	"\201\227",	"\201\105",	"\245",	/*	32 ref	*/
	"[",	"\201\155",	"\201\165",	"\242",	/*	59 ref	*/
	"\\",	"\201\137",	"\201\217",	"\\",	/*	60 ref	*/
	"]",	"\201\156",	"\201\166",	"\243",	/*	61 ref	*/
	"-",	"\201\174",	"\201\174",	"-",	/*	add	*/
	".",	"\201\104",	"\201\104",	".",	/*	add	*/
	"",	"",	"",	""
};

sj_atbl_set1 ()
{
	set_atbl (12, "\201\101", "\244");	/*	12 sp	*/
	set_atbl (13, "\201\133", "\260");	/*	13 sp	*/
	set_atbl (14, "\201\102", "\241");	/*	14 sp	*/
	set_atbl (32, "\201\105", "\245");	/*	32 sp	*/
	set_atbl (59, "\201\165", "\242");	/*	59 sp	*/
	set_atbl (60, "\201\217", "\\");	/*	60 sp	*/
	set_atbl (61, "\201\166", "\243");	/*	61 sp	*/
}

sj_atbl_set2 ()
{
	set_atbl (12, "\201\103", ",");	/*	12 sp	*/
	set_atbl (13, "\201\174", "-");	/*	13 sp	*/
	set_atbl (14, "\201\104", ".");	/*	14 sp	*/
	set_atbl (32, "\201\227", "@");	/*	32 sp	*/
	set_atbl (59, "\201\155", "[");	/*	59 sp	*/
	set_atbl (60, "\201\137", "\\");	/*	60 sp	*/
	set_atbl (61, "\201\156", "]");	/*	61 sp	*/
}

set_atbl (n, s1, s2)
int	n;
char	*s1, *s2;
{
	strncpy (Atable[n][2], s1, 2);
	strncpy (Atable[n][3], s2, 1);
}
