/*
 * $Id: rk_read.c,v 1.3 1992/10/22 02:14:11 proj Exp $
 */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/***********************************************************************
			rk_read.c
						88. 6.11   

	rk_main.c ʡѴбɽɤ߹ߤô
***********************************************************************/
/*	Version 3.0
 */
#include "rk_header.h"
#include "rk_extvars.h"
#include <sys/types.h>
#include <sys/stat.h>

letter	onescan(), *rangekettei();
char	*ename();

extern	letter	*ltrgrow(), *ltrend(), letterpick(), *ltr1cut();
extern	char	*chrcat(), *strend();

static int termsscan(), evalandcpy(), eval1cpy(), partscan(),
  evlis(), atermscan(), serfun(), hensrc_tourk(), blankpass(),
  modsrcL(), chkL_get_int();
static void ERRLIN(), ERHOPN(), readhyo(),
  ltr1tostr(), ERRHYO(), vchk(), rangeset(), de_bcksla(), 
  listscan(), singleqscan(), doubleqscan();
extern void BUGreport(), choosehyo(), readmode();
extern int ltrcmp(), ltrstrcmp(), readfnm(), fixednamep();

#define IHENSU (1 << 24) /* ɽξ̣ХȤǡѿɽ */
#define IKANSU (2 << 24) /*	      	      ؿɽ */
#define IMODNM (3 << 24) /*	      	      ⡼̾ɽ */

#define ENDOF_NestFileArea ((FILE *)~0)
	 /** includeեΥǥץǼꥢΥɥޡ*/


 /**	ɤ߹ߡɤ߹ޤʤEOFˤĤä0֤
	âincludeθƤ롣бɽˤ϶ʸʳΥȥʸ
	ǤϺʤΤȤäƤå롣*/
int
readln(buf)
uns_chr *buf;
{
	register uns_chr *p;
	register int	c;

	if(NULL == *base){
		*buf = '\0';
		return(0);
	}

	p = buf;
	while(1){
		while(EOF == (c = getc(*base))){
			fclose(*base);
			if(NULL == *--base){
				c = EOF;
				break;
			}
		}
		if(c == EOF || c == '\n') break;

		if(is_cntrl(c) && !isspace(c)){
			sprintf(hcurread, "\\%03o", c);
			ERRLIN(21);
		}
		*p++ = c;
	}
	*p = '\0';
	return(p != buf || c != EOF);
}

letter	*memptr, *ltrbufptr, *hensumei, *hen_iki, *term, **henptr;
letter	*dummy;
struct	dat	*datptr;
struct	hensuset
{
	unsigned	regdflg : 1;	/* Ͽѿɽ */
	unsigned	curlinflg : 1;	/* ߹Ԥ˴Фѿɽ */
	unsigned	constflg : 1; /* Ȥ줿Ȥɽ */
	letter		*name;
	letter		*range;
} *hentourkptr, *henorg;

 /** Ϳ줿ե뤬ǥ쥯ȥʤ0֤ */
int
isdir(fnm)
char	*fnm;
{
	struct	stat	statbuf;
/*
	return(stat(fnm, &statbuf) == 0 && (statbuf.st_mode & S_IFDIR));
*/
	return(stat(fnm, &statbuf) == 0 && ((statbuf.st_mode & S_IFMT) == S_IFDIR));
}

 /**	nameͿ줿̾Ѵбɽ򥪡ץ󤹤롣̾ȸʤʤ
	̾fixednamep()ȡˤФƤϡѥ򸫤롣ξ硢
	ץ顢ѥ̾ *dirnamptr֤롣¾ξ
	*dirnamptr˶ʸ롣*errcodˤϼΥ顼ɤ롣
	Ϳ줿ե뤬ǥ쥯ȥλ1ʥѥõ3ˡ
	ե򥪡ץǤʤ2Ʊ4ˡ*/
FILE	*trytoopen(name, dirnamptr, errptr)
char	*name, **dirnamptr;
int	*errptr;
{
	char	**src, taio_fnm[REALFN];
	FILE	*opened;

	*dirnamptr = nulstr;
	*errptr = 0;

	if(fixednamep(name)){
		if(isdir(name)){
			*errptr = 1;
			return(NULL);
		}
		if(NULL == (opened = fopen(name, "r"))){
			*errptr = 2;
			return(NULL);
		}
		if(flags & RK_VERBOS){
			fprintf(stderr, "romkan: using Taio-hyo %s ...\r\n",
				name);
		}
		return(opened);
	} else {
		for(src = pathmeiorg; *src != NULL; src++){
			strcpy(taio_fnm, (*dirnamptr = *src));
			strcat(taio_fnm, name);

			if(isdir(taio_fnm)){
				*errptr = 3;
				return(NULL);
			}
			if(NULL == (opened = fopen(taio_fnm, "r"))) continue;

			 /* Now Taio-hyo found */
			if(flags & RK_VERBOS)
				fprintf(stderr,
					"romkan: using Taio-hyo %s ...\r\n",
					taio_fnm);
			return(opened);
		}
		if(flags & RK_VERBOS){ /* Taio-hyo not found */
			char	*p, *q;

			fprintf(stderr, "no %s in", name);
			for(src = pathmeiorg; *src != NULL; src++){
				fputc(' ', stderr);
				q = *src;
				if(*q == KUGIRI && *(q + 1) == '\0') q++;
				 else q = strend(q);
				for(p = *src; p < q; p++)
					fputc(*p, stderr);
			}
			fprintf(stderr, ".\n");
		}
		*dirnamptr = nulstr;
		*errptr = 4;
		return(NULL);
	}
}

 /** ɽɤ߹ */
void
readdata(memory, data, hensudefhyo, modf)
letter	*memory;	/* бɽɽƬϤϤ */
struct	dat	*data;	/* бɽιԤȤΥǡ */
letter	**hensudefhyo;	/* ѿΥǡ */
char	*modf;		/* ⡼ɽ̾ϤΥѥ̾äƤ */
{
	int	i, j;
	char	*hyomeibgn[HYOMAX];
	 /* ɽ̾ؤΥݥ󥿤 */
	char	hyomeimem_[HYOMEI];
	 /* ɽ̾μºݤʸ */
	char	*pathmeibgn[PTHMAX];
	 /* ѥ̾ؤΥݥ󥿤 */
	char	pathmeimem_[PTHMEI];
	 /* ѥ̾μºݤʸ */
	char	modfnm[REALFN];
	 /* ⡼ɽΥե̾򤳤إԤ ΤˤϤΥѥ̾ */

	memptr = memory;
	datptr = data;
	henptr = hensudefhyo;
	*(pathmeiptr = pathmeiorg = pathmeibgn) = NULL;
	*(pathmeimem = pathmeimem_) = '\0';
	*(hyomeiptr = hyomeiorg = hyomeibgn) = NULL;
	*(hyomeimem = hyomeimem_) = '\0';
	*(modmeiptr = modmeibgn) = NULL;
	*(modmeimem = modmeimem_) = '\0';
	*(dspnamptr = dspnambgn) = NULL;
	*(dspcod = dspcod_) = '\0';
	*(naibu = naibu_) = '\0';

	strcpy(modfnm, modf);
	     /* modfnmͿե̾ѥ̾Ϳ줿顢ǥեȤ
		⡼ɽ̾"mode"ĤʤKUGIRIǥ쥯ȥζڤʸ */

	if(*modfnm == '\0' || *(strend(modfnm)) == KUGIRI){
		strcat(modfnm, "mode");
	} else if(isdir(modfnm)){
		chrcat(modfnm, KUGIRI);
		strcat(modfnm, "mode");
	}

	curdir = nulstr;
	readmode(curfnm = modfnm);

	for(i = 0; hyomeiorg[i] != NULL; i++){
		int	err;

		for(j = 0; j < FILNST; j++) nestfile[j] = NULL;
		nestfile[FILNST - 1] = ENDOF_NestFileArea;
		base = nestfile + 1;

		*base = trytoopen(curfnm = hyomeiorg[i], &curdir, &err);
		if(err){
			switch(err){
				case 1:
				case 3: ERHOPN(1);
				case 2:
				case 4: ERHOPN(0);
			}
		}
		readhyo(i);
	}

	hyo_n[i] . data = NULL;
	choosehyo();
}

 /** ե̾ѥ̾ʬƬ֤*/
char	*ename(s)
char	*s;
{
	char	*p;

	p = strrchr(s, KUGIRI);
	return(p == NULL ? s : p + 1);
}

 /**	ե̾ΥåƬʥѥ̾Ͻˤ'1''3'ǤʤȤʤ
	ʤΤʤ13ܡɽζ̤ɽˤ֤Ǥʤ
	0֤*/
int
filnamchk(s)
char	*s;
{
	char	c;

	c = *(ename(s)) - '0';
	return((1 <= c && c <= 3) ? c : 0);
}

 /**	linbufäƤunsigned charletterˤltrbuf롣
	ɥޡEOLTTRˤʤ롣flg0λϡƬζʸФ*/
void
ustrtoltr(linbuf, ltrbuf, flg)
uns_chr *linbuf;
int	flg;
register letter *ltrbuf;
{
	register letter l;

	if(flg){
		while(l = letterpick(&linbuf), is_eolsp(l)){
			if(l == EOLTTR){
				*ltrbuf = EOLTTR;
				return;
			}
		}
		*ltrbuf++ = l;
	}
	while((*ltrbuf++ = letterpick(&linbuf)) != EOLTTR);
}

 /**	letterʸ˥СȡĤΥݥ󥿤ƱϤǤäƤ
	ưݾڤ뤳ȡ*/
void
ltrtostr(ltrbuf, linbuf)
char	*linbuf;
letter	*ltrbuf;
{
	letter	l;

	while((l = *ltrbuf++) != EOLTTR) ltr1tostr(l, &linbuf);
	*linbuf = '\0';
}

 /** letterʸ˥С */
static void
ltr1tostr(l, sptr)
char	**sptr;
letter	l;
{
	int	i;

	for(i = 0; i < 3 && 0 == (l & (0xff000000)); i++) l <<= 8;
	for(; i < 4; i++){
		*(*sptr)++ = (char)(l >> 24);
		l <<= 8;
	}
}

 /** ѿΡָ߹ԴХե饰פƥꥢ */
void
hen_useflgclr(hensu)
struct	hensuset	*hensu;
{
	for(; hensu -> name != NULL; hensu++)
		hensu -> curlinflg = 0; /* ߹Ԥ̤ */
}

 /** бɽɤ߹ */
static void
readhyo(n)
int	n;
{
	uns_chr linbuf[LINSIZ];
	letter	ltrbuf[LINSIZ], *lp;
	letter	termbuf[SIZALL]; /* 顼θơɽΥʬäƤ*/
	letter	dummybuf[TRMSIZ], hensumei_[VARLEN], hen_iki_[SIZALL];
	struct	hensuset	hensu[VARMAX];
	int	m, hyosw, rsltyp[3];

	hcurread = (char *)linbuf; /* 顼 */
	ltrbufbgn = ltrbuf;

	*(hensumei = hensumei_) = EOLTTR;
	*(hen_iki = hen_iki_) = EOLTTR;
	(henorg = hentourkptr = hensu) -> name = NULL;
	dummy = dummybuf;

	hyo_n[n] . hensudef = henptr;
	hyo_n[n] . data = datptr;

	hyosw = hyoshu[n];
	while(readln(linbuf)){
		hen_useflgclr(henorg);
		ustrtoltr(linbuf, ltrbuf, 1);
		ltrbufptr = ltrbuf;

		for(m = 0; termsscan(&ltrbufptr, term = termbuf, 1); m++){
			 /* mϡܤιܤ򸫤Ƥ뤫ɽ */
			if(*term == ';') break; /*  */
			if(m == 3) ERRLIN(15);
			if(m != 0 && rsltyp[0] == 4) ERRLIN(12);

			datptr -> code[m] = memptr;
			if((rsltyp[m] = evalandcpy(&term, m)) == 4){
				if(m) ERRLIN(14);
			 /* Ϻǽιܤˤʤ
			    funstr[]appearե饰ǤåƤ뤬
			    Τ˰ˤåƤ*/
			} else {
			 /* λˤɽؤΥݥ󥿤Ͽʤʤ */
				totail(memptr);
				memptr++;
			}
		}

		if(m != 0 && rsltyp[0] != 4){
			for( /* m=? */ ; m < 3; m++){
				datptr -> code[m] = nil;
				rsltyp[m] = -1; /* doesn't exist */
			}
			datptr++;

 /* rsltyp: 0=ʸ 1=ʸϢ 2=ǡϢ 3=ǽ 4= -1=¸ߤ */
			switch(hyosw){
		   /* ϡɽƤ¤롣򸡺 */
				case 1:
					if(!(rsltyp[0] == 0 &&
					     rsltyp[1] == 0 && 
					     rsltyp[2] == -1
					    ))
						ERRLIN(17);
					break;
				case 2:
					if(rsltyp[1] == 3 && rsltyp[2] != -1)
						ERRLIN(19);
					break;
				case 3:
					if(!(rsltyp[0] == 0 &&
					     (rsltyp[1] == 0 ||
					      rsltyp[1] == 1) &&
					     rsltyp[2] == -1
					    ))
						ERRLIN(18);
					break;
				default:
					BUGreport(10);
			}

		}
	}

	(datptr++) -> code[0] = NULL;

		/* ѿϿǤޤȤƤ */
	for(lp = hen_iki_; lp < hen_iki; ) *memptr++ = *lp++;
	for(hentourkptr = henorg; hentourkptr -> name != NULL;
	    hentourkptr++){
		if(hentourkptr -> regdflg == 0) ERRHYO(0);
		*henptr++ = memptr - (lp - hentourkptr -> range);
	}
	*henptr++ = NULL;

	/*  fclose(*base); סreadlnǤǤ */
}

 /**	ѴбɽιܰĤ򡢲ᤷơΥǡꥢ˥ԡ롣
	֤ͤϡᤷܤʸʤ0ʳʸϢʤ1ʳ
	ǥǡϢʤ2ǽʤ3ʤ4ʳϥ顼*/
static int
evalandcpy(socp, m)
register letter **socp; /* ܤؤΥݥ󥿡ʤؤΥݥ󥿡*/
int	m;   /* бɽβܤιܤ򸫤Ƥ뤫ɽϥ
		ƤȤ0ϥʤ1ХåեĤʤ2 */
{
#define TYPMAX	5

	char	exist[TYPMAX], total;
	 /* existϡ줾쥿04ινиΥե饰eval1cpy()ȡˡ
	    totalΤȤƤνиե饰ɤ⡢1=̤ 2= ¾
	    ϲ2ӥå0 */
	int	type;

#define TIME_0(flag) ((flag) == 1)
#define TIME_1(flag) ((flag) == 2)
#define TIME_n(flag) (((flag) & 3) == 0)

	total = 1;
	for(type = 0; type < TYPMAX; type++) exist[type] = 1;

	while(!is_eolsp(**socp)){
		if(!(0 <= (type = eval1cpy(socp, m, 0)) && type < TYPMAX))
			BUGreport(3);
		exist[type] <<= 1;
		total <<= 1;
	}

	if(TIME_0(total))
		BUGreport(13); /* ܤʤevalandcpyϼ¹ԤʤȦ */
	if(!TIME_0(exist[3]) || !TIME_0(exist[4])){
		if(TIME_n(total)) ERRLIN(9);
		return(type); /* 34typeͤݻƤȦ */
	}
	if(TIME_1(total) && TIME_1(exist[0])) return(0);
	return(!TIME_0(exist[2]) ? 2 : 1);
}

 /**	бɽιܤιĤᤷΥǡꥢ˥ԡ
	Υסʸ=0 ʸ=1 üؿ=2 ǽ=3 =4ˤ
	֤flg0ʤ顢ƵŪ˸ƤФ줿Ȥ̣ξ硢
	߹Ԥ̤Фѿ򸡽Ф饨顼ޤm0ΤȤϥ
	ʳν򸫤Ƥˤ⡢߹Ԥ̤Фѿ򸡽Ф饨顼*/
static int
eval1cpy(socp, m, flg)
letter	**socp; /* flgʳΰΰ̣evalandcpyƱ */
int	m, flg;
{
	letter	t1buf[TRMSIZ], *t1bufp;

	t1bufp = t1buf;

	*memptr = EOLTTR;
	switch(partscan(socp, t1bufp)){
		case 1: /* ñʸ */
			memptr = ltrgrow(memptr, t1bufp);
			*memptr = EOLTTR;
			return(0);
		case 2: /* ʸ */
			t1bufp++;
			*memptr++ = onescan(&t1bufp, dummy);
			*memptr = EOLTTR;
			return(0);
		case 3: /* ʸ */
			t1bufp++;
			while(*t1bufp != '"'){
				*memptr++ = onescan(&t1bufp, dummy);
			}
			*memptr = EOLTTR;
			return(1);
		case 0: /* ꥹ */
			return(evlis(m, &t1bufp, flg));
			 /* evlis *memptr = EOLTTR; 򤷤Ƥ롣*/
		default:
			BUGreport(4);
			return(-1);
			 /*NOTREACHED*/
	}
	/*NOTREACHED*/
}

#define bitchk(x, n) ((x) & (1 << (n)))

#define get_ltr(lp) (*(lp)++)
#define unget_ltr(l, lp) (*--(lp) = (l))

 /** globalʥݥ󥿤ؤƤletter󤫤ʸäƤ롣*/
letter	get1ltr()
{
	return(get_ltr(lptr));
}

letter	unget1ltr(l)
letter	l;
{
	return(unget_ltr(l, lptr));
}

int int_get1ltr() {return((int)(get1ltr()));}
int int_unget1ltr(c) letter c; {return((int)(unget1ltr((letter) c)));}
 /** ȤξʤʤؿηcastǤʤΡ
    (int ()) get1ltrפȽ񤭤 */

 /**	includeե̾letterstring˼ФȤletterν
	ޤ³롣flg & 010ʤ顢'/'Ǥ⽪λ*/
letter	getfrom_dblq(socp, destp, flg)
letter	**socp;
char	**destp;
int	flg;
{
	letter	l;

	while(**socp != EOLTTR && !(flg & 01 && **socp == KUGIRI)){
		if (**socp == '\\') *(*destp)++ = '\\';
		l = onescan(socp, dummy);
		ltr1tostr(l, destp);
	}
	*(*destp)++ = '\0';
	return(**socp);
}

int
getfrom_lptr(sptr, flg)
char	**sptr;
int	flg;
{
	return((int)getfrom_dblq(&lptr, sptr, flg));
}

 /**	ꥹȤᤷɽˤ롣ͤϡΥꥹȤΥפɽ
	ʸѿʸؿ:0 ʸؿ:1 üؿ:2
	ǽ:3 :4 */
static int
evlis(m, socp, flg)
letter	**socp; /* ΰ̣eval1cpy򻲾 */
int	m, flg;
{
	int	fnnum, hennum, i;
	letter	t1buf[TRMSIZ];

	(*socp)++; /* '('򥹥å */
	atermscan(socp, t1buf, 3);

	fnnum = serfun(t1buf);
	if(fnnum != -1 && !bitchk(func[fnnum] . appear, m)) ERRLIN(14);
	 /* mͤˤäơƤϤʤؤνиɤƤ롣*/

	switch(fnnum){ /* defaultνʳ func[fnnum].argnumȤäƤʤ */
		case -1: /* ѿ */
			vchk(t1buf);
			atermscan(socp, dummy, 2); /* ERR */
			hennum = hensrc_tourk(t1buf, ((m==0 && !flg)? 0 : 1));
			*memptr++ = (henorg[hennum] . constflg ? 
				     *(henorg[hennum].range) : hennum|IHENSU);
			break;

		case 0: /* fn No.0 defvar */
			atermscan(socp, t1buf, 3);
			if(*t1buf == '('){
				letter	*soc2, t1buf2[TRMSIZ], t1buf3[TRMSIZ];
				letter	*common_hen;

				atermscan(socp, t1buf3, 3);

				soc2 = t1buf + 1; /* skip '(' */

				atermscan(&soc2, t1buf2, 3);
				vchk(t1buf2);
				if(-1 != serfun(t1buf2)) ERRLIN(11);
				hennum = hensrc_tourk(t1buf2, 2);
				common_hen = rangekettei(hennum, t1buf3);

				while(atermscan(&soc2, t1buf2, 0)){
					vchk(t1buf2);
					if(-1 != serfun(t1buf2)) ERRLIN(11);
					hennum = hensrc_tourk(t1buf2, 2);
					rangeset(hennum, common_hen);
				}
			} else {
				vchk(t1buf);
				if(-1 != serfun(t1buf)) ERRLIN(11);
				hennum = hensrc_tourk(t1buf, 2);
			  /* defvardefconstѿ̾νʣ򤱤뤿 */
				atermscan(socp, t1buf, 3);
				rangekettei(hennum, t1buf);
			}
			atermscan(socp, dummy, 2);
			break;
		case 36: /* fn No.36 defconst */
			atermscan(socp, t1buf, 3);
			vchk(t1buf);
			if(-1 != serfun(t1buf)) ERRLIN(11);

			hennum = hensrc_tourk(t1buf, 6);
			  /* defvardefconstѿ̾ʣ򤱤뤿 */

			rangeset(hennum, hen_iki);

			blankpass(socp, 1);
			if(*(*socp)++ != '\'') ERRLIN(8);
			*hen_iki++ = onescan(socp, dummy);
			(*socp)++; /*'פĤƤ뤳ȤθϺѤǤ*/
			*hen_iki++ = EOLTTR; /* needed? */
			*hen_iki = EOLTTR;

			atermscan(socp, dummy, 2);
			break;

		case 1: /* fn No.1 include */
			{
				char	fnmtmparea[REALFN], *s, *dirnamptr;
				int	dummyc = 0, err;

				blankpass(socp, 1);
				if(3 != partscan(socp, t1buf)) ERRLIN(22);
				atermscan(socp, dummy, 2);
				 /* ;ʬˤERR */

				ltr1cut(lptr = t1buf + 1);
				*(s = fnmtmparea) = '\0';
				err = readfnm(int_get1ltr, int_unget1ltr,
					      getfrom_lptr, &s, &dummyc);

				if(err){
					hcurread = s;
					switch(err){
						case 1:
						case 3: ERRLIN(25);
						case 2: ERRLIN(26);
						case 4: ERRLIN(27);
					}
				}
				de_bcksla(fnmtmparea, fnmtmparea);

				if(*++base == ENDOF_NestFileArea){
					base--;
					ERRLIN(23);
				}
				*base= trytoopen(fnmtmparea, &dirnamptr,&err);
				if(err){
					switch(err){
						case 1:
						case 3:
						case 2:
						case 4: base--;
							ERRLIN(24);
					}
				}
			}
			break;

		 /* ⡼̾Ĥ˼ */
		case 4: /* fn No.46 off,on,switch */
		case 5:
		case 6:
		case 20: /* fn No.20,21 if,unless */
		case 21:
			*memptr++ = fnnum | IKANSU;
			atermscan(socp, t1buf, 3);
			*memptr++ = modsrcL(t1buf) | IMODNM;
			atermscan(socp, t1buf, 2);
			break;

		 /* ⡼̾ʸ ĤĤ˼ */
		case 37: /* fn No.3743 setmodeʤ */
		case 38:
		case 39:
		case 40:
		case 41:
		case 42:
		case 43:
			{
				int	err, n;
				modetyp	stat;

				*memptr++ = fnnum | IKANSU;
				atermscan(socp, t1buf, 3);
				*memptr++ = (n = modsrcL(t1buf))| IMODNM;
				atermscan(socp, t1buf, 3);
				err = chkL_get_int(t1buf, &stat,
							 modesw[n] . moderng);
				if(err != 0) ERRLIN(29);
				*memptr++ = stat;
				atermscan(socp, t1buf, 2);
				break;
			}

		 /* ̡ʰʤΤޤ */
		default: /* toupper,tolower */
			*memptr++ = fnnum | IKANSU;
			*memptr = EOLTTR;
			for(i = 0; i < func[fnnum] . argnum; i++){
				blankpass(socp, 1);
				if(eval1cpy(socp, m, 1) != 0) ERRLIN(13);
			}
			atermscan(socp, dummy, 2); /* ;ʬˤERR */
			break;
	}
	*memptr = EOLTTR;
	return(fnnum == -1 ? 0 : func[fnnum] . fntype);
}

 /** ʸΡ\פȴ */
static void
de_bcksla(s, r)
char	*s, *r;
{
	for(; *s; *r++ = *s++) if(*s == '\\') s++;
	*r = '\0';
}

 /**	defvarshikiˤᤷơѿѰꤹ롣
	ѿκǸ˥ɥޡ롣ͤϡѰǼ
	ؤΥݥ󥿡*/
letter	*rangekettei(num, shiki)
letter	*shiki;
int	num; /* ѰꤷĤĤѿֹ */
{
	letter	hyoukabuf[TRMSIZ];

	rangeset(num, hen_iki);
	*hen_iki = EOLTTR;

	if(*shiki++ != '(') ERRLIN(8);
	atermscan(&shiki, hyoukabuf, 1);

	if(!ltrstrcmp(hyoukabuf, "all")){
		*hen_iki++ = VARRNG;
		*hen_iki++ = 0;
		*hen_iki++ = LTRHUG; /* Ѱʸ */
		*hen_iki++ = EOLTTR;
		*hen_iki = EOLTTR;
		atermscan(&shiki, dummy, 2); /* ;ʬˤERR */
	} else 
	if(!ltrstrcmp(hyoukabuf, "between")){
		int	i;

		*hen_iki++ = VARRNG;
		while(blankpass(&shiki, 1), *shiki != ')'){
			for(i = 1; i <= 2; i++){
				switch(*shiki){
					case '\'':
						shiki++;
						*hen_iki++ =
						       onescan(&shiki, dummy);
						shiki++;
						break;
					case ')':
					case '"':
					case '(': ERRLIN(8);
					default:
						*hen_iki++ = *shiki++;
				}
				if(i < 2){
					if(!is_eolsp(*shiki)) ERRLIN(8);
					blankpass(&shiki, 1);
				}
			}
		}
		*hen_iki++ = EOLTTR;
		*hen_iki = EOLTTR;
	} else
	if(!ltrstrcmp(hyoukabuf, "list")){
		while(blankpass(&shiki, 1), *shiki != ')'){
			switch(*shiki){
				case '"':
				case '(': ERRLIN(8);
				case '\'':
					shiki++;
					*hen_iki++ = onescan(&shiki, dummy);
					shiki++; /* ˡ'פĤƤ뤫
					 ɤθϤ⤦ѤǤ롣*/
					break;
				default:
					*hen_iki++ = *shiki++;
			}
			if(!is_eolsp(*shiki)) ERRLIN(8);
		}
		*hen_iki++ = EOLTTR;
		*hen_iki = EOLTTR;
	} else {
		ERRLIN(8); /* Ϥ¾ιʸͽǤä */
	}

	return(henorg[num] . range);
}

 /**	numܤѿѰؤ٤ݥ󥿤λؤꤷѿ
	Ͽ֤ˤ롣*/
static void
rangeset(num, range)
letter	*range; /* ѰΥݥ */
int	num;
{
	henorg[num] . range = range;
	henorg[num] . regdflg = 1;
}

 /**	nameǻꤵ줿̾ѿõʤϿѿ̾κǸ
	ɥޡ롣
	flg & 010λ̾ѿ߹Ԥ̤Фʤ饨顼constȤ
	Ͽλˡޤ flg & 020λ̾ѿʤ
	顼defvarνʣåѡˡflg & 040ʤconstȤϿ*/
static int
hensrc_tourk(name, flg)
letter	*name;
int	flg;
{
	int	i;

	for(i = 0; henorg[i] . name != NULL; i++){
		if(ltrcmp(henorg[i] . name, name)) continue;
		 /* found */
		if(flg & 04) ERRLIN(28);
		if(flg & 02 && henorg[i] . regdflg != 0) ERRLIN(10);
		if(flg & 01 && henorg[i] . curlinflg == 0 &&
				 henorg[i] . constflg == 0)
			ERRLIN(5);
		henorg[i] . curlinflg = 1;
		return(i);
	}
	if(henorg + i != hentourkptr) BUGreport(5);

	 /* 褿ȤȤϡФѿȤȡflg & 01
	    0ʤ饨顼*/
	if(flg & 01) ERRLIN(5);
	hentourkptr -> name = hensumei;
	hentourkptr -> curlinflg = 1;
	hentourkptr -> regdflg = 0; /* Фrangedef̤Ȧ */
	hentourkptr -> constflg = ((flg & 04) != 0);
	(++hentourkptr) -> name = NULL;
	hensumei = ltrgrow(hensumei, name);
	*++hensumei = EOLTTR;

	return(i);
}

 /** Ȥ߹ߴؿǽ̾ФƤϤֹ򡢤ǤʤΤʤ-1֤ */
static int
serfun(lp)
register letter *lp; /* ؿǽ̾⤷ѿ̾ */
{
	register int	i;

	for(i = 0; func[i] . fnname != NULL; i++){
		if(! ltrstrcmp(lp, func[i] . fnname)) return(i);
	}
	return(-1);
}

 /** ѿ̾Υå ȥ顼 */
static void
vchk(lp)
letter	*lp;
{
	if(is_digit(*lp)) ERRLIN(3);
	for(; *lp != EOLTTR; lp++){
	  /*	if(is_lower(*lp)) *lp = to_upper(*lp);	*/
		if(!is_alnum(*lp) && *lp != '_') ERRLIN(3);
	}
}

 /**	ܤФФ1֤flg0λϡ')'
	Ĥȥ顼';'Ϥǰܰ*/
static int
termsscan(socp, dest, flg)
register letter **socp, *dest;
	 /* socpλؤƤݥ󥿤ؤƤ꤫Фdest롣
	    θ塢socpؤƤݥ󥿤ʤ롣Υե **scan()
	    ȤؿƤʤäƤ롣*/
int	flg;
{
	letter	*bgn;

	bgn = dest;

	if(blankpass(socp, 0) == 0){
		if(flg && **socp == ';'){
			*dest++ = *(*socp)++;
		} else
		while(!is_eolsp(**socp)){
			if(**socp == ')'){
				if(flg) ERRLIN(0);
				break;
			} else {
				partscan(socp, dest);
				totail(dest);
			}
		}
	}

	*dest = EOLTTR;
	return(bgn != dest);
}

 /**	ꥹȰĤñΰޤȤޤФ1֤
	flg1ΤȤ')'Ĥȥ顼
	flg2ΤȤФ饨顼
	flg3ΤȤФ˼Ԥ饨顼*/
static int
atermscan(socp, dest, flg)
register letter **socp, *dest;
int	flg;
{
	letter	*bgn;
	int	found;

	bgn = dest;

	if(blankpass(socp, 0) == 0){
		if(**socp == '('){
			listscan(socp, dest);
			totail(dest);
		} else {
			while(!is_eolsp(**socp) && **socp != '('){
				if(**socp == ')'){
					if(flg == 1) ERRLIN(0);
					break;
				} else {
					partscan(socp, dest);
					totail(dest);
				}
			}
		}
	}

	*dest = EOLTTR;

	found = (bgn != dest);
	if(!found && flg == 3 || found && flg == 2) ERRLIN(7);
	return(found);
}

 /**	ĤФФΤꥹȤʤͤ0ñʸʤ1
	ʸʤ2ʸʤ3*/
static int
partscan(socp, dest)
register letter **socp, *dest;
{
	switch(**socp){
		case '(':
			listscan(socp, dest);
			return(0);
		case '\'':
			singleqscan(socp, dest);
			return(2);
		case '"':
			doubleqscan(socp, dest);
			return(3);
		default:
			*dest++ = *(*socp)++;
			*dest = EOLTTR;
			return(1);
	}
}

 /** 󥰥륯ɽĤФ*/
static void
singleqscan(socp, dest)
letter	**socp, *dest;
{
	*dest++ = *(*socp)++;
	onescan(socp, dest);
	totail(dest);
	if((*dest++ = *(*socp)++) != '\'') ERRLIN(1);

	*dest = EOLTTR;
}

 /** ֥륯ɽĤФ*/
static void
doubleqscan(socp, dest)
letter	**socp, *dest;
{
	*dest++ = *(*socp)++;
	while(**socp != '"'){
		if(**socp == EOLTTR) ERRLIN(1);
		onescan(socp, dest);
		totail(dest);
	}
	*dest++ = *(*socp)++;

	*dest = EOLTTR;
}

 /**	81016ʥѥ饯ºݤΥɤľϤΥå
	ʸȿʳϤФƤñ0֤*/
int
ltov(l)
letter	l;
{
	if(is_upper(l)) return(l - 'A' + 10);
	if(is_lower(l)) return(l - 'a' + 10);
	if(is_digit(l)) return(l - '0'); else return(0);
}

 /** ltovε */
letter	vtol(l)
letter	l;
{
	if(BASEMX <= l) return('*');
	return(l + (l < 10 ? '0' : 'A' - 10));
}

 /**	󥰥롦֥륯ȤǤΰʸФ
	^פˤ륳ȥ륳ɽ\פˤ81016ɽˤ
	б\ɽϡ\odxϿ¤ӡ;ϡפǤ롣*/
letter	onescan(socp, dest)
letter	**socp, *dest;
{
	letter	l, realcode;
	int	digflg;

	switch(realcode = *dest++ = *(*socp)++){
		case '^':
			if(!(' ' <= (l = *(*socp)++) && l < '\177'))ERRLIN(2);
			realcode = ((*dest++ = l) == '?' ? '\177' : l & 0x1f);
			break;
		case '\\':
			digflg = 0;
			switch(**socp){
				case 'n':
					*dest++ = *(*socp)++; realcode = '\n';
					break;
				case 't':
					*dest++ = *(*socp)++; realcode = '\t';
					break;
				case 'b':
					*dest++ = *(*socp)++; realcode = '\b';
					break;
				case 'r':
					*dest++ = *(*socp)++; realcode = '\r';
					break;
				case 'f':
					*dest++ = *(*socp)++; realcode = '\f';
					break;
				case 'e':
				case 'E':
					*dest++ = *(*socp)++; realcode=ESCCHR;
					break;
				case 'o':
					*dest++ = *(*socp)++;
					for(realcode = 0; is_octal(**socp);){
						digflg = 1;
						realcode <<= 3;
						realcode += ltov
						       (*dest++ = *(*socp)++);
					}
					if(!digflg) ERRLIN(2);
					if(**socp== ';') *dest++ = *(*socp)++;
					break;
				case 'x':
					*dest++ = *(*socp)++;
					for(realcode = 0; is_xdigit(**socp);){
						digflg = 1;
						realcode <<= 4;
						realcode += ltov
						       (*dest++ = *(*socp)++);
					}
					if(!digflg) ERRLIN(2);
					if(**socp== ';') *dest++ = *(*socp)++;
					break;
				case 'd':
					*dest++ = *(*socp)++;
					for(realcode = 0; is_digit(**socp);){
						digflg = 1;
						realcode *= 10;
						realcode += ltov
						       (*dest++ = *(*socp)++);
					}
					if(!digflg) ERRLIN(2);
					if(**socp== ';') *dest++ = *(*socp)++;
					break;
				default:
					if(is_octal(**socp)){
						for(realcode = 0;
						    is_octal(**socp);){
							realcode <<= 3;
							realcode += ltov(
							*dest++ = *(*socp)++);
						}
						if(**socp == ';')
							*dest++ = *(*socp)++;
					} else {
						realcode= *dest++= *(*socp)++;
					}
			}
			break;
		default: ;
	}

	*dest = EOLTTR;
	return(realcode);
}
	
 /**	letterƬˤ򥹥åפ롣
	ã顢flg0ΤȤ1֤Ǥʤȥ顼*/
static int
blankpass(pptr, flg)
register letter **pptr;
	 /* letterΥݥ󥿤ؤΥݥ󥿡줬ؤƤΤʤ */
int	flg;
{
	while(is_eolsp(**pptr)){
		if(EOLTTR == **pptr){
			if(flg) ERRLIN(4);
			return(1);
		}
		(*pptr)++;
	}
	return(0);
}

 /** ꥹȰļФ */
static void
listscan(socp, dest)
register letter **socp, *dest;
{
	int	eofreach;

	*dest++ = *(*socp)++; /* = '(' */
	*dest++ = ' ';
	
	while(eofreach = blankpass(socp, 0), **socp != ')'){
		if(eofreach){
			if(! readln((uns_chr *)hcurread)) ERRLIN(20);
			ustrtoltr((uns_chr *)hcurread, (*socp= ltrbufbgn), 1);
			 /* listǹԤڤƤ硢ɲɤ߹ߤ
			    롣uns_chrѤΥХåե⡢letterѤΤΤ⡢
			    ʪƬѤƤΤաޤ
			    顼硢 顼ΰ֤ˤ餺
			    ߹ԤȤɽΤϡǸɤޤ줿ԤΤ*/
		} else {
			termsscan(socp, dest, 0);
			totail(dest);
			*dest++ = ' ';
		}
	}
	*dest++ = *(*socp)++; /* = ')' */
	*dest = EOLTTR;
}

 /** lpǻꤵ줿⡼̾õĤʤȥ顼 */
static int
modsrcL(lp)
letter	*lp;
{
	int	n;

	for(n = 0; modmeibgn[n] != NULL; n++)
		if(!ltrstrcmp(lp, modmeibgn[n])) return(n);

	ERRLIN(16);
	 /*NOTREACHED*/
	return(-1);
}

 /** chk_get_intrk_modread.cˤletter */
static int
chkL_get_int(lp, ip, range)
letter	*lp;
modetyp	*ip;
modetyp range;
{
	int	sgn = 1;
	modetyp	out;

	if(*lp == '-'){
		lp++;
		sgn = -1;
	}
	for(out = 0; *lp != EOLTTR; lp++){
		if(!is_digit(*lp)) return(-1);
#if defined(UX386) || defined(sun386)
		out = out * 10;
#else
		out *= 10;
#endif
		out += ltov(*lp);
	}
	if(range != 0) out %= range;
	if(sgn == -1 && out != 0) out = range - out;
	*ip = out;
	return(0);
}

 /**	ϡɽɤ߹ߤǥä˷ٹ𤹤롼nϥ顼ɡ
	ޤơromkan_initΥ顼ɤȤơlongjmpͳ
	1֤*/

void
ERMOPN(n) /* ⡼ɽץǤʤ */
unsigned int	n;
{
	static	char	*ermes[] = {
 /*  0 */	"Can't open Mode-hyo",
		"Unprintable error"
	};

	if(n >= numberof(ermes)) n = 1;

	fprintf(stderr, "\r\nMode-hyo %s ---\r\n", curfnm);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);
	longjmp(env0, 1);
}

static void
ERHOPN(n) /* ѴбɽץǤʤ */
unsigned int	n;
{
	static	char	*ermes[] = {
 /*  0 */	"Can't open Taio-hyo",
		"Is a directory",
		"Unprintable error"
	};

	if(n >= numberof(ermes)) n = 2;

	fprintf(stderr, "\r\nTaio-hyo %s%s ---\r\n", curdir, curfnm);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);
	longjmp(env0, 1);
}

void
ERRMOD(n) /* ⡼ɽΥ顼 */
unsigned int	n;
{
	static	char	*ermes[] = {
 /*  0 */	"Table incomplete",
		"')' mismatch",
		"Unprintable error",
		"Illegal filename",
		"Illegal modename",
 /*  5 */	"Undefined mode",
		"Illegal content(s) of list",
		"Illegal ^,\\o,\\x or \\d expression",
		"Illegal defmode",
		"Unrecognized keyword",
 /* 10 */	"Incomplete string",
		"Search path specified after filename",
		"Argument must be a string",
		"Can't get home directory",
		"Illegal @-keyword",
 /* 15 */	"User doesn't exist",
		"Illegal character",
		"Defmode or set-path placed wrong"
	};

	if(n >= numberof(ermes)) n = 2;

	fprintf(stderr, "\r\nMode-hyo %s%s ---\r\n%s\r\n",
		curdir, curfnm, mcurread);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);
	fclose(modefile);
	longjmp(env0, 1);
}

static void
ERRLIN(n) /* ѴбɽΥ顼 */
unsigned int	n;
{
	static	char	*ermes[] = {
 /*  0 */	"')' mismatch",
		"Incomplete single-quote or double-quote expression",
		"Illegal ^,\\o,\\x or \\d expression",
		"Illegal variable name",
		"Incomplete line",
 /*  5 */	"Evaluation of unbound variable",
		"Unprintable error",
		"Too many or too few contents of list",
		"Illegal defvar/defconst",
		"Faculity or declaration joined other item(s)",
 /* 10 */	"Duplicate defvar/defconst",
		"Variable/constant name conflicts with Function name",
		"A line contains both declaration and other output item(s)",
		"Argument isn't a letter",
		"Function, faculity or declaration in illegal place",
 /* 15 */	"More than 3 items",
		"Undefined mode",
		"Against the restriction of pre-transform table",
		"Against the restriction of after-transform table",
		"Item comes after faculity",
 /* 20 */	"Incomplete list",
		"Illegal character",
		"Illegal include",
		"Too many levels of 'include' nest",
		"Can't open include file",
 /* 25 */	"Can't get home directory",
		"Illegal @-keyword",
		"User doesn't exist",
		"Constant must be defined before used",
		"Illegal mode status"
	};

	if(n >= numberof(ermes)) n = 6;

	fprintf(stderr, "\r\nTaio-hyo %s%s ---\r\n%s\r\n",
		curdir, curfnm, hcurread);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);

	while(NULL != *base) fclose(*base--);

	longjmp(env0, 1);
}

static void
ERRHYO(n) /* ERRLINƱ͡бɽΥ顼ԤθǤʤ
 Τ򸫤ʤȤ狼ʤꡣνꡢ̤ѿνиפΤߡ*/
unsigned int	n;
{
	static	char	*ermes[] = {
 /*  0 */	"Undefined variable was found",
		"Unprintable error"
	};

	if(n >= numberof(ermes)) n = 1;

	fprintf(stderr, "\r\nTaio-hyo %s%s ---\r\n", curdir, curfnm);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);

	while(NULL != *base) fclose(*base--);

	longjmp(env0, 1);
}
