/*
 * $Id: rk_main.c,v 1.5 1992/07/29 07:17:23 proj Exp $
 */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/***********************************************************************
			rk_main.c
						87.12. 3   

	޻Ѵ¾ϥɤѴץࡣ
	ASCIIɻѤȤƤ롣
	ΥեϡѴΥᥤ롼
***********************************************************************/
/*	Version 3.1	88/06/14	H.HASHIMOTO
 */
#ifndef OMRON_LIB
#include "rk_header.h"
#include "rk_extvars.h"
#ifdef	MULTI
#include "rk_multi.h"
#endif	/*MULTI*/
#endif
#include "rext.h"

#ifdef	MULTI
#define	DISOUT ((cur_rk->flags & RK_NONISE) ? cur_rk->rk_output : cur_rk->disout)
 /* ե饰ͤromkan_init3()ꤵ졢RK_NONISEΥӥåȤͤ
    ɸ0äDISOUTɸͤdisoutrk_outputѤȡ
    ʽLTREOFˤڽФʤâϤɬ֤褦
    Ƥ˸¤ꡢEOLTTR֤ˡ*/

#else	/* !MULTI */
#ifdef KDSP
#	ifdef MVUX
letter	displine[DSPLIN]; /* ǥХå  ɽΰʬ򵭲 */
#	endif
#endif

/* 88/06/02 V3.1 */
static	letter	nil[1] = {EOLTTR};
static	letter	*curdis;
static	int	codein_len;
static	letter	*codeout, *remainkbf;
static	letter	ungetc_buf = EOLTTR; /* romkan_ungetcʸ򤷤ƤХåե */
static	letter	unnext_buf = EOLTTR; /* romkan_unnext		   		  */

static	letter	(*keyin_method)(); /* ؿΥɥ쥹 */
static	int	(*bytcnt_method)(); /* ХȥȴؿΥɥ쥹 */
static	int	(*kbytcnt_method)(); /* ϲѥХȥȴؿΥɥ쥹 */
 
/* ⡼ɽ̾ϤΥѥ̾ˤ¸ */ /* ꤬ø! */
static	char	prv_modfnm[REALFN] = "\0";

#define	DISOUT ((flags & RK_NONISE) ? rk_output : disout)
 /* ե饰ͤromkan_init3()ꤵ졢RK_NONISEΥӥåȤͤ
    ɸ0äDISOUTɸͤdisoutrk_outputѤȡ
    ʽLTREOFˤڽФʤâϤɬ֤褦
    Ƥ˸¤ꡢEOLTTR֤ˡ*/

static /* V3.1 */
char	eofflg; /* romkan_next()LTREOF褿Ȥˡromkan_henkan()1
		   ˤ롣ͤ0ʤѴбɽ(error)̵뤷ơ
		   ܽХåե̤ꥳɤ⡢ŪѴ롣
		   LTREOF褿̤ˤϤФ褦˻ꤵƤ
		   νԤâνϵޤ館Դˡ
		   eofflg2*/

static	letter	evalbuf[2][2][OUTSIZ];
static	letter	delchr, delchr2 = EOLTTR, nisedl; /* DELΥ饯ĤޤǻƤ*/

/* 88/05/31 V3.1 */
static	letter	rk_input;  /* ϡ3ХȤޤǤѹʤб */
static	letter	disout[OUTSIZ];  /* ܽνϤΥХåե */
static	letter	rk_output[OUTSIZ]; /* νϡʺǽϡˤΥХåե */
static	letter	keybuf[KBFSIZ], urabuf[KBFSIZ];  /* ܽХåեȤΰ */
static	int	lastoutlen, lastkbflen;
static	int	hyonum;
#endif	/* MULTI */

static void romkan_delete(), mchevl(), add_at_eof(), free_for_all_area(),
  ltrevlcpy(), set_rubout(), maeato_henkan(), codeout_chg();

/* letter֤ؿڤʰˤcharΤΤ⺮äƤ */

static int	head_bytecount(), p_eq(), hen_ikisrc(), match(),
  henkan_ok(), romkan_restart();
static letter	mchedsrc();
letter	romkan_next(), romkan_unnext();
letter	romkan_getc(), romkan_ungetc(), *romkan_henkan();
letter	to_zenalpha(), to_zenhira(), to_zenkata();
 /* to_zenhira;kata ʸޤȤˤʤ*/

static letter	*ltrcpy(lp1, lp2)
fast	letter	*lp1, *lp2;	/* V3.1 */
{
	fast	letter	*org;	/* V3.1 */

	org = lp1;
	while((*lp1++ = *lp2++) != EOLTTR);
	return(org);
}

static letter	*ltrncpy(lp1, lp2, n) /* 'EOLTTR'򥻥å */
letter	*lp1, *lp2;
int	n;	
{
	fast	letter	*org;

	org = lp1;
	for(; n; --n) if(EOLTTR == (*lp1++ = *lp2++)) return(org);
	*lp1 = EOLTTR;
	return(org);
}

 /** letter˰ʸĤʤ */
static /* V3.1 */
letter	*ltr1cat(lp, l)
fast	letter	*lp, l;	/* V3.1 */
{
	fast	letter	*org;	/* V3.1 */

	org = lp;
	totail(lp);
	*lp++ = l;
	*lp = EOLTTR;
	return(org);
}

 /** ʸ˰ʸĤʤ롣ltr1catchar */
#ifdef OMRON_LIB
static
#endif
char	*chrcat(s, c)
fast	char	*s, c;	/* V3.1 */
{
	fast	char	*org;	/* V3.1 */

	org = s;
	strtail(s);
	*s++ = c;
	*s = '\0';
	return(org);
}

static letter	*ltrcat(lp1, lp2)
fast	letter	*lp1, *lp2;	/* V3.1 */
{
	fast	letter	*org;	/* V3.1 */

	org = lp1;
	totail(lp1);
	ltrcpy(lp1, lp2);
	return(org);
}

 /** letterlp2γǤκǾ̥ӥåȤΩƤƤ顢lp1θˤĤʤ롣*/
static /* V3.1 */
letter	*bitup_ltrcat(lp1, lp2)
fast	letter	*lp1, *lp2;	/* V3.1 */
{
	fast	letter	*org;	/* V3.1 */

	org = lp1;
	totail(lp1);

	while((*lp1 = *lp2++) != EOLTTR) *lp1++ |= HG1BIT;
	 /** lp2 ƤκǾ̥ӥåȤΩƤ롣*lp2NISEBP(rk_spclval.h
	     define)ʤɤΤȤϺǽ餫Ǿ̤ΩäƤ뤫褤 */

	return(org);
}

 /** ltrcatȡ̤ʸ˥ݥ󥿤äƤ*/
#ifdef OMRON_LIB
static
#endif
letter	*ltrgrow(lp1, lp2)
fast	letter	*lp1, *lp2;	/* V3.1 */
{
	totail(lp1);
	while((*lp1 = *lp2++) != EOLTTR) lp1++;
	return(lp1);
}

int
ltrlen(lp)
fast	letter	*lp;	/* V3.1 */
{
	fast	letter	*org;	/* V3.1 */

	for(org = lp; *lp != EOLTTR; lp++);
	return(lp - org);
}

 /**	letterκǸʸؤΥݥ󥿤֤âʸФƤ
	Τޤ֤*/
static
letter	*ltrend(lp)
fast	letter	*lp;	/* V3.1 */
{
	return((*lp != EOLTTR) ? (lp + ltrlen(lp) - 1) : lp);
}

 /**	ʸκǸʸؤΥݥ󥿤֤ltrend()charǡltrend()
	Ʊ͡ʸΤȤ㤬롣*/
#ifdef OMRON_LIB
static
#endif
char	*strend(s)
fast	char	*s;	/* V3.1 */
{
	return(*s ? (s + strlen(s) - 1) : s);
}

int
ltrcmp(lp1, lp2)
fast	letter	*lp1, *lp2;	/* V3.1 */
{
	for(; *lp1 == *lp2; lp1++, lp2++) if(*lp1 == EOLTTR) return(0);
	return(*lp1 > *lp2 ? 1 : -1);
}

#ifdef nodef
int
ltrncmp(lp1, lp2, n)
letter	*lp1, *lp2;
int	n;	
{
	for(; n && *lp1 == *lp2; n--, lp1++, lp2++)
		if(*lp1 == EOLTTR) return(0);
	return(n == 0 ? 0 : (*lp1 > *lp2 ? 1 : -1));
}

/* 88/06/14 V3.1 */
/******************************************************************************/
#ifndef OMRON
letter	*ltr_index(lp, l)
letter	l, *lp;
{
	for(; *lp != EOLTTR; lp++) if(*lp == l) return(lp);
	return(NULL);
}
#endif
/******************************************************************************/
#endif

static /* V3.1 */
letter	*ltr_rindex(lp, l)
fast	letter	l, *lp;	/* V3.1 */
{
	fast	letter	*lp2;	/* V3.1 */

	for(lp += ltrlen(lp2 = lp); lp2 != lp; ) if(*--lp == l) return(lp);
	return(NULL);
}

 /** ʸʸ򥫥åȤ롣*/
/*static V3.1 */
letter	*ltr1cut(lp)
fast	letter	*lp;	/* V3.1 */
{
	fast	int	l;	/* V3.1 */

	if(0 == (l = ltrlen(lp))) BUGreport(0); /* Illegal POP */
	*(lp + --l) = EOLTTR;
	return(lp);
}

 /** letterΰʸĹʸѴ */
static /* V3.1 */
letter	*ltr_to_ltrseq(lp, l)
letter	*lp, l;
{
	*lp++ = l;
	*lp-- = EOLTTR;
	return(lp);
}

 /** char󤫤letterļФâ'\0'EOLTTRѤ */
#ifdef OMRON_LIB
static
#endif
letter	letterpick(lbfpptr)
fast uns_chr	**lbfpptr;
{
	fast letter	l = 0;
	fast	int	i;	/* V3.1 */

	for(i = (*(cur_rk_table->bytcnt_method))(*lbfpptr); i; i--)
		l = (l << 8) + *(*lbfpptr)++;
	return(l == 0 ? EOLTTR : l);
}

 /**	Ϥ줿ɤʸñ̤ˤޤȤ롣âEOFLTREOFrk_spclval.h
	ˤˤѤ롣*/
letter	romkan_next()
{
	letter	in;
	int	i, n;
	uns_chr	c;

	  /* unnextƤϡФ*/
	if(cur_rk->unnext_buf != EOLTTR)
		return(in = cur_rk->unnext_buf, cur_rk->unnext_buf = EOLTTR, in);

	if( (letter)EOF == (in = (*(cur_rk->keyin_method))() )) return(LTREOF);
	c = (in &= 0xff);
	n = (*(cur_rk->kbytcnt_method))(&c);
	for(i = 1; i < n; i++) in = (in << 8) + ((*(cur_rk->keyin_method))() & 0xff);
	return(in);
}

 /*	letterʸ l charʸ c ӡɥޡƱΡletter
	ɥޡEOLTTRcharΤ'\0'ˤפȤߤʤ*/
#define	ltrchreq(l, c) ((l) == (c) && (c) != 0 || (l) == EOLTTR && (c) == 0)

 /** letterʸcharʸ â羮ӤʤȤƤ */
#ifdef OMRON_LIB
static
#endif
int
ltrstrcmp(l, s)
fast	 letter	*l;	/* V3.1 */
fast	 char	*s;	/* V3.1 */
{
	for(; ltrchreq(*l, *s); l++, s++) if(*s == 0) return(0);
	return(1);
/*
	return((*l < (uns_chr)*s || *l == EOLTTR)? -1 : 1);
*/
}

 /** Ǹ˥ޥåʸ ĤޤurabufκǸ塣urabufEOLTTR֤ */
static /* V3.1 */
letter	lastmch()
{
	return(*(ltrend(cur_rk->urabuf)));
}

/* end of 'letter' functions */


 /** ѴХåեΥꥢ */
 /* ա romkan_clear()Ƥֻϡɬˡcur_rk򥻥åȤ뤳 */
void	romkan_clear()
{
#ifdef KDSP
#	ifdef MVUX
	*displine = EOLTTR;
#	endif
#endif
	cur_rk->ungetc_buf = *(cur_rk->keybuf) = *(cur_rk->urabuf) = *(cur_rk->disout) = *(cur_rk->rk_output) = EOLTTR;
	cur_rk->curdis = DISOUT;
	cur_rk->lastoutlen = cur_rk->lastkbflen = 0;
}

 /**	WnnV4.0ޥ饤ѤRomkan¤Τ **/
Romkan *
rk_buf_init()
{
	register Romkan	*p;
	register int i;

	if ((p = (Romkan *)malloc(sizeof(Romkan))) == NULL) {
		return(NULL);
	}
	malloc_for_henmatch(&(p->rk_henmatch),
			    cur_rk_table->rk_hensuudef.count);
	malloc_for_modesw(&(p->rk_modesw),
			  cur_rk_table->rk_modesw.max);
	p->rk_modesw.max = cur_rk_table->rk_modesw.max;
	p->rk_modesw.count = cur_rk_table->rk_modesw.count;
	for (i = 0; i < cur_rk_table->rk_modesw.max; i++) {
		p->rk_modesw.point[i] = cur_rk_table->rk_modesw.point[i];
	}
	malloc_for_usehyo(&(p->rk_usehyo), cur_rk_table->rk_usehyo.size);
	p->rk_usehyo.size = cur_rk_table->rk_usehyo.size;
	for (i = 0; i < (cur_rk_table->rk_usehyo.size + 1); i++) {
		p->rk_usehyo.usemaehyo[i] = cur_rk_table->rk_usehyo.usemaehyo[i];
		p->rk_usehyo.usehyo[i] = cur_rk_table->rk_usehyo.usehyo[i];
		p->rk_usehyo.useatohyo[i] = cur_rk_table->rk_usehyo.useatohyo[i];
	}
	p->rk_errstat = NULL;
	p->flags = 0;
	p->nil[0] = EOLTTR;
	p->ungetc_buf = EOLTTR;
	p->unnext_buf = EOLTTR;
	p->delchr2 = EOLTTR;
	p->ebf_sw = NULL;
	p->oneletter[0] = p->oneletter[1] = EOLTTR;
	p->keybuf[0] = p->urabuf[0] = p->disout[0] = p->rk_output[0] = EOLTTR;
	p->rk_table = (RomkanTable *)NULL;
	return(p);
}

RomkanTable *
rk_table_buf_init()
{
	RomkanTable	*p;
	if ((p = (RomkanTable *)malloc(sizeof(RomkanTable))) == NULL) {
		return(NULL);
	}
	p->flags = 0;
	p->rk_usehyo.size = -1;
	p->prv_modfnm[0] = NULL;
	return(p);
}


void
rk_close(p)
Romkan	*p;
{
	/*free_for_all_area();*/	/* V3.1 */
	free_for_modesw(&(p->rk_modesw));
	free_for_henmatch(&(p->rk_henmatch));
	free_for_usehyo(&(p->rk_usehyo));
	free(p);
}

 /**	ɽɤ߹Ѵν򤹤롣part 3*/
 /* WnnV4.0ޥ饤Ȥξ
	romkan_init3ϡRomkan¤ΤؤΥݥ󥿤֤ޤ
	θ塢romkan򤹤ϡХѿcur_rk
	Υݥ󥿤ʤФʤʤ 
	âromkan_init3()ϡǰŪcur_rk򥻥åȤ
	return˸ͤᤷޤ */

/* 88/06/13 V3.1 */
 /** ѴɽΥꥢ */
static /* V3.1 */
void
romkan_reset()
{
	if (cur_rk_table->rk_modenaibu.org != NULL) {
		cur_rk_table->rk_modenaibu.org[0] = 0;	/* Terminator */
	}
	choosehyo();
	romkan_clear();
}


RomkanTable *
romkan_table_init(p, modhyo, bytcntfn, flags_)
RomkanTable *p;
fast char	*modhyo;	/* ⡼ɽ̾ϤΥѥ̾ */
fast int	(*bytcntfn)();	/* Хȥȴؿ */
fast int	flags_;
{
	int	head_bytecount(); /* ǥեȤΥХȥȴؿ */
	int	errcod; /* ν1Τ */
	fast RomkanTable	*tmp_cur_rk_table;
	fast RomkanTable	*rk_table_buf;

	tmp_cur_rk_table = cur_rk_table;
	if (p == NULL) {
		if ((rk_table_buf = (RomkanTable *)rk_table_buf_init()) == NULL) {
			return(NULL);
		}
	} else {
		rk_table_buf = p;
	}
	cur_rk_table = rk_table_buf;
	cur_rk_table->bytcnt_method = (bytcntfn == NULL ? head_bytecount : bytcntfn);
	/* 88/05/30/ V3.1 */
	if (modhyo == NULL)
		modhyo = "";
	strcpy(cur_rk_table->prv_modfnm, modhyo);	/* V3.1 */
	if((errcod = setjmp(cur_rk_table->env0)) != 0){
		/* 88/06/13 V3.1 */
		free_for_all_area();	/* V3.1 */
		fprintf(stderr,"romkan_init failed.");
	} else {
		readdata(modhyo);	/* 88/06/08 V3.1 */
	}
	cur_rk_table = tmp_cur_rk_table;
	if (!errcod) {
		return(rk_table_buf);
	} else {
		free(rk_table_buf);
		return(NULL);
	}
}


 /**	ɽɤ߹Ѵν򤹤롣part 3*/

Romkan *
romkan_init3
(delchr_, nisedl_, delchr2_, keyinfn, bytcntfn, kbytcntfn, restartf,
 flags_)
letter	delchr_;	/* DELȤƻȤ */
letter	nisedl_;	/* DELȤƻȤ */
letter	delchr2_;	/* DELȤƻȤɤĤ礽Τ⤦ */
letter	(*keyinfn)();	/* ؿ */
int	(*bytcntfn)();	/* Хȥȴؿ */
int	(*kbytcntfn)();	/* βѥХȥȴؿNULLλ
			   bytcntfnƱΤȤ */
char	restartf;
 /*	romkan_restart()⤫ƤФ줿Ωĥե饰줬ΩĤȡХåե
	ꥢ˺Ѥޤλϥ顼лΥå⾯ۤʤ */
int	flags_;
 /* ʲΥե饰Ѳġrk_spclval.hˤ
	RK_CHMOUT:⡼ɥ󥸤Τ餻륳ɤ֤
	RK_KEYACK:Фɬ֤
	RK_NONISE:ɤФʤ褦ˤ뤫
	RK_REDRAW:Wnnüե饰redrawѤΥե饰Фɤ
	RK_SIMPLD:deleteưñˤ뤫
 */
{
	Romkan	*tmp_cur_rk;
	Romkan	*rk_buf;

	tmp_cur_rk = cur_rk;

	if(setjmp(cur_rk_table->env0) != 0){
		return(NULL);
	}

	if ((rk_buf = (Romkan *)rk_buf_init()) == NULL) {
		return(NULL);
	}
	cur_rk = rk_buf;
	 /* ɤФromkan_clearǻȤΤǡե饰
	    ˤäƤʤȤʤ*/
	cur_rk->flags = flags_;
	cur_rk->curdis = DISOUT;


	cur_rk->keyin_method = keyinfn;
	cur_rk->bytcnt_method = (bytcntfn == NULL ? head_bytecount : bytcntfn);
	cur_rk->kbytcnt_method = (kbytcntfn == NULL ? cur_rk->bytcnt_method : kbytcntfn);

	cur_rk->delchr = delchr_;
	cur_rk->nisedl = nisedl_;
	cur_rk->delchr2 = delchr2_;
 /**	¤DELΥ饯ĤޤǻƤ롣ܡdelchr2ϡ̤
	ȤͤEOLTTRˤ̵뤵롣ʳϡdelchr2Ϥ
	delchrϤ줿ΤƱ񤤤򤹤롣*/

	choosehyo();
	cur_rk = tmp_cur_rk;
	return(rk_buf);
}

#define ifflg(a, b) ((a) ? (b) : 0)

 /**	ɽɤ߹Ѵν򤹤롣part 2: ϤФɬ
	֤褦ˤ뤫Хåե򥯥ꥢ뤫ɤʤɤġ*/

Romkan *
romkan_init2
(delchr_, chmoutf, keyinfn, bytcntfn, keyackf, restartf, nonisecodf)
char	chmoutf, keyackf, restartf, nonisecodf;
letter	delchr_;
letter	(*keyinfn)();
int	(*bytcntfn)(); /* ξܺ٤romkan_init3򻲾 */
{
	return(romkan_init3(delchr_, toNISE(delchr_), EOLTTR,
			    keyinfn, bytcntfn, (int (*)())NULL,
			    restartf,
			    ifflg(chmoutf, RK_CHMOUT) |
			    ifflg(keyackf, RK_KEYACK) |
			    ifflg(nonisecodf, RK_NONISE)));
}

 /**	ɽɤ߹Ѵν򤹤롣part 1*/
Romkan *
romkan_init(delchr_, chmoutf, keyinfn, bytcntfn)
char	chmoutf;
letter	delchr_;
letter	(*keyinfn)();
int	(*bytcntfn)(); /* ξܺ٤romkan_init3򻲾 */
{
	return(romkan_init2(delchr_, chmoutf, keyinfn, bytcntfn,
			    0, 0, 0));
}


 /**	ХȥȴؿΥǥեȡsλؤƤäƤΤ
	Хȥɤ֤
	romkan_nextաǤϡХȥȴؿͤ
	ΰʸܤˤΤ߰¸ȲꤷƤ롣*/
static /* V3.1 */
int
head_bytecount(s)
fast uns_chr	*s;
{
	fast uns_chr c = *s;
#ifdef IKIS
	return((c <= 0xa0 || c == 0xff)? 1 : 2);
#else
	return((c <= 0xa0 && c != HNKAK1 || c == 0xff)? 1 : 2);
#endif
}

 /** Ѵ줿ʸ缡֤ */
letter	romkan_getc()
{
	fast	letter	l;	/* V3.1 */

	  /* ungetcƤϡФ*/
	if(cur_rk->ungetc_buf != EOLTTR)
		return(l = cur_rk->ungetc_buf, cur_rk->ungetc_buf = EOLTTR, l);

	while(*(cur_rk->curdis) == EOLTTR){
		 /* romkan_next()ͤLTREOFλ⡢Τޤɤ*/
		cur_rk->curdis = romkan_henkan(romkan_next());

		 /* keyackflg0ʤ顢󤬤ɬ֤
		    ᡢ֤٤ΤʤEOLTTR֤Ȥˤ롣*/
		if(cur_rk->flags & RK_KEYACK) break;
	}

	if(EOLTTR != (l = *(cur_rk->curdis))) cur_rk->curdis++;
	return(l);
	 /* ʪʸʤ顢HG1BITΩäƤ롣*/
	 /* ̤ʥ(㤨еBEEPȤNISEBP)֤Ȥ롣
	    rk_spclval.hƤ롣*/
}

 /**	romkan_getcβ̴ؿȤơϤʸä
	Ѵ̤ʸϤ롣*/
letter	*romkan_henkan(mae_in)
letter	mae_in;
{
	letter	mae_out[2], *p;

	/* if(*(cur_rk->curdis) != EOLTTR){p = cur_rk->curdis; cur_rk->curdis = cur_rk->nil; return(p);} */
	/* Ǥmae_in̵뤵 */
	cur_rk->curdis = cur_rk->nil;

	  /* ؤϤϾˤʸ */
	mae_out[0] = mae_out[1] = EOLTTR;

	cur_rk->eofflg = cur_rk->rk_errstat = 0;
	*(cur_rk->rk_output) = *(cur_rk->disout) = EOLTTR;

	maeato_henkan(mae_in, mae_out, cur_rk->rk_usehyo.usemaehyo);
	cur_rk->rk_input = *mae_out;

	if(cur_rk->rk_input == LTREOF){
		 /* LTREOF褿硢(error)̵뤷ܽХåե
		    Ѵ롣Τeofflg1ˤ롣θ塢̤
		    ˡLTREOF褿̥ɡʻꤵƤСˤȡ
		    LTREOFĤʤ*/
		cur_rk->eofflg = 1;
		match();

		cur_rk->eofflg = 2;
		add_at_eof(); /* codeoutˡLTREOF褿Фɤ롣*/
		ltr1cat(cur_rk->codeout, LTREOF);

		ltrcat(cur_rk->disout, cur_rk->codeout);
		ltrcat(cur_rk->rk_output, cur_rk->codeout);
	} else if(cur_rk->rk_input == EOLTTR){
		 /* EOLTTR褿⡢ƱͤνԤLTREOF
		    Ĥʤʤʤromkan_getc()ƤǤ
		    ʤromkan_next()EOLTTR֤ʤˡ*/
		cur_rk->eofflg = 1;
		match();
	} else if(cur_rk->rk_input == cur_rk->delchr
		|| cur_rk->rk_input == cur_rk->delchr2){
	    /* delchr2̤ʤ餽ͤEOLTTRʤΤrk_inputʤ*/
		romkan_delete(cur_rk->rk_input);	/* V3.1 */
	} else {
		ltr1cat(cur_rk->keybuf, cur_rk->rk_input);
		ltr1cat(cur_rk->disout, toNISE(cur_rk->rk_input));
		match();
	}

	if(!(cur_rk->flags & RK_CHMOUT)){
	   /* chmoutflg0λϡCHMSIGФʤ*/
		for(p = DISOUT; ; p++){
			while(*p == CHMSIG) ltrcpy(p, p + 1);
			if(*p == EOLTTR) break;
		}
	}

	if((cur_rk->flags & RK_REDRAW)
	&& NULL != (p = ltr_rindex(cur_rk->disout, cur_rk->nisedl))){
		for(p++; *p != EOLTTR || (ltr1cat(cur_rk->disout, REDRAW), 0); p++)
			if(!isSPCL(*p)) break;
	}
	 /* wnnredrawΥե饰ΩäƤơdisoutnisedlʸü쥳ɤΤ
	    ǽäƤ顢REDRAWФơWnnѴԤredraw򤵤롣*/

	return(DISOUT);
}


/******************************************************************************/
 /* ǥХåѴؿ */
#ifdef	KDSP
#	ifdef	MVUX

pridbg2(a, b, c)
char	*a, *c;
letter	*b;
{
	printf("%s", a); dump_fordbg(b); printf("%s", c);
}

ltr_displen(l)
letter	l;
{
	while(l >= 256) l >>= 8;

	if(l == 0) return(0);
	if(l < ' ') return(0);
	if(168 <= l && l <= 170) return(1);
	return(l > 160 ? 2 : 1);
}

dump_fordbg(lp)
letter	*lp;
{
	while(*lp != EOLTTR) printf("%x/", *lp++);
}

print_fordbg(lp)
letter	*lp;
{
	while(*lp != EOLTTR) putletter(*lp++ & ~HG1BIT);
}

print_ltrseq(lp)
letter	*lp;
{
	while(*lp != EOLTTR) print_ltr(*lp++ & ~HG1BIT);
}

print_ltr(l)
letter	l;
{
	letter	*disptail;
	int	i;

	if(!isSPCL(l)) l &= ~HG1BIT;

	if(l == CHMSIG)
#ifdef CHMDSP
		printf("...mode=%s\n",romkan_dispmode())
#endif
		;
	else
#define BEEPCH	'\007'
#define NEWLIN	'\n'
	if(l == BEEPCH || l == NISEBP) putchar(BEEPCH);
	else
	if(l == NEWLIN){
		*(cur_rk->displine) = *(cur_rk->keybuf) = *(cur_rk->urabuf) = EOLTTR;
		cur_rk->lastoutlen = cur_rk->lastkbflen = 0;
		putchar(l);
	}
	else
	if(l == cur_rk->delchr || l == cur_rk->nisedl){
		if(*(cur_rk->displine) == EOLTTR) putchar(BEEPCH);
		 else {
			disptail = ltrend(cur_rk->displine);
			for(i = ltr_displen(*disptail); i; i--)
				printf("\031 \031");
			*disptail = EOLTTR;
		}
	}
	else {
		ltr1cat(cur_rk->displine, l);
		putletter(l);
	}
}

#	endif /* of #ifdef MVUX */
#endif
/* ǥХåѴؿ */


/* 88/06/10 V3.1 */
 /** DELϤ줿Ȥν򤹤 */
static /* V3.1 */
void
romkan_delete(input_del)
letter	input_del;
{
	if(ltrlen(cur_rk->keybuf) > ((cur_rk->flags & RK_SIMPLD) ? 0 : cur_rk->lastkbflen)){
		ltr1cut(cur_rk->keybuf);
		set_rubout(cur_rk->disout, 1, cur_rk->nisedl);
	} else {
		if(*(cur_rk->urabuf) != EOLTTR && !(cur_rk->flags & RK_SIMPLD)){
			ltr1cut(ltrcpy(cur_rk->keybuf, cur_rk->urabuf));
			*(cur_rk->urabuf) = EOLTTR;

			set_rubout(cur_rk->rk_output, cur_rk->lastoutlen, input_del);

			set_rubout(cur_rk->disout, cur_rk->lastkbflen, cur_rk->nisedl);
			bitup_ltrcat(ltrcat(cur_rk->disout, cur_rk->rk_output), cur_rk->keybuf);

			cur_rk->lastkbflen = cur_rk->lastoutlen = 0;
		} else {
			set_rubout(cur_rk->disout, 1, input_del);
			set_rubout(cur_rk->rk_output, 1, input_del);
		}
	}
}

 /**	letter lp1  lp2 Υޥåߤ롣ͤϡlp1lp2Ƭ
	פλ -1lp1ޤϤƬlp2פΤȤϰĹlp2
	ʸλޤࡣξͤ0ˡʳ -2
	lp2¦˼ޤޤƤɾ򤹤롣lp1¦ˤϼޤǤϤ */
static /* V3.1 */
int
prefixp(lp1, lp2)
letter	*lp1, *lp2;
{
	/* 1ԥޥå뤴Ȥˡޤmatch򥯥ꥢƤ顣
	   Ĥޤꡢrk_henmatch.point[0].ltrmch = EOLTTR; ȤƤ*/

	fast	 int	mch_len = 0, d_len;	/* V3.1 */

	for(;;){
		if(*lp2 == EOLTTR) return(mch_len);
		if(*lp1 == EOLTTR) return(-1);
		if((d_len = p_eq(&lp2, &lp1)) < 0) return(d_len);
		mch_len += d_len;
	}
}

 /** numܤѿˤʸȥޥåƤȲꤷơʸ֤ */
static /* V3.1 */
letter	mchedsrc(num)
fast	int	num;	/* V3.1 */
{
	fast	matchpair	*pairptr;	/* V3.1 */

	if (cur_rk->rk_henmatch.size <= 0) return(0);
	for(pairptr = cur_rk->rk_henmatch.point; pairptr -> ltrmch != EOLTTR; pairptr++){
		if(num == pairptr -> hennum)
			return(pairptr -> ltrmch);
	}
	return(BUGreport(8), 0);
}

 /**	numܤѿʸ l ȥޥå뤫Ĵ٤롣ѿunboundä
	 l bind롣ޥå(bindλޤ)1ʤ0֤ */
static /* V3.1 */
int
mchsrc(num, l)
fast	int	num;	/* V3.1 */
fast	letter	l;	/* V3.1 */
{
	fast	matchpair	*pairptr;	/* V3.1 */

	if(hen_ikisrc(num, l) == 0) return(0);
	if (cur_rk->rk_henmatch.size <= 0) return(0);
	for(pairptr = cur_rk->rk_henmatch.point; pairptr -> ltrmch != EOLTTR; pairptr++){
		if(num == pairptr -> hennum)
			return(pairptr -> ltrmch == l);
	}

	pairptr -> ltrmch = l;
	pairptr -> hennum = num;
	(++pairptr) -> ltrmch = EOLTTR;
	return(1);
}

 /**	l1pñ̤äɾʸl2Ȱפ뤫ɤ֤ɾ
	̤ʸˤʤʤä顢פʤ*/
static /* V3.1 */
int
l_eq(l1p, l2)
letter	*l1p, l2;
{
	letter	evlrsl[RSLMAX];

	switch(SHUBET(*l1p)){
		case 0:	return(*l1p == l2);
		case 1:	return(mchsrc((int)LWRMSK(*l1p), l2));
		case 2:
			mchevl(&l1p, evlrsl);
			return(evlrsl[0] == l2 && evlrsl[1] == EOLTTR);
		default:
			return(BUGreport(1), 0);
	}
}

 /**	prefixpǻ  âνϵաʤޤޤ줦Τl1pp¦
	Τߡl1ppñ̤֤äɾΤl2ppΥޥåߤ롣
	l2ppޤϤƬȥޥåаĹ֤l1ppɾ̤ʸ
	λޤࡣξͤ0ˡդl1ppɾ̤Ƭl2ppޥ
	 -1֤ޥåԤͤ -2*/
static /* V3.1 */
int
p_eq(l1pp, l2pp)
fast	 letter	**l1pp, **l2pp;	/* V3.1 */
{
	int	num;
	letter	evlrsl[RSLMAX], *rslptr;
	fast	 int	retval = -2;	/* V3.1 */

	 /*  l2pp¦ˤϼޤޤʤȦ */
	if(!is_HON(**l2pp)){
	    /*	if(is_HON(**l1pp)) retval = p_eq(l2pp, l1pp); else  */
		BUGreport(9);
	} else {
		switch(SHUBET(**l1pp)){
			case 0:	/* ʸƱ */
				retval = (*(*l1pp)++ == *(*l2pp)++ ? 1 : -2);
				break;
			case 1:	/* ѿʸ */
				num = LWRMSK(*(*l1pp)++);
				retval = (mchsrc(num, *(*l2pp)++) ? 1 : -2);
				break;
			case 2:	/* ʸ */
				mchevl(l1pp, rslptr = evlrsl);
				for(retval = 0; *rslptr != EOLTTR; retval++){
					if(**l2pp == EOLTTR){
						retval = -1; break;
					} else if(*rslptr++ != *(*l2pp)++){
						retval = -2; break;
					}
				}
				break;
			default:
				BUGreport(2);
		}
	}

	return(retval);
}

 /** l1pñɾl2p */
#ifdef	MULTI


#define XY2INT(X, Y) (((X) << 24) | (Y)) /* 줬󤷤YɾʤȤ
	¸ƽ񤤤Ƥս꤬  ա */

 /** l1pñɾl2p */
static
void
mchevl(l1pp, l2p)
letter	**l1pp, *l2p;
{
	letter	*l1p, tmpevl[RSLMAX];

	l1p = *l1pp;

	switch(SHUBET(*l1p)){
		case 0: *l2p++ = *l1p++; break;
		case 1: *l2p++ = mchedsrc((int)LWRMSK(*l1p++)); break;
		case 2:	 /* toupper, tolower, error,  */
			switch(LWRMSK(*l1p++)){
				case 2: mchevl(&l1p, tmpevl);
					*l2p++ = to_upper(*tmpevl);
					break;
				case 3: mchevl(&l1p, tmpevl);
					*l2p++ = to_lower(*tmpevl);
					break;
				case 4:
					*l2p++ = CHMSIG;
				        *l2p++ = *l1p++;
					*l2p++ = 0; break; /* EOLǤϤʤ */
				case 5:
					*l2p++ = CHMSIG;
				        *l2p++ = *l1p++;
					*l2p++ = 1; break;
				case 6:
					*l2p++ = CHMSIG;
					*l2p++ = *l1p++;
					*l2p++ = 2; break;
				case 7:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_updown(*tmpevl);
					break;
				case 8:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_zenalpha(*tmpevl);
					break;
				case 9:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_hira(*tmpevl);
					break;
				case 10:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_kata(*tmpevl);
					break;
				case 11:
					mchevl(&l1p, tmpevl);
					to_hankata(*tmpevl, &l2p);
					break; /* ü */
				case 12:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_zenhira(*tmpevl);
					break;
				case 13:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_zenkata(*tmpevl);
					break;
				case 14:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p += *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 15:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p -= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 16:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p *= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 17:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					if(! *tmpevl) *l2p = LTRHUG;
					 else *l2p /= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 18:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					if(! *tmpevl) *l2p = LTRHUG;
					 else *l2p %= *tmpevl;
					LWRCUT(*l2p++);
					break;
				 /* 192130ϡȶʸ
				    ǤʤUNUSDCʸȤ֤*/
				case 19:
					mchevl(&l1p, tmpevl);
					if(lastmch() != *tmpevl)
						*l2p++ = UNUSDC;
					break;
				case 20:
					if(! (cur_rk->rk_modesw.point)[LWRMSK(*l1p++)])
						*l2p++ = UNUSDC;
					break;
				case 21:
					if(cur_rk->rk_modesw.point[LWRMSK(*l1p++)])
						*l2p++ = UNUSDC;
					break;
				case 22:
					*l2p++ = REASIG;
					break;
				case 23:
					*l2p++ = cur_rk->delchr;
					break;
				case 24:
					*l2p++ = CHMSIG;
					*l2p++ = 0; /* ǡallפɽ */
					*l2p++ = 0; break;
				case 25:
					*l2p++ = CHMSIG;
					*l2p++ = 0;
					*l2p++ = 1; break;
				case 26:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p &= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 27:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p |= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 28:
					mchevl(&l1p, tmpevl);
					*l2p = ~(*tmpevl);
					LWRCUT(*l2p++);
					break;
				case 29:
					*l2p++ = URBFCL;
					break;
				case 30:
					if(cur_rk->eofflg != 2 || *(cur_rk->keybuf) != EOLTTR)
						*l2p++ = UNUSDC;
					break;
				case 31:
					{
						letter	code, basenum;

						mchevl(&l1p, tmpevl);
						code = *tmpevl;
						mchevl(&l1p, tmpevl);
						if((basenum = *tmpevl) <= 1 ||
						   BASEMX < basenum)
							basenum = 10;
						to_digit(code, basenum, &l2p);
					}
					break;
				case 32:
					mchevl(&l1p, tmpevl);
					dakuadd(*tmpevl, &l2p);
					break; /* ü */
				case 33:
					mchevl(&l1p, tmpevl);
					handakuadd(*tmpevl, &l2p);
					break; /* ü */
				case 34:
					mchevl(&l1p, tmpevl);
					*l2p++ = ltov(*tmpevl);
					break;
				case 35:
					*l2p++ = ERRCOD;
					break;
			     /*	case 36: omitted */
				case 37:
					*l2p++ = CHMSIG;
/*
					*l2p++ = LWRMSK(*l1p++);
*/
				        *l2p++ = *l1p++;
					*l2p++ = *l1p++; break;
				case 38:
					*l2p++ = CHMSIG;
					*l2p++ = XY2INT(2, LWRMSK(*l1p++));
					*l2p++ = *l1p++; break;
				case 39:
					*l2p++ = CHMSIG;
					*l2p++ = XY2INT(3, LWRMSK(*l1p++));
					*l2p++ = *l1p++; break;
				case 40:
					{
						letter	modnum;

						modnum = LWRMSK(*l1p++);
						if(cur_rk->rk_modesw.point[modnum] !=
						   *l1p++)
							*l2p++ = UNUSDC;
						break;
					}
				case 41:
					{
						letter	modnum;

						modnum = LWRMSK(*l1p++);
						if(cur_rk->rk_modesw.point[modnum] ==
						   *l1p++)
							*l2p++ = UNUSDC;
						break;
					}
				case 42:
					{
						letter	modnum;

						modnum = LWRMSK(*l1p++);
						if(cur_rk->rk_modesw.point[modnum] >=
						   *l1p++)
							*l2p++ = UNUSDC;
						break;
					}
				case 43:
					{
						letter	modnum;

						modnum = LWRMSK(*l1p++);
						if(cur_rk->rk_modesw.point[modnum] <=
						   *l1p++)
							*l2p++ = UNUSDC;
						break;
					}
				case 44:
					mchevl(&l1p, tmpevl);
					*l2p++ = SENDCH;
					*l2p++ = *tmpevl;
					break;
				default:/* case 0ڤӾ嵭ʳ */;
					BUGreport(7);
			}
	}

	*l2p = EOLTTR;
	*l1pp = l1p;
}
#else	/*!MULTI*/
static /* V3.1 */
mchevl(l1pp, l2p)
letter	**l1pp, *l2p;
{
	letter	*l1p, tmpevl[RSLMAX];

	l1p = *l1pp;

	switch(SHUBET(*l1p)){
		case 0: *l2p++ = *l1p++; break;
		case 1:	*l2p++ = mchedsrc((int)LWRMSK(*l1p++)); break;
		case 2:  /* toupper, tolower, error,  */
			switch(LWRMSK(*l1p++)){
				case 1:	mchevl(&l1p, tmpevl);
					*l2p++ = to_upper(*tmpevl);
					break;
				case 2:	mchevl(&l1p, tmpevl);
					*l2p++ = to_lower(*tmpevl);
					break;
				case 3: *l2p++ = ERRCOD;
					break;
				case 4:
					*l2p++ = CHMSIG;
					*l2p++ = *l1p++;
					*l2p++ = 0; break; /* EOLǤϤʤ */
				case 5:
					*l2p++ = CHMSIG;
					*l2p++ = *l1p++;
					*l2p++ = 1; break;
				case 6:
					*l2p++ = CHMSIG;
					*l2p++ = *l1p++;
					*l2p++ = 2; break;
				case 7:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_updown(*tmpevl);
					break;
				case 8:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_zenalpha(*tmpevl);
					break;
				case 9:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_hira(*tmpevl);
					break;
				case 10:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_kata(*tmpevl);
					break;
				case 11:
					mchevl(&l1p, tmpevl);
					to_hankata(*tmpevl, &l2p);
					break; /* ü */
				case 12:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_zenhira(*tmpevl);
					break;
				case 13:
					mchevl(&l1p, tmpevl);
					*l2p++ = to_zenkata(*tmpevl);
					break;
				case 14:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p += *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 15:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p -= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 16:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p *= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 17:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					if(! *tmpevl) *l2p = LTRHUG;
					 else *l2p /= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 18:
					mchevl(&l1p, tmpevl);
					*l2p++ = ltov(*tmpevl);
					break;
				 /* 192130ϡȶʸ
				    ǤʤUNUSDCʸȤ֤*/
				case 19:
					mchevl(&l1p, tmpevl);
					if(lastmch() != *tmpevl)
						*l2p++ = UNUSDC;
					break;
				case 20:
					if(!(cur_rk->rk_modesw.point)[LWRMSK(*l1p++)])
						*l2p++ = UNUSDC;
					break;
				case 21:
					if(cur_rk->rk_modesw.point[LWRMSK(*l1p++)])
						*l2p++ = UNUSDC;
					break;
				case 22:
					*l2p++ = REASIG;
					break;
				case 23:
					*l2p++ = cur_rk->delchr;
					break;
				case 24:
					*l2p++ = CHMSIG;
					*l2p++ = 0; /* ǡallפɽ */
					*l2p++ = 0; break;
				case 25:
					*l2p++ = CHMSIG;
					*l2p++ = 0;
					*l2p++ = 1; break;
				case 26:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p &= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 27:
					mchevl(&l1p, tmpevl);
					*l2p = *tmpevl;
					mchevl(&l1p, tmpevl);
					*l2p |= *tmpevl;
					LWRCUT(*l2p++);
					break;
				case 28:
					mchevl(&l1p, tmpevl);
					*l2p = ~(*tmpevl);
					LWRCUT(*l2p++);
					break;
				case 29:
					*l2p++ = URBFCL;
					break;
				case 30:
					if(cur_rk->eofflg != 2 || *(cur_rk->keybuf) != EOLTTR)
						*l2p++ = UNUSDC;
					break;
				case 31:
					{
						letter	code, basenum;

						mchevl(&l1p, tmpevl);
						code = *tmpevl;
						mchevl(&l1p, tmpevl);
						if((basenum = *tmpevl) <= 1 ||
						   BASEMX < basenum)
							basenum = 10;
						to_digit(code, basenum, &l2p);
					}
					break;
				case 32:
					mchevl(&l1p, tmpevl);
					dakuadd(*tmpevl, &l2p);
					break; /* ü */
				case 33:
					mchevl(&l1p, tmpevl);
					handakuadd(*tmpevl, &l2p);
					break; /* ü */
				default:/* case 0ڤӾ嵭ʹ */;
					BUGreport(7);
			}
	}

	*l2p = EOLTTR;
	*l1pp = l1p;
}
#endif	/*!MULTI*/

 /** numܤѿѰ褬ʸ l ޤफɤ֤ */
static /* V3.1 */
int
hen_ikisrc(num, l)
int	num;
letter	l;
{
	fast	letter	*defptr;	/* V3.1 */

	defptr = cur_rk_table->rk_hyo.point[cur_rk->hyonum].hensudef[num];	/* V3.1 */
	if(*defptr == VARRNG){
		for(defptr++; *defptr != EOLTTR; )
			if(*defptr++ <= l && l <= *defptr++) return(1);
		return(0);
	}

	for(; *defptr != EOLTTR; defptr++){
		if(l == *defptr) return(1);
	}
	return(0);
}

 /**	ѴΥᥤ롼ܽԤĤǤ˸äƤ롣
	ʤߤϡromkan_getcβ̴ؿromkan_henkanǡ
	δؿƤˤäƤ롣
	δؿϡromkan_nextʸ٤˸ƤФ롣ƤӽФ줿ľ
	output϶ʸdisoutˤϥɰʸäƤ롣
	δؿʸ󤬡romkan_henkanϤꡢ
	romkan_getcϡʸȤʬ򤷤֤
	(error)ǥ顼줿0֤ｪλ1֤ */
static /* V3.1 */
int
match()
{
	int	henkanflg = 0, okcode = 0, chm_exist;
	letter	*q;	/* V3.1 */
	letter	urabufcreate[KBFSIZ], orgkeybuf[KBFSIZ];
	letter	*urabufjunbi, *outcutptr, *dis_end;
	/* 88/03/01/ V3.1 */
	letter	nokoribuf[KBFSIZ];

	if(*(cur_rk->keybuf) == EOLTTR){
		*(cur_rk->urabuf) = EOLTTR;
		return(1);
	}

	ltrcpy(urabufjunbi = orgkeybuf, cur_rk->keybuf);
	outcutptr = cur_rk->rk_output;

	while((okcode = henkan_ok()) > 0){
		henkanflg = 1;

		codeout_chg();
		ltrcat(cur_rk->rk_output, cur_rk->codeout);
		/* 88/03/01/ V3.1 */
		/*
		p = keybuf + codein_len;

		ltrcat(ltrcpy(keybuf, remainkbf), p);
		*/
		ltrcpy(nokoribuf, cur_rk->keybuf + cur_rk->codein_len);
		ltrcat(ltrcpy(cur_rk->keybuf, cur_rk->remainkbf), nokoribuf);

		if(okcode == 2){
			ltrcpy(urabufjunbi = urabufcreate, cur_rk->keybuf);
			totail(outcutptr);
		}
	}

	if(okcode == 0){
		ltr1cut(ltrcpy(cur_rk->keybuf, orgkeybuf));
		ltr_to_ltrseq(cur_rk->disout, NISEBP);
		*(cur_rk->rk_output) = EOLTTR;
		return(0);
	}
	if(henkanflg){
		ltrcpy(cur_rk->urabuf, urabufjunbi);

		set_rubout(cur_rk->disout, ltrlen(orgkeybuf) - 1, cur_rk->nisedl);

		dis_end = cur_rk->disout;
		totail(dis_end);
		ltrcpy(dis_end, cur_rk->rk_output);

		 /* ⡼ɥ󥸤ľΤ餻뤿 CHMSIG
		    romkan_chmack(1)äƤʤȡȤǰʸĤ
		    ʬ򤹤ǡCHMSIG򥫥åȡˡ
		    ârk_outputϡCHMSIGȴ
		    ޤCHMSIGˣ󤷤Ϥʤ
		    ʣʾ夢äƤ⡢ˤޤȤơ֤ˡ*/
		for(chm_exist = 0, q = cur_rk->rk_output; ; q++){
			while(*q == CHMSIG){
				chm_exist = 1;
				if(ltrcpy(q, q + 1) < outcutptr) outcutptr--;
			}
			if(*q == EOLTTR) break;
		}
		if(chm_exist){
		 /* CHMSIG򣱤ĤˤޤȤ᤿Τdis_endˤĤʤľ
		    ifʸ򥫥åȤСCHMSIGΤȤޤȤϤʤ */
			ltr1cat(ltrcpy(dis_end, cur_rk->rk_output), CHMSIG);
		}

		bitup_ltrcat(cur_rk->disout, cur_rk->keybuf);
		cur_rk->lastoutlen = ltrlen(outcutptr);
		cur_rk->lastkbflen = ltrlen(cur_rk->keybuf);
	}
	return(1);
}

 /**	LTREOFäȤˡФ褦˻ꤵƤ뤫Ĵ٤ơ
	codeout򤽤η̤ʸʻ꤬ʤäˤ˥ݥȤ롣
	Ķޤ館ǡü쥳ϰ̵뤹롣*/
static /* V3.1 */
void
add_at_eof()
{
	fast	dat	*datptr;	/* V3.1 */
	fast	int	i;			/* V3.1 */
	fast	int	hyoseq;			/* V3.1 */
	letter	*p;
	letter	evlrsl[RSLMAX];

	/* 88/06/14 V3.1 */
	for (hyoseq = 0;
	    cur_rk_table->rk_hyo.point != NULL && (cur_rk->hyonum = cur_rk->rk_usehyo.usehyo[hyoseq]) != -1;
								hyoseq++) {
		for (i = 0, datptr = cur_rk_table->rk_hyo.point[cur_rk->hyonum].data;
				    (p = datptr[i].code[0]) != NULL; i++) {
			if (cur_rk->rk_henmatch.size > 0) {
			cur_rk->rk_henmatch.point[0].ltrmch = EOLTTR;
			}
			while(*p != EOLTTR){
				switch(SHUBET(*p)){
					case 0:	/* ʸ */
					case 1:	/* ѿ */
					 /* 餬ϡNULLȤ
					    ޥåʤ*/
						goto Pass;
					case 2:	/*  */
						mchevl(&p, evlrsl);
						if(*evlrsl != EOLTTR)
							goto Pass;
					 /* ϥˡɾ
					    ʸˤʤΤ¾ˤϤʤ
					    Ȥ*/
				}
			}

			ltrevlcpy(cur_rk->codeout = p = cur_rk->evalbuf[0][0],
				  datptr[i] . code[1]);
			while(*p != EOLTTR){
				if(isSPCL(*p)) ltrcpy(p, p + 1);
				 else p++;
			}
			codeout_chg();
			return;

Pass:			;
		}
	}
	cur_rk->codeout = cur_rk->nil;
}

/* 88/06/02 V3.1 */
 /**	numܤΥ⡼ɤ󥸤Ѵɽľ mod ͤ0ʤ
	⡼ɤoff1ʤon2ʤڤؤ롣mod͡01ˤ֤*/
static
int
chgmod(num, mod)
int	num, mod;
{
	fast	int	oldmod;	/* V3.1 */

	oldmod = cur_rk->rk_modesw.point[num];
	cur_rk->rk_modesw.point[num] = (mod != 2 ? mod : !oldmod);
	choosehyo();
	return(oldmod);
}

 /** ⡼ɤmod1ʤon0ʤoffڤ괹롣2ʤswitch롣*/
static
void
allchgmod(mod)
int	mod;
{
	fast	int	i;	/* V3.1 */

	/* 88/06/07 V3.1 */
	for(i = 0; i < cur_rk->rk_modesw.count; i++)
		cur_rk->rk_modesw.point[i] = (mod != 2 ? mod : !(cur_rk->rk_modesw.point[i]));
	choosehyo();
}

 /**	ޥåߤ롣ͤϡޥåƳꤷ1ʥ⡼ɥ󥸤
	äƤ2ˡޥå̤λ-1ޥåʤä0
	¹ϡѿ l ˡޤǤ˰פĹκǹ⵭ϿƤꡢ
	ĹפΤĤ뤴Ȥˡ򹹿롣lͤϡޥå
	ƤƤ0ˤʤ뤳Ȥ⤢롣p_eq() ڤ prefixp() ʸ򻲾ȡ*/
static /* V3.1 */
int
henkan_ok()
{
	fast	dat	*datptr;	/* V3.1 */
	fast	int	i, k;			/* V3.1 */
	fast	int	l, j, hyoseq;		/* V3.1 */
	char	urabuf_clrf; /* ⡼ɥ󥸤ʤɤǡurabuf򥯥ꥢɬפ
				Ϥ줬Ωη̡henkan_ok()
				1֤٤Ȥ2֤򸫤ơ
				match()urabufʤɤĴ򤹤롣*/
	fast	letter	*p;	/* V3.1 */
#ifndef	MULTI
	static	char	ebf_sw = 0;	/* V3.1 */
	static	letter	oneletter[2] = {EOLTTR, EOLTTR};	/* V3.1 */
#endif	/*!MULTI*/

	if(*(cur_rk->keybuf) == EOLTTR) return(-1);

	/* 88/06/14 V3.1 */
	for (l = -1, hyoseq = 0;
			cur_rk_table->rk_hyo.point != NULL && cur_rk->rk_usehyo.usehyo != NULL &&
			(cur_rk->hyonum = cur_rk->rk_usehyo.usehyo[hyoseq]) != -1; hyoseq++) {
		for (i = 0, datptr = cur_rk_table->rk_hyo.point[cur_rk->hyonum].data;
					(p = datptr[i].code[0]) != NULL; i++) {
			if (cur_rk->rk_henmatch.size > 0) {
			cur_rk->rk_henmatch.point[0].ltrmch = EOLTTR;
			}
			switch(k = prefixp(cur_rk->keybuf, p)){
				case -2: break;
				case -1:
					if(cur_rk->eofflg != 0) break;
				 /* eofflgΩäƤ顢̤βǽ
				    ΤƤ롣*/

					return(-1);
				default:
					if(k > l){
						cur_rk->ebf_sw = !cur_rk->ebf_sw;
						for(j = 1; j <= 2; j++){
							ltrevlcpy(
							 cur_rk->evalbuf[cur_rk->ebf_sw][j-1],
							 datptr[i] . code[j]);
						}

						l = k;
					}
			}
		}
	}

	if(l >= 0){
		cur_rk->codein_len = l;
		cur_rk->codeout = cur_rk->evalbuf[cur_rk->ebf_sw][0];
		cur_rk->remainkbf = cur_rk->evalbuf[cur_rk->ebf_sw][1];

		for(urabuf_clrf = 0, p = cur_rk->codeout; *p != EOLTTR; p++){
			switch(*p){
				case CHMSIG:
					 /* codeout1,2Хܤ
					    ⡼ֹȥåäƤ */
					if(*(p + 1) == 0)
						allchgmod((int)*(p + 2));
					 else chgmod((int)LWRMSK(*(p + 1)),
						     (int)*(p + 2));
					ltrcpy(p + 1, p + 3);
					 /* CHMSIGĤ1,2Хcut */

					urabuf_clrf = 1;
					break;
				case URBFCL:
				 /* urabufΥꥢŪ˻ꤹ */
					urabuf_clrf = 1;
					ltrcpy(p, p + 1);
					p--; /* ʸˤ뤿ᡢ
						forʸ p++ 껦ơ
						Ʊ⤦ٸ롣*/
					break;
			}
		}

		if(*(cur_rk->codeout) == ERRCOD){
			if(cur_rk->eofflg == 0){
				cur_rk->rk_errstat = 1;
				return(0);
			}

			 /* (error)ǤäơeofflgΩäƤ顢keybuf
			    ޤǡΤޤ޽Ф*/
			cur_rk->codein_len = ltrlen(cur_rk->keybuf);
			cur_rk->codeout = ltrcpy(cur_rk->evalbuf[cur_rk->ebf_sw][0], cur_rk->keybuf);
			cur_rk->remainkbf = cur_rk->nil;
			cur_rk->rk_errstat = 2;

			return(1);
		}
	   /* (error)ñȤǤ񤱤ʤΤǡ顼ФϤǽʬ*/

		if(*(cur_rk->codeout) == REASIG){
			*(cur_rk->codeout) = (romkan_restart() != 0 ? EOLTTR : CHMSIG);
			 /* readǥä⡼ɥ󥸤ΤϤʤ */

			urabuf_clrf = 1;
		}
	   /* ɽκreadâ줬äȤ򳰤Τ餻ΤCHMSIG
	      ΥɤΤΤϳؽФʤ(restart)ϡ(error)Ʊ͡
	      ñȤǤ񤱤ʤΤǡФϤǽʬ*/

		return(urabuf_clrf ? 2 : 1);
	}

	 /* ɽ˸ƤʤɤϤΤޤ֤ */

	cur_rk->codein_len = 1;
	*(cur_rk->codeout = cur_rk->oneletter) = *(cur_rk->keybuf);
	cur_rk->remainkbf = cur_rk->nil;
	return(1);
}

static
void
free_for_all_area()
{
	fast	int	i;

	free_for_modetable_struct(&(cur_rk_table->rk_defmode));
	free_for_modetable_struct(&(cur_rk_table->rk_taiouhyo));
	free_for_modetable_struct(&(cur_rk_table->rk_path));
	free_for_modebuf(&(cur_rk_table->rk_modebuf));
	free_for_hyobuf(&(cur_rk_table->rk_hyobuf));
	free_for_heniki(&(cur_rk_table->rk_heniki));
	free_for_hensuu(&(cur_rk_table->rk_hensuu));

	free_for_modetable_struct(&(cur_rk_table->rk_dspmode));
	/* free_for_modesw(&(cur_rk_table->rk_modesw)); */
	free_for_modenaibu(&(cur_rk_table->rk_modenaibu));
	for (i = 0; i < cur_rk_table->rk_hyo.size; i++) {
		free_for_hyo_area(&(cur_rk_table->rk_hyo), i);
	}
	free_for_hyo(&(cur_rk_table->rk_hyo));
	/* free_for_usehyo(&(cur_rk_table->rk_usehyo)); */
	free_for_hensuudef(&(cur_rk_table->rk_hensuudef));
	/* free_for_henmatch(&(cur_rk_table->rk_henmatch)); */
}

/* 88/06/10 V3.1 */
 /* romkan_restartǻȤޥ */
#define taihi(X, Y) {(X) = (Y);}
#define clear(X, N) {memset((char *)(&(X)), 0, (N));}
#define recov(X, Y) taihi((Y), (X))

 /**	ɽưŪɤ߹ߤ򤹤롣ߤɽ򤷡Ʊ
	ǥ쥯ȥʤˡߤΤȤˤɽɤ߹ࡣ⤷
	ɤ߹˥顼򸡽ФСȤǡ褷0֤*/
static /* V3.1 */
int
romkan_restart()
{
	fast	int	i/*, j*/;	/* V3.1 */

	modenaibutable	rk_modenaibu_sv;
	modeswtable	rk_modesw_sv;
	modetable	rk_dspmode_sv;
	hyotable	rk_hyo_sv;
	/* usehyotable	rk_usehyo_sv; */
	hensuudeftable	rk_hensuudef_sv;
	/* matchtable	rk_henmatch_sv; */

	/* char	*dspmod_sv[2][2]; */

	/*  */
	taihi(rk_modenaibu_sv,		cur_rk_table->rk_modenaibu);
	taihi(rk_modesw_sv,		cur_rk_table->rk_modesw);
	taihi(rk_dspmode_sv,		cur_rk_table->rk_dspmode);
	taihi(rk_hyo_sv,		cur_rk_table->rk_hyo);
	/* taihi(rk_usehyo_sv,		cur_rk_table->rk_usehyo); */
	taihi(rk_hensuudef_sv,		cur_rk_table->rk_hensuudef);
	/* taihi(rk_henmatch_sv,		cur_rk_table->rk_henmatch);

	for(i = 0; i < 2; i++)
		for(j = 0; j < 2; j++)  dspmod_sv[i][j] = cur_rk_table->dspmod[i][j];
	*/

	/* õ */
	clear(cur_rk_table->rk_modenaibu,		sizeof(modenaibutable));
	clear(cur_rk_table->rk_modesw,		sizeof(modeswtable));
	clear(cur_rk_table->rk_dspmode,		sizeof(modetable));
	clear(cur_rk_table->rk_hyo,			sizeof(hyotable));
	/* clear(cur_rk_table->rk_usehyo,		sizeof(usehyotable)); */
	clear(cur_rk_table->rk_hensuudef,		sizeof(hensuudeftable));
	/* clear(cur_rk_table->rk_henmatch,		sizeof(matchtable)); */

	if (NULL != romkan_table_init(cur_rk_table, cur_rk_table->prv_modfnm, cur_rk_table->flags)) {
		/* ｪλ */
		/* 88/06/10 V3.1 */
		/* ΰκ */
		free_for_modenaibu(&rk_modenaibu_sv);
		free_for_modesw(&rk_modesw_sv);
		free_for_modetable_struct(&rk_dspmode_sv);
		for (i = 0; i < rk_hyo_sv.size; i++) {
			free_for_hyo_area(&rk_hyo_sv, i);
		}
		free_for_hyo(&rk_hyo_sv);
		/* free_for_usehyo(&rk_usehyo_sv); */
		free_for_hensuudef(&rk_hensuudef_sv);
		/* free_for_henmatch(&rk_henmatch_sv); */

		return(0);
	}

	/* ۾ｪλ */
	/* 88/06/10 V3.1 */
	/* ΰκ */
	free_for_modenaibu(&(cur_rk_table->rk_modenaibu));
	free_for_modesw(&(cur_rk_table->rk_modesw));
	free_for_modetable_struct(&(cur_rk_table->rk_dspmode));
	for (i = 0; i < cur_rk_table->rk_hyo.size; i++) {
		free_for_hyo_area(&(cur_rk_table->rk_hyo), i);
	}
	free_for_hyo(&(cur_rk_table->rk_hyo));
	/* free_for_usehyo(&(cur_rk_table->rk_usehyo)); */
	free_for_hensuudef(&(cur_rk_table->rk_hensuudef));
	/* free_for_henmatch(&(cur_rk_table->rk_henmatch)); */

	/*  */
	recov(rk_modenaibu_sv,		cur_rk_table->rk_modenaibu);
	recov(rk_modesw_sv,		cur_rk_table->rk_modesw);
	recov(rk_dspmode_sv,		cur_rk_table->rk_dspmode);
	recov(rk_hyo_sv,		cur_rk_table->rk_hyo);
	/* recov(rk_usehyo_sv,		cur_rk_table->rk_usehyo); */
	recov(rk_hensuudef_sv,		cur_rk_table->rk_hensuudef);
	/* recov(rk_henmatch_sv,		cur_rk_table->rk_henmatch);

	for(i = 0; i < 2; i++)
		for(j = 0; j < 2; j++)  cur_rk_table->dspmod[i][j] = dspmod_sv[i][j];
	*/
	return(1);
}

 /** lp2ɾʸlp1˥ԡ */
static /* V3.1 */
void
ltrevlcpy(lp1, lp2)
letter	*lp1, *lp2;
{
	while(*lp2 != EOLTTR){
		mchevl(&lp2, lp1);
		totail(lp1);
	}
	*lp1 = EOLTTR;
}

static /* V3.1 */
void
set_rubout(lp, n, del)
 /** lp delnĤ򥻥åȤ롣 del  'delchr''nisedl' */
fast	letter	*lp, del;	/* V3.1 */
fast	int	n;		/* V3.1 */
{
	for(; n; n--) *lp++ = del;
	*lp = EOLTTR;
}

 /** 줬¹Ԥ줿Хâ¹ԤϤΤޤ³ */
#ifdef OMRON_LIB
static
#endif
void
BUGreport(n)
int	n;
{
	fprintf(stderr, "\r\nromkan-Bug%d!!\r\n", n);
}

 /** (mae_inmae_out)ϸ(ato_inato_out)Ԥ*/
static /* V3.1 */
void
maeato_henkan(in, outp, m_a_hyo)
letter	in;		/* Ϥΰʸ */
letter	*outp;		/* ϤϤ */
int	*m_a_hyo;	/* ɤɽ򤵤Ƥ뤫ξ */
{
	fast	dat	*datptr;	/* V3.1 */
	fast	int	i, hyoseq;		/* V3.1 */
	fast	letter	*curdat;		/* V3.1 */

	if(isSPCL(in)){
	 /* LTREOFCHMSIG褦Τǡü쥳ɤϤΤޤ֤褦
	    ٹƤʤȤʤ*/
		ltr_to_ltrseq(outp, in);
		return;
	}

	/* 88/06/14 V3.1 */
	for (hyoseq = 0;
	    m_a_hyo != NULL && (cur_rk->hyonum = m_a_hyo[hyoseq]) != -1; hyoseq++) {
		for(i = 0, datptr = cur_rk_table->rk_hyo.point[cur_rk->hyonum].data;
		    NULL != (curdat = datptr[i] . code[0]); i++){
			if (cur_rk->rk_henmatch.size > 0) {
			cur_rk->rk_henmatch.point[0].ltrmch = EOLTTR;
			}
			if(!l_eq(curdat, in)) continue;

			ltrevlcpy(outp, datptr[i] . code[1]);
			return;
		}
	}
	ltr_to_ltrseq(outp, in);
}

 /**  */
static /* V3.1 */
void
codeout_chg()
{
	fast	letter	*saishu_outp;	/* V3.1 */
	letter	saishu_out[OUTSIZ];	/* V3.1 */

	*(saishu_outp = saishu_out) = EOLTTR;

	for(; *(cur_rk->codeout) != EOLTTR; cur_rk->codeout++){
		maeato_henkan(*(cur_rk->codeout), saishu_outp, cur_rk->rk_usehyo.useatohyo);
		totail(saishu_outp);
	}

	cur_rk->codeout = saishu_out;
}

 /** ʸץå塦Хå */
letter	romkan_ungetc(l)
letter	l;
{
	return(cur_rk->ungetc_buf = l);
}

 /** romkan_nextФʸץå塦Хå */
letter	romkan_unnext(l)
letter	l;
{
	return(cur_rk->unnext_buf = l);
}

/* 88/06/02 V3.1 */
/******************************************************************************/
#ifndef OMRON
 /**	deleteȤƻȤ饯ʵdeleteˡ¹Ը
	romkan_clear¹ԤƤʤȺΤȤˤʤޤѻͽ*/
void
romkan_setdel(delchr_, nisedl_)
letter	delchr_, nisedl_;
{
	cur_rk->delchr = delchr_;
	cur_rk->nisedl = nisedl_;
}
#endif
/******************************************************************************/
