/*
 * $Id: w_string.c,v 1.6 1992/09/22 05:01:41 proj Exp $
 */
/*
 * Copyright 1989, 1990, 1991, 1992 by OMRON Corporation
 * Copyright 1991, 1992 by Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of OMRON and MIT not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  OMRON and MIT make no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * OMRON, MIT AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL OMRON, MIT OR WNN CONSORTIUM BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *	Author:	Seiji Kuwari	OMRON Corporation
 *				kuwa@omron.co.jp
 *				kuwa%omron.co.jp@uunet.uu.net
 */				
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	Version 4.0
 */
#include <stdio.h>
#include "commonhd.h"
#include "sdefine.h"
#ifdef	XJUTIL
#include "xjutil.h"
#include "sxheader.h"
#include "xext.h"
#else	/* XJUTIL */
#include "xim.h"
#include "sheader.h"
#include "ext.h"
#endif	/* XJUTIL */
#define CONTLINE '$'

#ifdef nodef
void
chartowchar(c , w)
w_char *w;
UCHAR *c;
{
    for(;*c; w++){
	if(*c & 0x80){
	    *w = ((w_char)*c++) << 8;
	    *w |= *c++;
	}else{
	    *w = *c++;
	}
    }
    *w = 0;
}
#endif

int
wchartochar(w , c)
w_char *w;
UCHAR *c;
{
    int flg = 0;

    for(;*w != 0 ; w++){
	if ((*w) > 0xff) flg = 1;
    }
    sStrcpy(c, w);
    return(flg);
}

#ifdef nodef
void
w_sttost(w , c)
w_char *w;
char *c;
{
    sStrcpy(c , w);
}

void
w_sttostn(w , c,n)
w_char *w;
char *c;
int n;
{
    sStrncpy(c, w, n);
}

int
eu_columlen(c)
unsigned char *c;
{
    int len = 0;
    w_char tmp;

    for(;*c;) {
	if((*c & 0x80)) {
	    tmp = ((w_char)*c++) << 8;
	    tmp |= *c++;
	} else {
	    tmp = *c++;
	}
	if(hankaku(tmp)){
	    len += 1;
	} else {
	    len += 2;
	}
    }
    return(len);
}
#endif

int sStrcpy(c, w)
register UCHAR *c;
register w_char *w;
{
    return(wnn_sStrcpy(c, w));
}

int Sstrcpy(w, c)
register w_char *w;
register UCHAR *c;
{
    return(wnn_Sstrcpy(w, c));
}

w_char * Strcat(w1, w2)
register w_char *w1, *w2;
{
    return(wnn_Strcat(w1, w2));
}

w_char * Strncat(w1, w2, n)
register w_char *w1, *w2;
register int n;
{
    return(wnn_Strncat(w1, w2, n));
}

int Strncmp(w1, w2, n)
register w_char *w1, *w2;
register int n;
{
    return(wnn_Strncmp(w1, w2, n));
}

w_char * Strcpy(w1, w2)
register w_char *w1, *w2;
{
    return(wnn_Strcpy(w1, w2));
}

w_char * Strncpy(w1, w2, n)
register w_char *w1, *w2;
register int n;
{
    return(wnn_Strncpy(w1, w2, n));
}

int Strlen(w)
register w_char *w;
{
    return(wnn_Strlen(w));
}

void delete_ss2(s, n)
register unsigned int *s;
register int n;
{
    wnn_delete_ss2(s, n);
}

void delete_w_ss2(s, n)
register w_char *s;
register int n;
{
    wnn_delete_w_ss2(s, n);
}

int byte_count(in)
register int in;
{
    return(wnn_byte_count(in));
}
