.TH wlc 3X "\fBCornell University Widget Set\fR"
.ad b
.de}F    
.ds)H Program of Computer Graphics
.ev1
.}E
.if\\n()s 'sp |\\n(.pu-1v-1p
.if\\n()t 'sp |\\n(.pu-3v
.ifn 'sp |\\n(.pu-4v
.tl\\*()H- % -\\*(]W
'bp
.ev
..
.SH NAME
wlc \- A Widget Layout Compiler
.ne 6
.SH OVERVIEW
\ 
.br
Usage: \fBwlc\fR \fIname\fR, or \fBwlc\fR \fIname.wl\fR
.sp
The \fBwlc\fR widget layout compiler
parses a description language with a .wl extension and outputs three files:
.in +5
.sp
\fIname\fR.wc - a compiled widget layout description
.br
\fIname\fR.cl - a list of widget classes encountered in \fIname\fR.wl.
.br
\fIname\fR.lw - a list of .wl files encountered in \fIname\fR.wl.
.in -5
.sp
\fIname\fR.wc is the file that is referenced by the \fBXcuWlm\fR
XtNfile resource.  There are three reasons for having compilation be
a separate process.  Since compilation is rapid, speed is the least
important reason.  Probably more important is the size of client programs,
since this isolates the largish routines generated by lex and yacc.
The primary reason, however, is to enable an automatic mechanism
for linking the required widgets with the client program.  The
\fIname\fR.cl and
\fIname\fR.lw files are part of that mechanism.
.sp
Client programs are required to have a \fBmake_tag_class_list()\fR procedure
which creates a list of widget class pairs.  One member of the pair is the
widget class name string as it appears in the description language, and
the other member of the pair is the widget class pointer. 
To make this procedure "by hand", follow this template:
.sp
#include <Xcu/WlmP.h>
.br
#include <X\fIid\fRName.h> /* One for each widget (substitute for \fIid\fR) */
.sp
void make_tag_class_list(wlm)
.br
XcuWlmWidget wlm ;
.br
{
.br
TAG_CLASS_ENTRY (wlm, "Name", nameWidgetClass) ; /* One for each widget */
.br
}
.sp
For each widget to be linked into the client, substitute the appropriate
widget name.
E.g., "Name" and "name" could be "XcuLabel" and "xcuLabel".
.sp
The following Makefile fragment, however, shows how it can be created
automatically when a significant change has been made to the layout
description:
.sp
WLDL=layout.wl
.br
WLDLI=layout1 layout2
.br
INCL_PATH=/usr/local/include
.br
CAT=/bin/cat
.br
CLIENT=main
.sp
$(CLIENT).o : $(CLIENT).c $(CLIENT).wh
.br
	$(CC) -c $(CFLAGS) $(CLIENT).c
.sp
$(CLIENT).wh : $(CLIENT).wb
.br
	wlm_incl_make `$(CAT) $(CLIENT).wb` > $@
.sp
$(CLIENT).nc : $(WLDL)
.br
	wlm_update_class $(CLIENT) $?
.sp
$(CLIENT).wf : $(CLIENT).nc
.sp
$(CLIENT).wb : $(CLIENT).wf
.br
	wlm_doupdate $(CLIENT)
.sp
$(WLDL) : $(WLDLI)
.br
	touch $@
.sp
The logic is as follows:
.sp
main.c depends on main.wh, which is an include file that
contains make_tag_class_list().
.sp
main.wh depends on main.wb, which is a list of widgets
.sp
main.wb depends on a dummy file, main.wf, which is only touched
when there are new widget names in the layout description
.sp
main.wb is created from main.nc by wlm_doupdate
.sp
main.nc is created by wlm_update_class, which invokes the compiler
on the layout description.
.sp 2
If only cosmetic changes are made to the layout description, "make" will
not update the client.
If, however, new widgets are added, then a new include file will be generated,
which will then force a recompile and relink.

.ne 6
.SH WARNINGS
\ 
.br
Some widget sets (e.g., HP) violate intrinsics naming conventions,
making it difficult to automatically generate a good include file.
wlm_incl_make has been fudged to handle HP widgets, but future problems
could occur if future non-compliant widgets are used.

.ne 6
.SH AUTHOR
\ 
.br
Gene Dykes, \fIgwd@freedom.graphics.cornell.edu\fR
.br
Program of Computer Graphics, Cornell University

