.\" $Header: XpexChangeRenderer.man,v 2.5 91/09/11 16:04:53 sinyaw Exp $
.\"
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\" 
.TH XpexChangeRenderer 3PEX "$Revision: 2.5 $" "Sony Microsystems" 
.AT
.SH "Name"
XpexChangeRenderer, XpexGetRendererAttributes, 
XpexGetRendererDynamics \- Modify or inquire attributes 
of renderer resources
.SH "Synopsis"
.nf
void XpexChangeRenderer(dpy, rdr_id, attr_mask, attributes)
.br
	Display  *dpy;
.br
	XpexRenderer  rdr_id;
.br
	XpexBitmask attr_mask;
.br
	XpexRendererAttributes *attributes;
.sp
Status XpexGetRendererAttributes(dpy, rdr_id, attr_mask, attributes)
.br
	Display  *dpy;
.br
	XpexRenderer  rdr_id;
.br
	XpexBitmask attr_mask;
.br
	XpexRendererAttributes  *attributes; /* RETURN */
.sp
Status XpexGetRendererDynamics(dpy, rdr_id, dynamics)
.br
	Display  *dpy;
.br
	XpexRenderer  rdr_id;
.br
	XpexRendererDynamics  *dynamics; /* RETURN */
.fi
.SH "Arguments"
.IP \fIdpy\fP
Specifies a pointer to the Display structure;
returned from XOpenDisplay.
.IP \fIrdr_id\fP 
Specifies the renderer.
.IP \fIattr_mask\fP 
Specifies the components are to be changed.
.IP \fIattributes\fP
Specifies the values of the components to be changed.
.IP \fIdynamics\fP  1i
Specifies the dynamics for all the attributes of the
specified renderer.
.SH "Description"
Refer to the PEX Protocol Specification Document, Sections 6.2. and
6.3.
.SH "Structures"
For XpexRendererAttributes, see XpexRendererAttributes(3PEX).
.sp
typedef struct {
.br
	XpexBitmask tables;
.br
	XpexBitmask namesets;
.br
	XpexBitmask attributes;
.br
} XpexRendererDynamics;
.SH "Errors"
Renderer, Match, Value, FloatingPointFormat, NameSet,
LookupTable, PipelineContext
.SH "Related Commands"
To be added 
