.\" $Header: XpexCreateNameSet.man,v 2.4 91/09/11 16:02:15 sinyaw Exp $
.\"
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\" 
.TH XpexCreateNameSet 3PEX "$Revision: 2.4 $" "Sony Microsystems" 
.AT
.SH "Name"
XpexCreateNameSet, XpexCopyNameSet, 
XpexFreeNameSet \- Functions that manage the creation, freeing, and copying of name set resources.
.SH "Synopsis"
.nf
XpexNameSet XpexCreateNameSet(dpy)
.br
	Display *\fIdpy\fP;
.sp
void XpexCopyNameSet(dpy, src_ns_id, dest_ns_id)
.br
	Display *\fIdpy\fP;
.br
	XpexNameSet \fIsrc_ns_id\fP;
.br
	XpexNameSet \fIdest_ns_id\fP;
.sp
void XpexFreeNameSet(dpy, ns_id)
.br
	Display *\fIdpy\fP;
.br
	XpexNameSet \fIns_id\fP;
.fi
.SH "Arguments"
.IP \fIdpy\fP 1i 
Specifies a pointer to the Display structure;
returned from XOpenDisplay.
.IP \fIsrc_ns_id\fP 1i 
To be added 
.IP \fIdest_ns_id\fP 1i 
To be added 
.IP \fIns_id\fP 1i 
To be added 
.SH "Description"
The \fIXpexCreateNameSet\fP function creates a name set resource 
for the specified name set identifier returned.  
The name set is initialized to an empty list when the resource 
is created.
.sp
The \fIXpexCopyNameSet\fP function copies the source name 
set src_ns_id to a destination
name set dest_ns_id after first emptying the contents of dest_ns_id.
The dest_ns_id must already exist as a valid resource.
.sp
The \fIXpexFreeNameSet\fP deletes the association between the 
resource ID and the name set.  The name set storage will be freed 
when no other resource references it.
.SH "Structures"
None
.SH "Errors"
IDChoice, Alloc
.SH "Related Commands" 
XpexGetNameSet, XpexChangeNameSet.
