.\" $Header: XpexSetLineType.man,v 2.5 91/09/11 16:03:32 sinyaw Exp $
.\"
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\" 
.\"
.\"
.\"
.TH XpexSetLineType 3PEX "$Revision: 2.5 $" "Sony Microsystems"
.AT
.SH "Name"
XpexSetLineType \-
.sp
XpexSetLineWidth \-
.sp
XpexSetLineColorIndex \-
.sp
XpexSetLineColor \-
.sp
XpexSetCurveApprox \-
.sp
XpexSetPolylineInterpMethod \-
.sp
XpexSetLineBundleIndex \-
.SH "Synopsis"
.nf
void XpexSetLineType(dpy, type)
.br
	Display *dpy;
.br
	XpexEnumTypeIndex type;
.sp
void XpexSetLineWidth(dpy, width)
.br
	Display *dpy;
.br
	XpexFloat width;
.sp
void XpexSetLineColorIndex(dpy, color_index)
.br
	Display *dpy;
.br
	XpexTableIndex color_index;
.sp
void XpexSetLineColor(dpy, color)
.br
	Display *dpy;
.br
	XpexColor *color;
.sp
void XpexSetCurveApproximation(dpy, approx_method, tolerance)
.br
	Display *dpy;
.br
	XpexEnumTypeIndex approx_method;
.br
	XpexFloat tolerance;
.sp
void XpexSetPolylineInterpMethod(dpy, method)
.br
	Display *dpy;
.br
	XpexEnumTypeIndex method;
.sp
void XpexSetLineBundleIndex(dpy, index)
.br
	Display *dpy;
.br
	XpexTableIndex index;
.fi
.SH "Arguments"
.IP \fIdpy\fP 1i
Specifies a pointer to the Display structure;
returned from XOpenDisplay.
.IP \fItype\fP 1i
To be added 
.IP \fIwidth\fP 1i
To be added 
.IP \fIcolor_index\fP 1i
To be added 
.IP \fIcolor\fP 1i
To be added 
.IP \fIapprox_method\fP 1i
To be added 
.IP \fItolerance\fP 1i
To be added 
.IP \fImethod\fP 1i
To be added 
.IP \fIindex\fP 1i
To be added 
.SH "Description"
Refer to the PEX Protocol Specification Document, Section 3.
.SH "Structures"
typedef struct {
.br
	union {
.br
		XpexIndexedColor indexed;
.br
		XpexRgb8Color rgb8;
.br
		XpexRgb16Color rgb16;
.br
		XpexRgbFloatColor rgbFloat;
.br
		XpexHsvColor hsvFloat;
.br
		XpexHlsColor hlsFloat;
.br
		XpexCieColor cieFloat;
.br
	} format;
.br
} XpexColor;
.sp
typedef struct {
.br
	unsigned char red;
.br
	unsigned char green;
.br
	unsigned char blue;
.br
	unsigned char pad;
.br
} XpexRgb8Color;
.sp
typedef struct {
.br
	unsigned short red;
.br
	unsigned short green;
.br
	unsigned short blue;
.br
	unsigned short pad;
.br
} XpexRgb16Color;
.SH "Errors"
Structure, Renderer, FloatingPointFormat, OutputCommand, Value
.SH "Related Commands"
To be added 
