.\" $Header: XpexTranslate.man,v 2.5 91/09/11 16:03:03 sinyaw Exp $
.\"
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\" 
.TH XpexTranslate 3PEX "$Revision: 2.5 $" "Sony Microsystems"
.AT
.SH "Name"
XpexTranslate \- calculate a 3D transformation matrix to perform a 
specified translation
.sp
XpexTranslate2D \- calculate a 2D transformation matrix to perform
a specified translation
.SH "Synopsis"
.nf
void XpexTranslate(translation_vector, transformation_matrix)
.br
	XpexVector3D *translation_vector;
.br
	XpexMatrix transformation_matrix; /* RETURN */
.sp
void XpexTranslate2D(translation_vector_2d, transformation_matrix_3x3)
.br
	XpexVector2D  *translation_vector_2d;
.br
	XpexMatrix3X3 transformation_matrix_3x3; /* RETURN */
.fi
.SH "Arguments"
.IP \fItranslation_vector\fP 1i
Specifies a pointer an XpexVector3D structure containing the 
Modelling Coordinate translation values to be applied in the 
x, y, and z dimensions.
.IP \fItransformation_matrix\fP 1i
Specifies the 4 X 4 homogeneous transformation matrix that 
performs the specified translation.
.IP \fItranslation_vector_2d\fP 1i
Specifies a pointer to an XpexVector2D structure containing the 
Modelling Coordinate translation values to be applied in the x 
and y dimensions.
.IP \fItransformation_matrix_3x3\fP 1i
Specifies the 3 X 3 homogeneous transformation matrix that 
performs the specified translation.
.SH "Description"
Refer to the description in the PEX-SI PHIGS Reference Manual. 
.SH "Structures"
typedef struct {
.br
	XpexFloat  x;
.br
	XpexFloat  y;
.br
	XpexFloat  z;
.br
} XpexVector3D;
.sp
typedef struct {
.br
	XpexFloat  x;
.br
	XpexFloat  y;
.br
} XpexVector2D;
.SH "Errors"
None
.SH "Related Commands"
XpexBuildTransformationMatrix, XpexBuildTransformationMatrix2D,
XpexComposeMatrix, XpexComposeMatrix2D, 
XpexComposeTransformationMatrix, 
XpexComposeTransformationMatrix2D, XpexRotate, 
XpexRotateX, XpexRotateY, XpexRotateZ, 
XpexScale, XpexScale2D, XpexSetGlobalTransform, 
XpexSetGlobalTransform2D, XpexSetLocalTransform, 
XpexSetLocalTransform2D, XpexSetViewRep, 
XpexTransformPoint, XpexTransformPoint2D,
XpexTranslate, XpexTranslate2D
